/*
 * Decompiled with CFR 0.152.
 */
package ingame;

import component.CSpriteAnimation;
import game.CCanvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class CRoadCar {
    public static final int TOTAL_ROAD_CARS = 5;
    private Image imgCar;
    public int iPosX;
    public int iPosY;
    public int iWidth;
    public int iHeigth;
    private int iSpeed;
    private int iHealth;
    private boolean isDestroyed;
    private boolean isDestroying;
    private CSpriteAnimation animBlast;
    private CSpriteAnimation animPloliceLight;
    private boolean isMovable;
    public boolean isCollided;
    private boolean isBike;

    public CRoadCar(int iType, Image img, int x2, int y2, int speed, CSpriteAnimation animNormal, CSpriteAnimation animLight) {
        this.iSpeed = speed;
        this.imgCar = img;
        this.iWidth = this.imgCar.getWidth();
        this.iHeigth = this.imgCar.getHeight();
        this.iPosX = x2;
        this.iPosY = y2;
        this.iHealth = 100;
        this.isCollided = false;
        this.isDestroyed = false;
        this.isDestroying = false;
        this.animBlast = animNormal;
        this.animPloliceLight = animLight;
        this.animBlast.reset();
        if (iType >= 3) {
            this.isMovable = true;
            if (iType > 3) {
                this.isBike = true;
            }
        } else {
            this.isMovable = false;
        }
    }

    public boolean isCopCar() {
        return this.isMovable;
    }

    public void unload() {
        this.imgCar = null;
    }

    public boolean update(int iPanSpeed) {
        int iRelativeSpeed = iPanSpeed - this.iSpeed;
        if (this.isMovable) {
            this.animPloliceLight.update();
            iRelativeSpeed = iPanSpeed + this.iSpeed;
        }
        if (this.isMovable) {
            if (!this.isCollided && iPanSpeed != 0) {
                this.iPosY += iRelativeSpeed;
            }
        } else {
            this.iPosY += iRelativeSpeed;
        }
        if (this.isDestroying && !this.isDestroyed) {
            this.isDestroyed = this.animBlast.updateOnce(true);
            if (this.isDestroyed) {
                this.isDestroying = false;
            }
        }
        return this.iPosY <= CCanvas.iScreenH;
    }

    public boolean decreaseHealth(int amount) {
        if (this.isDestroying) {
            return true;
        }
        this.iHealth -= amount;
        if (this.iHealth <= 0) {
            this.isDestroying = true;
            return false;
        }
        return true;
    }

    public boolean checkDestroyed() {
        return this.isDestroyed;
    }

    public boolean checkDestroying() {
        return this.isDestroying;
    }

    public void paint(Graphics g2) {
        if (!this.isDestroying && !this.isDestroyed) {
            g2.drawImage(this.imgCar, this.iPosX, this.iPosY, 17);
            if (this.isMovable && !this.isBike) {
                this.animPloliceLight.paint(g2, this.iPosX, this.iPosY + (this.iHeigth >> 1), 3);
            }
        } else if (!this.isDestroyed) {
            this.animBlast.paint(g2, this.iPosX, this.iPosY + (this.iHeigth >> 1), 3);
        }
    }
}

