/*
 * Decompiled with CFR 0.152.
 */
package com.shephertz.app42.paas.sdk.jme.appTab;

import com.shephertz.app42.paas.sdk.jme.App42Exception;
import com.shephertz.app42.paas.sdk.jme.appTab.Bill;
import com.shephertz.app42.paas.sdk.jme.appTab.BillMonth;
import com.shephertz.app42.paas.sdk.jme.appTab.BillResponseBuilder;
import com.shephertz.app42.paas.sdk.jme.connection.RESTConnector;
import com.shephertz.app42.paas.sdk.jme.util.Util;
import java.util.Hashtable;

public class BillService {
    private String version = "1.0";
    private String resource = "bill";
    private String apiKey;
    private String secretKey;

    public BillService(String apiKey, String secretKey) {
        this.apiKey = apiKey;
        this.secretKey = secretKey;
    }

    public Bill packageUsageByMonthAndYear(String schemeName, String packageName, String userName, String billMonth, Integer year) throws App42Exception {
        String response = null;
        Bill bill = null;
        Util.throwExceptionIfNullOrBlank(userName, "UserName");
        Util.throwExceptionIfNullOrBlank(packageName, "PackageName");
        Util.throwExceptionIfNullOrBlank(schemeName, "schemeName");
        Util.throwExceptionIfNullOrBlank(billMonth, "billMonth");
        Util.throwExceptionIfNullOrBlank(year, "year");
        BillMonth.throwExceptionIfNotValid(billMonth);
        try {
            Hashtable<String, String> params = new Hashtable<String, String>();
            Hashtable queryParams = new Hashtable();
            params.put("apiKey", this.apiKey);
            params.put("version", this.version);
            params.put("timeStamp", Util.getUTCFormattedTimestamp());
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, params);
            params.put("schemeName", schemeName);
            params.put("packageName", packageName);
            params.put("userName", userName);
            params.put("month", billMonth);
            params.put("year", "" + year);
            String signature = Util.sign(this.secretKey, params);
            String resourceURL = this.version + "/" + this.resource + "/package" + "/" + schemeName + "/" + packageName + "/" + userName + "/" + billMonth + "/" + year;
            response = RESTConnector.getInstance().executeGet(signature, resourceURL, queryParams);
            bill = new BillResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return bill;
    }

    public Bill getAllUsageByMonth(String schemeName, String packageName, String userName, String billMonth, Integer year) throws App42Exception {
        String response = null;
        Bill bill = null;
        Util.throwExceptionIfNullOrBlank(userName, "UserName");
        Util.throwExceptionIfNullOrBlank(packageName, "PackageName");
        Util.throwExceptionIfNullOrBlank(schemeName, "schemeName");
        Util.throwExceptionIfNullOrBlank(billMonth, "billMonth");
        Util.throwExceptionIfNullOrBlank(year, "year");
        BillMonth.throwExceptionIfNotValid(billMonth);
        try {
            Hashtable<String, String> params = new Hashtable<String, String>();
            Hashtable queryParams = new Hashtable();
            params.put("apiKey", this.apiKey);
            params.put("version", this.version);
            params.put("timeStamp", Util.getUTCFormattedTimestamp());
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, params);
            params.put("schemeName", schemeName);
            params.put("packageName", packageName);
            params.put("userName", userName);
            params.put("month", billMonth);
            params.put("year", "" + year);
            String signature = Util.sign(this.secretKey, params);
            String resourceURL = this.version + "/" + this.resource + "/package/usage" + "/" + schemeName + "/" + packageName + "/" + userName + "/" + billMonth + "/" + year;
            response = RESTConnector.getInstance().executeGet(signature, resourceURL, queryParams);
            bill = new BillResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return bill;
    }
}

