/*
 * Decompiled with CFR 0.152.
 */
package com.shephertz.app42.paas.sdk.jme.avatar;

import com.shephertz.app42.paas.sdk.jme.App42Log;
import com.shephertz.app42.paas.sdk.jme.App42ResponseBuilder;
import com.shephertz.app42.paas.sdk.jme.avatar.Avatar;
import com.shephertz.app42.paas.sdk.jme.util.Util;
import java.util.Vector;
import org.json.jme.JSONArray;
import org.json.jme.JSONObject;

public class AvatarResponseBuilder
extends App42ResponseBuilder {
    public Avatar buildResponse(String json) throws Exception {
        JSONObject avatarsJSONObj = this.getServiceJSONObject("avatars", json);
        JSONObject avatarJSOnObj = avatarsJSONObj.getJSONObject("avatar");
        Avatar avatar = this.buildAvatarObject(avatarJSOnObj);
        avatar.setStrResponse(json);
        avatar.setResponseSuccess(this.isResponseSuccess(json));
        return avatar;
    }

    private Avatar buildAvatarObject(JSONObject avatarJSONObj) throws Exception {
        Avatar avatar = new Avatar();
        this.buildObjectFromJSONTree(avatar, avatarJSONObj);
        return avatar;
    }

    public Vector buildArrayResponse(String json) throws Exception {
        JSONObject avatarsJSONObj = this.getServiceJSONObject("avatars", json);
        Vector<Avatar> avatarList = new Vector<Avatar>();
        if (avatarsJSONObj.get("avatar") instanceof JSONArray) {
            JSONArray avatarJSONArray = avatarsJSONObj.getJSONArray("avatar");
            for (int i = 0; i < avatarJSONArray.length(); ++i) {
                JSONObject avatarJSONObject = avatarJSONArray.getJSONObject(i);
                Avatar avatar = this.buildAvatarObject(avatarJSONObject);
                avatar.setStrResponse(json);
                avatar.setResponseSuccess(this.isResponseSuccess(json));
                avatarList.addElement(avatar);
            }
        } else {
            JSONObject avatarJSONObject = avatarsJSONObj.getJSONObject("avatar");
            Avatar avatar = this.buildAvatarObject(avatarJSONObject);
            avatar.setStrResponse(json);
            avatar.setResponseSuccess(this.isResponseSuccess(json));
            avatarList.addElement(avatar);
        }
        return avatarList;
    }

    public void buildObjectFromJSONTree(Object obj, JSONObject jsonObj) throws Exception {
        if (obj instanceof Avatar) {
            Avatar avatar = (Avatar)obj;
            String[] names = this.getNames(jsonObj);
            if (names != null) {
                for (int i = 0; i < names.length; ++i) {
                    String sendedOn;
                    String name = names[i];
                    if (name.equals("userName")) {
                        avatar.setUserName("" + jsonObj.get(name));
                    }
                    if (name.equals("name")) {
                        avatar.setName("" + jsonObj.get(name));
                    }
                    if (name.equals("url")) {
                        avatar.setURL("" + jsonObj.get(name));
                    }
                    if (name.equals("tinyUrl")) {
                        avatar.setTinyURL("" + jsonObj.get(name));
                    }
                    if (name.equals("isCurrent")) {
                        avatar.setIsCurrent((Boolean)jsonObj.get(name));
                    }
                    if (name.equals("createdOn") && jsonObj.get(name) != null && !(sendedOn = "" + jsonObj.get(name)).equals("null")) {
                        App42Log.debug(" createdOn Not Null " + jsonObj.get(name));
                        avatar.setCreatedOn(Util.getDateFromUTCTimeStamp("" + jsonObj.get(name)));
                    }
                    if (!name.equals("description")) continue;
                    avatar.setDescription("" + jsonObj.get(name));
                }
            }
        }
    }
}

