/*
 * Decompiled with CFR 0.152.
 */
package com.shephertz.app42.paas.sdk.jme.gallery;

import com.shephertz.app42.paas.sdk.jme.App42ResponseBuilder;
import com.shephertz.app42.paas.sdk.jme.gallery.Album;
import java.util.Vector;
import org.json.jme.JSONArray;
import org.json.jme.JSONObject;

public class AlbumResponseBuilder
extends App42ResponseBuilder {
    public Album buildResponse(String json) throws Exception {
        JSONObject albumsJSONObj = this.getServiceJSONObject("albums", json);
        JSONObject albumJSONObj = albumsJSONObj.getJSONObject("album");
        Album albumObj = new Album();
        albumObj.setStrResponse(json);
        albumObj.setResponseSuccess(this.isResponseSuccess(json));
        this.buildObjectFromJSONTree(albumObj, albumJSONObj);
        if (!albumJSONObj.has("photos")) {
            return albumObj;
        }
        if (!albumJSONObj.getJSONObject("photos").has("photo")) {
            return albumObj;
        }
        if (albumJSONObj.getJSONObject("photos").get("photo") instanceof JSONObject) {
            Album.Photo photoObj = albumObj.new Album.Photo();
            this.buildObjectFromJSONTree(photoObj, albumJSONObj.getJSONObject("photos").getJSONObject("photo"));
            photoObj = this.setTagList(photoObj, albumJSONObj.getJSONObject("photos").getJSONObject("photo"));
        } else {
            JSONArray photoJSONArray = albumJSONObj.getJSONObject("photos").getJSONArray("photo");
            for (int i = 0; i < photoJSONArray.length(); ++i) {
                JSONObject photoJSONObj = photoJSONArray.getJSONObject(i);
                Album.Photo photoObj = albumObj.new Album.Photo();
                this.buildObjectFromJSONTree(photoObj, photoJSONObj);
            }
        }
        return albumObj;
    }

    private Album buildAlbumObject(JSONObject albumsJSONObj) throws Exception {
        Album albumObj = new Album();
        this.buildObjectFromJSONTree(albumObj, albumsJSONObj);
        if (albumsJSONObj.has("photos") && albumsJSONObj.getJSONObject("photos").has("photo")) {
            if (albumsJSONObj.getJSONObject("photos").get("photo") instanceof JSONObject) {
                JSONObject photoJsonObj = albumsJSONObj.getJSONObject("photos").getJSONObject("photo");
                Album.Photo photoObj = albumObj.new Album.Photo();
                this.buildObjectFromJSONTree(photoObj, albumsJSONObj.getJSONObject("photos").getJSONObject("photo"));
                photoObj = this.setTagList(photoObj, photoJsonObj);
            } else {
                JSONArray photoJSONArray = albumsJSONObj.getJSONObject("photos").getJSONArray("photo");
                for (int j = 0; j < photoJSONArray.length(); ++j) {
                    JSONObject photoJSONObj = photoJSONArray.getJSONObject(j);
                    Album.Photo photoObj = albumObj.new Album.Photo();
                    this.buildObjectFromJSONTree(photoObj, photoJSONObj);
                    photoObj = this.setTagList(photoObj, photoJSONObj);
                }
            }
        }
        return albumObj;
    }

    public Vector buildArrayResponse(String json) throws Exception {
        JSONObject albumsJSONObj = this.getServiceJSONObject("albums", json);
        Vector<Album> albumList = new Vector<Album>();
        if (albumsJSONObj.get("album") instanceof JSONArray) {
            JSONArray albumJSONArray = albumsJSONObj.getJSONArray("album");
            for (int i = 0; i < albumJSONArray.length(); ++i) {
                JSONObject albumJSONObj = albumJSONArray.getJSONObject(i);
                Album album = this.buildAlbumObject(albumJSONObj);
                album.setStrResponse(json);
                album.setResponseSuccess(this.isResponseSuccess(json));
                albumList.addElement(album);
            }
        } else {
            JSONObject albumJSONObject = albumsJSONObj.getJSONObject("album");
            Album album = this.buildAlbumObject(albumJSONObject);
            album.setStrResponse(json);
            album.setResponseSuccess(this.isResponseSuccess(json));
            albumList.addElement(album);
        }
        return albumList;
    }

    private Album.Photo setTagList(Album.Photo photoObj, JSONObject photoJsonObj) throws Exception {
        if (photoJsonObj.has("tags")) {
            Vector<String> tagList = new Vector<String>();
            if (photoJsonObj.get("tags") instanceof JSONArray) {
                JSONArray tagArr = photoJsonObj.getJSONArray("tags");
                for (int i = 0; i < tagArr.length(); ++i) {
                    tagList.addElement(tagArr.getString(i));
                }
            } else {
                tagList.addElement(photoJsonObj.getString("tags"));
            }
            photoObj.setTagList(tagList);
        }
        return photoObj;
    }

    public void buildObjectFromJSONTree(Object obj, JSONObject jsonObj) throws Exception {
        String name;
        int i;
        String[] names;
        if (obj instanceof Album) {
            Album album = (Album)obj;
            names = this.getNames(jsonObj);
            if (names != null) {
                for (i = 0; i < names.length; ++i) {
                    name = names[i];
                    if (name.equals("userName")) {
                        album.setUserName("" + jsonObj.get(name));
                    }
                    if (name.equals("name")) {
                        album.setName("" + jsonObj.get(name));
                    }
                    if (!name.equals("description")) continue;
                    album.setDescription("" + jsonObj.get(name));
                }
            }
        }
        if (obj instanceof Album.Photo) {
            Album.Photo photo = (Album.Photo)obj;
            names = this.getNames(jsonObj);
            if (names != null) {
                for (i = 0; i < names.length; ++i) {
                    name = names[i];
                    if (name.equals("name")) {
                        photo.setName("" + jsonObj.get(name));
                    }
                    if (name.equals("description")) {
                        photo.setDescription("" + jsonObj.get(name));
                    }
                    if (name.equals("url")) {
                        photo.setUrl("" + jsonObj.get(name));
                    }
                    if (name.equals("tinyUrl")) {
                        photo.setTinyUrl("" + jsonObj.get(name));
                    }
                    if (name.equals("thumbNailUrl")) {
                        photo.setThumbNailUrl("" + jsonObj.get(name));
                    }
                    if (!name.equals("thumbNailTinyUrl")) continue;
                    photo.setThumbNailTinyUrl("" + jsonObj.get(name));
                }
            }
        }
    }
}

