/*
 * Decompiled with CFR 0.152.
 */
package com.shephertz.app42.paas.sdk.jme.log;

import com.shephertz.app42.paas.sdk.jme.App42CallBack;
import com.shephertz.app42.paas.sdk.jme.App42Exception;
import com.shephertz.app42.paas.sdk.jme.App42Log;
import com.shephertz.app42.paas.sdk.jme.App42Response;
import com.shephertz.app42.paas.sdk.jme.App42Service;
import com.shephertz.app42.paas.sdk.jme.connection.RESTConnectorAsync;
import com.shephertz.app42.paas.sdk.jme.log.Log;
import com.shephertz.app42.paas.sdk.jme.log.LogResponseBuilder;
import com.shephertz.app42.paas.sdk.jme.util.Util;
import java.util.Date;
import java.util.Hashtable;
import org.json.jme.JSONObject;

public class LogService
extends App42Service {
    private String resource = "log";

    public LogService(String apiKey, String secretKey, String baseURL) {
        this.apiKey = apiKey;
        this.secretKey = secretKey;
        this.version = "1.0";
    }

    private Log buildAndSend(String msg, String module, String level) throws App42Exception {
        String response = null;
        Log logObj = null;
        Util.throwExceptionIfNullOrBlank(msg, "Message");
        Util.throwExceptionIfNullOrBlank(module, "App Module");
        Util.throwExceptionIfNullOrBlank(module, "Level");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            JSONObject obj = new JSONObject();
            obj.put("message", msg);
            obj.put("appModule", module);
            StringBuffer sb = new StringBuffer();
            sb.append("{\"app42\":{\"log\":").append(obj.toString()).append("}}");
            App42Log.debug(" Json String : " + sb.toString());
            signParams.put("body", sb.toString());
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/" + level;
            response = RESTConnectorAsync.getInstance().executePost(resourceURL, queryParams, sb.toString(), headerParams);
            logObj = new LogResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return logObj;
    }

    public Log info(String msg, String module) throws App42Exception {
        return this.buildAndSend(msg, module, "info");
    }

    public void info(final String msg, final String module, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Log log = LogService.this.info(msg, module);
                    callBack.onSuccess(log);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Log debug(String msg, String module) throws App42Exception {
        return this.buildAndSend(msg, module, "debug");
    }

    public void debug(final String msg, final String module, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Log log = LogService.this.debug(msg, module);
                    callBack.onSuccess(log);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Log fatal(String msg, String module) throws App42Exception {
        return this.buildAndSend(msg, module, "fatal");
    }

    public void fatal(final String msg, final String module, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Log log = LogService.this.fatal(msg, module);
                    callBack.onSuccess(log);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Log error(String msg, String module) throws App42Exception {
        return this.buildAndSend(msg, module, "error");
    }

    public void error(final String msg, final String module, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Log log = LogService.this.error(msg, module);
                    callBack.onSuccess(log);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Log fetchLogsByModule(String moduleName) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(moduleName, "Module");
        String response = null;
        Log logObj = null;
        Util.throwExceptionIfNullOrBlank(moduleName, "ModuleName");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("moduleName", moduleName);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/" + "module" + "/" + moduleName;
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            logObj = new LogResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return logObj;
    }

    public void fetchLogsByModule(final String moduleName, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Log log = LogService.this.fetchLogsByModule(moduleName);
                    callBack.onSuccess(log);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public App42Response fetchLogsCountByModule(String moduleName) throws App42Exception {
        String response = null;
        App42Response responseObj = new App42Response();
        Util.throwExceptionIfNullOrBlank(moduleName, "ModuleName");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("moduleName", moduleName);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/" + "module" + "/" + moduleName + "/count";
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            responseObj.setStrResponse(response);
            responseObj.setResponseSuccess(true);
            responseObj.setTotalRecords(new LogResponseBuilder().getTotalRecords(response));
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return responseObj;
    }

    public void fetchLogsCountByModule(final String moduleName, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    App42Response log = LogService.this.fetchLogsCountByModule(moduleName);
                    callBack.onSuccess(log);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Log fetchLogsByModule(String moduleName, Integer max, Integer offset) throws App42Exception {
        String response = null;
        Log logObj = null;
        Util.validateMax(max);
        Util.throwExceptionIfNullOrBlank(moduleName, "Module");
        Util.throwExceptionIfNullOrBlank(max, "Max");
        Util.throwExceptionIfNullOrBlank(offset, "Offset");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("moduleName", moduleName);
            signParams.put("max", "" + max);
            signParams.put("offset", "" + offset);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/" + "paging" + "/" + "module" + "/" + moduleName + "/" + max + "/" + offset;
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            logObj = new LogResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return logObj;
    }

    public void fetchLogsByModule(final String moduleName, final Integer max, final Integer offset, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Log log = LogService.this.fetchLogsByModule(moduleName, max, offset);
                    callBack.onSuccess(log);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Log fetchLogsByModuleAndText(String moduleName, String text) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(moduleName, "Module");
        Util.throwExceptionIfNullOrBlank(text, "Text");
        String response = null;
        Log logObj = null;
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("moduleName", moduleName);
            signParams.put("text", text);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/" + "module" + "/" + moduleName + "/" + "text" + "/" + text;
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            logObj = new LogResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return logObj;
    }

    public void fetchLogsByModuleAndText(final String moduleName, final String text, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Log log = LogService.this.fetchLogsByModuleAndText(moduleName, text);
                    callBack.onSuccess(log);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public App42Response fetchLogsCountByModuleAndText(String moduleName, String text) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(moduleName, "Module");
        Util.throwExceptionIfNullOrBlank(text, "Text");
        String response = null;
        App42Response responseObj = new App42Response();
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("moduleName", moduleName);
            signParams.put("text", text);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/" + "module" + "/" + moduleName + "/" + "text" + "/" + text + "/count";
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            responseObj.setStrResponse(response);
            responseObj.setResponseSuccess(true);
            responseObj.setTotalRecords(new LogResponseBuilder().getTotalRecords(response));
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return responseObj;
    }

    public void fetchLogsCountByModuleAndText(final String moduleName, final String text, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    App42Response log = LogService.this.fetchLogsCountByModuleAndText(moduleName, text);
                    callBack.onSuccess(log);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Log fetchLogsByModuleAndText(String moduleName, String text, Integer max, Integer offset) throws App42Exception {
        Util.validateMax(max);
        String response = null;
        Log logObj = null;
        Util.throwExceptionIfNullOrBlank(moduleName, "Module");
        Util.throwExceptionIfNullOrBlank(text, "Text");
        Util.throwExceptionIfNullOrBlank(max, "Max");
        Util.throwExceptionIfNullOrBlank(offset, "Offset");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("moduleName", moduleName);
            signParams.put("text", text);
            signParams.put("max", "" + max);
            signParams.put("offset", "" + offset);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/" + "paging" + "/" + "module" + "/" + moduleName + "/" + "text" + "/" + text + "/" + max + "/" + offset;
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            logObj = new LogResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return logObj;
    }

    public void fetchLogsByModuleAndText(final String moduleName, final String text, final Integer max, final Integer offset, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Log log = LogService.this.fetchLogsByModuleAndText(moduleName, text, max, offset);
                    callBack.onSuccess(log);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    private Log fetchLogsByLevel(String level) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(level, "Level");
        String response = null;
        Log logObj = null;
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("type", level);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/" + "type" + "/" + level;
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            logObj = new LogResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return logObj;
    }

    private App42Response fetchLogsCountByLevel(String level) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(level, "Level");
        String response = null;
        App42Response responseObj = new App42Response();
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("type", level);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/" + "type" + "/" + level + "/count";
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            responseObj.setStrResponse(response);
            responseObj.setResponseSuccess(true);
            responseObj.setTotalRecords(new LogResponseBuilder().getTotalRecords(response));
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return responseObj;
    }

    public App42Response fetchLogsCountByInfo() throws App42Exception {
        return this.fetchLogsCountByLevel("INFO");
    }

    public void fetchLogsCountByInfo(final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    App42Response log = LogService.this.fetchLogsCountByInfo();
                    callBack.onSuccess(log);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public App42Response fetchLogsCountByDebug() throws App42Exception {
        return this.fetchLogsCountByLevel("DEBUG");
    }

    public void fetchLogsCountByDebug(final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    App42Response log = LogService.this.fetchLogsCountByDebug();
                    callBack.onSuccess(log);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public App42Response fetchLogsCountByError() throws App42Exception {
        return this.fetchLogsCountByLevel("ERROR");
    }

    public void fetchLogsCountByError(final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    App42Response log = LogService.this.fetchLogsCountByError();
                    callBack.onSuccess(log);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public App42Response fetchLogsCountByFatal() throws App42Exception {
        return this.fetchLogsCountByLevel("FATAL");
    }

    public void fetchLogsCountByFatal(final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    App42Response log = LogService.this.fetchLogsCountByFatal();
                    callBack.onSuccess(log);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    private Log fetchLogsByLevel(String level, Integer max, Integer offset) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(level, "Level");
        Util.throwExceptionIfNullOrBlank(max, "Max");
        Util.throwExceptionIfNullOrBlank(offset, "Offset");
        String response = null;
        Log logObj = null;
        Util.validateMax(max);
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("type", level);
            signParams.put("max", "" + max);
            signParams.put("offset", "" + offset);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/" + "paging" + "/" + "type" + "/" + level + "/" + max + "/" + offset;
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            logObj = new LogResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return logObj;
    }

    public Log fetchLogsByInfo() throws App42Exception {
        return this.fetchLogsByLevel("INFO");
    }

    public void fetchLogsByInfo(final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Log log = LogService.this.fetchLogsByInfo();
                    callBack.onSuccess(log);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Log fetchLogsByDebug() throws App42Exception {
        return this.fetchLogsByLevel("DEBUG");
    }

    public void fetchLogsByDebug(final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Log log = LogService.this.fetchLogsByDebug();
                    callBack.onSuccess(log);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Log fetchLogsByError() throws App42Exception {
        return this.fetchLogsByLevel("ERROR");
    }

    public void fetchLogsByError(final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Log log = LogService.this.fetchLogsByError();
                    callBack.onSuccess(log);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Log fetchLogsByFatal() throws App42Exception {
        return this.fetchLogsByLevel("FATAL");
    }

    public void fetchLogsByFatal(final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Log log = LogService.this.fetchLogsByFatal();
                    callBack.onSuccess(log);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Log fetchLogsByInfo(Integer max, Integer offset) throws App42Exception {
        return this.fetchLogsByLevel("INFO", max, offset);
    }

    public void fetchLogsByInfo(final Integer max, final Integer offset, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Log log = LogService.this.fetchLogsByInfo(max, offset);
                    callBack.onSuccess(log);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Log fetchLogsByDebug(Integer max, Integer offset) throws App42Exception {
        return this.fetchLogsByLevel("DEBUG", max, offset);
    }

    public void fetchLogsByDebug(final Integer max, final Integer offset, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Log log = LogService.this.fetchLogsByDebug(max, offset);
                    callBack.onSuccess(log);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Log fetchLogsByError(Integer max, Integer offset) throws App42Exception {
        return this.fetchLogsByLevel("ERROR", max, offset);
    }

    public void fetchLogsByError(final Integer max, final Integer offset, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Log log = LogService.this.fetchLogsByError(max, offset);
                    callBack.onSuccess(log);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Log fetchLogsByFatal(Integer max, Integer offset) throws App42Exception {
        return this.fetchLogsByLevel("FATAL", max, offset);
    }

    public void fetchLogsByFatal(final Integer max, final Integer offset, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Log log = LogService.this.fetchLogsByFatal(max, offset);
                    callBack.onSuccess(log);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Log fetchLogByDateRange(Date startDate, Date endDate) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(startDate, "Start Date");
        Util.throwExceptionIfNullOrBlank(endDate, "End Date");
        String response = null;
        Log logObj = null;
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            String strStartDate = Util.getUTCFormattedTimestamp(startDate);
            String strEndDate = Util.getUTCFormattedTimestamp(endDate);
            signParams.put("startDate", strStartDate);
            signParams.put("endDate", strEndDate);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/" + "startDate" + "/" + strStartDate + "/" + "endDate" + "/" + strEndDate;
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            logObj = new LogResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return logObj;
    }

    public void fetchLogByDateRange(final Date startDate, final Date endDate, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Log log = LogService.this.fetchLogByDateRange(startDate, endDate);
                    callBack.onSuccess(log);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public App42Response fetchLogCountByDateRange(Date startDate, Date endDate) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(startDate, "Start Date");
        Util.throwExceptionIfNullOrBlank(endDate, "End Date");
        String response = null;
        App42Response responseObj = new App42Response();
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            String strStartDate = Util.getUTCFormattedTimestamp(startDate);
            String strEndDate = Util.getUTCFormattedTimestamp(endDate);
            signParams.put("startDate", strStartDate);
            signParams.put("endDate", strEndDate);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/" + "startDate" + "/" + strStartDate + "/" + "endDate" + "/" + strEndDate + "/count";
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            responseObj.setStrResponse(response);
            responseObj.setResponseSuccess(true);
            responseObj.setTotalRecords(new LogResponseBuilder().getTotalRecords(response));
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return responseObj;
    }

    public void fetchLogCountByDateRange(final Date startDate, final Date endDate, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    App42Response log = LogService.this.fetchLogCountByDateRange(startDate, endDate);
                    callBack.onSuccess(log);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Log fetchLogByDateRange(Date startDate, Date endDate, Integer max, Integer offset) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(startDate, "Start Date");
        Util.throwExceptionIfNullOrBlank(endDate, "End Date");
        Util.throwExceptionIfNullOrBlank(max, "Max");
        Util.throwExceptionIfNullOrBlank(offset, "Offset");
        String response = null;
        Log logObj = null;
        Util.validateMax(max);
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            String strStartDate = Util.getUTCFormattedTimestamp(startDate);
            String strEndDate = Util.getUTCFormattedTimestamp(endDate);
            signParams.put("startDate", strStartDate);
            signParams.put("endDate", strEndDate);
            signParams.put("max", "" + max);
            signParams.put("offset", "" + offset);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/" + "paging" + "/" + "startDate" + "/" + strStartDate + "/" + "endDate" + "/" + strEndDate + "/" + max + "/" + offset;
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            logObj = new LogResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return logObj;
    }

    public void fetchLogByDateRange(final Date startDate, final Date endDate, final Integer max, final Integer offset, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Log log = LogService.this.fetchLogByDateRange(startDate, endDate, max, offset);
                    callBack.onSuccess(log);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public void setEvent(String moduleName, String eventName) throws App42Exception {
        this.event = eventName;
        Util.throwExceptionIfNullOrBlank(eventName, "eventName");
        this.info("EventMessage", moduleName);
    }

    public void setEvent(String eventName) throws App42Exception {
        this.event = eventName;
        Util.throwExceptionIfNullOrBlank(eventName, "eventName");
        this.info(eventName, "_App42_Event");
    }

    public void setEvent(String moduleName, String eventName, App42CallBack callBack) throws App42Exception {
        this.event = eventName;
        Util.throwExceptionIfNullOrBlank(eventName, "eventName");
        this.info("EventMessage", moduleName, callBack);
    }

    public void setEvent(String eventName, App42CallBack callBack) throws App42Exception {
        this.event = eventName;
        Util.throwExceptionIfNullOrBlank(eventName, "eventName");
        this.info(eventName, "_App42_Event", callBack);
    }
}

