/*
 * Decompiled with CFR 0.152.
 */
package com.shephertz.app42.paas.sdk.jme.session;

import com.shephertz.app42.paas.sdk.jme.App42ResponseBuilder;
import com.shephertz.app42.paas.sdk.jme.session.Session;
import com.shephertz.app42.paas.sdk.jme.util.Util;
import java.util.Vector;
import org.json.jme.JSONArray;
import org.json.jme.JSONObject;

public class SessionResponseBuilder
extends App42ResponseBuilder {
    public Session buildResponse(String json) throws Exception {
        Session sessionObj = new Session();
        Vector attributeList = new Vector();
        sessionObj.setAttributeList(attributeList);
        sessionObj.setStrResponse(json);
        JSONObject jsonObj = new JSONObject(json);
        JSONObject jsonObjApp42 = jsonObj.getJSONObject("app42");
        JSONObject jsonObjResponse = jsonObjApp42.getJSONObject("response");
        sessionObj.setResponseSuccess(jsonObjResponse.getBoolean("success"));
        JSONObject jsonObjSession = jsonObjResponse.getJSONObject("session");
        this.buildObjectFromJSONTree(sessionObj, jsonObjSession);
        if (!jsonObjSession.has("attributes")) {
            return sessionObj;
        }
        JSONObject jsonObjAttributes = jsonObjSession.getJSONObject("attributes");
        if (!jsonObjAttributes.has("attribute")) {
            return sessionObj;
        }
        if (jsonObjAttributes.get("attribute") instanceof JSONObject) {
            JSONObject jsonObjAttribute = jsonObjAttributes.getJSONObject("attribute");
            Session.Attribute attribute = sessionObj.new Session.Attribute();
            this.buildObjectFromJSONTree(attribute, jsonObjAttribute);
        } else {
            JSONArray jsonObjAttributeArray = jsonObjAttributes.getJSONArray("attribute");
            for (int i = 0; i < jsonObjAttributeArray.length(); ++i) {
                JSONObject jsonObjAttribute = jsonObjAttributeArray.getJSONObject(i);
                Session.Attribute attribute = sessionObj.new Session.Attribute();
                this.buildObjectFromJSONTree(attribute, jsonObjAttribute);
            }
        }
        return sessionObj;
    }

    public static void main(String[] args) throws Exception {
        Session seeionObj = new SessionResponseBuilder().buildResponse("{\"app42\":{\"response\":{\"success\":true,\"session\":{\"userName\":\"test\",\"sessionId\":\"f4e29dc2-6482-43b0-ad23-f499caab08e8\",\"createdOn\":\"2012-03-22T02:05:23.000Z\",\"attributes\": {  \"attribute\": [  {   \"name\": \"language\",  \"value\": \"eng\"   },    {     \"name\": \"version\",       \"value\": \"1.0\"    }    ]  }  }}}}");
    }

    public void buildObjectFromJSONTree(Object obj, JSONObject jsonObj) throws Exception {
        String name;
        int i;
        String[] names;
        if (obj instanceof Session) {
            Session session = (Session)obj;
            names = this.getNames(jsonObj);
            if (names != null) {
                for (i = 0; i < names.length; ++i) {
                    name = names[i];
                    if (name.equals("userName")) {
                        session.setUserName("" + jsonObj.get(name));
                    }
                    if (name.equals("sessionId")) {
                        session.setSessionId("" + jsonObj.get(name));
                    }
                    if (name.equals("createdOn") && jsonObj.get(name) != null) {
                        session.setCreatedOn(Util.getDateFromUTCTimeStamp("" + jsonObj.get(name)));
                    }
                    if (!name.equals("invalidatedOn") || jsonObj.get(name) == null) continue;
                    session.setInvalidatedOn(Util.getDateFromUTCTimeStamp("" + jsonObj.get(name)));
                }
            }
        }
        if (obj instanceof Session.Attribute) {
            Session.Attribute attribute = (Session.Attribute)obj;
            names = this.getNames(jsonObj);
            if (names != null) {
                for (i = 0; i < names.length; ++i) {
                    name = names[i];
                    if (name.equals("name")) {
                        attribute.setName("" + jsonObj.get(name));
                    }
                    if (!name.equals("value")) continue;
                    attribute.setValue("" + jsonObj.get(name));
                }
            }
        }
    }
}

