/*
 * Decompiled with CFR 0.152.
 */
package com.shephertz.app42.paas.sdk.jme.shopping;

import com.shephertz.app42.paas.sdk.jme.App42ResponseBuilder;
import com.shephertz.app42.paas.sdk.jme.shopping.Cart;
import com.shephertz.app42.paas.sdk.jme.util.Util;
import java.util.Vector;
import org.json.jme.JSONArray;
import org.json.jme.JSONObject;

public class CartResponseBuilder
extends App42ResponseBuilder {
    public Cart buildResponse(String json) throws Exception {
        JSONObject cartsJSONObj = this.getServiceJSONObject("carts", json);
        JSONObject cartJSONObj = cartsJSONObj.getJSONObject("cart");
        Cart cart = this.buildCartObject(cartJSONObj);
        cart.setStrResponse(json);
        cart.setResponseSuccess(this.isResponseSuccess(json));
        return cart;
    }

    private Cart buildCartObject(JSONObject cartJSONObj) throws Exception {
        Cart cart = new Cart();
        this.buildObjectFromJSONTree(cart, cartJSONObj);
        if (cartJSONObj.has("items") && cartJSONObj.getJSONObject("items").has("item")) {
            if (cartJSONObj.getJSONObject("items").get("item") instanceof JSONObject) {
                JSONObject itemJSONObj = cartJSONObj.getJSONObject("items").getJSONObject("item");
                Cart.Item item = cart.new Cart.Item();
                this.buildObjectFromJSONTree(item, itemJSONObj);
            } else {
                JSONArray itemJSONArray = cartJSONObj.getJSONObject("items").getJSONArray("item");
                for (int i = 0; i < itemJSONArray.length(); ++i) {
                    JSONObject itemJSONObj = itemJSONArray.getJSONObject(i);
                    Cart.Item item = cart.new Cart.Item();
                    this.buildObjectFromJSONTree(item, itemJSONObj);
                }
            }
        }
        if (cartJSONObj.has("payments") && cartJSONObj.getJSONObject("payments").has("payment")) {
            JSONObject paymentJSONObj = cartJSONObj.getJSONObject("payments").getJSONObject("payment");
            Cart.Payment payment = cart.new Cart.Payment();
            this.buildObjectFromJSONTree(payment, paymentJSONObj);
        }
        return cart;
    }

    public Vector buildArrayResponse(String json) throws Exception {
        JSONObject cartsJSONObj = this.getServiceJSONObject("carts", json);
        Vector<Cart> cartList = new Vector<Cart>();
        if (cartsJSONObj.get("cart") instanceof JSONArray) {
            JSONArray cartJSONArray = cartsJSONObj.getJSONArray("cart");
            for (int i = 0; i < cartJSONArray.length(); ++i) {
                JSONObject cartJSONObj = cartJSONArray.getJSONObject(i);
                Cart cart = this.buildCartObject(cartJSONObj);
                cart.setStrResponse(json);
                cart.setResponseSuccess(this.isResponseSuccess(json));
                cartList.addElement(cart);
            }
        } else {
            JSONObject cartJSONObj = cartsJSONObj.getJSONObject("cart");
            Cart cart = this.buildCartObject(cartJSONObj);
            cart.setStrResponse(json);
            cart.setResponseSuccess(this.isResponseSuccess(json));
            cartList.addElement(cart);
        }
        return cartList;
    }

    public void buildObjectFromJSONTree(Object obj, JSONObject jsonObj) throws Exception {
        String name;
        int i;
        String[] names;
        if (obj instanceof Cart) {
            Cart cart = (Cart)obj;
            names = this.getNames(jsonObj);
            if (names != null) {
                for (i = 0; i < names.length; ++i) {
                    name = names[i];
                    if (name.equals("userName")) {
                        cart.setUserName("" + jsonObj.get(name));
                    }
                    if (name.equals("cartId")) {
                        cart.setCartId("" + jsonObj.get(name));
                    }
                    if (name.equals("creationTime") && jsonObj.get(name) != null) {
                        cart.setCreationTime(Util.getDateFromUTCTimeStamp("" + jsonObj.get(name)));
                    }
                    if (name.equals("checkOutTime") && jsonObj.get(name) != null) {
                        cart.setCheckOutTime(Util.getDateFromUTCTimeStamp("" + jsonObj.get(name)));
                    }
                    if (name.equals("state") && jsonObj.get(name) != null) {
                        cart.setState("" + jsonObj.get(name));
                    }
                    if (name.equals("isEmpty") && jsonObj.get(name) != null) {
                        cart.setIsEmpty(new Boolean(Util.strToBool("" + jsonObj.get(name))));
                    }
                    if (name.equals("cartSession")) {
                        cart.setCartSession("" + jsonObj.get(name));
                    }
                    if (!name.equals("totalAmount")) continue;
                    cart.setTotalAmount(Double.valueOf("" + jsonObj.get(name)));
                }
            }
        }
        if (obj instanceof Cart.Item) {
            Cart.Item item = (Cart.Item)obj;
            names = this.getNames(jsonObj);
            if (names != null) {
                for (i = 0; i < names.length; ++i) {
                    name = names[i];
                    if (name.equals("itemId")) {
                        item.setItemId("" + jsonObj.get(name));
                    }
                    if (name.equals("quantity")) {
                        item.setQuantity(Integer.valueOf("" + jsonObj.get(name)));
                    }
                    if (name.equals("name")) {
                        item.setName("" + jsonObj.get(name));
                    }
                    if (name.equals("image")) {
                        item.setImage("" + jsonObj.get(name));
                    }
                    if (name.equals("price")) {
                        item.setPrice(Double.valueOf("" + jsonObj.get(name)));
                    }
                    if (!name.equals("totalAmount")) continue;
                    item.setTotalAmount(Double.valueOf("" + jsonObj.get(name)));
                }
            }
        }
        if (obj instanceof Cart.Payment) {
            Cart.Payment payment = (Cart.Payment)obj;
            names = this.getNames(jsonObj);
            if (names != null) {
                for (i = 0; i < names.length; ++i) {
                    name = names[i];
                    if (name.equals("transactionId")) {
                        payment.setTransactionId("" + jsonObj.get(name));
                    }
                    if (name.equals("totalAmount")) {
                        payment.setTotalAmount(Double.valueOf("" + jsonObj.get(name)));
                    }
                    if (name.equals("status")) {
                        payment.setStatus("" + jsonObj.get(name));
                    }
                    if (!name.equals("date") || jsonObj.get(name) == null) continue;
                    payment.setDate(Util.getDateFromUTCTimeStamp("" + jsonObj.get(name)));
                }
            }
        }
    }
}

