/*
 * Decompiled with CFR 0.152.
 */
package com.shephertz.app42.paas.sdk.jme.storage;

import com.shephertz.app42.paas.sdk.jme.ACL;
import com.shephertz.app42.paas.sdk.jme.App42CallBack;
import com.shephertz.app42.paas.sdk.jme.App42Exception;
import com.shephertz.app42.paas.sdk.jme.App42Log;
import com.shephertz.app42.paas.sdk.jme.App42Response;
import com.shephertz.app42.paas.sdk.jme.App42Service;
import com.shephertz.app42.paas.sdk.jme.connection.RESTConnectorAsync;
import com.shephertz.app42.paas.sdk.jme.storage.GeoQuery;
import com.shephertz.app42.paas.sdk.jme.storage.OrderByType;
import com.shephertz.app42.paas.sdk.jme.storage.Query;
import com.shephertz.app42.paas.sdk.jme.storage.Storage;
import com.shephertz.app42.paas.sdk.jme.storage.StorageResponseBuilder;
import com.shephertz.app42.paas.sdk.jme.util.Util;
import java.util.Enumeration;
import java.util.Hashtable;
import org.json.jme.JSONArray;
import org.json.jme.JSONObject;

public class StorageService
extends App42Service {
    private String resource = "storage";

    public StorageService(String apiKey, String secretKey, String baseURL) {
        this.apiKey = apiKey;
        this.secretKey = secretKey;
        this.version = "1.0";
    }

    public Storage insertJSONDocument(String dbName, String collectionName, String json) throws App42Exception {
        String response = null;
        Storage storage = null;
        Util.throwExceptionIfNullOrBlank(dbName, "DataBaseName");
        Util.throwExceptionIfNullOrBlank(collectionName, "CollectionName");
        Util.throwExceptionIfNullOrBlank(json, "Json");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("dbName", dbName);
            signParams.put("collectionName", collectionName);
            JSONObject obj = new JSONObject();
            obj.put("jsonDoc", json);
            StringBuffer sb = new StringBuffer();
            sb.append("{\"app42\":{\"storage\":").append(obj.toString()).append("}}");
            App42Log.debug(" Json String : " + sb.toString());
            signParams.put("body", sb.toString());
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/insert/dbName/" + dbName + "/collectionName/" + collectionName;
            response = RESTConnectorAsync.getInstance().executePost(resourceURL, queryParams, sb.toString(), headerParams);
            System.out.println(response);
            storage = new StorageResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return storage;
    }

    public void insertJSONDocument(final String dbName, final String collectionName, final String json, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Storage storage = StorageService.this.insertJSONDocument(dbName, collectionName, json);
                    callBack.onSuccess(storage);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Storage insertJSONDocument(String dbName, String collectionName, JSONObject json) throws App42Exception {
        String response = null;
        Storage storage = null;
        Util.throwExceptionIfNullOrBlank(dbName, "DataBaseName");
        Util.throwExceptionIfNullOrBlank(collectionName, "CollectionName");
        Util.throwExceptionIfNullOrBlank(json, "Json");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("dbName", dbName);
            signParams.put("collectionName", collectionName);
            JSONObject obj = new JSONObject();
            obj.put("jsonDoc", json);
            StringBuffer sb = new StringBuffer();
            sb.append("{\"app42\":{\"storage\":").append(obj.toString()).append("}}");
            App42Log.debug(" Json String : " + sb.toString());
            signParams.put("body", sb.toString());
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/insert/dbName/" + dbName + "/collectionName/" + collectionName;
            response = RESTConnectorAsync.getInstance().executePost(resourceURL, queryParams, sb.toString(), headerParams);
            storage = new StorageResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return storage;
    }

    public void insertJSONDocument(final String dbName, final String collectionName, final JSONObject json, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Storage storage = StorageService.this.insertJSONDocument(dbName, collectionName, json);
                    callBack.onSuccess(storage);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Storage findAllDocuments(String dbName, String collectionName) throws App42Exception {
        String response = null;
        Storage storage = null;
        Util.throwExceptionIfNullOrBlank(dbName, "DataBaseName");
        Util.throwExceptionIfNullOrBlank(collectionName, "CollectionName");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("dbName", dbName);
            signParams.put("collectionName", collectionName);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/findAll/dbName/" + dbName + "/collectionName/" + collectionName;
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            storage = new StorageResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return storage;
    }

    public void findAllDocuments(final String dbName, final String collectionName, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Storage storage = StorageService.this.findAllDocuments(dbName, collectionName);
                    callBack.onSuccess(storage);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public App42Response findAllDocumentsCount(String dbName, String collectionName) throws App42Exception {
        String response = null;
        App42Response responseObj = new App42Response();
        Util.throwExceptionIfNullOrBlank(dbName, "DataBaseName");
        Util.throwExceptionIfNullOrBlank(collectionName, "CollectionName");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("dbName", dbName);
            signParams.put("collectionName", collectionName);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/findAll/count/dbName/" + dbName + "/collectionName/" + collectionName;
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            responseObj.setStrResponse(response);
            responseObj.setResponseSuccess(true);
            responseObj.setTotalRecords(new StorageResponseBuilder().getTotalRecords(response));
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return responseObj;
    }

    public void findAllDocumentsCount(final String dbName, final String collectionName, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    App42Response storage = StorageService.this.findAllDocumentsCount(dbName, collectionName);
                    callBack.onSuccess(storage);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Storage findAllDocuments(String dbName, String collectionName, Integer max, Integer offset) throws App42Exception {
        String response = null;
        Storage storage = null;
        Util.throwExceptionIfNullOrBlank(dbName, "DataBaseName");
        Util.throwExceptionIfNullOrBlank(collectionName, "CollectionName");
        Util.throwExceptionIfNullOrBlank(max, "Max");
        Util.throwExceptionIfNullOrBlank(offset, "Offset");
        Util.validateMax(max);
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            signParams.put("dbName", dbName);
            signParams.put("collectionName", collectionName);
            signParams.put("max", "" + max);
            signParams.put("offset", "" + offset);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/findAll/dbName/" + dbName + "/collectionName/" + collectionName + "/" + max + "/" + offset;
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            storage = new StorageResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return storage;
    }

    public void findAllDocuments(final String dbName, final String collectionName, final Integer max, final Integer offset, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Storage storage = StorageService.this.findAllDocuments(dbName, collectionName, max, offset);
                    callBack.onSuccess(storage);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Storage findDocumentById(String dbName, String collectionName, String docId) throws App42Exception {
        String response = null;
        Storage storage = null;
        Util.throwExceptionIfNullOrBlank(dbName, "DataBaseName");
        Util.throwExceptionIfNullOrBlank(collectionName, "CollectionName");
        Util.throwExceptionIfNullOrBlank(docId, "DocumentId");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("dbName", dbName);
            signParams.put("collectionName", collectionName);
            signParams.put("docId", docId);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/findDocById/dbName/" + dbName + "/collectionName/" + collectionName + "/docId/" + docId;
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            storage = new StorageResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return storage;
    }

    public void findDocumentById(final String dbName, final String collectionName, final String docId, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Storage storage = StorageService.this.findDocumentById(dbName, collectionName, docId);
                    callBack.onSuccess(storage);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Storage findDocumentByKeyValue(String dbName, String collectionName, String key, String value) throws App42Exception {
        String response = null;
        Storage storage = null;
        Util.throwExceptionIfNullOrBlank(dbName, "DataBaseName");
        Util.throwExceptionIfNullOrBlank(collectionName, "CollectionName");
        Util.throwExceptionIfNullOrBlank(key, "Key");
        Util.throwExceptionIfNullOrBlank(value, "Value");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("dbName", dbName);
            signParams.put("collectionName", collectionName);
            signParams.put("key", key);
            signParams.put("value", value);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/findDocByKV/dbName/" + dbName + "/collectionName/" + collectionName + "/" + key + "/" + value;
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            storage = new StorageResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return storage;
    }

    public void findDocumentByKeyValue(final String dbName, final String collectionName, final String key, final String value, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Storage storage = StorageService.this.findDocumentByKeyValue(dbName, collectionName, key, value);
                    callBack.onSuccess(storage);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Storage findDocumentsByQuery(String dbName, String collectionName, Query query) throws App42Exception {
        String response = null;
        Storage storage = null;
        Util.throwExceptionIfNullOrBlank(dbName, "DataBaseName");
        Util.throwExceptionIfNullOrBlank(collectionName, "CollectionName");
        Util.throwExceptionIfNullOrBlank(query, "query");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams.put("jsonQuery", query.getStr());
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("dbName", dbName);
            signParams.put("collectionName", collectionName);
            signParams.put("jsonQuery", query.getStr());
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/findDocsByQuery/dbName/" + dbName + "/collectionName/" + collectionName;
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            storage = new StorageResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return storage;
    }

    public void findDocumentsByQuery(final String dbName, final String collectionName, final Query query, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Storage storage = StorageService.this.findDocumentsByQuery(dbName, collectionName, query);
                    callBack.onSuccess(storage);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Storage findDocumentsByQueryWithPaging(String dbName, String collectionName, Query query, Integer max, Integer offset) throws App42Exception {
        String response = null;
        Storage storage = null;
        Util.throwExceptionIfNullOrBlank(dbName, "DataBaseName");
        Util.throwExceptionIfNullOrBlank(collectionName, "CollectionName");
        Util.throwExceptionIfNullOrBlank(query, "query");
        Util.throwExceptionIfNullOrBlank(max, "max");
        Util.throwExceptionIfNullOrBlank(offset, "offset");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams.put("jsonQuery", query.getStr());
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("dbName", dbName);
            signParams.put("collectionName", collectionName);
            signParams.put("jsonQuery", query.getStr());
            signParams.put("max", "" + max);
            signParams.put("offset", "" + offset);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/findDocsByQuery/dbName/" + dbName + "/collectionName/" + collectionName + "/" + max + "/" + offset;
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            storage = new StorageResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return storage;
    }

    public void findDocumentsByQueryWithPaging(final String dbName, final String collectionName, final Query query, final Integer max, final Integer offset, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Storage storage = StorageService.this.findDocumentsByQueryWithPaging(dbName, collectionName, query, max, offset);
                    callBack.onSuccess(storage);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Storage findDocsWithQueryPagingOrderBy(String dbName, String collectionName, Query query, Integer max, Integer offset, String orderByKey, String type) throws App42Exception {
        String response = null;
        Storage storage = null;
        Util.throwExceptionIfNullOrBlank(dbName, "DataBaseName");
        Util.throwExceptionIfNullOrBlank(collectionName, "CollectionName");
        Util.throwExceptionIfNullOrBlank(query, "query");
        Util.throwExceptionIfNullOrBlank(max, "max");
        Util.throwExceptionIfNullOrBlank(offset, "offset");
        OrderByType.throwExceptionIfNotValid(type);
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams.put("jsonQuery", query.getStr());
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            if (orderByKey != null) {
                queryParams.put("orderByKey", orderByKey);
            }
            if (type != null) {
                queryParams.put("orderByType", type);
            }
            signParams.put("dbName", dbName);
            signParams.put("collectionName", collectionName);
            signParams.put("jsonQuery", query.getStr());
            signParams.put("max", "" + max);
            signParams.put("offset", "" + offset);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/findDocsByQuery/dbName/" + dbName + "/collectionName/" + collectionName + "/" + max + "/" + offset;
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            storage = new StorageResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return storage;
    }

    public void findDocsWithQueryPagingOrderBy(final String dbName, final String collectionName, final Query query, final Integer max, final Integer offset, final String orderByKey, final String type, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Storage storage = StorageService.this.findDocsWithQueryPagingOrderBy(dbName, collectionName, query, max, offset, orderByKey, type);
                    callBack.onSuccess(storage);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Storage updateDocumentByKeyValue(String dbName, String collectionName, String key, String value, String newJsonDoc) throws App42Exception {
        String response = null;
        Storage storage = null;
        Util.throwExceptionIfNullOrBlank(dbName, "DataBaseName");
        Util.throwExceptionIfNullOrBlank(collectionName, "CollectionName");
        Util.throwExceptionIfNullOrBlank(key, "Key");
        Util.throwExceptionIfNullOrBlank(value, "Value");
        Util.throwExceptionIfNullOrBlank(newJsonDoc, "NewJsonDocument");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("dbName", dbName);
            signParams.put("collectionName", collectionName);
            signParams.put("key", key);
            signParams.put("value", value);
            JSONObject obj = new JSONObject();
            obj.put("jsonDoc", newJsonDoc);
            StringBuffer sb = new StringBuffer();
            sb.append("{\"app42\":{\"storage\":").append(obj.toString()).append("}}");
            App42Log.debug(" Json String : " + sb.toString());
            signParams.put("body", sb.toString());
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/update/dbName/" + dbName + "/collectionName/" + collectionName + "/" + key + "/" + value;
            response = RESTConnectorAsync.getInstance().executePut(resourceURL, queryParams, sb.toString(), headerParams);
            storage = new StorageResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return storage;
    }

    public void updateDocumentByKeyValue(final String dbName, final String collectionName, final String key, final String value, final String newJsonDoc, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Storage storage = StorageService.this.updateDocumentByKeyValue(dbName, collectionName, key, value, newJsonDoc);
                    callBack.onSuccess(storage);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Storage updateDocumentByDocId(String dbName, String collectionName, String docId, String newJsonDoc) throws App42Exception {
        String response = null;
        Storage storage = null;
        Util.throwExceptionIfNullOrBlank(dbName, "DataBaseName");
        Util.throwExceptionIfNullOrBlank(collectionName, "CollectionName");
        Util.throwExceptionIfNullOrBlank(docId, "DocId");
        Util.throwExceptionIfNullOrBlank(newJsonDoc, "NewJsonDocument");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("dbName", dbName);
            signParams.put("collectionName", collectionName);
            signParams.put("docId", docId);
            JSONObject obj = new JSONObject();
            obj.put("jsonDoc", newJsonDoc);
            StringBuffer sb = new StringBuffer();
            sb.append("{\"app42\":{\"storage\":").append(obj.toString()).append("}}");
            App42Log.debug(" Json String : " + sb.toString());
            signParams.put("body", sb.toString());
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/updateByDocId/dbName/" + dbName + "/collectionName/" + collectionName + "/docId/" + docId;
            response = RESTConnectorAsync.getInstance().executePut(resourceURL, queryParams, sb.toString(), headerParams);
            storage = new StorageResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return storage;
    }

    public void updateDocumentByDocId(final String dbName, final String collectionName, final String docId, final String newJsonDoc, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Storage storage = StorageService.this.updateDocumentByDocId(dbName, collectionName, docId, newJsonDoc);
                    callBack.onSuccess(storage);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public App42Response deleteDocumentById(String dbName, String collectionName, String docId) throws App42Exception {
        String response = null;
        App42Response responseObj = new App42Response();
        Util.throwExceptionIfNullOrBlank(dbName, "DataBaseName");
        Util.throwExceptionIfNullOrBlank(collectionName, "CollectionName");
        Util.throwExceptionIfNullOrBlank(docId, "DocumentId");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("dbName", dbName);
            signParams.put("collectionName", collectionName);
            signParams.put("docId", docId);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/deleteDocById/dbName/" + dbName + "/collectionName/" + collectionName + "/docId/" + docId;
            response = RESTConnectorAsync.getInstance().executeDelete(resourceURL, queryParams, headerParams);
            responseObj.setStrResponse(response);
            responseObj.setResponseSuccess(true);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return responseObj;
    }

    public void deleteDocumentById(final String dbName, final String collectionName, final String docId, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    App42Response storage = StorageService.this.deleteDocumentById(dbName, collectionName, docId);
                    callBack.onSuccess(storage);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public String getJsonFromMap(Hashtable map) throws App42Exception {
        StringBuffer sb = new StringBuffer();
        try {
            sb.append("{");
            if (map != null && map.size() != 0) {
                Enumeration keySet = map.keys();
                int i = 0;
                while (keySet.hasMoreElements()) {
                    ++i;
                    String key = (String)keySet.nextElement();
                    String value = (String)map.get(key);
                    sb.append("\"" + key + "\"" + ":" + "\"" + value + "\"");
                    if (!keySet.hasMoreElements()) continue;
                    sb.append(",");
                }
            }
            sb.append("}");
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return sb.toString();
    }

    public void getJsonFromMap(final Hashtable map, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    String storage = StorageService.this.getJsonFromMap(map);
                    callBack.onSuccess(storage);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Storage insertJsonDocUsingMap(String dbName, String collectionName, Hashtable map) throws App42Exception {
        String jsonBody = this.getJsonFromMap(map);
        return this.insertJSONDocument(dbName, collectionName, jsonBody);
    }

    public void insertJsonDocUsingMap(final String dbName, final String collectionName, final Hashtable map, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Storage storage = StorageService.this.insertJsonDocUsingMap(dbName, collectionName, map);
                    callBack.onSuccess(storage);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public String mapReduce(String dbName, String collectionName, String mapFunction, String reduceFunction) throws App42Exception {
        String response = null;
        Util.throwExceptionIfNullOrBlank(dbName, "DataBaseName");
        Util.throwExceptionIfNullOrBlank(collectionName, "CollectionName");
        Util.throwExceptionIfNullOrBlank(mapFunction, "MapFunction");
        Util.throwExceptionIfNullOrBlank(reduceFunction, "ReduceFunction");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("dbName", dbName);
            signParams.put("collectionName", collectionName);
            JSONObject obj = new JSONObject();
            obj.put("map", mapFunction);
            obj.put("reduce", reduceFunction);
            StringBuffer sb = new StringBuffer();
            sb.append("{\"app42\":{\"storage\":").append(obj.toString()).append("}}");
            App42Log.debug(" Json String : " + sb.toString());
            signParams.put("body", sb.toString());
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/mapReduce/dbName/" + dbName + "/collectionName/" + collectionName;
            response = RESTConnectorAsync.getInstance().executePost(resourceURL, queryParams, sb.toString(), headerParams);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return response;
    }

    public void mapReduce(final String dbName, final String collectionName, final String mapFunction, final String reduceFunction, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    String storage = StorageService.this.mapReduce(dbName, collectionName, mapFunction, reduceFunction);
                    callBack.onSuccess(storage);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Storage grantAccessOnDoc(String dbName, String collectionName, String docId, Hashtable aclList) throws App42Exception {
        String response = null;
        Storage storage = null;
        Util.throwExceptionIfNullOrBlank(dbName, "DataBaseName");
        Util.throwExceptionIfNullOrBlank(collectionName, "CollectionName");
        Util.throwExceptionIfNullOrBlank(aclList, "aclList");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("dbName", dbName);
            signParams.put("collectionName", collectionName);
            signParams.put("docId", docId);
            JSONArray aclArray = new JSONArray();
            Enumeration aclListEnum = aclList.keys();
            while (aclListEnum.hasMoreElements()) {
                String key = aclListEnum.nextElement().toString();
                ACL acl = new ACL(key, aclList.get(key).toString());
                aclArray.put(acl.getJSONObject());
            }
            JSONObject obj = new JSONObject();
            obj.put("acls", "{\"acl\":" + aclArray + "}");
            StringBuffer sb = new StringBuffer();
            sb.append("{\"app42\":{\"storage\":").append(obj.toString()).append("}}");
            signParams.put("body", sb.toString());
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/" + "grantAccessOnDoc" + "/" + dbName + "/" + collectionName + "/" + docId;
            response = RESTConnectorAsync.getInstance().executePut(resourceURL, queryParams, sb.toString(), headerParams);
            storage = new StorageResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return storage;
    }

    public void grantAccessOnDoc(final String dbName, final String collectionName, final String docId, final Hashtable aclList, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Storage storage = StorageService.this.grantAccessOnDoc(dbName, collectionName, docId, aclList);
                    callBack.onSuccess(storage);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Storage revokeAccessOnDoc(String dbName, String collectionName, String docId, Hashtable aclList) throws App42Exception {
        String response = null;
        Storage storage = null;
        Util.throwExceptionIfNullOrBlank(dbName, "DataBaseName");
        Util.throwExceptionIfNullOrBlank(collectionName, "CollectionName");
        Util.throwExceptionIfNullOrBlank(aclList, "acl");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            Enumeration enum_keys = signParams.keys();
            while (enum_keys.hasMoreElements()) {
                String key = (String)enum_keys.nextElement();
                queryParams.put(key, signParams.get(key));
            }
            signParams.put("dbName", dbName);
            signParams.put("collectionName", collectionName);
            signParams.put("docId", docId);
            JSONArray aclArray = new JSONArray();
            Enumeration aclListEnum = aclList.keys();
            while (aclListEnum.hasMoreElements()) {
                String key = aclListEnum.nextElement().toString();
                ACL acl = new ACL(key, aclList.get(key).toString());
                aclArray.put(acl.getJSONObject());
            }
            JSONObject obj = new JSONObject();
            obj.put("acls", "{\"acl\":" + aclArray + "}");
            StringBuffer sb = new StringBuffer();
            sb.append("{\"app42\":{\"storage\":").append(obj.toString()).append("}}");
            signParams.put("body", sb.toString());
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/" + "revokeAccessOnDoc" + "/" + dbName + "/" + collectionName + "/" + docId;
            response = RESTConnectorAsync.getInstance().executePut(resourceURL, queryParams, sb.toString(), headerParams);
            storage = new StorageResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return storage;
    }

    public void revokeAccessOnDoc(final String dbName, final String collectionName, final String docId, final Hashtable aclList, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Storage storage = StorageService.this.revokeAccessOnDoc(dbName, collectionName, docId, aclList);
                    callBack.onSuccess(storage);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public App42Response deleteAllDocuments(String dbName, String collectionName) throws App42Exception {
        String response = null;
        App42Response responseObj = new App42Response();
        Util.throwExceptionIfNullOrBlank(dbName, "DataBaseName");
        Util.throwExceptionIfNullOrBlank(collectionName, "CollectionName");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("dbName", dbName);
            signParams.put("collectionName", collectionName);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/deleteAll/dbName/" + dbName + "/collectionName/" + collectionName;
            response = RESTConnectorAsync.getInstance().executeDelete(resourceURL, queryParams, headerParams);
            responseObj.setStrResponse(response);
            responseObj.setResponseSuccess(true);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return responseObj;
    }

    public void deleteAllDocuments(final String dbName, final String collectionName, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    App42Response storage = StorageService.this.deleteAllDocuments(dbName, collectionName);
                    callBack.onSuccess(storage);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public App42Response deleteDocumentsByKeyValue(String dbName, String collectionName, String key, Object value) throws App42Exception {
        String response = null;
        App42Response responseObj = new App42Response();
        Util.throwExceptionIfNullOrBlank(dbName, "DataBaseName");
        Util.throwExceptionIfNullOrBlank(collectionName, "CollectionName");
        Util.throwExceptionIfNullOrBlank(key, "key");
        Util.throwExceptionIfNullOrBlank(value, "value");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            JSONObject getKey = new JSONObject().put("key", value);
            signParams.put("value", getKey + "");
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("dbName", dbName);
            signParams.put("collectionName", collectionName);
            signParams.put("key", key);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/deletebykey/dbName/" + dbName + "/collectionName/" + collectionName + "/" + key;
            response = RESTConnectorAsync.getInstance().executeDelete(resourceURL, queryParams, headerParams);
            responseObj.setStrResponse(response);
            responseObj.setResponseSuccess(true);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return responseObj;
    }

    public void deleteDocumentsByKeyValue(final String dbName, final String collectionName, final String key, final Object value, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    App42Response storage = StorageService.this.deleteDocumentsByKeyValue(dbName, collectionName, key, value);
                    callBack.onSuccess(storage);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Storage findDocumentsByLocation(String dbName, String collectionName, GeoQuery query) throws App42Exception {
        String response = null;
        Storage storage = null;
        Util.throwExceptionIfNullOrBlank(dbName, "DbName");
        Util.throwExceptionIfNullOrBlank(collectionName, "CollectionName");
        Util.throwExceptionIfNullOrBlank(query, "Query");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("dbName", dbName);
            signParams.put("collectionName", collectionName);
            signParams.put("jsonQuery", query.getStr());
            queryParams.put("jsonQuery", query.getStr());
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/findDocsBylocation/dbName/" + dbName + "/collectionName/" + collectionName;
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            storage = new StorageResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return storage;
    }

    public void findDocumentsByLocation(final String dbName, final String collectionName, final GeoQuery query, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Storage storage = StorageService.this.findDocumentsByLocation(dbName, collectionName, query);
                    callBack.onSuccess(storage);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }
}

