/*
 * Decompiled with CFR 0.152.
 */
package ingame;

import component.CRectangle;
import component.CSpriteAnimation;
import component.CUtility;
import game.CCanvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class CCoin {
    private CSpriteAnimation[] animArrCoins;
    private int[][] iCoinPos = null;
    private boolean[] isCollected = null;
    private int iNoOfCoins;
    private int iCoinW;
    private int iCoinH;
    public boolean isAttracting = false;
    public static final int TOTAL_PATTERN = 7;
    public static final int PATTERN_VER_2 = 0;
    public static final int PATTERN_VER_3 = 1;
    public static final int PATTERN_HOR_2 = 2;
    public static final int PATTERN_HOR_3 = 3;
    public static final int PATTERN_HOR_4 = 4;
    public static final int PATTERN_DIA_R = 5;
    public static final int PATTERN_DIA_L = 6;

    public CCoin(Image imgCoin, int iPatternType, int iPosX, int iStartY) {
        try {
            this.iCoinW = imgCoin.getWidth() >> 2;
            this.iCoinH = imgCoin.getHeight();
            CSpriteAnimation tmpAnim = new CSpriteAnimation(imgCoin, 4, 2, false, false);
            switch (iPatternType) {
                case 0: {
                    this.iNoOfCoins = 2;
                    this.animArrCoins = new CSpriteAnimation[this.iNoOfCoins];
                    this.iCoinPos = new int[this.iNoOfCoins][2];
                    this.isCollected = new boolean[this.iNoOfCoins];
                    for (int i = 0; i < this.iNoOfCoins; ++i) {
                        this.animArrCoins[i] = tmpAnim;
                        this.iCoinPos[i][0] = iPosX;
                        this.iCoinPos[i][1] = iStartY + i * (this.iCoinH + (this.iCoinH >> 1));
                        this.isCollected[i] = false;
                    }
                    break;
                }
                case 1: {
                    this.iNoOfCoins = 3;
                    this.animArrCoins = new CSpriteAnimation[this.iNoOfCoins];
                    this.iCoinPos = new int[this.iNoOfCoins][2];
                    this.isCollected = new boolean[this.iNoOfCoins];
                    for (int i = 0; i < this.iNoOfCoins; ++i) {
                        this.animArrCoins[i] = tmpAnim;
                        this.iCoinPos[i][0] = iPosX;
                        this.iCoinPos[i][1] = iStartY + i * (this.iCoinH + (this.iCoinH >> 1));
                        this.isCollected[i] = false;
                    }
                    break;
                }
                case 2: {
                    this.iNoOfCoins = 2;
                    this.animArrCoins = new CSpriteAnimation[this.iNoOfCoins];
                    this.iCoinPos = new int[this.iNoOfCoins][2];
                    iPosX -= this.iCoinW * this.iNoOfCoins + (this.iCoinW >> 1) * (this.iNoOfCoins - 1) >> 1;
                    this.isCollected = new boolean[this.iNoOfCoins];
                    for (int i = 0; i < this.iNoOfCoins; ++i) {
                        this.animArrCoins[i] = tmpAnim;
                        this.iCoinPos[i][0] = iPosX + i * (this.iCoinW + (this.iCoinW >> 1));
                        this.iCoinPos[i][1] = iStartY;
                        this.isCollected[i] = false;
                    }
                    break;
                }
                case 3: {
                    this.iNoOfCoins = 3;
                    this.animArrCoins = new CSpriteAnimation[this.iNoOfCoins];
                    this.iCoinPos = new int[this.iNoOfCoins][2];
                    iPosX -= this.iCoinW * this.iNoOfCoins + (this.iCoinW >> 1) * (this.iNoOfCoins - 1) >> 1;
                    this.isCollected = new boolean[this.iNoOfCoins];
                    for (int i = 0; i < this.iNoOfCoins; ++i) {
                        this.animArrCoins[i] = tmpAnim;
                        this.iCoinPos[i][0] = iPosX + i * (this.iCoinW + (this.iCoinW >> 1));
                        this.iCoinPos[i][1] = iStartY;
                        this.isCollected[i] = false;
                    }
                    break;
                }
                case 4: {
                    this.iNoOfCoins = 4;
                    this.animArrCoins = new CSpriteAnimation[this.iNoOfCoins];
                    this.iCoinPos = new int[this.iNoOfCoins][2];
                    iPosX = (CCanvas.iScreenW >> 1) - (this.iCoinW * this.iNoOfCoins + (this.iCoinW >> 1) * (this.iNoOfCoins - 1) >> 1);
                    this.isCollected = new boolean[this.iNoOfCoins];
                    for (int i = 0; i < this.iNoOfCoins; ++i) {
                        this.animArrCoins[i] = tmpAnim;
                        this.iCoinPos[i][0] = iPosX + i * (this.iCoinW + (this.iCoinW >> 1));
                        this.iCoinPos[i][1] = iStartY;
                        this.isCollected[i] = false;
                    }
                    break;
                }
                case 5: {
                    this.iNoOfCoins = 4;
                    this.animArrCoins = new CSpriteAnimation[this.iNoOfCoins];
                    this.iCoinPos = new int[this.iNoOfCoins][2];
                    this.isCollected = new boolean[this.iNoOfCoins];
                    for (int i = 0; i < this.iNoOfCoins; ++i) {
                        this.animArrCoins[i] = tmpAnim;
                        this.iCoinPos[i][0] = iPosX + i * this.iCoinW;
                        this.iCoinPos[i][1] = iStartY + i * (this.iCoinH + (this.iCoinH >> 1));
                        this.isCollected[i] = false;
                    }
                    break;
                }
                case 6: {
                    this.iNoOfCoins = 4;
                    this.animArrCoins = new CSpriteAnimation[this.iNoOfCoins];
                    this.iCoinPos = new int[this.iNoOfCoins][2];
                    this.isCollected = new boolean[this.iNoOfCoins];
                    for (int i = 0; i < this.iNoOfCoins; ++i) {
                        this.animArrCoins[i] = tmpAnim;
                        this.iCoinPos[i][0] = iPosX - i * this.iCoinW;
                        this.iCoinPos[i][1] = iStartY + i * (this.iCoinH + (this.iCoinH >> 1));
                        this.isCollected[i] = false;
                    }
                    break;
                }
            }
            tmpAnim = null;
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    public void update(int iSpeed) {
        for (int i = 0; i < this.iNoOfCoins; ++i) {
            int[] nArray = this.iCoinPos[i];
            nArray[1] = nArray[1] + iSpeed;
        }
        this.animArrCoins[0].update();
    }

    public void attractCoin(int iTargetX, int iYSpeed, int iTargetY) {
        this.isAttracting = true;
        int iSpeed = 0;
        int iTime = (iTargetY - (CCanvas.iScreenH >> 4)) / (iYSpeed + 5);
        if (iTime <= 0) {
            iTime = 1;
        }
        for (int i = 0; i < this.iNoOfCoins; ++i) {
            if (this.isCollected[i] || this.iCoinPos[i][1] < CCanvas.iScreenH >> 4) continue;
            iSpeed = (iTargetX - this.iCoinPos[i][0]) / iTime;
            iSpeed = iSpeed < 0 ? --iSpeed : ++iSpeed;
            int[] nArray = this.iCoinPos[i];
            nArray[0] = nArray[0] + (iSpeed << 1);
            if (this.iCoinPos[i][1] > iTargetY) {
                int[] nArray2 = this.iCoinPos[i];
                nArray2[1] = nArray2[1] - (iYSpeed + 5);
                continue;
            }
            if (this.iCoinPos[i][1] >= iTargetY) continue;
            int[] nArray3 = this.iCoinPos[i];
            nArray3[1] = nArray3[1] + 5;
        }
    }

    public int getPosY() {
        return this.iCoinPos[0][1];
    }

    public void paint(Graphics g) {
        for (int i = 0; i < this.iNoOfCoins; ++i) {
            if (this.isCollected[i]) continue;
            this.animArrCoins[i].paint(g, this.iCoinPos[i][0], this.iCoinPos[i][1], 17);
        }
    }

    public int getCollisionCount(CRectangle rectBike) {
        int iCollCount = 0;
        for (int i = 0; i < this.iNoOfCoins; ++i) {
            if (this.isCollected[i]) continue;
            this.isCollected[i] = CUtility.isCollideRect(this.iCoinPos[i][0] - (this.iCoinW >> 1), this.iCoinPos[i][1], this.iCoinW, this.iCoinH, rectBike.iX, rectBike.iY, rectBike.iW, rectBike.iH);
            if (!this.isCollected[i]) continue;
            ++iCollCount;
        }
        return iCollCount;
    }
}

