/*
 * Decompiled with CFR 0.152.
 */
package ingame;

import component.CUtility;
import component.gameData;
import game.CCanvas;
import ingame.CIngameManager;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class CCutScene {
    private Image[][] imgArrCutScenes = new Image[2][2];
    private int[][][] iArrPos = new int[2][2][2];
    private int iCurScreen;
    private int iTimer;
    private int iSpeed;
    private boolean isAppearing;
    private boolean isStaying;
    private int iOffsetY;
    private Image imgBtnSkip;
    private Image imgBtnNext;
    private boolean isAnimComplete;

    public CCutScene() {
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                try {
                    this.imgArrCutScenes[i][j] = Image.createImage((String)("/cutscene_" + i + "" + j + ".png"));
                    if (j % 2 == 0) {
                        this.iArrPos[i][j][0] = -(this.imgArrCutScenes[i][j].getWidth() >> 1);
                        this.iArrPos[i][j][1] = 0;
                        continue;
                    }
                    this.iArrPos[i][j][0] = CCanvas.iScreenW + (this.imgArrCutScenes[i][j].getWidth() >> 1);
                    this.iArrPos[i][j][1] = this.imgArrCutScenes[i][j - 1].getHeight();
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.iSpeed = CCanvas.iScreenW >> 4;
        this.iCurScreen = 0;
        this.iTimer = CCanvas.FPS * 9;
        this.isAppearing = true;
        this.iOffsetY = CCanvas.iScreenH - this.imgArrCutScenes[0][0].getHeight() - this.imgArrCutScenes[0][1].getHeight() >> 1;
        try {
            this.imgBtnSkip = Image.createImage((String)"/skip.png");
            this.imgBtnNext = Image.createImage((String)"/next.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.isAnimComplete = false;
    }

    public void unload() {
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                try {
                    this.imgArrCutScenes[i][j] = null;
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.imgBtnNext = null;
        this.imgBtnSkip = null;
    }

    public void update() {
        if (!this.isAnimComplete) {
            if (this.isAppearing) {
                int[] nArray = this.iArrPos[this.iCurScreen][0];
                nArray[0] = nArray[0] + this.iSpeed;
                int[] nArray2 = this.iArrPos[this.iCurScreen][1];
                nArray2[0] = nArray2[0] - this.iSpeed;
                if (this.iArrPos[this.iCurScreen][0][0] >= CCanvas.iScreenW >> 1) {
                    this.iArrPos[this.iCurScreen][0][0] = CCanvas.iScreenW >> 1;
                }
                if (this.iArrPos[this.iCurScreen][1][0] <= CCanvas.iScreenW >> 1) {
                    this.iArrPos[this.iCurScreen][1][0] = CCanvas.iScreenW >> 1;
                }
                if (this.iArrPos[this.iCurScreen][0][0] == CCanvas.iScreenW >> 1 && this.iArrPos[this.iCurScreen][1][0] == CCanvas.iScreenW >> 1) {
                    this.isAppearing = false;
                    this.isStaying = true;
                }
            } else if (this.isStaying) {
                --this.iTimer;
                if (this.iTimer == 0) {
                    this.isStaying = false;
                    this.iTimer = CCanvas.FPS * 5;
                }
            } else {
                int[] nArray = this.iArrPos[this.iCurScreen][0];
                nArray[0] = nArray[0] - this.iSpeed;
                int[] nArray3 = this.iArrPos[this.iCurScreen][1];
                nArray3[0] = nArray3[0] + this.iSpeed;
                if (this.iArrPos[this.iCurScreen][0][0] <= -(this.imgArrCutScenes[this.iCurScreen][0].getWidth() >> 1)) {
                    this.iArrPos[this.iCurScreen][0][0] = -(this.imgArrCutScenes[this.iCurScreen][0].getWidth() >> 1);
                }
                if (this.iArrPos[this.iCurScreen][1][0] >= CCanvas.iScreenW + (this.imgArrCutScenes[this.iCurScreen][0].getWidth() >> 1)) {
                    this.iArrPos[this.iCurScreen][1][0] = CCanvas.iScreenW + (this.imgArrCutScenes[this.iCurScreen][0].getWidth() >> 1);
                }
                if (this.iArrPos[this.iCurScreen][0][0] <= -(this.imgArrCutScenes[this.iCurScreen][0].getWidth() >> 1) && this.iArrPos[this.iCurScreen][1][0] >= CCanvas.iScreenW + (this.imgArrCutScenes[this.iCurScreen][0].getWidth() >> 1)) {
                    if (this.iCurScreen < 1) {
                        ++this.iCurScreen;
                        this.isAppearing = true;
                    } else {
                        this.isAnimComplete = true;
                        if (gameData.getData(5) >= 1) {
                            CIngameManager.getInstance().switchToStates(2);
                        } else {
                            CIngameManager.getInstance().setCurrentBike(0);
                            CIngameManager.getInstance().switchToStates(0);
                        }
                    }
                }
            }
        }
    }

    public void paint(Graphics g) {
        g.drawImage(this.imgArrCutScenes[this.iCurScreen][0], this.iArrPos[this.iCurScreen][0][0], this.iArrPos[this.iCurScreen][0][1] + this.iOffsetY, 17);
        g.drawImage(this.imgArrCutScenes[this.iCurScreen][1], this.iArrPos[this.iCurScreen][1][0], this.iArrPos[this.iCurScreen][1][1] + this.iOffsetY, 17);
        if (this.isStaying && this.iCurScreen == 0) {
            CUtility.paintSoftKeys(g, this.imgBtnNext, this.imgBtnSkip);
        } else {
            CUtility.paintSoftKeys(g, null, this.imgBtnSkip);
        }
    }

    public void handleInput(int key, boolean isPressed) {
        if (!isPressed) {
            if (key == 212) {
                if (gameData.getData(5) >= 1) {
                    CIngameManager.getInstance().switchToStates(2);
                } else {
                    CIngameManager.getInstance().setCurrentBike(0);
                    CIngameManager.getInstance().switchToStates(0);
                }
            } else if (key == 211 && this.isStaying && this.iCurScreen == 0) {
                this.isStaying = false;
                this.iTimer = CCanvas.FPS * 5;
            }
        }
    }

    public void handleTouchInput(int pointerX, int pointerY, int iTouchState) {
        if (iTouchState == 2) {
            if (CUtility.isRSKPressed(pointerX, pointerY)) {
                if (gameData.getData(5) >= 1) {
                    CIngameManager.getInstance().switchToStates(2);
                } else {
                    CIngameManager.getInstance().setCurrentBike(0);
                    CIngameManager.getInstance().switchToStates(0);
                }
            } else if (CUtility.isLSKPressed(pointerX, pointerY) && this.isStaying && this.iCurScreen == 0) {
                this.isStaying = false;
                this.iTimer = CCanvas.FPS * 5;
            }
        }
    }
}

