/*
 * Decompiled with CFR 0.152.
 */
package ingame;

import component.CUtility;
import component.customFont;
import component.gameData;
import game.CCanvas;
import game.CMainGameManager;
import ingame.CIngameManager;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class CNameInsert {
    private customFont objLargeFont;
    private int iNameLength = 12;
    private boolean isAlertMsgActive;
    private int[][] iStartx;
    private int[][] iStarty;
    private int iGapx;
    private int iGapy;
    private int iRectx;
    private int iRecty;
    private int iRectWidth;
    private int iRectHeight;
    private int iIndex = 0;
    private int iPrevRow;
    private int iPressedRow = -1;
    private int iPrevColumn;
    private int iPresssedColumn = -1;
    private int iPressCounter = 0;
    private int iTimeCounter = -1;
    private int iCurserBlinkCounter = 0;
    private int iTimeCounterLimit = 0;
    private int iBlinkCounterLimit = 0;
    private boolean bTimeCounterStart = false;
    private boolean bRemoveChar = false;
    private boolean bRepeatSpecialChar = false;
    private boolean isPointerPressed = false;
    private String[][] sButton;
    private String strName = "";
    private char curserSign = (char)124;
    private char curser;
    private StringBuffer objSbuffer;
    private static final char[] KEY_NUM1_CHARS = new char[]{'.'};
    private static final char[] KEY_NUM2_CHARS = new char[]{'A', 'B', 'C'};
    private static final char[] KEY_NUM3_CHARS = new char[]{'D', 'E', 'F'};
    private static final char[] KEY_NUM4_CHARS = new char[]{'G', 'H', 'I'};
    private static final char[] KEY_NUM5_CHARS = new char[]{'J', 'K', 'L'};
    private static final char[] KEY_NUM6_CHARS = new char[]{'M', 'N', 'O'};
    private static final char[] KEY_NUM7_CHARS = new char[]{'P', 'Q', 'R', 'S'};
    private static final char[] KEY_NUM8_CHARS = new char[]{'T', 'U', 'V'};
    private static final char[] KEY_NUM9_CHARS = new char[]{'W', 'X', 'Y', 'Z'};
    private static final char[] KEY_NUM0_CHARS = new char[]{' '};
    private static final char[] KEY_UNDERSCORE_CHARS = new char[]{'_'};
    private Image imageNameButtons;
    private Image imageNameButtonsRoll;
    private Image imgBtnEnter;
    private Image imgBtnHome;
    private Image imgBtnYes;
    private Image imgBtnNo;
    private char prevKey = (char)46;

    public CNameInsert(customFont objFont) {
        this.iStartx = new int[4][3];
        this.iStarty = new int[4][3];
        this.sButton = new String[4][3];
        this.curser = this.curserSign;
        this.objSbuffer = new StringBuffer();
        this.objLargeFont = objFont;
        this.loadImages();
        this.initializeButtonPosition();
    }

    private char[] getChars(int key) {
        switch (key) {
            case 201: {
                return KEY_NUM1_CHARS;
            }
            case 202: {
                return KEY_NUM2_CHARS;
            }
            case 203: {
                return KEY_NUM3_CHARS;
            }
            case 204: {
                return KEY_NUM4_CHARS;
            }
            case 205: {
                return KEY_NUM5_CHARS;
            }
            case 206: {
                return KEY_NUM6_CHARS;
            }
            case 207: {
                return KEY_NUM7_CHARS;
            }
            case 208: {
                return KEY_NUM8_CHARS;
            }
            case 209: {
                return KEY_NUM9_CHARS;
            }
            case 200: {
                return KEY_NUM0_CHARS;
            }
            case 213: {
                return KEY_UNDERSCORE_CHARS;
            }
        }
        return null;
    }

    private void loadImages() {
        try {
            this.imageNameButtons = Image.createImage((String)"/keypad_button.png");
            this.imageNameButtonsRoll = Image.createImage((String)"/keypad_button_roll.png");
            this.imgBtnHome = Image.createImage((String)"/home.png");
            this.imgBtnEnter = Image.createImage((String)"/enter.png");
            this.imgBtnYes = Image.createImage((String)"/yes.png");
            this.imgBtnNo = Image.createImage((String)"/no.png");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void unloadImages() {
        this.imageNameButtons = null;
        this.imageNameButtonsRoll = null;
        this.imgBtnHome = null;
        this.imgBtnNo = null;
        this.imgBtnEnter = null;
        this.imgBtnYes = null;
    }

    private void initializeButtonPosition() {
        this.isAlertMsgActive = false;
        this.iGapx = (CCanvas.iScreenW - 3 * this.imageNameButtons.getWidth()) / 4;
        this.iGapy = (CCanvas.iScreenH - CCanvas.iScreenH / 3 - 4 * this.imageNameButtons.getHeight()) / 5;
        int x = this.iGapx;
        int y = CCanvas.iScreenH - (4 * this.imageNameButtons.getHeight() + 4 * this.iGapy) - 2 * this.iGapy;
        for (int row = 0; row < 4; ++row) {
            for (int column = 0; column < 3; ++column) {
                this.iStartx[row][column] = x + (this.iGapx + this.imageNameButtons.getWidth()) * column;
                this.iStarty[row][column] = y + (this.iGapy + this.imageNameButtons.getHeight()) * row;
            }
        }
        this.iRectWidth = 2 * this.iGapx + 3 * this.imageNameButtons.getWidth();
        this.iRectHeight = 25;
        this.iRectx = this.iGapx;
        this.iRecty = CCanvas.isTouchDevice ? CCanvas.iScreenH * 15 / 100 : (CCanvas.iScreenH >> 1) - (this.iRectHeight >> 1);
        this.sButton[0][0] = ".";
        this.sButton[0][1] = "ABC";
        this.sButton[0][2] = "DEF";
        this.sButton[1][0] = "GHI";
        this.sButton[1][1] = "JKL";
        this.sButton[1][2] = "MNO";
        this.sButton[2][0] = "PQRS";
        this.sButton[2][1] = "TUV";
        this.sButton[2][2] = "WXYZ";
        this.sButton[3][0] = "-";
        this.sButton[3][1] = "SPACE";
        this.sButton[3][2] = "CLEAR";
        this.iTimeCounterLimit = CCanvas.FPS;
        this.iBlinkCounterLimit = CCanvas.FPS / 3;
    }

    private void setMyName(String myname) {
        this.strName = myname;
    }

    private String getMyName() {
        this.strName = this.strName.toUpperCase();
        return this.strName;
    }

    private String getName() {
        char lastChar = this.getMyName().charAt(this.strName.length() - 1);
        if (lastChar == '.' || lastChar == '_' || lastChar == ' ') {
            this.removeChar();
        }
        return this.strName;
    }

    private void setIndex(int index) {
        this.iIndex = index;
    }

    private int getIndex() {
        return this.iIndex;
    }

    private void updateCaretPosition(int row, int column) {
        char lastChar;
        this.bRepeatSpecialChar = false;
        int pressCounterRang = 1;
        if (row == 2 && (column == 0 || column == 2)) {
            pressCounterRang = 2;
        }
        if (row == 0 && column == 0 || row == 3 && column == 1 || row == 3 && column == 0) {
            pressCounterRang = -1;
        }
        if (row != this.iPrevRow || column != this.iPrevColumn) {
            this.iPressCounter = -1;
            this.iTimeCounter = -1;
            this.iPrevRow = row;
            this.iPrevColumn = column;
        }
        if (this.strName.length() != 0 && pressCounterRang == -1 && ((lastChar = this.strName.charAt(this.strName.length() - 1)) == '.' || lastChar == '_' || lastChar == ' ')) {
            this.bRepeatSpecialChar = true;
        }
        if (!this.bRepeatSpecialChar) {
            this.bTimeCounterStart = true;
            if (this.iPressCounter <= pressCounterRang) {
                ++this.iPressCounter;
                this.bRemoveChar = false;
            } else {
                this.iPressCounter = 0;
                this.iTimeCounter = 0;
                this.bRemoveChar = true;
            }
            this.setIndex(this.iPressCounter);
        }
    }

    public void update() {
        if (!this.isAlertMsgActive) {
            if (this.bTimeCounterStart) {
                if (this.iTimeCounter > this.iTimeCounterLimit) {
                    this.bTimeCounterStart = false;
                    this.iTimeCounter = -1;
                    this.iPressCounter = -1;
                } else {
                    ++this.iTimeCounter;
                }
            }
            ++this.iCurserBlinkCounter;
            if (this.iCurserBlinkCounter == this.iBlinkCounterLimit) {
                this.iCurserBlinkCounter = 0;
                this.curser = this.strName.length() >= this.iNameLength && this.iTimeCounter == -1 ? (char)32 : (this.curser == this.curserSign ? (char)32 : this.curserSign);
            }
        }
    }

    public void paint(Graphics g) {
        this.drawInsertNameScreen(g);
    }

    private void drawInsertNameScreen(Graphics g) {
        this.objLargeFont.drawString("ENTER YOUR NAME", CCanvas.iScreenW >> 1, this.iRecty - this.iRectHeight, g, 3);
        if (CCanvas.isTouchDevice) {
            for (int row = 0; row < 4; ++row) {
                for (int column = 0; column < 3; ++column) {
                    if (row == this.iPressedRow && column == this.iPresssedColumn) {
                        g.drawImage(this.imageNameButtonsRoll, this.iStartx[row][column], this.iStarty[row][column], 0);
                    } else {
                        g.drawImage(this.imageNameButtons, this.iStartx[row][column], this.iStarty[row][column], 0);
                    }
                    this.objLargeFont.drawString(this.sButton[row][column], this.iStartx[row][column] + (this.imageNameButtons.getWidth() >> 1), this.iStarty[row][column] + (this.imageNameButtons.getHeight() >> 1), g, 3);
                }
            }
        }
        g.setColor(0xFF0000);
        g.fillRect(this.iRectx, this.iRecty, this.iRectWidth, this.iRectHeight);
        g.setColor(0);
        this.objLargeFont.drawString(this.getMyName() + this.curser, this.iRectx + 5, this.iRecty + 2, g, 0);
        if (!this.isAlertMsgActive) {
            if (this.strName.length() != 0) {
                CUtility.paintSoftKeys(g, this.imgBtnEnter, this.imgBtnHome);
            } else {
                CUtility.paintSoftKeys(g, null, this.imgBtnHome);
            }
        } else {
            this.drawPopupScreen(g);
        }
    }

    private void drawPopupScreen(Graphics g) {
        g.setColor(0x444444);
        g.fillRoundRect(CCanvas.iScreenW >> 5, CCanvas.iScreenH - CCanvas.iScreenH / 3, CCanvas.iScreenW - (CCanvas.iScreenW >> 4), CCanvas.iScreenH >> 2, 25, 25);
        g.setColor(0xDDDDDD);
        g.drawRoundRect(CCanvas.iScreenW >> 5, CCanvas.iScreenH - CCanvas.iScreenH / 3, CCanvas.iScreenW - (CCanvas.iScreenW >> 4), CCanvas.iScreenH >> 2, 25, 25);
        String strFull = "Your name is \" " + this.getName() + " \"";
        int iFontHeight = CIngameManager.getInstance().objSmallFont.getHeight();
        CIngameManager.getInstance().objSmallFont.drawString(strFull, CCanvas.iScreenW >> 1, CCanvas.iScreenH - CCanvas.iScreenH / 3 + (CCanvas.iScreenH >> 3) - iFontHeight, g, 3);
        CIngameManager.getInstance().objSmallFont.drawString("Are you sure ?", CCanvas.iScreenW >> 1, CCanvas.iScreenH - CCanvas.iScreenH / 3 + (CCanvas.iScreenH >> 3) - (iFontHeight >> 1) + iFontHeight, g, 3);
        CUtility.paintSoftKeys(g, this.imgBtnYes, this.imgBtnNo);
    }

    private void removeChar() {
        if (this.strName.length() != 0) {
            this.objSbuffer.deleteCharAt(this.strName.length() - 1);
            this.setMyName(this.objSbuffer.toString());
        }
    }

    private void updateNameInput(int CanvasKeyNum) {
        if (!(this.strName.length() >= this.iNameLength && this.iTimeCounter == -1 || this.bRepeatSpecialChar)) {
            char[] key_Num = this.getChars(CanvasKeyNum);
            if (this.iPressCounter > 0 || this.bRemoveChar) {
                this.removeChar();
            }
            this.objSbuffer.insert(this.strName.length(), key_Num[this.getIndex()]);
            this.setMyName(this.objSbuffer.toString());
        }
    }

    private void insertName(int row, int column) {
        block30: {
            if (!this.isPointerPressed && CCanvas.isAlphaKey) {
                return;
            }
            if (this.strName.length() < this.iNameLength || this.iTimeCounter != -1) {
                this.updateCaretPosition(row, column);
            }
            block0 : switch (row) {
                case 0: {
                    switch (column) {
                        case 0: {
                            if (this.strName.length() == 0) break;
                            this.updateNameInput(201);
                            break;
                        }
                        case 1: {
                            this.updateNameInput(202);
                            break;
                        }
                        case 2: {
                            this.updateNameInput(203);
                        }
                    }
                    break;
                }
                case 1: {
                    switch (column) {
                        case 0: {
                            this.updateNameInput(204);
                            break;
                        }
                        case 1: {
                            this.updateNameInput(205);
                            break;
                        }
                        case 2: {
                            this.updateNameInput(206);
                        }
                    }
                    break;
                }
                case 2: {
                    switch (column) {
                        case 0: {
                            this.updateNameInput(207);
                            break;
                        }
                        case 1: {
                            this.updateNameInput(208);
                            break;
                        }
                        case 2: {
                            this.updateNameInput(209);
                        }
                    }
                    break;
                }
                case 3: {
                    switch (column) {
                        case 0: {
                            if (this.strName.length() != 0) {
                                this.updateNameInput(213);
                                break block0;
                            }
                            break block30;
                        }
                        case 1: {
                            if (this.strName.length() != 0) {
                                this.updateNameInput(200);
                                break block0;
                            }
                            break block30;
                        }
                        case 2: {
                            this.removeChar();
                        }
                    }
                }
            }
        }
    }

    private void saveName() {
        gameData.saveData(11, this.getName());
    }

    public void handleTouchInput(int pointerX, int pointerY, int iTouchState) {
        int column;
        int row;
        if (iTouchState == 0) {
            this.isPointerPressed = true;
            if (!this.isAlertMsgActive) {
                for (row = 0; row < 4; ++row) {
                    for (column = 0; column < 3; ++column) {
                        if (!CUtility.isPointInRect(pointerX, pointerY, this.iStartx[row][column], this.iStarty[row][column], this.imageNameButtons.getWidth(), this.imageNameButtons.getHeight())) continue;
                        this.iPressedRow = row;
                        this.iPresssedColumn = column;
                    }
                }
            }
        }
        if (iTouchState == 2) {
            if (!this.isAlertMsgActive) {
                for (row = 0; row < 4; ++row) {
                    for (column = 0; column < 3; ++column) {
                        if (!CUtility.isPointInRect(pointerX, pointerY, this.iStartx[row][column], this.iStarty[row][column], this.imageNameButtons.getWidth(), this.imageNameButtons.getHeight()) || iTouchState != 2) continue;
                        this.insertName(row, column);
                        this.iPressedRow = -1;
                        this.iPresssedColumn = -1;
                    }
                }
                if (this.strName.length() != 0 && CUtility.isLSKPressed(pointerX, pointerY)) {
                    this.isAlertMsgActive = true;
                }
                if (CUtility.isRSKPressed(pointerX, pointerY)) {
                    CMainGameManager.getInstance().switchToStates(1);
                }
            } else {
                if (CUtility.isLSKPressed(pointerX, pointerY)) {
                    this.saveName();
                    CMainGameManager.getInstance().switchToStates(1);
                }
                if (CUtility.isRSKPressed(pointerX, pointerY)) {
                    this.isAlertMsgActive = false;
                }
            }
        }
    }

    public void handleInput(String chKey, boolean isPressed) {
        this.isPointerPressed = false;
        if (isPressed) {
            if (chKey.equalsIgnoreCase("BACKSPACE")) {
                this.removeChar();
            }
            if (chKey.equalsIgnoreCase("SPACE") && this.strName.length() != 0 && this.prevKey != ' ') {
                this.objSbuffer.insert(this.strName.length(), " ");
                this.setMyName(this.objSbuffer.toString());
            }
            if (!(chKey.length() != 1 || chKey.equalsIgnoreCase(",") || chKey.equalsIgnoreCase(".") || chKey.equalsIgnoreCase("'") || chKey.equalsIgnoreCase("/") || chKey.equalsIgnoreCase("?") || chKey.equalsIgnoreCase("@") || this.strName.length() >= this.iNameLength)) {
                this.objSbuffer.insert(this.strName.length(), chKey);
                this.setMyName(this.objSbuffer.toString());
            }
            if (this.strName.length() != 0) {
                this.prevKey = this.strName.charAt(this.strName.length() - 1);
            }
        }
    }

    public void handleInput(int key, boolean isPressed) {
        this.isPointerPressed = false;
        if (key < 200 || key > 214) {
            return;
        }
        if (isPressed) {
            if (!this.isAlertMsgActive) {
                switch (key) {
                    case 201: {
                        this.insertName(0, 0);
                        break;
                    }
                    case 202: {
                        this.insertName(0, 1);
                        break;
                    }
                    case 203: {
                        this.insertName(0, 2);
                        break;
                    }
                    case 204: {
                        this.insertName(1, 0);
                        break;
                    }
                    case 205: {
                        this.insertName(1, 1);
                        break;
                    }
                    case 206: {
                        this.insertName(1, 2);
                        break;
                    }
                    case 207: {
                        this.insertName(2, 0);
                        break;
                    }
                    case 208: {
                        this.insertName(2, 1);
                        break;
                    }
                    case 209: {
                        this.insertName(2, 2);
                        break;
                    }
                    case 213: {
                        this.insertName(3, 0);
                        break;
                    }
                    case 200: {
                        this.insertName(3, 1);
                        break;
                    }
                    case 214: {
                        this.removeChar();
                        break;
                    }
                    case 211: {
                        if (this.strName.length() == 0) break;
                        this.isAlertMsgActive = true;
                        break;
                    }
                    case 212: {
                        CMainGameManager.getInstance().switchToStates(1);
                    }
                }
            } else {
                switch (key) {
                    case 211: {
                        this.saveName();
                        CMainGameManager.getInstance().switchToStates(1);
                        break;
                    }
                    case 212: {
                        this.isAlertMsgActive = false;
                    }
                }
            }
        }
    }
}

