/*
 * Decompiled with CFR 0.152.
 */
package com.shephertz.app42.paas.sdk.jme;

import com.shephertz.app42.paas.sdk.jme.ACL;
import com.shephertz.app42.paas.sdk.jme.App42API;
import com.shephertz.app42.paas.sdk.jme.App42Log;
import com.shephertz.app42.paas.sdk.jme.storage.GeoTag;
import com.shephertz.app42.paas.sdk.jme.util.Util;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.json.jme.JSONArray;
import org.json.jme.JSONException;
import org.json.jme.JSONObject;

public abstract class App42Service {
    protected String apiKey;
    protected String version;
    protected String sessionId;
    protected String adminKey;
    protected GeoTag geoTag;
    protected String secretKey;
    protected int pageOffset = -1;
    protected int pageMaxRecords = -1;
    protected String fbAccessToken;
    protected String orderByDescending;
    protected Vector dataACL;
    protected String orderByAscending;
    protected Hashtable otherMetaHeaders = new Hashtable();
    protected String event;
    protected Vector selectKeys = new Vector();
    protected Vector aclList = new Vector();

    public String getEvent() {
        return this.event;
    }

    public String getOrderByDescending() {
        return this.orderByDescending;
    }

    public void setOrderByDescending(String orderByDescending) {
        this.orderByDescending = orderByDescending;
    }

    public Hashtable getOtherMetaHeaders() {
        return this.otherMetaHeaders;
    }

    public void setOtherMetaHeaders(Hashtable otherMetaHeaders) {
        this.otherMetaHeaders = otherMetaHeaders;
    }

    public String getOrderByAscending() {
        return this.orderByAscending;
    }

    public GeoTag getGeoTag() {
        return this.geoTag;
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public void setGeoTag(GeoTag geoTag) {
        Util.throwExceptionIfNullOrBlank(geoTag, "geoTag");
        this.geoTag = geoTag;
    }

    public void setOrderByAscending(String orderByAscending) {
        this.orderByAscending = orderByAscending;
    }

    public Vector getSelectKeys() {
        return this.selectKeys;
    }

    public void setSelectKeys(Vector selectKeys) {
        this.selectKeys = selectKeys;
    }

    public Vector getAclList() {
        return this.aclList;
    }

    public void setAclList(Vector aclList) {
        this.aclList = aclList;
    }

    protected Hashtable populateSignParams() throws JSONException {
        Hashtable<String, String> params = new Hashtable<String, String>();
        params.put("apiKey", this.apiKey);
        params.put("version", this.version);
        if (this.sessionId != null) {
            params.put("sessionId", this.sessionId);
        } else if (App42API.getUserSessionId() != null && !App42API.getUserSessionId().equals("")) {
            App42Log.debug(" ########## Setting Session ##########");
            params.put("sessionId", App42API.getUserSessionId());
        }
        if (this.adminKey != null) {
            params.put("adminKey", this.adminKey);
        }
        if (this.fbAccessToken != null) {
            params.put("fbAccessToken", this.fbAccessToken);
        } else if (App42API.getFbAccesToken() != null && !App42API.getFbAccesToken().equals("")) {
            params.put("fbAccessToken", App42API.getFbAccesToken());
        }
        params.put("timeStamp", Util.getUTCFormattedTimestamp());
        if (this.dataACL != null && this.dataACL.size() != 0) {
            JSONArray aclArray = new JSONArray();
            for (int i = 0; i < this.dataACL.size(); ++i) {
                JSONArray acl = aclArray.put(this.dataACL.elementAt(i));
                acl.put(acl.getJSONObject(i));
            }
            params.put("dataACL", aclArray.toString());
        }
        return params;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        Util.throwExceptionIfNullOrBlank(sessionId, "sessionId");
        this.sessionId = sessionId;
    }

    public String getAdminKey() {
        return this.adminKey;
    }

    public void setAdminKey(String adminKey) {
        Util.throwExceptionIfNullOrBlank(adminKey, "adminKey");
        this.adminKey = adminKey;
    }

    public int getPageOffset() {
        return this.pageOffset;
    }

    public void setPageOffset(int pageOffset) {
        this.pageOffset = pageOffset;
    }

    public int getPageMaxRecords() {
        return this.pageMaxRecords;
    }

    public void setPageMaxRecords(int pageMaxRecords) {
        this.pageMaxRecords = pageMaxRecords;
    }

    public String getFbAccessToken() {
        return this.fbAccessToken;
    }

    public void setFbAccessToken(String fbAccessToken) {
        this.fbAccessToken = fbAccessToken;
    }

    protected Hashtable populateMetaHeaderParams() throws JSONException {
        Hashtable<String, String> params = new Hashtable<String, String>();
        if ((long)this.pageOffset != -1L) {
            params.put("offset", "" + this.pageOffset);
        }
        if (this.pageMaxRecords != -1) {
            params.put("max", "" + this.pageMaxRecords);
        }
        if (this.fbAccessToken != null) {
            params.put("fbAccessToken", this.fbAccessToken);
        }
        if (this.geoTag != null) {
            params.put("geoTag", this.geoTag.getJSONObject().toString());
        }
        this.setACLHeader(params);
        if (this.selectKeys.size() > 0) {
            JSONObject selectJSONKeys = new JSONObject();
            for (int i = 0; i < this.selectKeys.size(); ++i) {
                String key = (String)this.selectKeys.elementAt(i);
                selectJSONKeys.put(key, "1");
            }
            params.put("selectKeys", selectJSONKeys.toString());
        }
        params.put("SDKName", "J2ME");
        if (App42API.getInstallationId() != null && !App42API.getInstallationId().equals("")) {
            params.put("deviceId", App42API.getInstallationId());
        }
        if (this.otherMetaHeaders.size() > 0) {
            Enumeration keySet = this.otherMetaHeaders.keys();
            while (keySet.hasMoreElements()) {
                String key = (String)keySet.nextElement();
                String value = (String)this.otherMetaHeaders.get(key);
                if (key == null || key.equals("") || value == null || value.equals("")) continue;
                params.put(key, value);
            }
        }
        return params;
    }

    private void setACLHeader(Hashtable params) throws JSONException {
        if (this.aclList.size() > 0) {
            JSONArray aclArray = this.getJsonObj(this.aclList);
            params.put("dataACL", aclArray.toString());
        } else if (App42API.defaultACL.size() > 0) {
            JSONArray aclArray = this.getJsonObj(this.aclList);
            params.put("dataACL", aclArray.toString());
        }
    }

    private JSONArray getJsonObj(Vector aclList) throws JSONException {
        JSONArray aclArray = new JSONArray();
        for (int i = 0; i < aclList.size(); ++i) {
            ACL aclObj = (ACL)aclList.elementAt(i);
            aclArray.put(new JSONObject().put(aclObj.getUser(), aclObj.getPermission()));
        }
        return aclArray;
    }
}

