/*
 * Decompiled with CFR 0.152.
 */
package com.shephertz.app42.paas.sdk.jme;

import com.shephertz.app42.paas.sdk.jme.App42Log;
import com.shephertz.app42.paas.sdk.jme.ConfigurationException;

public class Config {
    private static Config config;
    private String protocol = "http://";
    private String baseURL = "https://api.shephertz.com/cloud/";
    private String serverName = "/App42_API_SERVER/cloud/";
    private String contentType = "application/json";
    private String accept = "application/json";
    private String customCodeURL = "https://customcode.shephertz.com/";

    private Config() throws ConfigurationException {
        App42Log.debug("Configuration Properties " + this.baseURL);
    }

    public static Config getInstance() {
        if (config == null) {
            try {
                config = new Config();
            }
            catch (ConfigurationException e) {
                throw new RuntimeException(" Instance Cannot be created due to wrong config.");
            }
        }
        return config;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setBaseURL(String protocol, String host, Integer port) {
        this.baseURL = protocol + host + ":" + port + this.serverName;
    }

    public void setBaseURL(String url) {
        this.baseURL = url;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setAccept(String accept) {
        this.accept = accept;
    }

    public String getAccept() {
        return this.accept;
    }

    public String getCustomCodeURL() {
        return this.customCodeURL;
    }

    public void setCustomCodeURL(String customCodeURL) {
        this.customCodeURL = customCodeURL;
    }
}

