/*
 * Decompiled with CFR 0.152.
 */
package com.shephertz.app42.paas.sdk.jme.achievement;

import com.shephertz.app42.paas.sdk.jme.App42CallBack;
import com.shephertz.app42.paas.sdk.jme.App42Exception;
import com.shephertz.app42.paas.sdk.jme.App42Log;
import com.shephertz.app42.paas.sdk.jme.App42Service;
import com.shephertz.app42.paas.sdk.jme.achievement.Achievement;
import com.shephertz.app42.paas.sdk.jme.achievement.AchievementResponseBuilder;
import com.shephertz.app42.paas.sdk.jme.connection.RESTConnectorAsync;
import com.shephertz.app42.paas.sdk.jme.util.Util;
import java.util.Hashtable;
import java.util.Vector;
import org.json.jme.JSONObject;

public class AchievementService
extends App42Service {
    private String resource = "achievement";

    public AchievementService(String apiKey, String secretKey, String baseURL) {
        this.apiKey = apiKey;
        this.secretKey = secretKey;
        this.version = "1.0";
    }

    public Achievement createAchievement(String name, String description) throws App42Exception {
        String response = null;
        Achievement achievement = null;
        Util.throwExceptionIfNullOrBlank(name, "Achievement Name");
        Util.throwExceptionIfNullOrBlank(description, "description");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            JSONObject obj = new JSONObject();
            obj.put("name", name);
            obj.put("description", description);
            StringBuffer sb = new StringBuffer();
            sb.append("{\"app42\":{\"achievement\":").append(obj.toString()).append("}}");
            App42Log.debug(" Json String : " + sb.toString());
            signParams.put("body", sb.toString());
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource;
            response = RESTConnectorAsync.getInstance().executePost(resourceURL, queryParams, sb.toString(), headerParams);
            achievement = new AchievementResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return achievement;
    }

    public void createAchievement(final String name, final String description, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Achievement achievement = AchievementService.this.createAchievement(name, description);
                    callBack.onSuccess(achievement);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Achievement earnAchievement(String userName, String achievementName, String gameName, String description) throws App42Exception {
        String response = null;
        Achievement achievement = null;
        Util.throwExceptionIfNullOrBlank(userName, "userName");
        Util.throwExceptionIfNullOrBlank(achievementName, "Achievement Name");
        Util.throwExceptionIfNullOrBlank(gameName, "gameName");
        Util.throwExceptionIfNullOrBlank(description, "description");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            JSONObject obj = new JSONObject();
            obj.put("userName", userName);
            obj.put("name", achievementName);
            obj.put("gameName", gameName);
            obj.put("description", description);
            StringBuffer sb = new StringBuffer();
            sb.append("{\"app42\":{\"achievement\":").append(obj.toString()).append("}}");
            App42Log.debug(" Json String : " + sb.toString());
            signParams.put("body", sb.toString());
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/earn";
            response = RESTConnectorAsync.getInstance().executePost(resourceURL, queryParams, sb.toString(), headerParams);
            achievement = new AchievementResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return achievement;
    }

    public void earnAchievement(final String userName, final String achievementName, final String gameName, final String description, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Achievement achievement = AchievementService.this.earnAchievement(userName, achievementName, gameName, description);
                    callBack.onSuccess(achievement);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Vector getAllAchievementsForUser(String userName) throws App42Exception {
        String response = null;
        Vector achievementList = null;
        Util.throwExceptionIfNullOrBlank(userName, "UserName");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("userName", userName);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/" + userName;
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            achievementList = new AchievementResponseBuilder().buildArrayResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return achievementList;
    }

    public void getAllAchievementsForUser(final String userName, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Vector achievement = AchievementService.this.getAllAchievementsForUser(userName);
                    callBack.onSuccess(achievement);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Vector getAllAchievementsForUserInGame(String userName, String gameName) throws App42Exception {
        String response = null;
        Vector achievementList = null;
        Util.throwExceptionIfNullOrBlank(userName, "UserName");
        Util.throwExceptionIfNullOrBlank(gameName, "gameName");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("userName", userName);
            signParams.put("gameName", gameName);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/" + userName + "/" + gameName;
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            achievementList = new AchievementResponseBuilder().buildArrayResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return achievementList;
    }

    public void getAllAchievementsForUserInGame(final String userName, final String gameName, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Vector achievement = AchievementService.this.getAllAchievementsForUserInGame(userName, gameName);
                    callBack.onSuccess(achievement);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Vector getAllAchievements() throws App42Exception {
        String response = null;
        Vector achievementList = null;
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/all";
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            achievementList = new AchievementResponseBuilder().buildArrayResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return achievementList;
    }

    public void getAllAchievements(final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Vector achievement = AchievementService.this.getAllAchievements();
                    callBack.onSuccess(achievement);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Achievement getAchievementByName(String achievementName) throws App42Exception {
        String response = null;
        Achievement achievement = null;
        Util.throwExceptionIfNullOrBlank(achievementName, "achievementName");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("achievementName", achievementName);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/achievementName/" + achievementName;
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            achievement = new AchievementResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return achievement;
    }

    public void getAchievementByName(final String achievementName, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Achievement achievement = AchievementService.this.getAchievementByName(achievementName);
                    callBack.onSuccess(achievement);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Vector getUsersAchievement(String achievementName, String gameName) throws App42Exception {
        String response = null;
        Vector achievementList = null;
        Util.throwExceptionIfNullOrBlank(achievementName, "achievementName");
        Util.throwExceptionIfNullOrBlank(gameName, "gameName");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("achievementName", achievementName);
            signParams.put("game", gameName);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/users/" + achievementName + "/" + gameName;
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            achievementList = new AchievementResponseBuilder().buildArrayResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return achievementList;
    }

    public void getUsersAchievement(final String achievementName, final String gameName, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Vector achievement = AchievementService.this.getUsersAchievement(achievementName, gameName);
                    callBack.onSuccess(achievement);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }
}

