/*
 * Decompiled with CFR 0.152.
 */
package com.shephertz.app42.paas.sdk.jme.game;

import com.shephertz.app42.paas.sdk.jme.App42CallBack;
import com.shephertz.app42.paas.sdk.jme.App42Exception;
import com.shephertz.app42.paas.sdk.jme.App42Log;
import com.shephertz.app42.paas.sdk.jme.App42Service;
import com.shephertz.app42.paas.sdk.jme.connection.RESTConnectorAsync;
import com.shephertz.app42.paas.sdk.jme.game.Game;
import com.shephertz.app42.paas.sdk.jme.game.GameResponseBuilder;
import com.shephertz.app42.paas.sdk.jme.util.Util;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import org.json.jme.JSONObject;

public class ScoreBoardService
extends App42Service {
    private String resource = "game/scoreboard";
    private String adminKey;
    String baseURL;

    public ScoreBoardService(String apiKey, String secretKey, String baseURL) {
        this.apiKey = apiKey;
        this.secretKey = secretKey;
        this.baseURL = baseURL;
        this.version = "1.0";
    }

    public Game saveUserScore(String gameName, String gameUserName, double gameScore) throws App42Exception {
        String response = null;
        Game game = null;
        Util.throwExceptionIfNullOrBlank(gameName, "Game Name");
        Util.throwExceptionIfNullOrBlank(gameUserName, "User Name");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            JSONObject gameObj = new JSONObject();
            JSONObject obj = new JSONObject();
            obj.put("value", "" + gameScore);
            obj.put("userName", gameUserName);
            JSONObject score = new JSONObject();
            score.put("score", obj);
            gameObj.put("scores", score);
            gameObj.put("name", gameName);
            StringBuffer sb = new StringBuffer();
            sb.append("{\"app42\":{\"game\":").append(gameObj.toString()).append("}}");
            signParams.put("body", sb.toString());
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource;
            response = RESTConnectorAsync.getInstance().executePost(resourceURL, queryParams, sb.toString(), headerParams);
            game = new GameResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return game;
    }

    public void saveUserScore(final String gameName, final String gameUserName, final double gameScore, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Game game = ScoreBoardService.this.saveUserScore(gameName, gameUserName, gameScore);
                    callBack.onSuccess(game);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Game getScoresByUser(String gameName, String userName) throws App42Exception {
        String response = null;
        Game game = null;
        Util.throwExceptionIfNullOrBlank(gameName, "Game Name");
        Util.throwExceptionIfNullOrBlank(userName, "User Name");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("name", gameName);
            signParams.put("userName", userName);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/" + gameName + "/" + userName;
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            game = new GameResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return game;
    }

    public void getScoresByUser(final String gameName, final String userName, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Game game = ScoreBoardService.this.getScoresByUser(gameName, userName);
                    callBack.onSuccess(game);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Game getHighestScoreByUser(String gameName, String userName) throws App42Exception {
        String response = null;
        Game game = null;
        Util.throwExceptionIfNullOrBlank(gameName, "Game Name");
        Util.throwExceptionIfNullOrBlank(userName, "User Name");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("name", gameName);
            signParams.put("userName", userName);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/" + gameName + "/" + userName + "/highest";
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            game = new GameResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return game;
    }

    public void getHighestScoreByUser(final String gameName, final String userName, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Game game = ScoreBoardService.this.getHighestScoreByUser(gameName, userName);
                    callBack.onSuccess(game);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Game getLowestScoreByUser(String gameName, String userName) throws App42Exception {
        String response = null;
        Game game = null;
        Util.throwExceptionIfNullOrBlank(gameName, "Game Name");
        Util.throwExceptionIfNullOrBlank(userName, "User Name");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("name", gameName);
            signParams.put("userName", userName);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/" + gameName + "/" + userName + "/lowest";
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            game = new GameResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return game;
    }

    public void getLowestScoreByUser(final String gameName, final String userName, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Game game = ScoreBoardService.this.getLowestScoreByUser(gameName, userName);
                    callBack.onSuccess(game);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Game getTopRankings(String gameName) throws App42Exception {
        String response = null;
        Game game = null;
        Util.throwExceptionIfNullOrBlank(gameName, "Game Name");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("name", gameName);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/" + gameName + "/ranking";
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            game = new GameResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return game;
    }

    public void getTopRankings(final String gameName, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Game game = ScoreBoardService.this.getTopRankings(gameName);
                    callBack.onSuccess(game);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Game getTopRankings(String gameName, Date startDate, Date endDate) throws App42Exception {
        String response = null;
        Game game = null;
        Util.throwExceptionIfNullOrBlank(gameName, "Game Name");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            String strStartDate = Util.getUTCFormattedTimestamp(startDate);
            String strEndDate = Util.getUTCFormattedTimestamp(endDate);
            signParams.put("name", gameName);
            signParams.put("startDate", strStartDate);
            signParams.put("endDate", strEndDate);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/" + gameName + "/ranking" + "/" + strStartDate + "/" + strEndDate;
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            game = new GameResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return game;
    }

    public void getTopRankings(final String gameName, final Date startDate, final Date endDate, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Game game = ScoreBoardService.this.getTopRankings(gameName, startDate, endDate);
                    callBack.onSuccess(game);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Game getAverageScoreByUser(String gameName, String userName) throws App42Exception {
        String response = null;
        Game game = null;
        Util.throwExceptionIfNullOrBlank(gameName, "Game Name");
        Util.throwExceptionIfNullOrBlank(userName, "User Name");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("name", gameName);
            signParams.put("userName", userName);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/" + gameName + "/" + userName + "/average";
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            game = new GameResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return game;
    }

    public void getAverageScoreByUser(final String gameName, final String userName, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Game game = ScoreBoardService.this.getAverageScoreByUser(gameName, userName);
                    callBack.onSuccess(game);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Game getTopNRankings(String gameName, Integer max) throws App42Exception {
        String response = null;
        Game game = null;
        Util.throwExceptionIfNullOrBlank(gameName, "Game Name");
        Util.throwExceptionIfNullOrBlank(max, "Max");
        Util.validateMax(max);
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("name", gameName);
            signParams.put("max", "" + max);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/" + gameName + "/ranking" + "/" + max;
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            game = new GameResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return game;
    }

    public void getTopNRankings(final String gameName, final Integer max, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Game game = ScoreBoardService.this.getTopNRankings(gameName, max);
                    callBack.onSuccess(game);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Game getUserRanking(String gameName, String userName) throws App42Exception {
        String response = null;
        Game game = null;
        Util.throwExceptionIfNullOrBlank(gameName, "Game Name");
        Util.throwExceptionIfNullOrBlank(userName, "User Name");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("name", gameName);
            signParams.put("userName", userName);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/" + gameName + "/" + userName + "/ranking";
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            game = new GameResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return game;
    }

    public void getUserRanking(final String gameName, final String userName, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Game game = ScoreBoardService.this.getUserRanking(gameName, userName);
                    callBack.onSuccess(game);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Game getTopRankingsByGroup(String gameName, Vector userList) throws App42Exception {
        String response = null;
        Game game = null;
        Util.throwExceptionIfNullOrBlank(gameName, "Game Name");
        Util.throwExceptionIfNullOrBlank(userList, "UserList");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            signParams.put("userList", userList.toString());
            signParams.put("name", gameName);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/" + gameName + "/group";
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            game = new GameResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return game;
    }

    public void getTopRankingsByGroup(final String gameName, final Vector userList, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Game game = ScoreBoardService.this.getTopRankingsByGroup(gameName, userList);
                    callBack.onSuccess(game);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Game getLastScoreByUser(String gameName, String userName) throws App42Exception {
        String response = null;
        Game game = null;
        Util.throwExceptionIfNullOrBlank(gameName, "Game Name");
        Util.throwExceptionIfNullOrBlank(userName, "userName");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            signParams.put("name", gameName);
            signParams.put("userName", userName);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/" + gameName + "/" + userName + "/lastscore";
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            game = new GameResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return game;
    }

    public void getLastScoreByUser(final String gameName, final String userName, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Game game = ScoreBoardService.this.getLastScoreByUser(gameName, userName);
                    callBack.onSuccess(game);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Game getLastGameScore(String userName) throws App42Exception {
        String response = null;
        Game game = null;
        Util.throwExceptionIfNullOrBlank(userName, "UserName");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            signParams.put("userName", userName);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/" + userName + "/lastgame";
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            game = new GameResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return game;
    }

    public void getLastGameScore(final String userName, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Game game = ScoreBoardService.this.getLastGameScore(userName);
                    callBack.onSuccess(game);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Game getTopNRankers(String gameName, Integer max) throws App42Exception {
        String response = null;
        Game game = null;
        Util.throwExceptionIfNullOrBlank(gameName, "Game Name");
        Util.throwExceptionIfNullOrBlank(max, "Max");
        Util.validateMax(max);
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            signParams.put("name", gameName);
            signParams.put("max", "" + max);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/" + gameName + "/rankers" + "/" + max;
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            game = new GameResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return game;
    }

    public void getTopNRankers(final String gameName, final Integer max, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Game game = ScoreBoardService.this.getTopNRankers(gameName, max);
                    callBack.onSuccess(game);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Game getTopNRankers(String gameName, Date startDate, Date endDate, Integer max) throws App42Exception {
        String response = null;
        Game game = null;
        Util.throwExceptionIfNullOrBlank(gameName, "Game Name");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            String strStartDate = Util.getUTCFormattedTimestamp(startDate);
            String strEndDate = Util.getUTCFormattedTimestamp(endDate);
            signParams.put("name", gameName);
            signParams.put("startDate", strStartDate);
            signParams.put("endDate", strEndDate);
            signParams.put("max", "" + max);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/" + gameName + "/rankers" + "/" + strStartDate + "/" + strEndDate + "/" + max;
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            game = new GameResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return game;
    }

    public void getTopNRankers(final String gameName, final Date startDate, final Date endDate, final Integer max, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Game game = ScoreBoardService.this.getTopNRankers(gameName, startDate, endDate, max);
                    callBack.onSuccess(game);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Game getTopNRankersByGroup(String gameName, Vector userList) throws App42Exception {
        String response = null;
        Game game = null;
        Util.throwExceptionIfNullOrBlank(gameName, "Game Name");
        Util.throwExceptionIfNullOrBlank(userList, "UserList");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            signParams.put("userList", userList.toString());
            signParams.put("name", gameName);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/" + gameName + "/rankers/group";
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            game = new GameResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return game;
    }

    public void getTopNRankersByGroup(final String gameName, final Vector userList, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Game game = ScoreBoardService.this.getTopNRankersByGroup(gameName, userList);
                    callBack.onSuccess(game);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Game editScoreValueById(String scoreId, Double gameScore) throws App42Exception {
        String response = null;
        Game game = null;
        Util.throwExceptionIfNullOrBlank(scoreId, "ScoreId");
        Util.throwExceptionIfNullOrBlank(gameScore, "GameScore");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            JSONObject gameObj = new JSONObject();
            JSONObject obj = new JSONObject();
            obj.put("scoreId", scoreId);
            obj.put("value", gameScore);
            JSONObject score = new JSONObject();
            score.put("score", obj);
            gameObj.put("scores", score);
            StringBuffer sb = new StringBuffer();
            sb.append("{\"app42\":{\"game\":").append(gameObj.toString()).append("}}");
            signParams.put("body", sb.toString());
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/editscore";
            response = RESTConnectorAsync.getInstance().executePut(resourceURL, queryParams, sb.toString(), headerParams);
            game = new GameResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return game;
    }

    public void editScoreValueById(final String scoreId, final Double gameScore, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Game game = ScoreBoardService.this.editScoreValueById(scoreId, gameScore);
                    callBack.onSuccess(game);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Game getTopNRankersFromFacebook(String gameName, String userName, String fbAccessToken, int max) throws App42Exception {
        String response = null;
        Game game = null;
        Util.throwExceptionIfNullOrBlank(gameName, "Game Name");
        Util.throwExceptionIfNullOrBlank(fbAccessToken, "fbAccessToken");
        try {
            this.setFbAccessToken(fbAccessToken);
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("name", gameName);
            signParams.put("userName", userName);
            signParams.put("max", "" + max);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/" + gameName + "/rankers/facebook/" + userName + "/" + max;
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            game = new GameResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return game;
    }

    public void getTopNRankersFromFacebook(final String gameName, final String userName, final String fbAccessToken, final int max, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Game game = ScoreBoardService.this.getTopNRankersFromFacebook(gameName, userName, fbAccessToken, max);
                    callBack.onSuccess(game);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Game getTopRankersFromBuddyGroup(String gameName, String userName, String ownerName, String groupName) throws App42Exception {
        String response = null;
        Game game = null;
        Util.throwExceptionIfNullOrBlank(gameName, "Game Name");
        Util.throwExceptionIfNullOrBlank(userName, "User Name");
        Util.throwExceptionIfNullOrBlank(ownerName, "Owner Name");
        Util.throwExceptionIfNullOrBlank(groupName, "Group Name");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("name", gameName);
            signParams.put("userName", userName);
            signParams.put("ownerName", ownerName);
            signParams.put("groupName", groupName);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/" + gameName + "/rankers" + "/" + userName + "/group/" + ownerName + "/" + groupName;
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            game = new GameResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return game;
    }

    public void getTopRankersFromBuddyGroup(final String gameName, final String userName, final String ownerName, final String groupName, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Game game = ScoreBoardService.this.getTopRankersFromBuddyGroup(gameName, userName, ownerName, groupName);
                    callBack.onSuccess(game);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getAdminKey() {
        return this.adminKey;
    }

    public void setAdminKey(String adminKey) {
        this.adminKey = adminKey;
    }
}

