/*
 * Decompiled with CFR 0.152.
 */
package com.shephertz.app42.paas.sdk.jme.geo;

import com.shephertz.app42.paas.sdk.jme.App42CallBack;
import com.shephertz.app42.paas.sdk.jme.App42Exception;
import com.shephertz.app42.paas.sdk.jme.App42Log;
import com.shephertz.app42.paas.sdk.jme.App42Response;
import com.shephertz.app42.paas.sdk.jme.App42Service;
import com.shephertz.app42.paas.sdk.jme.connection.RESTConnectorAsync;
import com.shephertz.app42.paas.sdk.jme.geo.Geo;
import com.shephertz.app42.paas.sdk.jme.geo.GeoPoint;
import com.shephertz.app42.paas.sdk.jme.geo.GeoResponseBuilder;
import com.shephertz.app42.paas.sdk.jme.util.Util;
import java.util.Hashtable;
import java.util.Vector;
import org.json.jme.JSONArray;
import org.json.jme.JSONObject;

public class GeoService
extends App42Service {
    private String resource = "geo";
    String baseURL;

    public GeoService(String apiKey, String secretKey, String baseURL) {
        this.apiKey = apiKey;
        this.secretKey = secretKey;
        this.baseURL = baseURL;
        this.version = "1.0";
    }

    public Geo createGeoPoints(String geoStorageName, Vector geoPointsList) throws App42Exception {
        String response = null;
        Geo geoObj = null;
        Util.throwExceptionIfNullOrBlank(geoStorageName, "Geo Storage Name");
        Util.throwExceptionIfNullOrBlank(geoPointsList, "Geo Points List");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            JSONObject obj = new JSONObject();
            obj.put("storageName", geoStorageName);
            JSONArray geoArray = new JSONArray();
            for (int i = 0; i < geoPointsList.size(); ++i) {
                GeoPoint geoPoint = (GeoPoint)geoPointsList.elementAt(i);
                geoArray.put(geoPoint.getJSONObject());
            }
            obj.put("points", "{\"point\":" + geoArray + "}");
            StringBuffer sb = new StringBuffer();
            sb.append("{\"app42\":{\"geo\":{\"storage\":").append(obj.toString()).append("}}}");
            signParams.put("body", sb.toString());
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/createGeoPoints";
            response = RESTConnectorAsync.getInstance().executePost(resourceURL, queryParams, sb.toString(), headerParams);
            geoObj = new GeoResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return geoObj;
    }

    public void createGeoPoints(final String geoStorageName, final Vector geoPointsList, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Geo geo = GeoService.this.createGeoPoints(geoStorageName, geoPointsList);
                    callBack.onSuccess(geo);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Geo getNearByPointsByMaxDistance(String storageName, Double lat, Double lng, Double distanceInKM) throws App42Exception {
        String response = null;
        Geo geoObj = null;
        Util.throwExceptionIfNullOrBlank(storageName, "Geo Storage Name");
        Util.throwExceptionIfNullOrBlank(lat, "Latitute");
        Util.throwExceptionIfNullOrBlank(lng, "langitude");
        Util.throwExceptionIfNullOrBlank(distanceInKM, "Distance In KM");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("storageName", storageName);
            signParams.put("lat", lat + "");
            signParams.put("lng", lng + "");
            signParams.put("distanceInKM", distanceInKM + "");
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/getNearByPoints" + "/storageName" + "/" + storageName + "/lat" + "/" + lat + "/lng" + "/" + lng + "/distanceInKM" + "/" + distanceInKM;
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            geoObj = new GeoResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return geoObj;
    }

    public void getNearByPointsByMaxDistance(final String storageName, final Double lat, final Double lng, final Double distanceInKM, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Geo geo = GeoService.this.getNearByPointsByMaxDistance(storageName, lat, lng, distanceInKM);
                    callBack.onSuccess(geo);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Geo getNearByPoint(String storageName, Double lat, Double lng, int resultLimit) throws App42Exception {
        String response = null;
        Geo geoObj = null;
        Util.throwExceptionIfNullOrBlank(storageName, "Geo Storage Name");
        Util.throwExceptionIfNullOrBlank(lat, "lattitude");
        Util.throwExceptionIfNullOrBlank(lng, "longitude");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("storageName", storageName);
            signParams.put("lat", lat + "");
            signParams.put("lng", lng + "");
            signParams.put("resultLimit", resultLimit + "");
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/getNearByPoint" + "/storageName" + "/" + storageName + "/lat" + "/" + lat + "/lng" + "/" + lng + "/limit" + "/" + resultLimit;
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            geoObj = new GeoResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return geoObj;
    }

    public void getNearByPoint(final String storageName, final Double lat, final Double lng, final int resultLimit, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Geo geo = GeoService.this.getNearByPoint(storageName, lat, lng, resultLimit);
                    callBack.onSuccess(geo);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Geo getPointsWithInCircle(String storageName, Double lat, Double lng, Double radiusInKM, int resultLimit) throws App42Exception {
        String response = null;
        Geo geoObj = null;
        Util.throwExceptionIfNullOrBlank(storageName, "Geo Storage Name");
        Util.throwExceptionIfNullOrBlank(lat, "Latitute");
        Util.throwExceptionIfNullOrBlank(lng, "Langitude");
        Util.throwExceptionIfNullOrBlank(radiusInKM, "Radius In KM");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("storageName", storageName);
            signParams.put("lat", lat + "");
            signParams.put("lng", lng + "");
            signParams.put("resultLimit", resultLimit + "");
            signParams.put("radiusInKM", radiusInKM + "");
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/getPointsWithInCircle" + "/storageName" + "/" + storageName + "/lat" + "/" + lat + "/lng" + "/" + lng + "/radiusInKM" + "/" + radiusInKM + "/limit" + "/" + resultLimit;
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            geoObj = new GeoResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return geoObj;
    }

    public void getPointsWithInCircle(final String storageName, final Double lat, final Double lng, final Double radiusInKM, final int resultLimit, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Geo geo = GeoService.this.getPointsWithInCircle(storageName, lat, lng, radiusInKM, resultLimit);
                    callBack.onSuccess(geo);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Vector getAllStorage() throws App42Exception {
        String response = null;
        Vector geoObjList = null;
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/storage";
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            geoObjList = new GeoResponseBuilder().buildArrayResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return geoObjList;
    }

    public void getAllStorage(final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Vector geo = GeoService.this.getAllStorage();
                    callBack.onSuccess(geo);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public App42Response deleteStorage(String storageName) throws App42Exception {
        String response = null;
        App42Response responseObj = new App42Response();
        Util.throwExceptionIfNullOrBlank(storageName, "Geo Storage Name");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("storageName", storageName);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/storage" + "/" + storageName;
            response = RESTConnectorAsync.getInstance().executeDelete(resourceURL, queryParams, headerParams);
            responseObj.setStrResponse(response);
            responseObj.setResponseSuccess(true);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return responseObj;
    }

    public void deleteStorage(final String storageName, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    App42Response geo = GeoService.this.deleteStorage(storageName);
                    callBack.onSuccess(geo);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Geo getAllPoints(String storageName) throws App42Exception {
        String response = null;
        Geo geoObj = null;
        Util.throwExceptionIfNullOrBlank(storageName, "Geo Storage Name");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("storageName", storageName);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/points" + "/" + storageName;
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            geoObj = new GeoResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return geoObj;
    }

    public void getAllPoints(final String storageName, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Geo geo = GeoService.this.getAllPoints(storageName);
                    callBack.onSuccess(geo);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }
}

