/*
 * Decompiled with CFR 0.152.
 */
package com.shephertz.app42.paas.sdk.jme.log;

import com.shephertz.app42.paas.sdk.jme.App42ResponseBuilder;
import com.shephertz.app42.paas.sdk.jme.log.Log;
import com.shephertz.app42.paas.sdk.jme.util.Util;
import java.util.Vector;
import org.json.jme.JSONArray;
import org.json.jme.JSONObject;

public class LogResponseBuilder
extends App42ResponseBuilder {
    public Log buildResponse(String json) throws Exception {
        Log logObj = new Log();
        Vector msgList = new Vector();
        logObj.setMessageList(msgList);
        logObj.setStrResponse(json);
        JSONObject jsonObj = new JSONObject(json);
        JSONObject jsonObjApp42 = jsonObj.getJSONObject("app42");
        JSONObject jsonObjResponse = jsonObjApp42.getJSONObject("response");
        logObj.setResponseSuccess(jsonObjResponse.getBoolean("success"));
        JSONObject jsonObjLog = jsonObjResponse.getJSONObject("logs");
        if (!jsonObjLog.has("log")) {
            return logObj;
        }
        if (jsonObjLog.get("log") instanceof JSONObject) {
            JSONObject jsonObjLogMessage = jsonObjLog.getJSONObject("log");
            Log.Message messageItem = logObj.new Log.Message();
            this.buildObjectFromJSONTree(messageItem, jsonObjLogMessage);
        } else {
            JSONArray jsonObjMessageArray = jsonObjLog.getJSONArray("log");
            for (int i = 0; i < jsonObjMessageArray.length(); ++i) {
                JSONObject jsonObjLogMessage = jsonObjMessageArray.getJSONObject(i);
                Log.Message messageItem = logObj.new Log.Message();
                this.buildObjectFromJSONTree(messageItem, jsonObjLogMessage);
            }
        }
        return logObj;
    }

    public static void main(String[] args) throws Exception {
        Log log = new LogResponseBuilder().buildResponse("{\"app42\":{\"response\":{\"success\":true,\"logs\":{\"log\":[{\"message\":\"info logs\",\"type\":\"INFO\",\"logTime\":\"2012-03-23T06:29:23.482Z\",\"module\":\"testmod1\"},{\"message\":\"info logs\",\"logTime\":\"2012-03-23T07:12:59.000Z\",\"module\":\"testmod2\",\"type\":\"INFO\"}]}}}}");
    }

    public void buildObjectFromJSONTree(Object obj, JSONObject jsonObj) throws Exception {
        if (obj instanceof Log) {
            Log log = (Log)obj;
        }
        if (obj instanceof Log.Message) {
            Log.Message msg = (Log.Message)obj;
            String[] names = this.getNames(jsonObj);
            if (names != null) {
                for (int i = 0; i < names.length; ++i) {
                    String dob;
                    String name = names[i];
                    if (name.equals("message")) {
                        msg.setMessage("" + jsonObj.get(name));
                    }
                    if (name.equals("type")) {
                        msg.setType("" + jsonObj.get(name));
                    }
                    if (name.equals("module")) {
                        msg.setModule("" + jsonObj.get(name));
                    }
                    if (!name.equals("logTime") || jsonObj.get(name) == null || (dob = "" + jsonObj.get(name)).equals("null")) continue;
                    msg.setLogTime(Util.getDateFromUTCTimeStamp("" + jsonObj.get(name)));
                }
            }
        }
    }
}

