/*
 * Decompiled with CFR 0.152.
 */
package com.shephertz.app42.paas.sdk.jme.storage;

import com.shephertz.app42.paas.sdk.jme.ACL;
import com.shephertz.app42.paas.sdk.jme.App42Log;
import com.shephertz.app42.paas.sdk.jme.App42ResponseBuilder;
import com.shephertz.app42.paas.sdk.jme.storage.GeoTag;
import com.shephertz.app42.paas.sdk.jme.storage.Storage;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.json.jme.JSONArray;
import org.json.jme.JSONObject;

public class StorageResponseBuilder
extends App42ResponseBuilder {
    public Storage buildResponse(String json) throws Exception {
        App42Log.debug("Response : " + json);
        Storage storageObj = new Storage();
        Vector jsonDocList = new Vector();
        storageObj.setJsonDocList(jsonDocList);
        storageObj.setStrResponse(json);
        JSONObject jsonObj = new JSONObject(json);
        JSONObject jsonObjApp42 = jsonObj.getJSONObject("app42");
        JSONObject jsonObjResponse = jsonObjApp42.getJSONObject("response");
        storageObj.setResponseSuccess(jsonObjResponse.getBoolean("success"));
        JSONObject jsonObjStorage = jsonObjResponse.getJSONObject("storage");
        this.buildObjectFromJSONTree(storageObj, jsonObjStorage);
        if (!jsonObjStorage.has("jsonDoc")) {
            return storageObj;
        }
        if (jsonObjStorage.get("jsonDoc") instanceof JSONObject) {
            JSONObject jsonObjDoc = jsonObjStorage.getJSONObject("jsonDoc");
            Storage.JSONDocument document = storageObj.new Storage.JSONDocument();
            this.buildJsonDocument(document, jsonObjDoc);
        } else {
            JSONArray jsonObjDocArray = jsonObjStorage.getJSONArray("jsonDoc");
            for (int i = 0; i < jsonObjDocArray.length(); ++i) {
                JSONObject jsonObjDoc = jsonObjDocArray.getJSONObject(i);
                Storage.JSONDocument document = storageObj.new Storage.JSONDocument();
                this.buildJsonDocument(document, jsonObjDoc);
            }
        }
        App42Log.debug(storageObj.getDbName() + " : " + storageObj.getCollectionName() + " : " + storageObj.getJsonDocList());
        return storageObj;
    }

    private void buildJsonDocument(Storage.JSONDocument document, JSONObject jsonObjDoc) throws Exception {
        if (jsonObjDoc.has("loc") && jsonObjDoc.get("loc") instanceof JSONArray) {
            JSONArray geoArray = (JSONArray)jsonObjDoc.get("loc");
            for (int i = 0; i < geoArray.length(); ++i) {
                if (geoArray.length() != 2) continue;
                GeoTag geoTag = new GeoTag();
                geoTag.setLat(Double.valueOf(geoArray.get(0).toString()));
                geoTag.setLng(Double.valueOf(geoArray.get(1).toString()));
                document.setLocation(geoTag);
                jsonObjDoc.remove("loc");
            }
        }
        if (jsonObjDoc.has("_id") && !jsonObjDoc.get("_id").getClass().equals("org.json.JSONObject.Null")) {
            JSONObject idObj = jsonObjDoc.getJSONObject("_id");
            String oIdObj = idObj.getString("$oid");
            document.setDocId(oIdObj);
            jsonObjDoc.remove("_id");
        }
        if (jsonObjDoc.has("_$createdAt") && !jsonObjDoc.get("_$createdAt").getClass().equals("org.json.JSONObject.Null")) {
            String createdId = jsonObjDoc.getString("_$createdAt");
            document.setCreatedAt(createdId);
            jsonObjDoc.remove("_$createdAt");
        }
        if (jsonObjDoc.has("_$updatedAt") && !jsonObjDoc.get("_$updatedAt").getClass().equals("org.json.JSONObject.Null")) {
            String updateId = jsonObjDoc.getString("_$updatedAt");
            document.setUpdatedAt(updateId);
            jsonObjDoc.remove("_$updatedAt");
        }
        if (jsonObjDoc.has("_$acl") && !jsonObjDoc.get("_$acl").getClass().equals("org.json.JSONObject.Null")) {
            Hashtable<String, ACL> aclList = new Hashtable<String, ACL>();
            document.setAclList(aclList);
            if (jsonObjDoc.get("_$acl") instanceof JSONArray) {
                JSONArray aclArray = (JSONArray)jsonObjDoc.get("_$acl");
                for (int i = 0; i < aclArray.length(); ++i) {
                    if (!(aclArray.get(i) instanceof JSONObject)) continue;
                    JSONObject aclObj = (JSONObject)aclArray.get(i);
                    Enumeration keys = aclObj.keys();
                    ACL acl = new ACL();
                    while (keys.hasMoreElements()) {
                        String key = (String)keys.nextElement();
                        acl.setUser(key);
                        acl.setPermission(aclObj.getString(key));
                    }
                    aclList.put(acl.getUser(), acl);
                }
            } else {
                JSONObject aclObj = (JSONObject)jsonObjDoc.get("_$acl");
                Enumeration keys = aclObj.keys();
                ACL acl = new ACL();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    acl.setUser(key);
                    acl.setPermission(aclObj.getString(key));
                }
                aclList.put(acl.getUser(), acl);
            }
        }
        if (jsonObjDoc.has("_$owner") && !jsonObjDoc.get("_$owner").getClass().equals("org.json.JSONObject.Null")) {
            JSONObject jsonObjOwner = jsonObjDoc.getJSONObject("_$owner");
            String owner = jsonObjOwner.getString("owner");
            document.setOwner(owner);
        }
        document.setJsonDoc(jsonObjDoc.toString());
    }

    public static void main(String[] args) throws Exception {
        Storage storage = new Storage();
        Storage.JSONDocument doc = storage.new Storage.JSONDocument();
        new StorageResponseBuilder().buildResponse("{\"app42\":{\"response\":{\"success\":true,\"storage\":{\"dbName\":\"db\",\"collectionName\":\"col\",\"jsonDoc\":[{\"_id\":{\"$oid\":\"4f6af8b56cba3551222b5db8\"},\"nae\":\"test\"},{\"_id\":{\"$oid\":\"4f6af8fb6cba3551222b5db9\"},\"nae\":\"test\"},{\"_id\":{\"$oid\":\"4f6af9b66cba3551222b5dba\"},\"nae\":\"test\"}]}}}}");
    }

    public void buildObjectFromJSONTree(Object obj, JSONObject jsonObj) throws Exception {
        String name;
        int i;
        String[] names;
        if (obj instanceof Storage) {
            Storage storage = (Storage)obj;
            names = this.getNames(jsonObj);
            if (names != null) {
                for (i = 0; i < names.length; ++i) {
                    name = names[i];
                    if (name.equals("dbName")) {
                        storage.setDbName("" + jsonObj.get(name));
                    }
                    if (name.equals("collectionName")) {
                        storage.setCollectionName("" + jsonObj.get(name));
                    }
                    if (!name.equals("recordCount")) continue;
                    storage.setRecordCount("" + jsonObj.get(name));
                }
            }
        }
        if (obj instanceof Storage.JSONDocument) {
            Storage.JSONDocument doc = (Storage.JSONDocument)obj;
            names = this.getNames(jsonObj);
            if (names != null) {
                for (i = 0; i < names.length; ++i) {
                    name = names[i];
                    if (name.equals("jsonDoc")) {
                        doc.setJsonDoc("" + jsonObj.get(name));
                    }
                    if (name.equals("docId")) {
                        doc.setDocId("" + jsonObj.get(name));
                    }
                    if (name.equals("owner")) {
                        doc.setOwner("" + jsonObj.get(name));
                    }
                    if (name.equals("createdAt")) {
                        doc.setCreatedAt("" + jsonObj.get(name));
                    }
                    if (!name.equals("updatedAt")) continue;
                    doc.setUpdatedAt("" + jsonObj.get(name));
                }
            }
        }
    }
}

