/*
 * Decompiled with CFR 0.152.
 */
package com.shephertz.app42.paas.sdk.jme.user;

import com.shephertz.app42.paas.sdk.jme.App42API;
import com.shephertz.app42.paas.sdk.jme.App42CallBack;
import com.shephertz.app42.paas.sdk.jme.App42Exception;
import com.shephertz.app42.paas.sdk.jme.App42Log;
import com.shephertz.app42.paas.sdk.jme.App42Response;
import com.shephertz.app42.paas.sdk.jme.App42Service;
import com.shephertz.app42.paas.sdk.jme.connection.RESTConnectorAsync;
import com.shephertz.app42.paas.sdk.jme.user.User;
import com.shephertz.app42.paas.sdk.jme.user.UserResponseBuilder;
import com.shephertz.app42.paas.sdk.jme.util.Util;
import java.util.Hashtable;
import java.util.Vector;
import org.json.jme.JSONArray;
import org.json.jme.JSONObject;

public class UserService
extends App42Service {
    private String resource = "user";

    public UserService(String apiKey, String secretKey, String baseURL) {
        this.apiKey = apiKey;
        this.secretKey = secretKey;
        this.version = "1.0";
    }

    public User createUser(String uName, String pwd, String emailAddress) throws App42Exception {
        String response = null;
        User usr = null;
        Util.throwExceptionIfNullOrBlank(uName, "UserName");
        Util.throwExceptionIfNullOrBlank(pwd, "Password");
        Util.throwExceptionIfNullOrBlank(emailAddress, "EmailAddress");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            JSONObject obj = new JSONObject();
            obj.put("email", emailAddress);
            obj.put("password", pwd);
            obj.put("userName", uName);
            StringBuffer sb = new StringBuffer();
            sb.append("{\"app42\":{\"user\":").append(obj.toString()).append("}}");
            App42Log.debug(" Json String : " + sb.toString());
            signParams.put("body", sb.toString());
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource;
            response = RESTConnectorAsync.getInstance().executePost(resourceURL, queryParams, sb.toString(), headerParams);
            usr = new UserResponseBuilder().buildResponse(response);
            App42API.setLoggedInUser(uName);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return usr;
    }

    public void createUser(final String uName, final String pwd, final String emailAddress, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    User user = UserService.this.createUser(uName, pwd, emailAddress);
                    callBack.onSuccess(user);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public User createUser(String uName, String pwd, String emailAddress, Vector roleList) throws App42Exception {
        String response = null;
        User usr = null;
        Util.throwExceptionIfNullOrBlank(uName, "UserName");
        Util.throwExceptionIfNullOrBlank(pwd, "Password");
        Util.throwExceptionIfNullOrBlank(emailAddress, "EmailAddress");
        Util.throwExceptionIfNullOrBlank(roleList, "RoleList");
        Util.throwExceptionIfEmailNotValid(emailAddress, "EmailAddress");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            JSONArray roleArray = new JSONArray();
            JSONObject obj = new JSONObject();
            obj.put("email", emailAddress);
            obj.put("password", pwd);
            obj.put("userName", uName);
            for (int i = 0; i < roleList.size(); ++i) {
                String role = (String)roleList.elementAt(i);
                roleArray.put(role);
            }
            obj.put("roles", "{\"role\":" + roleArray + "}");
            StringBuffer sb = new StringBuffer();
            sb.append("{\"app42\":{\"user\":").append(obj.toString()).append("}}");
            App42Log.debug(" Json String : " + sb.toString());
            signParams.put("body", sb.toString());
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/role";
            response = RESTConnectorAsync.getInstance().executePost(resourceURL, queryParams, sb.toString(), headerParams);
            usr = new UserResponseBuilder().buildResponse(response);
            App42API.setLoggedInUser(uName);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return usr;
    }

    public void createUser(final String uName, final String pwd, final String emailAddress, final Vector roleList, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    User user = UserService.this.createUser(uName, pwd, emailAddress, roleList);
                    callBack.onSuccess(user);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public User assignRoles(String uName, Vector roleList) throws App42Exception {
        String response = null;
        User usr = null;
        Util.throwExceptionIfNullOrBlank(uName, "UserName");
        Util.throwExceptionIfNullOrBlank(roleList, "RoleList");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            JSONArray roleArray = new JSONArray();
            JSONObject obj = new JSONObject();
            obj.put("userName", uName);
            for (int i = 0; i < roleList.size(); ++i) {
                String role = (String)roleList.elementAt(i);
                roleArray.put(role);
            }
            obj.put("roles", "{\"role\":" + roleArray + "}");
            StringBuffer sb = new StringBuffer();
            sb.append("{\"app42\":{\"user\":").append(obj.toString()).append("}}");
            App42Log.debug(" Json String : " + sb.toString());
            signParams.put("body", sb.toString());
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/assignrole";
            response = RESTConnectorAsync.getInstance().executePost(resourceURL, queryParams, sb.toString(), headerParams);
            usr = new UserResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return usr;
    }

    public void assignRoles(final String uName, final Vector roleList, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    User user = UserService.this.assignRoles(uName, roleList);
                    callBack.onSuccess(user);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public User getUser(String userName) throws App42Exception {
        String response = null;
        User user = null;
        Util.throwExceptionIfNullOrBlank(userName, "UserName");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("userName", userName);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/" + userName;
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            user = new UserResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return user;
    }

    public void getUser(final String userName, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    User user = UserService.this.getUser(userName);
                    callBack.onSuccess(user);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public User getRolesByUser(String userName) throws App42Exception {
        String response = null;
        User user = null;
        Util.throwExceptionIfNullOrBlank(userName, "UserName");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("userName", userName);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/" + userName + "/roles";
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            user = new UserResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return user;
    }

    public void getRolesByUser(final String userName, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    User user = UserService.this.getRolesByUser(userName);
                    callBack.onSuccess(user);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Vector getUsersByRole(String role) throws App42Exception {
        String response = null;
        Vector userList = new Vector();
        Util.throwExceptionIfNullOrBlank(role, "Role");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("role", role);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/role" + "/" + role;
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            userList = new UserResponseBuilder().buildArrayResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return userList;
    }

    public void getUsersByRole(final String role, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Vector user = UserService.this.getUsersByRole(role);
                    callBack.onSuccess(user);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Vector getAllUsers() throws App42Exception {
        String response = null;
        Vector userList = null;
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource;
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            userList = new UserResponseBuilder().buildArrayResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return userList;
    }

    public void getAllUsers(final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Vector user = UserService.this.getAllUsers();
                    callBack.onSuccess(user);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public App42Response getAllUsersCount() throws App42Exception {
        String response = null;
        App42Response responseObj = new App42Response();
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/count/all";
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            responseObj.setStrResponse(response);
            responseObj.setResponseSuccess(true);
            responseObj.setTotalRecords(new UserResponseBuilder().getTotalRecords(response));
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return responseObj;
    }

    public void getAllUsersCount(final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    App42Response user = UserService.this.getAllUsersCount();
                    callBack.onSuccess(user);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Vector getAllUsers(Integer max, Integer offset) throws App42Exception {
        String response = null;
        Vector userList = null;
        Util.validateMax(max);
        Util.throwExceptionIfNullOrBlank(max, "Max");
        Util.throwExceptionIfNullOrBlank(offset, "Offset");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            signParams.put("max", "" + max);
            signParams.put("offset", "" + offset);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/paging" + "/" + max + "/" + offset;
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            userList = new UserResponseBuilder().buildArrayResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return userList;
    }

    public void getAllUsers(final Integer max, final Integer offset, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Vector user = UserService.this.getAllUsers(max, offset);
                    callBack.onSuccess(user);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Vector getLockedUsers() throws App42Exception {
        String response = null;
        Vector userList = null;
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/" + "locked";
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            userList = new UserResponseBuilder().buildArrayResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return userList;
    }

    public void getLockedUsers(final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Vector user = UserService.this.getLockedUsers();
                    callBack.onSuccess(user);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public App42Response getLockedUsersCount() throws App42Exception {
        String response = null;
        App42Response responseObj = new App42Response();
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/count/locked";
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            responseObj.setStrResponse(response);
            responseObj.setResponseSuccess(true);
            responseObj.setTotalRecords(new UserResponseBuilder().getTotalRecords(response));
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return responseObj;
    }

    public void getLockedUsersCount(final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    App42Response user = UserService.this.getLockedUsersCount();
                    callBack.onSuccess(user);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Vector getLockedUsers(Integer max, Integer offset) throws App42Exception {
        String response = null;
        Vector userList = null;
        Util.validateMax(max);
        Util.throwExceptionIfNullOrBlank(max, "Max");
        Util.throwExceptionIfNullOrBlank(offset, "Offset");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            signParams.put("max", "" + max);
            signParams.put("offset", "" + offset);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/" + "locked" + "/" + max + "/" + offset;
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            userList = new UserResponseBuilder().buildArrayResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return userList;
    }

    public void getLockedUsers(final Integer max, final Integer offset, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Vector user = UserService.this.getLockedUsers(max, offset);
                    callBack.onSuccess(user);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public User getUserByEmailId(String emailId) throws App42Exception {
        String response = null;
        User user = null;
        Util.throwExceptionIfNullOrBlank(emailId, "EmailId");
        Util.throwExceptionIfEmailNotValid(emailId, "EmailAddress");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("emailId", emailId);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/" + "email" + "/" + emailId;
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            user = new UserResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return user;
    }

    public void getUserByEmailId(final String emailId, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    User user = UserService.this.getUserByEmailId(emailId);
                    callBack.onSuccess(user);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public User updateEmail(String uName, String emailAddress) throws App42Exception {
        String response = null;
        User user = null;
        Util.throwExceptionIfNullOrBlank(uName, "UserName");
        Util.throwExceptionIfNullOrBlank(emailAddress, "Email Address");
        Util.throwExceptionIfEmailNotValid(emailAddress, "EmailAddress");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            JSONObject obj = new JSONObject();
            obj.put("email", emailAddress);
            obj.put("userName", uName);
            StringBuffer sb = new StringBuffer();
            sb.append("{\"app42\":{\"user\":").append(obj.toString()).append("}}");
            App42Log.debug(" Json String : " + sb.toString());
            signParams.put("body", sb.toString());
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource;
            response = RESTConnectorAsync.getInstance().executePut(resourceURL, queryParams, sb.toString(), headerParams);
            user = new UserResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return user;
    }

    public void updateEmail(final String uName, final String emailAddress, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    User user = UserService.this.updateEmail(uName, emailAddress);
                    callBack.onSuccess(user);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public App42Response deleteUser(String userName) throws App42Exception {
        String response = null;
        Util.throwExceptionIfNullOrBlank(userName, "UserName");
        App42Response responseObj = new App42Response();
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("userName", userName);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/" + userName;
            response = RESTConnectorAsync.getInstance().executeDelete(resourceURL, queryParams, headerParams);
            responseObj.setStrResponse(response);
            responseObj.setResponseSuccess(true);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return responseObj;
    }

    public void deleteUser(final String userName, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    App42Response user = UserService.this.deleteUser(userName);
                    callBack.onSuccess(user);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public User createOrUpdateProfile(User user) throws App42Exception {
        String response = null;
        User userResponse = null;
        Util.throwExceptionIfNullOrBlank(user, "User");
        Util.throwExceptionIfNullOrBlank(user.getUserName(), "UserName");
        Util.throwExceptionIfNullOrBlank(user.getProfile(), "Profile Data");
        User.UserGender.throwExceptionIfNotValid(user.getProfile().getSex());
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            JSONObject obj = new JSONObject();
            User.Profile profile = user.getProfile();
            JSONObject profileObj = new JSONObject();
            profileObj.put("firstName", profile.getFirstName());
            profileObj.put("lastName", profile.getLastName());
            profileObj.put("sex", profile.getSex());
            profileObj.put("mobile", profile.getMobile());
            profileObj.put("line1", profile.getLine1());
            profileObj.put("line2", profile.getLine2());
            profileObj.put("city", profile.getCity());
            profileObj.put("state", profile.getState());
            profileObj.put("country", profile.getCountry());
            profileObj.put("pincode", profile.getPincode());
            profileObj.put("homeLandLine", profile.getHomeLandLine());
            profileObj.put("officeLandLine", profile.getOfficeLandLine());
            if (profile.getDateOfBirth() != null) {
                profileObj.put("dateOfBirth", Util.getUTCFormattedTimestamp(profile.getDateOfBirth()));
            }
            obj.put("profileData", profileObj);
            obj.put("userName", user.getUserName());
            StringBuffer sb = new StringBuffer();
            sb.append("{\"app42\":{\"user\":").append(obj.toString()).append("}}");
            App42Log.debug(" Json String : " + sb.toString());
            signParams.put("body", sb.toString());
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/profile";
            response = RESTConnectorAsync.getInstance().executePut(resourceURL, queryParams, sb.toString(), headerParams);
            userResponse = new UserResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return userResponse;
    }

    public void createOrUpdateProfile(final User user, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    User update = UserService.this.createOrUpdateProfile(user);
                    callBack.onSuccess(update);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public User authenticate(String uName, String pwd) throws App42Exception {
        String response = null;
        User user = null;
        Util.throwExceptionIfNullOrBlank(uName, "UserName");
        Util.throwExceptionIfNullOrBlank(pwd, "Password");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            JSONObject obj = new JSONObject();
            obj.put("userName", uName);
            obj.put("password", pwd);
            StringBuffer sb = new StringBuffer();
            sb.append("{\"app42\":{\"user\":").append(obj.toString()).append("}}");
            App42Log.debug(" Json String : " + sb.toString());
            signParams.put("body", sb.toString());
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/authenticate";
            response = RESTConnectorAsync.getInstance().executePost(resourceURL, queryParams, sb.toString(), headerParams);
            user = new UserResponseBuilder().buildResponse(response);
            App42API.setUserSessionId(user.getSessionId());
            App42API.setLoggedInUser(uName);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return user;
    }

    public void authenticate(final String uName, final String pwd, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    User user = UserService.this.authenticate(uName, pwd);
                    callBack.onSuccess(user);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public User lockUser(String uName) throws App42Exception {
        String response = null;
        User usr = null;
        Util.throwExceptionIfNullOrBlank(uName, "UserName");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            JSONObject obj = new JSONObject();
            obj.put("userName", uName);
            StringBuffer sb = new StringBuffer();
            sb.append("{\"app42\":{\"user\":").append(obj.toString()).append("}}");
            App42Log.debug(" Json String : " + sb.toString());
            signParams.put("body", sb.toString());
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/lock";
            response = RESTConnectorAsync.getInstance().executePut(resourceURL, queryParams, sb.toString(), headerParams);
            usr = new UserResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return usr;
    }

    public void lockUser(final String uName, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    User user = UserService.this.lockUser(uName);
                    callBack.onSuccess(user);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public User unlockUser(String uName) throws App42Exception {
        String response = null;
        User usr = null;
        Util.throwExceptionIfNullOrBlank(uName, "UserName");
        App42Response responseObj = new App42Response();
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            JSONObject obj = new JSONObject();
            obj.put("userName", uName);
            StringBuffer sb = new StringBuffer();
            sb.append("{\"app42\":{\"user\":").append(obj.toString()).append("}}");
            App42Log.debug(" Json String : " + sb.toString());
            signParams.put("body", sb.toString());
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/unlock";
            response = RESTConnectorAsync.getInstance().executePut(resourceURL, queryParams, sb.toString(), headerParams);
            usr = new UserResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return usr;
    }

    public void unlockUser(final String uName, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    User user = UserService.this.unlockUser(uName);
                    callBack.onSuccess(user);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public App42Response changeUserPassword(String uName, String oldPwd, String newPwd) throws App42Exception {
        String response = null;
        Util.throwExceptionIfNullOrBlank(uName, "UserName");
        Util.throwExceptionIfNullOrBlank(oldPwd, "Old Password");
        Util.throwExceptionIfNullOrBlank(newPwd, "New Password");
        App42Response responseObj = new App42Response();
        if (oldPwd.equals(newPwd)) {
            throw new App42Exception("Old password and new password are same");
        }
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            JSONObject obj = new JSONObject();
            obj.put("userName", uName);
            obj.put("newPassword", newPwd);
            obj.put("oldPassword", oldPwd);
            StringBuffer sb = new StringBuffer();
            sb.append("{\"app42\":{\"user\":").append(obj.toString()).append("}}");
            App42Log.debug(" Json String : " + sb.toString());
            signParams.put("body", sb.toString());
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/changeUserPassword";
            response = RESTConnectorAsync.getInstance().executePut(resourceURL, queryParams, sb.toString(), headerParams);
            responseObj.setStrResponse(response);
            responseObj.setResponseSuccess(true);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return responseObj;
    }

    public void changeUserPassword(final String uName, final String oldPwd, final String newPwd, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    App42Response user = UserService.this.changeUserPassword(uName, oldPwd, newPwd);
                    callBack.onSuccess(user);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public App42Response revokeRole(String userName, String role) throws App42Exception {
        String response = null;
        Util.throwExceptionIfNullOrBlank(userName, "UserName");
        Util.throwExceptionIfNullOrBlank(role, "Role");
        App42Response responseObj = new App42Response();
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("userName", userName);
            signParams.put("role", role);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/" + userName + "/revoke/" + role;
            response = RESTConnectorAsync.getInstance().executeDelete(resourceURL, queryParams, headerParams);
            responseObj.setStrResponse(response);
            responseObj.setResponseSuccess(true);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return responseObj;
    }

    public void revokeRole(final String userName, final String role, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    App42Response user = UserService.this.revokeRole(userName, role);
                    callBack.onSuccess(user);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public App42Response revokeAllRoles(String userName) throws App42Exception {
        String response = null;
        Util.throwExceptionIfNullOrBlank(userName, "UserName");
        App42Response responseObj = new App42Response();
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("userName", userName);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/" + userName + "/revoke";
            response = RESTConnectorAsync.getInstance().executeDelete(resourceURL, queryParams, headerParams);
            responseObj.setStrResponse(response);
            responseObj.setResponseSuccess(true);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return responseObj;
    }

    public void revokeAllRoles(final String userName, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    App42Response user = UserService.this.revokeAllRoles(userName);
                    callBack.onSuccess(user);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public App42Response resetUserPassword(String uName, String pwd) throws App42Exception {
        String response = null;
        Object usr = null;
        Util.throwExceptionIfNullOrBlank(uName, "UserName");
        Util.throwExceptionIfNullOrBlank(pwd, "Password");
        App42Response responseObj = new App42Response();
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            JSONObject obj = new JSONObject();
            obj.put("userName", uName);
            obj.put("password", pwd);
            StringBuffer sb = new StringBuffer();
            sb.append("{\"app42\":{\"user\":").append(obj.toString()).append("}}");
            App42Log.debug(" Json String : " + sb.toString());
            signParams.put("body", sb.toString());
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/resetUserPassword";
            response = RESTConnectorAsync.getInstance().executePut(resourceURL, queryParams, sb.toString(), headerParams);
            responseObj.setStrResponse(response);
            responseObj.setResponseSuccess(true);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return responseObj;
    }

    public void resetUserPassword(final String uName, final String pwd, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    App42Response user = UserService.this.resetUserPassword(uName, pwd);
                    callBack.onSuccess(user);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public App42Response resetUserPassword(String uName) throws App42Exception {
        String response = null;
        Object usr = null;
        Util.throwExceptionIfNullOrBlank(uName, "UserName");
        App42Response responseObj = new App42Response();
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            JSONObject obj = new JSONObject();
            obj.put("userName", uName);
            StringBuffer sb = new StringBuffer();
            sb.append("{\"app42\":{\"user\":").append(obj.toString()).append("}}");
            App42Log.debug(" Json String : " + sb.toString());
            signParams.put("body", sb.toString());
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/resetAppUserPassword";
            response = RESTConnectorAsync.getInstance().executePut(resourceURL, queryParams, sb.toString(), headerParams);
            responseObj.setStrResponse(response);
            responseObj.setResponseSuccess(true);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return responseObj;
    }

    public App42Response logout(String sessionId) throws App42Exception {
        String response = null;
        App42Response responseObj = new App42Response();
        Util.throwExceptionIfNullOrBlank(sessionId, "SessionId");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            JSONObject obj = new JSONObject();
            obj.put("id", sessionId);
            StringBuffer sb = new StringBuffer();
            sb.append("{\"app42\":{\"session\":").append(obj.toString()).append("}}");
            App42Log.debug(" Json String : " + sb.toString());
            signParams.put("body", sb.toString());
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + "session";
            response = RESTConnectorAsync.getInstance().executePut(resourceURL, queryParams, sb.toString(), headerParams);
            responseObj.setStrResponse(response);
            responseObj.setResponseSuccess(true);
            App42API.removeSession();
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return responseObj;
    }

    public void logout(final String sessionId, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    App42Response user = UserService.this.logout(sessionId);
                    callBack.onSuccess(user);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public void resetUserPassword(final String uName, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    App42Response user = UserService.this.resetUserPassword(uName);
                    callBack.onSuccess(user);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Vector getUsersByProfileData(User.Profile profileData) throws App42Exception {
        String response = null;
        Vector userList = new Vector();
        String parameters = "";
        parameters = this.fillParamsWithProfileData(profileData);
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/profile" + "/" + parameters;
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            userList = new UserResponseBuilder().buildArrayResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return userList;
    }

    public void getUsersByProfileData(final User.Profile profileData, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Vector user = UserService.this.getUsersByProfileData(profileData);
                    callBack.onSuccess(user);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    private String fillParamsWithProfileData(User.Profile profileData) {
        String profileDataCond = "";
        if (profileData.getCity() != null && !profileData.getCity().equals("")) {
            profileDataCond = profileDataCond + "city:" + profileData.getCity() + "!";
        }
        if (profileData.getCountry() != null && !profileData.getCountry().equals("")) {
            profileDataCond = profileDataCond + "country:" + profileData.getCountry() + "!";
        }
        if (profileData.getDateOfBirth() != null && !profileData.getDateOfBirth().equals("")) {
            profileDataCond = profileDataCond + "date_of_birth:" + profileData.getDateOfBirth() + "!";
        }
        if (profileData.getFirstName() != null && !profileData.getFirstName().equals("")) {
            profileDataCond = profileDataCond + "first_name:" + profileData.getFirstName() + "!";
        }
        if (profileData.getLastName() != null && !profileData.getLastName().equals("")) {
            profileDataCond = profileDataCond + "last_name:" + profileData.getLastName() + "!";
        }
        if (profileData.getHomeLandLine() != null && !profileData.getHomeLandLine().equals("")) {
            profileDataCond = profileDataCond + "home_land_line:" + profileData.getHomeLandLine() + "!";
        }
        if (profileData.getLine1() != null && !profileData.getLine1().equals("")) {
            profileDataCond = profileDataCond + "line1:" + profileData.getLine1() + "!";
        }
        if (profileData.getLine2() != null && !profileData.getLine2().equals("")) {
            profileDataCond = profileDataCond + "line2:" + profileData.getLine2() + "!";
        }
        if (profileData.getMobile() != null && !profileData.getMobile().equals("")) {
            profileDataCond = profileDataCond + "mobile:" + profileData.getMobile() + "!";
        }
        if (profileData.getOfficeLandLine() != null && !profileData.getOfficeLandLine().equals("")) {
            profileDataCond = profileDataCond + "office_land_line:" + profileData.getOfficeLandLine() + "!";
        }
        if (profileData.getPincode() != null && !profileData.getPincode().equals("")) {
            profileDataCond = profileDataCond + "pincode:" + profileData.getPincode() + "!";
        }
        if (profileData.getSex() != null && !profileData.getSex().equals("")) {
            profileDataCond = profileDataCond + "sex:" + profileData.getSex() + "!";
        }
        if (profileData.getState() != null && !profileData.getState().equals("")) {
            profileDataCond = profileDataCond + "state:" + profileData.getState() + "!";
        }
        return profileDataCond;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getAdminKey() {
        return this.adminKey;
    }

    public void setAdminKey(String adminKey) {
        this.adminKey = adminKey;
    }
}

