/*
 * Decompiled with CFR 0.152.
 */
package com.shephertz.app42.paas.sdk.jme.util;

import com.shephertz.app42.paas.sdk.jme.App42BadParameterException;
import com.shephertz.app42.paas.sdk.jme.App42Exception;
import com.shephertz.app42.paas.sdk.jme.App42LimitException;
import com.shephertz.app42.paas.sdk.jme.App42Log;
import com.shephertz.app42.paas.sdk.jme.App42NotFoundException;
import com.shephertz.app42.paas.sdk.jme.App42SecurityException;
import com.shephertz.app42.paas.sdk.jme.util.URLEncoder;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.TimeZone;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import net.oauth.jme.signature.HMACSHA1Signature;
import org.json.jme.JSONObject;

public class Util {
    public static final String TRUE = "true";

    private static String sortAndConvertTableToString(Hashtable table) {
        Enumeration enumKeys = net.oauth.jme.Util.sort(table.keys());
        Vector v = new Vector();
        while (enumKeys.hasMoreElements()) {
            v.addElement(enumKeys.nextElement());
        }
        StringBuffer requestString = new StringBuffer();
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String val = (String)table.get(key);
            requestString.append(key);
            requestString.append(val);
        }
        return requestString.toString();
    }

    public static String sign(String secretKey, Hashtable params) throws InvalidKeyException, NoSuchAlgorithmException, IllegalStateException, UnsupportedEncodingException {
        String sortedParams = Util.sortAndConvertTableToString(params);
        String signature = Util.computeHmac(sortedParams, secretKey);
        return signature;
    }

    public static String computeHmac(String baseString, String key) {
        HMACSHA1Signature sha1 = new HMACSHA1Signature();
        sha1.setKey(key);
        sha1.setMessage(baseString);
        String signature = sha1.getSignature();
        return signature;
    }

    public static String getUTCFormattedTimestamp() {
        StringBuffer sb = new StringBuffer();
        Date d = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTimeZone(TimeZone.getTimeZone("UTC"));
        cal.setTime(d);
        sb.append(cal.get(1)).append("-");
        if (cal.get(2) + 1 >= 10) {
            sb.append(cal.get(2) + 1).append("-");
        } else {
            sb.append("0").append(cal.get(2) + 1).append("-");
        }
        if (cal.get(5) >= 10) {
            sb.append(cal.get(5)).append("T");
        } else {
            sb.append("0").append(cal.get(5)).append("T");
        }
        if (cal.get(11) >= 10) {
            sb.append(cal.get(11)).append(":");
        } else {
            sb.append("0").append(cal.get(11)).append(":");
        }
        if (cal.get(12) >= 10) {
            sb.append(cal.get(12)).append(":");
        } else {
            sb.append("0").append(cal.get(12)).append(":");
        }
        if (cal.get(13) >= 10) {
            sb.append(cal.get(13)).append(".");
        } else {
            sb.append("0").append(cal.get(13)).append(".");
        }
        if (cal.get(14) >= 100) {
            sb.append(cal.get(14)).append("Z");
        } else if (cal.get(14) >= 10) {
            sb.append("0").append(cal.get(14)).append("Z");
        } else {
            sb.append("00").append(cal.get(14)).append("Z");
        }
        App42Log.debug(" UTC Date : " + sb);
        return sb.toString();
    }

    public static String getUTCFormattedTimestamp(Date date) {
        StringBuffer sb = new StringBuffer();
        Date d = date;
        Calendar cal = Calendar.getInstance();
        cal.setTimeZone(TimeZone.getTimeZone("UTC"));
        cal.setTime(d);
        sb.append(cal.get(1)).append("-");
        if (cal.get(2) + 1 >= 10) {
            sb.append(cal.get(2) + 1).append("-");
        } else {
            sb.append("0").append(cal.get(2) + 1).append("-");
        }
        if (cal.get(5) >= 10) {
            sb.append(cal.get(5)).append("T");
        } else {
            sb.append("0").append(cal.get(5)).append("T");
        }
        if (cal.get(11) >= 10) {
            sb.append(cal.get(11)).append(":");
        } else {
            sb.append("0").append(cal.get(11)).append(":");
        }
        if (cal.get(12) >= 10) {
            sb.append(cal.get(12)).append(":");
        } else {
            sb.append("0").append(cal.get(12)).append(":");
        }
        if (cal.get(13) >= 10) {
            sb.append(cal.get(13)).append(".");
        } else {
            sb.append("0").append(cal.get(13)).append(".");
        }
        if (cal.get(14) >= 100) {
            sb.append(cal.get(14)).append("Z");
        } else if (cal.get(14) >= 10) {
            sb.append("0").append(cal.get(14)).append("Z");
        } else {
            sb.append("00").append(cal.get(14)).append("Z");
        }
        App42Log.debug(" UTC Date : " + sb);
        return sb.toString();
    }

    public static boolean isNull(Object obj, String name) {
        boolean flag = false;
        if (obj == null) {
            flag = true;
        }
        return flag;
    }

    public static String multiPartRequest(String name, InputStream fileInputStream, String fileName, Hashtable queryParams, Hashtable postParams, Hashtable headerParams, String urlPost, String accept) throws Exception {
        String str;
        block21: {
            HttpConnection conn = null;
            FilterOutputStream dos = null;
            Object inStream = null;
            str = null;
            String lineEnd = "\r\n";
            String twoHyphens = "--";
            String boundary = "**********";
            int maxBufferSize = 0x100000;
            urlPost = net.oauth.jme.Util.replace(urlPost, " ", "%20");
            StringBuffer queryString = new StringBuffer("?");
            String apiKey = (String)queryParams.get("apiKey");
            String signature = (String)queryParams.get("signature");
            String timeStamp = (String)queryParams.get("timeStamp");
            String sessionId = (String)queryParams.get("sessionId");
            String adminKey = (String)queryParams.get("adminKey");
            queryParams.remove("apiKey");
            queryParams.remove("signature");
            queryParams.remove("timeStamp");
            queryParams.remove("sessionId");
            queryParams.remove("adminKey");
            Enumeration enumKeys = queryParams.keys();
            while (enumKeys.hasMoreElements()) {
                String key = (String)enumKeys.nextElement();
                String value = (String)queryParams.get(key);
                queryString.append(URLEncoder.encode(key) + "=" + URLEncoder.encode(value) + "&");
            }
            String urlString = urlPost + queryString;
            try {
                int chr;
                StringBuffer responseMessage;
                App42Log.debug(" Upload URL is " + urlString);
                conn = (HttpConnection)Connector.open((String)urlString, (int)3);
                conn.setRequestMethod("POST");
                conn.setRequestProperty("Accept", "application/json");
                Enumeration enumKeysHeader = headerParams.keys();
                while (enumKeysHeader.hasMoreElements()) {
                    String key = (String)enumKeysHeader.nextElement();
                    String value = (String)headerParams.get(key);
                    conn.setRequestProperty(key, value);
                }
                conn.setRequestProperty("User-Agent", "Profile/MIDP-1.0 Confirguration/CLDC-1.0");
                conn.setRequestProperty("Content-Type", "multipart/form-data;boundary=" + boundary);
                dos = conn.openDataOutputStream();
                dos.write(new String(twoHyphens + boundary + lineEnd).getBytes());
                dos.write(new String("Content-Disposition: form-data; name=\"" + name + "\"" + ";" + " filename=\"" + fileName + "\"" + lineEnd).getBytes());
                dos.write(lineEnd.getBytes());
                int bytesAvailable = fileInputStream.available();
                int bufferSize = Math.min(bytesAvailable, maxBufferSize);
                byte[] buffer = new byte[bufferSize];
                int bytesRead = fileInputStream.read(buffer, 0, bufferSize);
                while (bytesRead > 0) {
                    ((DataOutputStream)dos).write(buffer, 0, bufferSize);
                    bytesAvailable = fileInputStream.available();
                    bufferSize = Math.min(bytesAvailable, maxBufferSize);
                    bytesRead = fileInputStream.read(buffer, 0, bufferSize);
                }
                dos.write(lineEnd.getBytes());
                App42Log.debug(" Bytes Writen : " + bytesRead);
                if (postParams != null && postParams.size() > 0) {
                    dos.write((twoHyphens + boundary + lineEnd).getBytes());
                } else {
                    dos.write((twoHyphens + boundary + twoHyphens + lineEnd).getBytes());
                }
                Enumeration keysParam = postParams.keys();
                int i = 0;
                while (keysParam.hasMoreElements()) {
                    ++i;
                    String key = (String)keysParam.nextElement();
                    String value = (String)postParams.get(key);
                    dos.write(("Content-Disposition: form-data; name=\"" + key + "\"" + lineEnd).getBytes());
                    dos.write(lineEnd.getBytes());
                    dos.write((value + lineEnd).getBytes());
                    if (!keysParam.hasMoreElements()) {
                        dos.write((twoHyphens + boundary + twoHyphens + lineEnd).getBytes());
                    } else {
                        dos.write((twoHyphens + boundary + lineEnd).getBytes());
                    }
                    App42Log.debug(" Setting Param  :" + key + " : " + value);
                }
                ((DataOutputStream)dos).flush();
                String response = conn.getResponseMessage();
                if (conn.getResponseCode() == 200) {
                    int chr2;
                    responseMessage = new StringBuffer();
                    DataInputStream is = conn.openDataInputStream();
                    while ((chr2 = ((InputStream)is).read()) != -1) {
                        responseMessage.append((char)chr2);
                    }
                    str = responseMessage.toString();
                    break block21;
                }
                responseMessage = new StringBuffer();
                DataInputStream is = conn.openDataInputStream();
                while ((chr = ((InputStream)is).read()) != -1) {
                    responseMessage.append((char)chr);
                }
                str = responseMessage.toString();
                JSONObject jsonObj = new JSONObject(str);
                int httpErrorCode = Integer.valueOf(jsonObj.getJSONObject("app42Fault").getString("httpErrorCode"));
                int appErrorCode = Integer.valueOf(jsonObj.getJSONObject("app42Fault").getString("appErrorCode"));
                if (httpErrorCode == 404) {
                    throw new App42NotFoundException(str, httpErrorCode, appErrorCode);
                }
                if (httpErrorCode == 400) {
                    throw new App42BadParameterException(str, httpErrorCode, appErrorCode);
                }
                if (httpErrorCode == 401) {
                    throw new App42SecurityException(str, httpErrorCode, appErrorCode);
                }
                if (httpErrorCode == 413) {
                    throw new App42LimitException(str, httpErrorCode, 1413);
                }
                if (httpErrorCode == 500) {
                    throw new App42Exception(str, httpErrorCode, appErrorCode);
                }
                throw new App42Exception("We are sorry something has gone wrong on our side", 500, 1500);
            }
            catch (Exception ex) {
                App42Log.debug("From ServletCom CLIENT REQUEST:" + ex);
                throw ex;
            }
            finally {
                fileInputStream.close();
                dos.close();
                conn.close();
            }
        }
        return str;
    }

    public static void throwExceptionIfNullOrBlank(Object obj, String name) {
        if (obj == null) {
            throw new App42Exception(name + " parameter can not be null ");
        }
        if (obj instanceof String && ((String)obj).trim().equals("")) {
            throw new App42Exception(name + " parameter can not be blank ");
        }
        if (obj instanceof Vector && ((Vector)obj).size() == 0) {
            throw new App42Exception(name + "  cannot be empty");
        }
    }

    public static void throwExceptionIfHowManyNotValid(int obj, String name) {
        if (obj > 1000) {
            throw new App42Exception(name + "  should be less then 1000");
        }
    }

    public static void throwExceptionIfNotValidImageExtension(String fileName, String name) {
        if (fileName == null) {
            throw new App42Exception(name + " parameter can not be null ");
        }
        if (fileName.indexOf(46) == -1) {
            throw new App42Exception(name + " does not contain valid extension. ");
        }
        String ext = Util.extractFileExtension(fileName);
        if (!(ext.equalsIgnoreCase("jpg") || ext.equalsIgnoreCase("jpeg") || ext.equalsIgnoreCase("gif") || ext.equalsIgnoreCase("png"))) {
            throw new IllegalArgumentException("The Request parameters are invalid. Only file with extensions jpg, jpeg, gif and png are supported");
        }
    }

    public static String extractFileExtension(String fileName) {
        String ext = fileName.substring(fileName.lastIndexOf(46) + 1, fileName.length());
        return ext;
    }

    public static boolean strToBool(String s) {
        if (s != null) {
            return s.trim().equalsIgnoreCase(TRUE);
        }
        return false;
    }

    public static Date getDateFromUTCTimeStamp(String timeStamp) {
        String year = timeStamp.substring(0, 4);
        String month = timeStamp.substring(5, 7);
        String date = timeStamp.substring(8, 10);
        String hour = timeStamp.substring(11, 13);
        String minute = timeStamp.substring(14, 16);
        String second = timeStamp.substring(17, 19);
        String ms = timeStamp.substring(20, 23);
        Calendar cal = Calendar.getInstance();
        cal.setTimeZone(TimeZone.getTimeZone("UTC"));
        cal.set(1, Integer.valueOf(year));
        cal.set(2, Integer.valueOf(month) - 1);
        cal.set(5, Integer.valueOf(date));
        cal.set(11, Integer.valueOf(hour));
        cal.set(12, Integer.valueOf(minute));
        cal.set(13, Integer.valueOf(second));
        cal.set(14, Integer.valueOf(ms));
        return cal.getTime();
    }

    public static void main(String[] args) {
        new Util();
        App42Log.debug(Util.getUTCFormattedTimestamp());
    }

    public static void throwExceptionIfNotValidExtension(String fileName) {
        if (fileName != null) {
            if (fileName.indexOf(46) == -1) {
                throw new App42Exception("File Name does not contain extension");
            }
        } else {
            throw new App42Exception(" File Name Can not be null");
        }
    }

    public static void validateMax(Integer max) {
        if (max < 1) {
            throw new App42Exception("Max must be greater than Zero.");
        }
    }

    public static void throwExceptionIfEmailNotValid(Object obj, String name) {
        if (obj == null) {
            throw new App42Exception(name + " parameter can not be null ");
        }
        String email = obj.toString();
        if (email == null || email.length() == 0 || email.indexOf("@") == -1 || email.indexOf(" ") != -1) {
            throw new App42Exception(name + " is not valid. ");
        }
        int emailLenght = email.length();
        int atPosition = email.indexOf("@");
        String beforeAt = email.substring(0, atPosition);
        String afterAt = email.substring(atPosition + 1, emailLenght);
        if (beforeAt.length() == 0 || afterAt.length() == 0) {
            throw new App42Exception(name + " is not valid. ");
        }
        if (email.charAt(atPosition - 1) == '.') {
            throw new App42Exception(name + " is not valid. ");
        }
        if (email.charAt(atPosition + 1) == '.') {
            throw new App42Exception(name + " is not valid. ");
        }
        if (afterAt.indexOf(".") == -1) {
            throw new App42Exception(name + " is not valid. ");
        }
        char dotCh = '\u0000';
        for (int i = 0; i < afterAt.length(); ++i) {
            char ch = afterAt.charAt(i);
            if (ch == '.' && ch == dotCh) {
                throw new App42Exception(name + " is not valid. ");
            }
            dotCh = ch;
        }
        if (afterAt.indexOf("@") != -1) {
            throw new App42Exception(name + " is not valid. ");
        }
        int ind = 0;
        while (true) {
            int newInd;
            if ((newInd = afterAt.indexOf(".", ind + 1)) == ind || newInd == -1) {
                String prefix = afterAt.substring(ind + 1);
                if (prefix.length() > 1 && prefix.length() < 6) break;
                throw new App42Exception(name + " is not valid. ");
            }
            ind = newInd;
        }
        dotCh = '\u0000';
        for (int i = 0; i < beforeAt.length(); ++i) {
            char ch = beforeAt.charAt(i);
            if (!(ch >= '0' && ch <= '9' || ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch == '.' || ch == '-' || ch == '_')) {
                throw new App42Exception(name + " is not valid. ");
            }
            if (ch == '.' && ch == dotCh) {
                throw new App42Exception(name + " is not valid. ");
            }
            dotCh = ch;
        }
    }
}

