/*
 * Decompiled with CFR 0.152.
 */
package game;

import component.keyMasking;
import game.CMainGameManager;
import game.gameMidlet;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class CCanvas
extends Canvas
implements Runnable {
    public static int FPS = 15;
    public static int iScreenW = 0;
    public static int iScreenH = 0;
    public static int iPlaybleW = 0;
    public static int iPressedPointerX = -1;
    public static int iPressedPointerY = -1;
    public static int iDraggedPointerX = -1;
    public static int iDraggedPointerY = -1;
    public static int iReleasedPointerX = -1;
    public static int iReleasedPointerY = -1;
    private boolean isPoinetrReleased;
    private boolean isPoinetrPressed;
    private CMainGameManager objMainGameManager;
    private static boolean isRunning = false;
    private static boolean isOnces = true;
    private static boolean isQWERTY = false;
    public static boolean isAlphaKey = false;
    public static boolean isTouchDevice = true;
    public static boolean isShowAdd = false;
    public static boolean isCallShowAdd = false;
    public static boolean isInsideAdd = false;
    public static boolean isAllowPress = true;
    Thread gameThread;
    private boolean isUpdated;
    private Image imgBuffer;
    private Graphics gBuff;
    private boolean isKeyPressed;

    public CCanvas() {
        this.setFullScreenMode(true);
        iScreenW = this.getWidth();
        iScreenH = this.getHeight();
        iPlaybleW = iScreenW == 320 && iScreenH < 250 ? 240 : (iScreenW == 640 && iScreenH < 500 ? 360 : iScreenW);
        this.objMainGameManager = new CMainGameManager();
        isRunning = false;
        this.isUpdated = false;
        this.isPoinetrReleased = false;
        this.isPoinetrPressed = false;
        this.imgBuffer = Image.createImage((int)iScreenW, (int)iScreenH);
        this.gBuff = this.imgBuffer.getGraphics();
        this.gameThread = new Thread(this);
        this.touchTypeDetection();
    }

    protected void paint(Graphics g) {
        if (!this.isUpdated) {
            return;
        }
        if (isCallShowAdd) {
            isCallShowAdd = false;
            this.showADD();
        }
        this.gBuff.setClip(0, 0, iScreenW, iScreenH);
        this.gBuff.setColor(0);
        this.gBuff.fillRect(0, 0, iScreenW, iScreenH);
        this.objMainGameManager.paint(this.gBuff);
        g.drawImage(this.imgBuffer, 0, 0, 20);
        this.isUpdated = false;
    }

    protected void keyPressed(int keyCode) {
        if (isAllowPress) {
            if (isOnces) {
                try {
                    isQWERTY = this.getKeyName(65).equalsIgnoreCase("A");
                }
                catch (Exception ex) {
                    // empty catch block
                }
                isOnces = false;
            }
            int keyState = this.getGameAction(keyCode);
            this.isKeyPressed = true;
            int iMaskedKey = keyState == 0 ? keyMasking.getInstance().adoptNumericKeyCode(keyCode) : keyMasking.getInstance().adoptArrowKeyCode(keyState);
            boolean isNumericCode = false;
            if (isQWERTY) {
                if (keyCode >= 65 && keyCode <= 122 || keyCode == 8 || keyCode == 32) {
                    iMaskedKey = keyMasking.getInstance().adoptQwertyKeyCode(keyCode);
                    this.objMainGameManager.handleInput(this.getKeyName(keyCode), this.isKeyPressed);
                    isAlphaKey = true;
                } else if (keyCode >= 48 && keyCode <= 57 || keyCode == 35 || keyCode == 42) {
                    iMaskedKey = keyMasking.getInstance().adoptNumericKeyCode(keyCode);
                    this.objMainGameManager.handleInput(iMaskedKey, this.isKeyPressed);
                    isNumericCode = true;
                }
            }
            if (!isNumericCode) {
                this.objMainGameManager.handleInput(iMaskedKey, this.isKeyPressed);
            }
        }
    }

    protected void keyReleased(int keyCode) {
        if (isAllowPress) {
            int keyState = this.getGameAction(keyCode);
            this.isKeyPressed = false;
            int iMaskedKey = keyState == 0 ? keyMasking.getInstance().adoptNumericKeyCode(keyCode) : keyMasking.getInstance().adoptArrowKeyCode(keyState);
            if (isQWERTY && keyCode >= 65 && keyCode <= 122) {
                iMaskedKey = keyMasking.getInstance().adoptQwertyKeyCode(keyCode);
            }
            this.objMainGameManager.handleInput(iMaskedKey, this.isKeyPressed);
        }
        if (!isInsideAdd) {
            isAllowPress = true;
        }
    }

    protected void pointerDragged(int x, int y) {
        if (isAllowPress) {
            iDraggedPointerX = x;
            iDraggedPointerY = y;
            this.objMainGameManager.handleTouchInput(x, y, 1);
            iReleasedPointerX = -1;
            iReleasedPointerY = -1;
        }
    }

    protected void pointerPressed(int x, int y) {
        if (isAllowPress) {
            if (!this.isPoinetrReleased) {
                this.objMainGameManager.handleTouchInput(iPressedPointerX, iPressedPointerY, 2);
                this.isPoinetrReleased = true;
            }
            iPressedPointerX = x;
            iPressedPointerY = y;
            this.objMainGameManager.handleTouchInput(x, y, 0);
            this.isPoinetrReleased = false;
            this.isPoinetrPressed = true;
        }
    }

    protected void pointerReleased(int x, int y) {
        if (isAllowPress) {
            iReleasedPointerX = x;
            iReleasedPointerY = y;
            if (this.isPoinetrPressed) {
                this.objMainGameManager.handleTouchInput(x, y, 2);
                iPressedPointerX = -1;
                iPressedPointerY = -1;
                this.isPoinetrPressed = false;
                this.isPoinetrReleased = true;
            }
            iDraggedPointerX = -1;
            iDraggedPointerY = -1;
        }
        if (!isInsideAdd) {
            isAllowPress = true;
        }
    }

    public void start() {
        isRunning = true;
        this.isUpdated = false;
        this.gameThread.start();
    }

    public void run() {
        while (isRunning) {
            long lStartTime = System.currentTimeMillis();
            this.objMainGameManager.update();
            this.isUpdated = true;
            this.repaint();
            this.serviceRepaints();
            long lEndTime = System.currentTimeMillis();
            long lDeltaTime = lEndTime - lStartTime;
            long lDelay = 30L;
            FPS = (int)(1000L / (lDeltaTime + lDelay));
            if (FPS <= 0) {
                FPS = 1;
            }
            if (lDelay <= 0L) continue;
            try {
                Thread.sleep(lDelay);
            }
            catch (Exception ex) {
                System.out.println("Error in loop:: " + ex);
            }
        }
        if (!isRunning) {
            this.objMainGameManager.unload();
            gameMidlet.getInstance().destroyApp(false);
        }
    }

    public static void exitGame() {
        isRunning = false;
    }

    public void showNotify() {
        this.objMainGameManager.gameInterrupted(false);
    }

    public void hideNotify() {
        this.objMainGameManager.gameInterrupted(true);
    }

    private void touchTypeDetection() {
        if (this.hasRepeatEvents() && this.hasPointerEvents()) {
            isTouchDevice = true;
        } else if (this.hasRepeatEvents()) {
            isTouchDevice = false;
        }
    }

    private void showADD() {
        isInsideAdd = true;
        isAllowPress = false;
        gameMidlet.getInstance().showAddVserv("mid");
    }
}

