/*
 * Decompiled with CFR 0.152.
 */
package ingame;

import component.CRectangle;
import component.CSoundPlayer;
import component.CSpriteAnimation;
import component.CUtility;
import component.gameData;
import constants.CPortingValues;
import game.CCanvas;
import ingame.CChopper;
import ingame.CCoin;
import ingame.CControlPopup;
import ingame.CFirableAmmo;
import ingame.CIngameManager;
import ingame.CIngamePopup;
import ingame.CObstacle;
import ingame.CPauseMenu;
import ingame.CPlayerBike;
import ingame.CPoliceCar;
import ingame.CPowerUps;
import ingame.CRoadCar;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class CIngameStatePlay {
    private int iLevel;
    private boolean isSoundOn;
    private int iLastLongestRun;
    private CSoundPlayer objSoundplayer;
    private CPlayerBike objPlayerBike;
    private boolean isPlayerMoveLeft;
    private boolean isPlayerMoveRight;
    private int iPanningSpeed;
    private CRectangle rectCollBike;
    private boolean isHeadStart;
    private int iHeadStartDistance;
    private boolean isSaveMeActive;
    private int iSaveTimer;
    private Image imgAamirFace;
    private Image imgSaveMe;
    private int iMaxSaveMeTime;
    private CSpriteAnimation animCoinCollector;
    private CSpriteAnimation animShield;
    private CPowerUps objPowerUps;
    private int iPowerUpDelay;
    private int iPWUpDelayCounter;
    private boolean isMagnetActive;
    private boolean isShieldActive;
    private int iMagnetTime;
    private int iShieldTime;
    private int iShieldMaxTime;
    private int iMagnetMaxTime;
    private boolean shldGnrtPowerUp;
    private Image imgMagnetStrip;
    private Image imgShieldStrip;
    private Image imgGlowPw;
    private Image imgPoliceCar;
    private CPoliceCar objPoliceCar;
    private int iPoliceCarTime;
    private Image imgLightSprite;
    private CSpriteAnimation animLight;
    private CRoadCar objRoadCar;
    private Image[] imgCars;
    private int iTotalOtherCars;
    private CObstacle objObstacle;
    private boolean isFirstCollision;
    private CSpriteAnimation animBlast;
    private Image[] imgArrObstacles;
    private Image[] imgArrHousesL;
    private Image[] imgArrHousesR;
    private final int HOUSE_NONE;
    private final int TOTAL_HOUSES;
    private final int SINGLE_TILE_HOUSE;
    private int[] iArrHouseQueL;
    private int[] iArrHouseQueR;
    private final int ROAD_NRW;
    private final int ROAD_BROAD;
    private final int ROAD_JOINT_UP;
    private final int ROAD_JOINT_DN;
    private final int LANE_1;
    private final int LANE_2;
    private final int LANE_3;
    private final int LANE_4;
    private Image[] imgArrRoads;
    private int iTileHeight;
    private int iRoadTileCount;
    private int iRoadTileFillCount;
    private int iCurRoadTile;
    private int[] iArrRoadTileQ;
    private int iRoadStartY;
    private int iDistanceCovered;
    private Image[] imgArrPatchesL;
    private Image[] imgArrPatchesR;
    private int[] iArrPatchTileQL;
    private int[] iArrPatchTileQR;
    private final int TOTAL_PATCHES;
    private final int TOTAL_SINGLE_PATCH;
    private CCoin[] objArrCoinsets;
    private int iTotalCoinSetOnScreen;
    private int iCoinCollected;
    private Image imgCoin;
    private CSpriteAnimation animCoin;
    private int iSaveMePurchaseCount;
    private CFirableAmmo objBullets;
    private Image imgPauseBtn;
    private boolean isPaused;
    private CPauseMenu objPauseMenu;
    private boolean isCtrlInfoActive;
    private boolean isCtrlInfoDone;
    private CControlPopup objControlPopup;
    private Image imgHUDLeftUp;
    private Image imgHUDLeftDn;
    private int iHudLeftHeight;
    private Image imgHUDRight;
    private Image imgHUDAmmo;
    private Image[] stripHUDFont;
    private int iHUDBlinkCounter;
    private boolean shldBlinkHUD;
    private CIngamePopup objIngamePopup;
    private Image imgNotifire;
    private boolean isShowingNotifire;
    private boolean isNotifireComing;
    private int iNotifireTimer;
    private int iNotifireY;
    private CChopper objChopper;
    private int iScore;
    private String[] strTextRows = null;
    private int iHeightSaveMe;
    int iLimit = 0;

    public CIngameStatePlay() {
        this.HOUSE_NONE = -1;
        this.TOTAL_HOUSES = 10;
        this.SINGLE_TILE_HOUSE = 4;
        this.ROAD_NRW = 0;
        this.ROAD_BROAD = 1;
        this.ROAD_JOINT_UP = 2;
        this.ROAD_JOINT_DN = 3;
        this.LANE_1 = 0;
        this.LANE_2 = 1;
        this.LANE_3 = 2;
        this.LANE_4 = 3;
        this.TOTAL_PATCHES = 13;
        this.TOTAL_SINGLE_PATCH = 3;
    }

    public void load(int loadingCounter) {
        switch (loadingCounter) {
            case 2: {
                this.iLevel = 0;
                this.iScore = 0;
                this.iSaveTimer = this.iMaxSaveMeTime = CCanvas.FPS * 3;
                this.isSaveMeActive = false;
                this.iHUDBlinkCounter = 0;
                this.shldBlinkHUD = false;
                try {
                    this.imgHUDLeftUp = Image.createImage((String)"/hud_left_01.png");
                    this.imgHUDLeftDn = Image.createImage((String)"/hud_left_02.png");
                    this.imgHUDRight = Image.createImage((String)"/hud_right.png");
                    this.iHudLeftHeight = this.imgHUDLeftUp.getHeight();
                    this.imgHUDAmmo = CIngameManager.getInstance().getCurrentBike() == 1 ? Image.createImage((String)"/hud_bullet.png") : (CIngameManager.getInstance().getCurrentBike() == 2 ? Image.createImage((String)"/hud_missiel.png") : null);
                    Image imgFontStrip = Image.createImage((String)"/hud_font.png");
                    int fontWidth = imgFontStrip.getWidth() / 10;
                    int fontHeight = imgFontStrip.getHeight();
                    this.stripHUDFont = new Image[10];
                    for (int i = 0; i < 10; ++i) {
                        this.stripHUDFont[i] = Image.createImage((Image)imgFontStrip, (int)(i * fontWidth), (int)0, (int)fontWidth, (int)fontHeight, (int)0);
                    }
                    imgFontStrip = null;
                }
                catch (Exception ex) {}
                break;
            }
            case 4: {
                this.loadBg();
                this.objChopper = new CChopper();
                this.objSoundplayer = new CSoundPlayer();
                this.objSoundplayer.loadSound(new String[]{"/sound/siren.mid", "/sound/blast.mid"});
                if (gameData.getData(4) == 0) {
                    this.isSoundOn = true;
                    break;
                }
                this.isSoundOn = false;
                break;
            }
            case 6: {
                this.loadPlayer();
                this.animBlast = new CSpriteAnimation("/car_blast.png", 4, 2, false, false);
                break;
            }
            case 8: {
                this.iPanningSpeed = 9;
                this.iCoinCollected = 0;
                this.iDistanceCovered = 0;
                this.isFirstCollision = false;
                this.iSaveMePurchaseCount = gameData.getData(16);
                this.iTotalCoinSetOnScreen = CCanvas.iScreenH / (this.iTileHeight << 1);
                this.objArrCoinsets = new CCoin[this.iTotalCoinSetOnScreen];
                this.imgArrObstacles = new Image[4];
                try {
                    this.imgCoin = Image.createImage((String)"/coin.png");
                    this.imgArrObstacles[0] = Image.createImage((String)"/traffic_cone.png");
                    this.imgArrObstacles[1] = Image.createImage((String)"/manwhole.png");
                    this.imgArrObstacles[2] = Image.createImage((String)"/barricade.png");
                    this.imgArrObstacles[3] = Image.createImage((String)"/roadblock.png");
                    this.animCoin = new CSpriteAnimation(this.imgCoin, 4, 2, false, false);
                }
                catch (Exception ex) {}
                break;
            }
            case 10: {
                for (int i = 0; i < this.iTotalCoinSetOnScreen; ++i) {
                    this.objArrCoinsets[i] = this.generateCoinSet(i << 1);
                }
                try {
                    this.imgNotifire = Image.createImage((String)"/longest_run.png");
                    this.iNotifireY = -this.imgNotifire.getHeight();
                    this.imgAamirFace = Image.createImage((String)"/popup_aamir.png");
                    this.imgSaveMe = Image.createImage((String)"/inapp_0.png");
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (this.strTextRows == null) {
                    this.strTextRows = CUtility.getTextRows("Escape immediately after being caught", CIngameManager.getInstance().objSmallFont, CCanvas.iScreenW - (CCanvas.iScreenW >> 2) - CIngameManager.getInstance().objBigFont.getHeight() * 2);
                }
                this.iHeightSaveMe = (CCanvas.iScreenH >> 1) - (this.iTileHeight / 3 + (CIngameManager.getInstance().objSmallFont.getHeight() >> 1));
                this.isNotifireComing = false;
                this.isShowingNotifire = false;
                this.iNotifireTimer = 1 * CCanvas.FPS;
                this.iLastLongestRun = gameData.getData(13);
                this.objIngamePopup = new CIngamePopup(this.imgAamirFace);
                break;
            }
            case 12: {
                this.iTotalOtherCars = 5;
                this.imgCars = new Image[this.iTotalOtherCars];
                try {
                    for (int i = 0; i < this.iTotalOtherCars - 2; ++i) {
                        this.imgCars[i] = Image.createImage((String)("/car_" + (i + 1) + ".png"));
                    }
                    this.imgPoliceCar = Image.createImage((String)"/car_police.png");
                    this.imgLightSprite = Image.createImage((String)"/police_light.png");
                    this.imgLightSprite = Image.createImage((Image)this.imgLightSprite, (int)0, (int)0, (int)this.imgLightSprite.getWidth(), (int)this.imgLightSprite.getHeight(), (int)3);
                    this.animLight = new CSpriteAnimation(this.imgLightSprite, 2, 4, false, false);
                    this.imgCars[this.iTotalOtherCars - 2] = Image.createImage((Image)this.imgPoliceCar, (int)0, (int)0, (int)this.imgPoliceCar.getWidth(), (int)this.imgPoliceCar.getHeight(), (int)3);
                    this.imgCars[this.iTotalOtherCars - 1] = Image.createImage((String)"/copbike.png");
                    this.objPoliceCar = new CPoliceCar(this.imgPoliceCar, CCanvas.iScreenW >> 1);
                }
                catch (Exception ex) {}
                break;
            }
            case 14: {
                this.iPoliceCarTime = CCanvas.FPS * 1;
                this.objBullets = new CFirableAmmo(CIngameManager.getInstance().getCurrentBike());
                break;
            }
            case 16: {
                this.objPauseMenu = new CPauseMenu();
                this.objControlPopup = new CControlPopup();
                this.isCtrlInfoActive = false;
                this.isCtrlInfoDone = gameData.getData(2) >= 3;
                this.isPaused = false;
                try {
                    this.imgPauseBtn = Image.createImage((String)"/pause_button.png");
                }
                catch (Exception ex) {
                    // empty catch block
                }
                this.isHeadStart = true;
                this.iHeadStartDistance = 400;
                this.objPlayerBike.setPlayerState(5);
                break;
            }
            case 18: {
                this.animCoinCollector = new CSpriteAnimation("/coin_collector.png", 4, 2, false, false);
                this.animShield = new CSpriteAnimation("/shield_anim.png", 4, 2, false, false);
                this.isMagnetActive = false;
                this.isShieldActive = false;
                this.iShieldMaxTime = CPortingValues.AMOUNT_SHIELD_TIME[gameData.getData(7)];
                this.iMagnetMaxTime = CPortingValues.AMOUNT_MAGNET_TIME[gameData.getData(6)];
                this.iPowerUpDelay = this.iMagnetTime > this.iShieldTime ? this.iMagnetTime >> 1 : this.iShieldTime >> 1;
                this.iPWUpDelayCounter = 0;
                try {
                    this.imgMagnetStrip = Image.createImage((String)"/magnet_strip.png");
                    this.imgShieldStrip = Image.createImage((String)"/shield_strip.png");
                    this.imgGlowPw = Image.createImage((String)"/powerup_glow.png");
                }
                catch (Exception exception) {}
                break;
            }
            case 20: {
                this.iMagnetMaxTime = CCanvas.FPS * this.iMagnetMaxTime;
                this.iShieldMaxTime = CCanvas.FPS * this.iShieldMaxTime;
                this.iMagnetTime = this.iMagnetMaxTime;
                this.iShieldTime = this.iShieldMaxTime;
            }
        }
    }

    public void playStartSound() {
        if (this.isSoundOn) {
            this.objSoundplayer.playSound(0, true);
        }
    }

    private void generatePowerUp() {
        if (this.isShieldActive || this.isMagnetActive) {
            return;
        }
        ++this.iPWUpDelayCounter;
        if (this.iPWUpDelayCounter < this.iPowerUpDelay) {
            return;
        }
        for (int i = 0; i < this.iTotalCoinSetOnScreen; ++i) {
            if (this.objArrCoinsets[i].getPosY() >= this.iRoadStartY + this.iPanningSpeed) continue;
            return;
        }
        if (this.objObstacle != null && this.objObstacle.iPosY + this.objObstacle.iHeigth <= 0) {
            return;
        }
        int iLaneIndex = CUtility.getRandomNumberInRange(0, 100) % 4;
        if (this.iArrRoadTileQ[0] != 1) {
            iLaneIndex = CUtility.getRandomNumberInRange(0, 100) % 2 + 1;
        }
        int type = CUtility.getRandomNumberInRange(0, 100) % 2;
        if (iLaneIndex == this.getCurrentLaneOfPosition(this.objPlayerBike.iPosX)) {
            iLaneIndex = iLaneIndex == 1 ? 2 : 1;
        }
        if (iLaneIndex == 3) {
            iLaneIndex = 2;
        }
        int iOffSet = CCanvas.iScreenW - CCanvas.iPlaybleW >> 1;
        this.objPowerUps = type == 0 ? new CPowerUps(type, this.imgMagnetStrip, this.imgGlowPw, (iLaneIndex + 1) * (CCanvas.iPlaybleW >> 2) + iOffSet, this.iRoadStartY) : new CPowerUps(type, this.imgShieldStrip, this.imgGlowPw, (iLaneIndex + 1) * (CCanvas.iPlaybleW >> 2) + iOffSet, this.iRoadStartY);
        this.iPWUpDelayCounter = 0;
        this.shldGnrtPowerUp = false;
    }

    private void generateObstacle() {
        int iType;
        if (this.iLevel < 15 ? this.iDistanceCovered - 400 < CPortingValues.LEVEL_UP_DIST[this.iLevel] >> 2 : this.iDistanceCovered - 400 < CPortingValues.LEVEL_UP_DIST[15] >> 2) {
            return;
        }
        for (int i = 0; i < this.iTotalCoinSetOnScreen; ++i) {
            if (this.objArrCoinsets[i].getPosY() >= this.iRoadStartY + this.iPanningSpeed) continue;
            return;
        }
        int iLaneIndex = CUtility.getRandomNumberInRange(0, 100) % 4;
        if (this.iArrRoadTileQ[0] != 1) {
            iLaneIndex = CUtility.getRandomNumberInRange(0, 100) % 2 + 1;
        }
        if ((iType = this.iLevel > 10 ? CUtility.getRandomNumberInRange(0, 100) % 4 : (this.iLevel > 5 ? CUtility.getRandomNumberInRange(0, 100) % 3 : (this.iLevel > 2 ? CUtility.getRandomNumberInRange(0, 100) % 2 : 0))) == 0) {
            iLaneIndex = this.iArrRoadTileQ[0] != 1 ? 1 : CUtility.getRandomNumberInRange(0, 100) % 3;
        } else if (this.objRoadCar != null && iLaneIndex == this.getCurrentLaneOfPosition(this.objRoadCar.iPosX)) {
            iLaneIndex = iLaneIndex == 1 ? 2 : 1;
        }
        if (iType != 0 && this.objPowerUps != null && this.objPowerUps.iY + this.objPowerUps.iHeight < 0 && iLaneIndex == this.getCurrentLaneOfPosition(this.objPowerUps.iX)) {
            if (iLaneIndex == 0 || iLaneIndex == 1) {
                this.objPowerUps.iX += CCanvas.iPlaybleW >> 2;
            } else if (iLaneIndex == 2 || iLaneIndex == 3) {
                this.objPowerUps.iX -= CCanvas.iPlaybleW >> 2;
            }
        }
        int iOffset = CCanvas.iScreenW - CCanvas.iPlaybleW >> 1;
        this.objObstacle = new CObstacle(this.imgArrObstacles[iType], iType, (iLaneIndex + 1) * (CCanvas.iPlaybleW >> 2) + iOffset, this.iRoadStartY, this.animBlast);
    }

    private void loadPlayer() {
        this.objPlayerBike = new CPlayerBike();
        this.isPlayerMoveLeft = false;
        this.isPlayerMoveRight = false;
        this.rectCollBike = new CRectangle(this.objPlayerBike.iPosX - (this.objPlayerBike.iWidth >> 1), this.objPlayerBike.iPosY - this.objPlayerBike.iHeight, this.objPlayerBike.iWidth, this.objPlayerBike.iHeight);
    }

    private CCoin generateCoinSet(int iTileIndex) {
        int coinX;
        int iLaneIndex;
        int iPattern = -1;
        int iOffset = CCanvas.iScreenW - CCanvas.iPlaybleW >> 1;
        if (this.iArrRoadTileQ[iTileIndex] == 1) {
            do {
                iLaneIndex = CUtility.getRandomNumberInRange(0, 100) % 4;
                coinX = iLaneIndex * (CCanvas.iPlaybleW >> 2) + (CCanvas.iPlaybleW >> 3) + iOffset;
            } while (this.objObstacle != null && iLaneIndex == this.getCurrentLaneOfPosition(this.objObstacle.iPosX));
        } else {
            do {
                iLaneIndex = CUtility.getRandomNumberInRange(0, 100) % 2 + 1;
                coinX = iLaneIndex * (CCanvas.iPlaybleW >> 2) + (CCanvas.iPlaybleW >> 3) + iOffset;
            } while (this.objObstacle != null && iLaneIndex == this.getCurrentLaneOfPosition(this.objObstacle.iPosX));
        }
        int coinY = iTileIndex * this.iTileHeight + this.iRoadStartY;
        do {
            int iTmp;
            if (!((iTmp = CUtility.getRandomNumberInRange(0, 100) % 7) != 3 && iTmp != 4 || iLaneIndex != 0 && iLaneIndex != 3)) {
                iPattern = -1;
                continue;
            }
            if ((iTmp == 6 || iTmp == 5) && this.iArrRoadTileQ[iTileIndex] != 1) {
                iPattern = -1;
                continue;
            }
            if (iTmp == 6 && iLaneIndex == 0) {
                iPattern = -1;
                continue;
            }
            if (iTmp == 5 && iLaneIndex == 3) {
                iPattern = -1;
                continue;
            }
            if (this.objObstacle != null) {
                if (this.objObstacle.iPosY <= -this.iTileHeight - this.iRoadStartY && (iTmp == 3 || iTmp == 4)) {
                    iPattern = -1;
                    continue;
                }
                iPattern = iTmp;
                continue;
            }
            iPattern = iTmp;
        } while (iPattern == -1);
        return new CCoin(this.imgCoin, iPattern, coinX, coinY);
    }

    private void loadBg() {
        int i;
        this.imgArrRoads = new Image[4];
        this.imgArrRoads[0] = CUtility.getFlippedRGBImageAdded("/roadnarrow.png");
        this.imgArrRoads[1] = CUtility.getFlippedRGBImageAdded("/roadbroad.png");
        this.imgArrRoads[2] = CUtility.getFlippedRGBImageAdded("/roadjoint.png");
        this.imgArrRoads[3] = Image.createImage((Image)this.imgArrRoads[2], (int)0, (int)0, (int)this.imgArrRoads[2].getWidth(), (int)this.imgArrRoads[2].getHeight(), (int)3);
        this.iTileHeight = this.imgArrRoads[0].getHeight();
        this.iCurRoadTile = 0;
        this.iRoadTileCount = CUtility.getRandomNumberInRange(2, 7);
        this.iRoadTileFillCount = CCanvas.iScreenH / this.iTileHeight + 3;
        this.iArrRoadTileQ = new int[this.iRoadTileFillCount];
        for (i = 0; i < this.iRoadTileFillCount; ++i) {
            this.iArrRoadTileQ[i] = 0;
        }
        this.iRoadStartY = -(this.iTileHeight << 1);
        this.imgArrHousesL = new Image[10];
        this.imgArrHousesR = new Image[10];
        try {
            for (i = 0; i < 10; ++i) {
                this.imgArrHousesL[i] = Image.createImage((String)("/house_" + (i + 1) + ".png"));
                this.imgArrHousesR[i] = Image.createImage((Image)this.imgArrHousesL[i], (int)0, (int)0, (int)this.imgArrHousesL[i].getWidth(), (int)this.imgArrHousesL[i].getHeight(), (int)2);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.iArrHouseQueL = new int[this.iRoadTileFillCount];
        this.iArrHouseQueR = new int[this.iRoadTileFillCount];
        this.iArrPatchTileQL = new int[this.iRoadTileFillCount];
        this.iArrPatchTileQR = new int[this.iRoadTileFillCount];
        try {
            this.imgArrPatchesL = new Image[13];
            this.imgArrPatchesR = new Image[13];
            for (int i2 = 0; i2 < 10; ++i2) {
                this.imgArrPatchesL[i2] = Image.createImage((String)("/house_" + (i2 + 1) + "_top.png"));
                this.imgArrPatchesR[i2] = Image.createImage((Image)this.imgArrPatchesL[i2], (int)0, (int)0, (int)this.imgArrPatchesL[i2].getWidth(), (int)this.imgArrPatchesL[i2].getHeight(), (int)2);
            }
            this.imgArrPatchesL[10] = Image.createImage((String)"/roadjoint_top.png");
            this.imgArrPatchesR[10] = Image.createImage((Image)this.imgArrPatchesL[10], (int)0, (int)0, (int)this.imgArrPatchesL[10].getWidth(), (int)this.imgArrPatchesL[10].getHeight(), (int)2);
            this.imgArrPatchesL[11] = Image.createImage((String)"/roadjoint_top.png");
            this.imgArrPatchesL[11] = Image.createImage((Image)this.imgArrPatchesL[11], (int)0, (int)0, (int)this.imgArrPatchesL[11].getWidth(), (int)this.imgArrPatchesL[11].getHeight(), (int)1);
            this.imgArrPatchesR[11] = Image.createImage((Image)this.imgArrPatchesL[11], (int)0, (int)0, (int)this.imgArrPatchesL[11].getWidth(), (int)this.imgArrPatchesL[11].getHeight(), (int)2);
            this.imgArrPatchesL[12] = Image.createImage((String)"/roadbroad_top.png");
            this.imgArrPatchesR[12] = Image.createImage((Image)this.imgArrPatchesL[12], (int)0, (int)0, (int)this.imgArrPatchesL[12].getWidth(), (int)this.imgArrPatchesL[12].getHeight(), (int)2);
        }
        catch (Exception ex) {
            // empty catch block
        }
        for (int i3 = 0; i3 < this.iRoadTileFillCount; ++i3) {
            if (this.iArrRoadTileQ[i3] == 0) {
                do {
                    this.iArrHouseQueL[i3] = CUtility.getRandomNumberInRange(0, 50) % 4;
                } while (i3 > 0 && this.iArrHouseQueL[i3] == this.iArrHouseQueL[i3 - 1]);
                do {
                    this.iArrHouseQueR[i3] = CUtility.getRandomNumberInRange(0, 25) % 4;
                } while (this.iArrHouseQueR[i3] == this.iArrHouseQueL[i3]);
                this.iArrPatchTileQL[i3] = this.iArrHouseQueL[i3];
                this.iArrPatchTileQR[i3] = this.iArrHouseQueR[i3];
                continue;
            }
            this.iArrHouseQueL[i3] = -1;
            this.iArrHouseQueR[i3] = -1;
            if (this.iArrRoadTileQ[i3] == 1) {
                this.iArrPatchTileQL[i3] = 12;
                this.iArrPatchTileQR[i3] = 12;
                continue;
            }
            if (this.iArrRoadTileQ[i3] == 2) {
                this.iArrPatchTileQL[i3] = 11;
                this.iArrPatchTileQR[i3] = 11;
                continue;
            }
            this.iArrPatchTileQL[i3] = 10;
            this.iArrPatchTileQR[i3] = 10;
        }
    }

    private void generateRoadCar() {
        if (this.iLevel < 15 ? this.iDistanceCovered - 400 < CPortingValues.LEVEL_UP_DIST[this.iLevel] >> 1 : this.iDistanceCovered - 400 < CPortingValues.LEVEL_UP_DIST[15] >> 1) {
            return;
        }
        int iLaneIndex = this.getCurrentLaneOfPosition(this.objPlayerBike.iPosX - 1) - CUtility.getRandomNumberInRange(0, 100) % 2;
        if (iLaneIndex == 0) {
            iLaneIndex = 1;
        } else if (iLaneIndex == 3) {
            iLaneIndex = 2;
        }
        if (this.objObstacle != null && iLaneIndex == this.getCurrentLaneOfPosition(this.objObstacle.iPosX)) {
            if (iLaneIndex == 0) {
                iLaneIndex = 1;
            } else if (iLaneIndex == 1) {
                iLaneIndex = 2;
            } else if (iLaneIndex == 2) {
                iLaneIndex = 1;
            }
        }
        int iTileType = this.getCurrentTileType(-this.iTileHeight);
        int iOffset = CCanvas.iScreenW - CCanvas.iPlaybleW >> 1;
        int iPosX = iLaneIndex * (CCanvas.iPlaybleW >> 2) + (CCanvas.iPlaybleW >> 3) + iOffset;
        if (iTileType != 1) {
            iPosX = iLaneIndex > 1 ? 2 * (CCanvas.iPlaybleW >> 2) + (CCanvas.iPlaybleW >> 3) + iOffset : 1 * (CCanvas.iPlaybleW >> 2) + (CCanvas.iPlaybleW >> 3) + iOffset;
        }
        int iCarIndex = 0;
        iCarIndex = this.iLevel < 5 ? CUtility.getRandomNumberInRange(0, 100) % (this.iTotalOtherCars - 3) : (this.iLevel < 10 || this.objRoadCar != null && this.objRoadCar.isCopCar() ? CUtility.getRandomNumberInRange(0, 100) % (this.iTotalOtherCars - 2) : CUtility.getRandomNumberInRange(0, 100) % this.iTotalOtherCars);
        if (this.objRoadCar != null) {
            this.objRoadCar.unload();
            this.objRoadCar = null;
        }
        this.objRoadCar = new CRoadCar(iCarIndex, this.imgCars[iCarIndex], iPosX, -(this.iTileHeight << 1), this.iPanningSpeed >> 1, this.animBlast, this.animLight);
    }

    public void unload() {
        int i;
        this.iArrRoadTileQ = null;
        this.imgArrRoads = null;
        this.imgArrHousesR = null;
        this.imgArrHousesL = null;
        this.iArrHouseQueL = null;
        this.iArrHouseQueR = null;
        this.imgArrPatchesL = null;
        this.imgArrPatchesR = null;
        this.iArrPatchTileQL = null;
        this.iArrPatchTileQR = null;
        for (i = 0; i < this.iTotalOtherCars; ++i) {
            this.imgCars[i] = null;
        }
        this.imgCars = null;
        this.imgPoliceCar = null;
        if (this.objArrCoinsets != null) {
            for (i = 0; i < this.objArrCoinsets.length; ++i) {
                this.objArrCoinsets[i] = null;
            }
            this.objArrCoinsets = null;
        }
        this.objBullets = null;
        if (this.objObstacle != null) {
            this.objObstacle.unload();
        }
        this.objObstacle = null;
        if (this.objPauseMenu != null) {
            this.objPauseMenu.unload();
        }
        this.objPauseMenu = null;
        if (this.objControlPopup != null) {
            this.objControlPopup.unload();
        }
        this.objControlPopup = null;
        if (this.objPlayerBike != null) {
            this.objPlayerBike.unload();
        }
        this.objPlayerBike = null;
        if (this.objPoliceCar != null) {
            this.objPoliceCar.unload();
        }
        this.objPoliceCar = null;
        if (this.objRoadCar != null) {
            this.objRoadCar.unload();
        }
        this.objRoadCar = null;
        if (this.objSoundplayer != null) {
            this.objSoundplayer.unloadSound();
        }
        this.imgNotifire = null;
        this.objSoundplayer = null;
        this.imgSaveMe = null;
    }

    public void update() {
        if (this.isPaused || this.isCtrlInfoActive) {
            return;
        }
        if (!this.objPlayerBike.isPlayerFalling) {
            this.updateBg();
            if (this.isHeadStart) {
                this.iDistanceCovered += this.iPanningSpeed >> 1;
                this.iHeadStartDistance -= this.iPanningSpeed >> 1;
                this.iScore = this.iDistanceCovered;
                if (!this.isCtrlInfoDone && this.iDistanceCovered >= 50) {
                    this.isCtrlInfoActive = true;
                    this.isCtrlInfoDone = true;
                    this.objPlayerBike.setPlayerState(5);
                } else if (this.iHeadStartDistance <= 0) {
                    System.out.println("Headstart ends here ...");
                    this.isHeadStart = false;
                    this.objPlayerBike.setPlayerState(0);
                    if (this.objBullets.getType() != 0 && this.iDistanceCovered <= 400 + this.iPanningSpeed) {
                        this.objIngamePopup.show(true);
                    }
                }
            } else {
                this.iDistanceCovered += this.iPanningSpeed >> 1;
                this.iScore = this.iDistanceCovered;
                if (this.iLevel < 15) {
                    if (this.iDistanceCovered % CPortingValues.LEVEL_UP_DIST[this.iLevel] >= 0 && this.iDistanceCovered % CPortingValues.LEVEL_UP_DIST[this.iLevel] < this.iPanningSpeed) {
                        this.shldGnrtPowerUp = true;
                        this.generatePowerUp();
                    }
                } else if (this.iDistanceCovered % CPortingValues.LEVEL_UP_DIST[15] >= 0 && this.iDistanceCovered % CPortingValues.LEVEL_UP_DIST[15] < this.iPanningSpeed) {
                    this.shldGnrtPowerUp = true;
                    this.generatePowerUp();
                }
                if (this.iLevel < 15) {
                    if (this.iDistanceCovered >= CPortingValues.LEVEL_UP_DIST[this.iLevel]) {
                        if (this.iPanningSpeed < 18 && (this.iLevel > 0 && this.iLevel <= 4 || this.iLevel == 11 || this.iLevel == 15)) {
                            ++this.iPanningSpeed;
                        }
                        ++this.iLevel;
                        this.objChopper.show();
                    }
                } else if (this.iDistanceCovered >= CPortingValues.LEVEL_UP_DIST[15] + (this.iLevel - 16 - 1) * 5000) {
                    if (this.iPanningSpeed < 18 && this.iLevel >= 16) {
                        ++this.iPanningSpeed;
                    }
                    ++this.iLevel;
                    this.objChopper.show();
                }
                if (this.iLastLongestRun > this.iDistanceCovered && this.iLastLongestRun <= this.iDistanceCovered + this.iPanningSpeed) {
                    this.isShowingNotifire = true;
                    this.isNotifireComing = true;
                }
            }
            if (!this.isHeadStart && this.objObstacle == null && this.iDistanceCovered % 400 <= this.iPanningSpeed) {
                this.generateObstacle();
            }
            this.objPlayerBike.update();
        } else if (!this.objPlayerBike.isAnimEnd()) {
            this.objPlayerBike.update();
        }
        this.objBullets.update(this.iPanningSpeed);
        if (this.isShowingNotifire) {
            if (this.isNotifireComing && this.iNotifireY < 0) {
                this.iNotifireY += 2;
            } else if (this.isNotifireComing && this.iNotifireY >= 0) {
                --this.iNotifireTimer;
                if (this.iNotifireTimer <= 0) {
                    this.isNotifireComing = false;
                }
            } else if (this.iNotifireY > -this.imgNotifire.getHeight()) {
                this.iNotifireY -= 2;
            } else {
                this.isShowingNotifire = false;
            }
        }
        if (!this.objPlayerBike.isPlayerFalling) {
            if (!(!this.isPlayerMoveLeft || this.objPlayerBike.iPosX - this.objPlayerBike.iBikeLRSpeed - (this.objPlayerBike.iWidth >> 2) <= this.getLeftCollitionOfTile(this.getCurrentTileType(this.objPlayerBike.iPosY - (this.objPlayerBike.iHeight >> 1))) || this.objRoadCar != null && this.isSideCollideWithCar() && this.objPlayerBike.iPosX - this.objPlayerBike.iBikeLRSpeed - (this.objPlayerBike.iWidth >> 2) >= this.objRoadCar.iPosX - (this.objRoadCar.iWidth >> 1) || this.objObstacle != null && this.isSideCollideWithObstacle() && this.objPlayerBike.iPosX - this.objPlayerBike.iBikeLRSpeed - (this.objPlayerBike.iWidth >> 1) >= this.objObstacle.iPosX)) {
                this.objPlayerBike.iPosX -= this.objPlayerBike.iBikeLRSpeed;
            } else if (!(!this.isPlayerMoveRight || this.objPlayerBike.iPosX + this.objPlayerBike.iBikeLRSpeed + (this.objPlayerBike.iWidth >> 2) >= this.getRightCollitionOfTile(this.getCurrentTileType(this.objPlayerBike.iPosY - (this.objPlayerBike.iHeight >> 1))) || this.objRoadCar != null && this.isSideCollideWithCar() && this.objPlayerBike.iPosX + this.objPlayerBike.iBikeLRSpeed + (this.objPlayerBike.iWidth >> 2) <= this.objRoadCar.iPosX + (this.objRoadCar.iWidth >> 1) || this.objObstacle != null && this.isSideCollideWithObstacle() && this.objPlayerBike.iPosX + this.objPlayerBike.iBikeLRSpeed + (this.objPlayerBike.iWidth >> 1) <= this.objObstacle.iPosX + this.objObstacle.iWidth)) {
                this.objPlayerBike.iPosX += this.objPlayerBike.iBikeLRSpeed;
            }
            if (this.isPlayerMoveLeft && this.objPlayerBike.iPosX - this.objPlayerBike.iBikeLRSpeed - (this.objPlayerBike.iWidth >> 2) <= this.getLeftCollitionOfTile(this.getCurrentTileType(this.objPlayerBike.iPosY - (this.objPlayerBike.iHeight >> 1)))) {
                this.isPlayerMoveLeft = false;
                if (this.isHeadStart) {
                    this.objPlayerBike.setPlayerState(5);
                } else {
                    this.objPlayerBike.setPlayerState(0);
                }
            } else if (this.isPlayerMoveRight && this.objPlayerBike.iPosX + this.objPlayerBike.iBikeLRSpeed + (this.objPlayerBike.iWidth >> 2) >= this.getRightCollitionOfTile(this.getCurrentTileType(this.objPlayerBike.iPosY - (this.objPlayerBike.iHeight >> 1)))) {
                this.isPlayerMoveRight = false;
                if (this.isHeadStart) {
                    this.objPlayerBike.setPlayerState(5);
                } else {
                    this.objPlayerBike.setPlayerState(0);
                }
            }
            if (this.isFrontCollideWithRoad()) {
                if (this.getCurrentLaneOfPosition(this.objPlayerBike.iPosX) <= 1) {
                    this.objPlayerBike.setPlayerState(3);
                } else {
                    this.objPlayerBike.setPlayerState(4);
                }
                this.objPlayerBike.isPlayerFalling = true;
                this.objPoliceCar.capturePlayer(this.objPlayerBike.iPosY);
                if (this.isShieldActive) {
                    this.isShieldActive = false;
                    this.iShieldTime = this.iShieldMaxTime;
                }
                if (this.isMagnetActive) {
                    this.isMagnetActive = false;
                    this.iMagnetTime = this.iMagnetMaxTime;
                }
                if (this.isSoundOn) {
                    this.objSoundplayer.playSound(0, true);
                }
            } else if (!this.isHeadStart && this.isFrontCollideWithCar() && !this.isShieldActive) {
                this.objRoadCar.isCollided = true;
                if (this.getCurrentLaneOfPosition(this.objPlayerBike.iPosX) <= 1) {
                    this.objPlayerBike.setPlayerState(3);
                } else {
                    this.objPlayerBike.setPlayerState(4);
                }
                this.objPlayerBike.isPlayerFalling = true;
                this.objPoliceCar.capturePlayer(this.objPlayerBike.iPosY);
                if (this.isMagnetActive) {
                    this.isMagnetActive = false;
                    this.iMagnetTime = this.iMagnetMaxTime;
                }
                if (this.isSoundOn) {
                    this.objSoundplayer.playSound(0, true);
                }
            } else if (!this.isHeadStart && this.isFrontCollideWithObstacle() && !this.isShieldActive) {
                if (this.objObstacle.checkTerminatingObstacle() || this.objPlayerBike.shouldFall && this.isFirstCollision) {
                    if (this.getCurrentLaneOfPosition(this.objPlayerBike.iPosX) <= 1) {
                        this.objPlayerBike.setPlayerState(3);
                    } else {
                        this.objPlayerBike.setPlayerState(4);
                    }
                    this.objPlayerBike.isPlayerFalling = true;
                    this.objPoliceCar.capturePlayer(this.objPlayerBike.iPosY);
                    if (this.isMagnetActive) {
                        this.isMagnetActive = false;
                        this.iMagnetTime = this.iMagnetMaxTime;
                    }
                    if (this.isSoundOn) {
                        this.objSoundplayer.playSound(0, true);
                    }
                    this.isFirstCollision = false;
                    this.objPlayerBike.shouldFall = false;
                } else if (!this.objPlayerBike.shouldFall && !this.isFirstCollision) {
                    this.objPlayerBike.shouldFall = true;
                    this.isFirstCollision = true;
                    this.iPoliceCarTime = CCanvas.FPS * 3;
                    this.objPoliceCar.show(this.objPlayerBike.iPosX);
                    this.objPlayerBike.setPlayerState(6);
                    this.objIngamePopup.show(false);
                    if (this.isSoundOn) {
                        this.objSoundplayer.playSound(0, true);
                    }
                }
            }
        } else if (!this.isSaveMeActive && this.objPlayerBike.isAnimEnd() && this.objPoliceCar.isCaptured()) {
            if (this.isSoundOn) {
                this.objSoundplayer.stopSound(0);
            }
            if (this.iSaveMePurchaseCount <= 0) {
                CIngameManager.getInstance().setRidingData(this.iScore + this.iCoinCollected * 20, this.iCoinCollected, this.iDistanceCovered, this.objBullets.iAmmoCount);
                CIngameManager.getInstance().switchToStates(1);
                return;
            }
            this.isSaveMeActive = true;
        } else if (this.isSaveMeActive) {
            --this.iSaveTimer;
            this.animCoin.update();
            if (this.iSaveTimer == 0) {
                this.isSaveMeActive = false;
                this.iSaveTimer = this.iMaxSaveMeTime = CCanvas.FPS * 3;
                CIngameManager.getInstance().setRidingData(this.iScore + this.iCoinCollected * 20, this.iCoinCollected, this.iDistanceCovered, this.objBullets.iAmmoCount);
                CIngameManager.getInstance().switchToStates(1);
                return;
            }
        }
        this.objPoliceCar.update(this.objPlayerBike.iPosX, this.objPlayerBike.iBikeLRSpeed);
        if (this.objPoliceCar.checkChasingPlayer()) {
            --this.iPoliceCarTime;
            if (this.iPoliceCarTime == 0) {
                if (this.isSoundOn) {
                    this.objSoundplayer.stopSound(0);
                }
                this.objPoliceCar.hide();
                this.objPlayerBike.shouldFall = false;
                this.isFirstCollision = false;
                this.iPoliceCarTime = CCanvas.FPS * 3;
                if (!this.isHeadStart) {
                    this.objPlayerBike.setPlayerState(0);
                }
            }
        } else if (!this.objPoliceCar.isVisible()) {
            this.objPlayerBike.shouldFall = false;
            this.isFirstCollision = false;
        }
        if (this.objRoadCar != null) {
            if (!this.objPlayerBike.isPlayerFalling) {
                if (!this.objRoadCar.update(this.iPanningSpeed)) {
                    this.generateRoadCar();
                } else if (!this.objRoadCar.checkDestroying() && !this.objRoadCar.checkDestroyed()) {
                    if (this.objBullets.checkBulletColl(this.objRoadCar.iPosX - (this.objRoadCar.iWidth >> 1), this.objRoadCar.iPosY, this.objRoadCar.iWidth, this.objRoadCar.iHeigth) && !this.objRoadCar.decreaseHealth(this.objBullets.iDamage)) {
                        this.iScore += 200;
                        if (this.isSoundOn) {
                            this.objSoundplayer.playSound(1, false);
                        }
                    }
                } else if (this.objRoadCar.checkDestroyed()) {
                    this.generateRoadCar();
                }
            } else {
                this.objRoadCar.update(0);
            }
        } else {
            this.generateRoadCar();
        }
        if (this.objObstacle != null) {
            if (!this.objPlayerBike.isPlayerFalling) {
                if (!this.objObstacle.update(this.iPanningSpeed)) {
                    this.generateObstacle();
                } else if (!(this.objObstacle.checkDestroying() || this.objObstacle.getType() != 2 && this.objObstacle.getType() != 0 || !this.objBullets.checkBulletColl(this.objObstacle.iPosX, this.objObstacle.iPosY, this.objObstacle.iWidth, this.objObstacle.iHeigth << 1) || this.objObstacle.decreaseHealth(this.objBullets.iDamage))) {
                    if (this.isSoundOn) {
                        this.objSoundplayer.playSound(1, false);
                    }
                    this.iScore += 100;
                } else if (this.objObstacle.checkDestroyed()) {
                    this.generateObstacle();
                }
            } else {
                this.objObstacle.update(0);
            }
        } else if (!this.isHeadStart) {
            this.generateObstacle();
        }
        if (this.objPowerUps != null) {
            if (!this.objPlayerBike.isPlayerFalling) {
                if (this.objPowerUps.update(this.iPanningSpeed) && this.objPowerUps.isCollected(this.objPlayerBike.iPosX - (this.objPlayerBike.iWidth >> 1), this.objPlayerBike.iPosY - this.objPlayerBike.iHeight, this.objPlayerBike.iWidth, this.objPlayerBike.iHeight)) {
                    if (this.objPowerUps.getType() == 0) {
                        this.isMagnetActive = true;
                    } else {
                        this.isShieldActive = true;
                    }
                    this.objPowerUps = null;
                } else if (this.objPowerUps.iY > CCanvas.iScreenH) {
                    this.objPowerUps = null;
                    this.shldGnrtPowerUp = false;
                }
            } else {
                this.objPowerUps.update(0);
            }
        } else if (this.shldGnrtPowerUp) {
            this.generatePowerUp();
        }
        if (this.isMagnetActive) {
            --this.iMagnetTime;
            this.animCoinCollector.update();
            if (this.iMagnetTime <= 0) {
                this.iMagnetTime = this.iMagnetMaxTime;
                this.isMagnetActive = false;
            }
        }
        if (this.isShieldActive) {
            --this.iShieldTime;
            this.animShield.update();
            if (this.iShieldTime <= 0) {
                this.iShieldTime = this.iShieldMaxTime;
                this.isShieldActive = false;
            }
        }
        if (!this.objPlayerBike.isPlayerFalling) {
            int i;
            if (this.isMagnetActive) {
                for (i = 0; i < this.iTotalCoinSetOnScreen; ++i) {
                    this.objArrCoinsets[i].attractCoin(this.objPlayerBike.iPosX, this.iPanningSpeed, this.objPlayerBike.iPosY - this.objPlayerBike.iHeight);
                }
                this.rectCollBike.iX = this.objPlayerBike.iPosX - (this.objPlayerBike.iWidth >> 1);
                this.rectCollBike.iY = this.objPlayerBike.iPosY - this.objPlayerBike.iHeight + 2;
                this.rectCollBike.iW = this.objPlayerBike.iWidth;
            } else {
                this.rectCollBike.iX = this.objPlayerBike.iPosX - (this.objPlayerBike.iWidth >> 1);
                this.rectCollBike.iY = this.objPlayerBike.iPosY - this.objPlayerBike.iHeight + 2;
                this.rectCollBike.iW = this.objPlayerBike.iWidth;
            }
            for (i = 0; i < this.iTotalCoinSetOnScreen; ++i) {
                this.objArrCoinsets[i].update(this.iPanningSpeed);
                this.iCoinCollected += this.objArrCoinsets[i].getCollisionCount(this.rectCollBike);
            }
            for (i = 0; i < this.iTotalCoinSetOnScreen; ++i) {
                if (this.objArrCoinsets[i].getPosY() <= CCanvas.iScreenH) continue;
                this.objArrCoinsets = this.updateCoinSets(this.objArrCoinsets);
                this.objArrCoinsets[0] = this.generateCoinSet(0);
                break;
            }
        }
        this.objChopper.update();
        this.objIngamePopup.update();
        if (this.shldBlinkHUD) {
            ++this.iHUDBlinkCounter;
            this.iHUDBlinkCounter %= 500;
            if (this.iHUDBlinkCounter >= CCanvas.FPS) {
                this.shldBlinkHUD = false;
            }
        }
    }

    private void updateBg() {
        if (this.iRoadStartY >= -this.iTileHeight) {
            this.iRoadStartY -= this.iTileHeight;
            --this.iRoadTileCount;
            if (this.iRoadTileCount == 1) {
                this.iArrRoadTileQ = this.getUpdatedQueue(this.iArrRoadTileQ);
                if (this.iCurRoadTile == 0) {
                    this.iCurRoadTile = 1;
                    this.iArrRoadTileQ[0] = 2;
                } else {
                    this.iCurRoadTile = 0;
                    this.iArrRoadTileQ[0] = 3;
                }
                this.iRoadTileCount = CUtility.getRandomNumberInRange(5, 15);
                this.iArrHouseQueL = this.getUpdatedQueue(this.iArrHouseQueL);
                this.iArrHouseQueR = this.getUpdatedQueue(this.iArrHouseQueR);
                this.iArrPatchTileQL = this.getUpdatedQueue(this.iArrPatchTileQL);
                this.iArrPatchTileQR = this.getUpdatedQueue(this.iArrPatchTileQR);
                if (this.iArrRoadTileQ[0] == 0) {
                    do {
                        this.iArrHouseQueL[0] = CUtility.getRandomNumberInRange(0, 100) % 4;
                    } while (this.iArrHouseQueL[0] == this.iArrHouseQueL[1]);
                    do {
                        this.iArrHouseQueR[0] = CUtility.getRandomNumberInRange(0, 25) % 4;
                    } while (this.iArrHouseQueR[0] == this.iArrHouseQueL[0]);
                    this.iArrPatchTileQL[0] = this.iArrHouseQueL[0];
                    this.iArrPatchTileQR[0] = this.iArrHouseQueR[0];
                } else {
                    this.iArrHouseQueL[0] = -1;
                    this.iArrHouseQueR[0] = -1;
                    if (this.iArrRoadTileQ[0] == 1) {
                        this.iArrPatchTileQL[0] = 12;
                        this.iArrPatchTileQR[0] = 12;
                    } else if (this.iArrRoadTileQ[0] == 2) {
                        this.iArrPatchTileQL[0] = 11;
                        this.iArrPatchTileQR[0] = 11;
                    } else {
                        this.iArrPatchTileQL[0] = 10;
                        this.iArrPatchTileQR[0] = 10;
                    }
                }
            } else {
                this.iArrRoadTileQ = this.getUpdatedQueue(this.iArrRoadTileQ);
                this.iArrHouseQueL = this.getUpdatedQueue(this.iArrHouseQueL);
                this.iArrHouseQueR = this.getUpdatedQueue(this.iArrHouseQueR);
                this.iArrPatchTileQL = this.getUpdatedQueue(this.iArrPatchTileQL);
                this.iArrPatchTileQR = this.getUpdatedQueue(this.iArrPatchTileQR);
                this.iArrRoadTileQ[0] = this.iCurRoadTile;
                if (this.iCurRoadTile == 0) {
                    if (this.iRoadTileCount > 2) {
                        if (this.iArrHouseQueL[1] >= 4 && this.iArrHouseQueL[1] % 2 == 0) {
                            this.iArrHouseQueL[0] = this.iArrHouseQueL[1] + 1;
                        } else {
                            this.iArrHouseQueL[0] = CUtility.getRandomNumberInRange(0, 100) % 10;
                            if (this.iArrHouseQueL[0] >= 4 && this.iArrHouseQueL[0] % 2 != 0) {
                                this.iArrHouseQueL[0] = this.iArrHouseQueL[0] - 1;
                            }
                        }
                    } else {
                        this.iArrHouseQueL[0] = this.iArrHouseQueL[1] >= 4 && this.iArrHouseQueL[1] % 2 == 0 ? this.iArrHouseQueL[1] + 1 : CUtility.getRandomNumberInRange(0, 100) % 4;
                    }
                    if (this.iRoadTileCount > 2) {
                        if (this.iArrHouseQueR[1] >= 4 && this.iArrHouseQueR[1] % 2 == 0) {
                            this.iArrHouseQueR[0] = this.iArrHouseQueR[1] + 1;
                        } else {
                            do {
                                this.iArrHouseQueR[0] = CUtility.getRandomNumberInRange(0, 50) % 10;
                            } while (this.iArrHouseQueR[0] == this.iArrHouseQueL[0]);
                            if (this.iArrHouseQueR[0] >= 4 && this.iArrHouseQueR[0] % 2 != 0) {
                                this.iArrHouseQueR[0] = this.iArrHouseQueR[0] - 1;
                            }
                        }
                    } else {
                        this.iArrHouseQueR[0] = this.iArrHouseQueR[1] >= 4 && this.iArrHouseQueR[1] % 2 == 0 ? this.iArrHouseQueR[1] + 1 : CUtility.getRandomNumberInRange(0, 100) % 4;
                    }
                    this.iArrPatchTileQL[0] = this.iArrHouseQueL[0];
                    this.iArrPatchTileQR[0] = this.iArrHouseQueR[0];
                } else {
                    this.iArrHouseQueL[0] = -1;
                    this.iArrHouseQueR[0] = -1;
                    if (this.iArrRoadTileQ[0] == 1) {
                        this.iArrPatchTileQL[0] = 12;
                        this.iArrPatchTileQR[0] = 12;
                    } else if (this.iArrRoadTileQ[0] == 2) {
                        this.iArrPatchTileQL[0] = 11;
                        this.iArrPatchTileQR[0] = 11;
                    } else {
                        this.iArrPatchTileQL[0] = 10;
                        this.iArrPatchTileQR[0] = 10;
                    }
                }
            }
        }
        this.iRoadStartY += this.iPanningSpeed;
    }

    private CCoin[] updateCoinSets(CCoin[] objCurSet) {
        int iLen = objCurSet.length;
        for (int i = iLen - 1; i > 0; --i) {
            objCurSet[i] = objCurSet[i - 1];
        }
        return objCurSet;
    }

    int[] getUpdatedQueue(int[] data) {
        int ilen = data.length;
        int[] iArrProcessData = new int[ilen];
        for (int i = 0; i < ilen - 1; ++i) {
            iArrProcessData[i + 1] = data[i];
        }
        return iArrProcessData;
    }

    public void paint(Graphics g) {
        int i;
        int iOffSet = CCanvas.iScreenW - CCanvas.iPlaybleW >> 1;
        for (i = 0; i < this.iRoadTileFillCount; ++i) {
            g.drawImage(this.imgArrPatchesL[this.iArrPatchTileQL[i]], iOffSet, this.iRoadStartY + i * this.iTileHeight, 24);
            g.drawImage(this.imgArrPatchesR[this.iArrPatchTileQR[i]], CCanvas.iPlaybleW + iOffSet, this.iRoadStartY + i * this.iTileHeight, 20);
            g.drawImage(this.imgArrRoads[this.iArrRoadTileQ[i]], (CCanvas.iPlaybleW >> 1) + iOffSet, this.iRoadStartY + i * this.iTileHeight, 17);
            if (this.iArrHouseQueL[i] == -1) continue;
            g.drawImage(this.imgArrHousesL[this.iArrHouseQueL[i]], iOffSet, this.iRoadStartY + i * this.iTileHeight, 20);
            g.drawImage(this.imgArrHousesR[this.iArrHouseQueR[i]], CCanvas.iPlaybleW + iOffSet - (CCanvas.iPlaybleW >> 2), this.iRoadStartY + i * this.iTileHeight, 20);
        }
        if (this.objObstacle != null) {
            this.objObstacle.paint(g);
        }
        for (i = 0; i < this.iTotalCoinSetOnScreen; ++i) {
            this.objArrCoinsets[i].paint(g);
        }
        if (this.objPowerUps != null && !this.isMagnetActive && !this.isShieldActive) {
            this.objPowerUps.paint(g);
        }
        if (this.objPoliceCar != null) {
            this.objPoliceCar.paint(g);
        }
        if (this.objRoadCar != null) {
            this.objRoadCar.paint(g);
        }
        if (this.isMagnetActive && (this.iMagnetTime >= CCanvas.FPS || this.iMagnetTime % 3 != 0)) {
            this.animCoinCollector.paint(g, this.objPlayerBike.iPosX, this.objPlayerBike.iPosY - this.objPlayerBike.iHeight + (this.objPlayerBike.iHeight >> 2), 3);
        }
        if (this.isShieldActive && (this.iShieldTime >= CCanvas.FPS || this.iShieldTime % 3 != 0)) {
            this.animShield.paint(g, this.objPlayerBike.iPosX, this.objPlayerBike.iPosY, 33);
        }
        this.objPlayerBike.paint(g);
        this.objBullets.paint(g);
        this.objChopper.paint(g);
        if (this.isShowingNotifire) {
            g.drawImage(this.imgNotifire, 80, this.iNotifireY, 20);
        }
        this.drawHUD(g);
        this.objIngamePopup.paint(g);
        if (this.isCtrlInfoActive) {
            this.objControlPopup.paint(g);
        } else if (this.isPaused) {
            this.objPauseMenu.paint(g);
        } else if (this.isSaveMeActive) {
            int iCostStrW = this.animCoin.getCurFrameWidth() + (this.animCoin.getCurFrameWidth() >> 1);
            g.setColor(0x2A2A2A);
            g.fillRoundRect(CCanvas.iScreenW >> 3, (CCanvas.iScreenH >> 1) - (this.iTileHeight >> 1), CCanvas.iScreenW - (CCanvas.iScreenW >> 2), this.iTileHeight + (this.iTileHeight >> 2), 15, 15);
            g.setColor(0xFFFFFF);
            g.drawRoundRect(CCanvas.iScreenW >> 3, (CCanvas.iScreenH >> 1) - (this.iTileHeight >> 1), CCanvas.iScreenW - (CCanvas.iScreenW >> 2), this.iTileHeight + (this.iTileHeight >> 2), 15, 15);
            g.drawImage(this.imgAamirFace, CCanvas.iScreenW >> 3, (CCanvas.iScreenH >> 1) - (this.iTileHeight >> 1), 3);
            int iImgStrWidth = this.imgSaveMe.getWidth() + CIngameManager.getInstance().objBigFont.stringWidth(" X " + this.iSaveMePurchaseCount);
            g.drawImage(this.imgSaveMe, (CCanvas.iScreenW >> 1) - (iImgStrWidth >> 1), this.iHeightSaveMe, 20);
            CIngameManager.getInstance().objBigFont.drawString(" X " + this.iSaveMePurchaseCount, (CCanvas.iScreenW >> 1) - (iImgStrWidth >> 1) + this.imgSaveMe.getWidth(), this.iHeightSaveMe + (this.imgSaveMe.getHeight() >> 1), g, 6);
            for (int i2 = 0; i2 < this.strTextRows.length; ++i2) {
                CIngameManager.getInstance().objSmallFont.drawString(this.strTextRows[i2], CCanvas.iScreenW >> 1, CIngameManager.getInstance().objSmallFont.getHeight() * i2 + (this.iHeightSaveMe + this.imgSaveMe.getHeight() + CIngameManager.getInstance().objSmallFont.getHeight()), g, 3);
            }
            this.paintTimeBar(g, this.iSaveTimer);
        } else {
            g.drawImage(this.imgPauseBtn, CCanvas.iScreenW, CCanvas.iScreenH, 40);
        }
    }

    private void paintTimeBar(Graphics g, int timeCounter) {
        int iMax = this.iMaxSaveMeTime;
        int x = (CCanvas.iScreenW >> 2) + (CCanvas.iScreenW >> 5);
        int y = (CCanvas.iScreenH >> 1) + (this.iTileHeight >> 1) + (CIngameManager.getInstance().objSmallFont.getHeight() >> 1);
        int w = ((CCanvas.iScreenW >> 1) - (CCanvas.iScreenW >> 4)) / iMax * timeCounter;
        int h = 6;
        g.setColor(65280);
        g.fillRoundRect(x, y, w, h, 10, 10);
    }

    private void drawHUD(Graphics g) {
        g.drawImage(this.imgHUDLeftUp, 0, 0, 20);
        g.drawImage(this.imgHUDRight, CCanvas.iScreenW, 0, 24);
        this.drawNumberFromStrip(g, this.iCoinCollected, 215 + (CCanvas.iScreenW - CCanvas.iPlaybleW), 17, 17);
        this.drawNumberFromStrip(g, this.iDistanceCovered, 50, 3, 20);
        if (!(this.imgHUDAmmo == null || this.objBullets.iAmmoCount <= 0 && this.shldBlinkHUD && this.iHUDBlinkCounter % 4 == 0)) {
            g.drawImage(this.imgHUDLeftDn, 0, this.iHudLeftHeight, 20);
            g.drawImage(this.imgHUDAmmo, 37, 23, 3);
            this.drawNumberFromStrip(g, this.objBullets.iAmmoCount, 64, 18, 20);
        }
    }

    private void drawNumberFromStrip(Graphics g, int num, int x, int y, int anchor) {
        int i;
        String strNum = String.valueOf(num);
        int iLen = strNum.length();
        int width = this.stripHUDFont[0].getWidth();
        if (anchor == 17) {
            x -= width * iLen >> 1;
        }
        int[] index = new int[iLen];
        for (i = iLen - 1; i >= 0; --i) {
            index[i] = num % 10;
            num /= 10;
        }
        for (i = 0; i < iLen; ++i) {
            g.drawImage(this.stripHUDFont[index[i]], x + i * width, y, 20);
        }
    }

    public void handleInput(int key, boolean isPressed) {
        if (isPressed) {
            if (this.isPaused || this.isCtrlInfoActive) {
                return;
            }
            if (!this.isSaveMeActive && key == 204 && !this.objPlayerBike.isPlayerFalling) {
                this.isPlayerMoveLeft = true;
                this.isPlayerMoveRight = false;
                this.objPlayerBike.setPlayerState(2);
            } else if (!this.isSaveMeActive && key == 206 && !this.objPlayerBike.isPlayerFalling) {
                this.isPlayerMoveLeft = false;
                this.isPlayerMoveRight = true;
                this.objPlayerBike.setPlayerState(1);
            } else if (!this.isSaveMeActive && key == 205 && !this.objPlayerBike.isPlayerFalling) {
                this.objBullets.fireBullet(this.objPlayerBike.iPosX, this.objPlayerBike.iPosY - this.objPlayerBike.iHeight);
                if (this.objBullets.iAmmoCount <= 0) {
                    this.shldBlinkHUD = true;
                    this.iHUDBlinkCounter = 0;
                }
            } else if (this.isSaveMeActive && key == 205) {
                --this.iSaveMePurchaseCount;
                gameData.saveData(16, this.iSaveMePurchaseCount);
                this.isSaveMeActive = false;
                this.iSaveTimer = this.iMaxSaveMeTime = CCanvas.FPS * 3;
                this.isHeadStart = true;
                this.iHeadStartDistance = 200;
                this.objPlayerBike.setPlayerState(5);
                this.objPlayerBike.iPosX = (CCanvas.iPlaybleW >> 1) + (CCanvas.iScreenW - CCanvas.iPlaybleW >> 1);
                this.objPlayerBike.isPlayerFalling = false;
                if (this.objPoliceCar != null) {
                    this.objPoliceCar.resetPosition();
                }
                this.objPlayerBike.resetAnimStates();
                if (this.objRoadCar != null) {
                    this.objRoadCar.isCollided = false;
                }
                this.isPlayerMoveLeft = false;
                this.isPlayerMoveRight = false;
            }
        } else {
            if (this.isCtrlInfoActive) {
                if (!this.objControlPopup.handleInput(key, isPressed)) {
                    this.objPlayerBike.setPlayerState(5);
                    this.isCtrlInfoActive = false;
                }
            } else if (this.isPaused) {
                if (!this.objPauseMenu.handleInput(key, isPressed)) {
                    this.isPaused = false;
                    this.isSoundOn = gameData.getData(4) == 0;
                    if (this.isSoundOn && (this.objPoliceCar.checkChasingPlayer() || this.objPoliceCar.isAppearing())) {
                        this.objSoundplayer.playSound(0, true);
                    }
                    if (!this.objPlayerBike.isPlayerFalling && !this.isHeadStart) {
                        this.objPlayerBike.setPlayerState(0);
                    }
                }
            } else if (!this.isSaveMeActive && key == 212) {
                this.isPlayerMoveLeft = false;
                this.isPlayerMoveRight = false;
                this.isPaused = true;
                if (this.isSoundOn) {
                    this.objSoundplayer.stopSound(0);
                }
            } else if (!this.objPlayerBike.isPlayerFalling) {
                if (this.isHeadStart) {
                    this.objPlayerBike.setPlayerState(5);
                } else {
                    this.objPlayerBike.setPlayerState(0);
                }
            }
            this.isPlayerMoveLeft = false;
            this.isPlayerMoveRight = false;
        }
    }

    public void handleTouchInput(int pointerX, int pointerY, int iTouchState) {
        if (iTouchState == 0) {
            if (this.isCtrlInfoActive) {
                this.objControlPopup.handleTouchInput(pointerX, pointerY, iTouchState);
            } else if (this.isPaused) {
                this.objPauseMenu.handleTouchInput(pointerX, pointerY, iTouchState);
            } else if (!this.isSaveMeActive && CUtility.isPointInRect(pointerX, pointerY, this.objPlayerBike.iPosX - this.objPlayerBike.iWidth, this.objPlayerBike.iPosY - this.objPlayerBike.iHeight - (this.objPlayerBike.iHeight >> 1), this.objPlayerBike.iWidth << 1, this.objPlayerBike.iHeight << 1) && !this.objPlayerBike.isPlayerFalling) {
                this.objBullets.fireBullet(this.objPlayerBike.iPosX, this.objPlayerBike.iPosY - this.objPlayerBike.iHeight);
            } else if (!this.isSaveMeActive && pointerX < CCanvas.iScreenW >> 1 && !this.objPlayerBike.isPlayerFalling) {
                this.isPlayerMoveLeft = true;
                this.isPlayerMoveRight = false;
                this.objPlayerBike.setPlayerState(2);
            } else if (!(this.isSaveMeActive || pointerX < CCanvas.iScreenW >> 1 || CUtility.isRSKPressed(pointerX, pointerY) || this.objPlayerBike.isPlayerFalling)) {
                this.isPlayerMoveRight = true;
                this.isPlayerMoveLeft = false;
                this.objPlayerBike.setPlayerState(1);
            }
        } else if (iTouchState == 2) {
            if (this.isCtrlInfoActive) {
                if (!this.objControlPopup.handleTouchInput(pointerX, pointerY, iTouchState)) {
                    this.objPlayerBike.setPlayerState(5);
                    this.isCtrlInfoActive = false;
                }
                this.isPlayerMoveLeft = false;
                this.isPlayerMoveRight = false;
            } else if (this.isPaused) {
                if (!this.objPauseMenu.handleTouchInput(pointerX, pointerY, iTouchState)) {
                    this.isPaused = false;
                    this.isSoundOn = gameData.getData(4) == 0;
                    if (this.isSoundOn && (this.objPoliceCar.checkChasingPlayer() || this.objPoliceCar.isAppearing())) {
                        this.objSoundplayer.playSound(0, true);
                    }
                    if (!this.objPlayerBike.isPlayerFalling && !this.isHeadStart) {
                        this.objPlayerBike.setPlayerState(0);
                    }
                }
            } else if (this.isSaveMeActive && CUtility.isPointInRect(pointerX, pointerY, CCanvas.iScreenW >> 2, (CCanvas.iScreenH >> 1) - (this.iTileHeight >> 1), CCanvas.iScreenW >> 1, this.iTileHeight)) {
                --this.iSaveMePurchaseCount;
                gameData.saveData(16, this.iSaveMePurchaseCount);
                this.isSaveMeActive = false;
                this.iSaveTimer = this.iMaxSaveMeTime = CCanvas.FPS * 3;
                this.isHeadStart = true;
                this.iHeadStartDistance = 200;
                this.objPlayerBike.setPlayerState(5);
                this.objPlayerBike.iPosX = (CCanvas.iPlaybleW >> 1) + (CCanvas.iScreenW - CCanvas.iPlaybleW >> 1);
                this.objPlayerBike.isPlayerFalling = false;
                if (this.objPoliceCar != null) {
                    this.objPoliceCar.resetPosition();
                }
                this.objPlayerBike.resetAnimStates();
                if (this.objRoadCar != null) {
                    this.objRoadCar.isCollided = false;
                }
                this.isPlayerMoveLeft = false;
                this.isPlayerMoveRight = false;
            } else if (!this.isSaveMeActive && CUtility.isRSKPressed(pointerX, pointerY)) {
                this.isPlayerMoveLeft = false;
                this.isPlayerMoveRight = false;
                this.isPaused = true;
                if (this.isSoundOn) {
                    this.objSoundplayer.stopSound(0);
                }
            } else if (!this.objPlayerBike.isPlayerFalling) {
                if (this.isHeadStart) {
                    this.objPlayerBike.setPlayerState(5);
                } else {
                    this.objPlayerBike.setPlayerState(0);
                }
            }
            this.isPlayerMoveLeft = false;
            this.isPlayerMoveRight = false;
        }
    }

    public void setPauseState(boolean state) {
        this.isPaused = state;
    }

    private int getCurrentTileType(int iPointY) {
        int index = (iPointY += Math.abs(this.iRoadStartY)) / this.iTileHeight;
        int iType = this.iArrRoadTileQ[index];
        return iType;
    }

    private int getLeftCollitionOfTile(int iTileType) {
        int iOffSet = CCanvas.iScreenW - CCanvas.iPlaybleW >> 1;
        switch (iTileType) {
            case 1: {
                this.iLimit = 0;
                return 5 + iOffSet;
            }
            case 0: 
            case 2: 
            case 3: {
                this.iLimit = 0;
                return (CCanvas.iPlaybleW >> 2) + 5 + iOffSet;
            }
        }
        return 0;
    }

    private int getRightCollitionOfTile(int iTileType) {
        int iOffSet = CCanvas.iScreenW - CCanvas.iPlaybleW >> 1;
        switch (iTileType) {
            case 1: {
                this.iLimit = 0;
                return CCanvas.iPlaybleW - 5 + iOffSet;
            }
            case 0: 
            case 2: 
            case 3: {
                this.iLimit = 0;
                return CCanvas.iPlaybleW - (CCanvas.iPlaybleW >> 2) - 5 + iOffSet;
            }
        }
        return 0;
    }

    private boolean isFrontCollideWithRoad() {
        if (this.getCurrentTileType(this.objPlayerBike.iPosY - this.objPlayerBike.iHeight + this.iPanningSpeed) == 3) {
            if (this.getCurrentLaneOfPosition(this.objPlayerBike.iPosX) == 0 && this.getLeftCollitionOfTile(3) >= this.objPlayerBike.iPosX) {
                return true;
            }
            if (this.getCurrentLaneOfPosition(this.objPlayerBike.iPosX) == 3 && this.getRightCollitionOfTile(3) <= this.objPlayerBike.iPosX) {
                return true;
            }
        }
        return false;
    }

    private boolean isFrontCollideWithCar() {
        if (this.isHeadStart || this.objRoadCar == null) {
            return false;
        }
        return !this.objRoadCar.checkDestroying() && !this.objRoadCar.checkDestroyed() && this.objPlayerBike.iPosY - this.objPlayerBike.iHeight <= this.objRoadCar.iPosY + this.objRoadCar.iHeigth && this.objPlayerBike.iPosY - this.objPlayerBike.iHeight >= this.objRoadCar.iPosY + this.objRoadCar.iHeigth - (this.iPanningSpeed << 1) && this.objPlayerBike.iPosY - this.objPlayerBike.iHeight > this.objRoadCar.iPosY && this.objPlayerBike.iPosX + (this.objPlayerBike.iWidth >> 2) >= this.objRoadCar.iPosX - (this.objRoadCar.iWidth >> 1) && this.objPlayerBike.iPosX - (this.objPlayerBike.iWidth >> 2) <= this.objRoadCar.iPosX + (this.objRoadCar.iWidth >> 1);
    }

    private boolean isSideCollideWithCar() {
        if (this.objRoadCar == null) {
            return false;
        }
        return CUtility.isCollideRect(this.objPlayerBike.iPosX - (this.objPlayerBike.iWidth >> 2), this.objPlayerBike.iPosY - this.objPlayerBike.iHeight, this.objPlayerBike.iWidth >> 1, this.objPlayerBike.iHeight, this.objRoadCar.iPosX - (this.objRoadCar.iWidth >> 1), this.objRoadCar.iPosY, this.objRoadCar.iWidth, this.objRoadCar.iHeigth) && !this.isFrontCollideWithCar();
    }

    private boolean isFrontCollideWithObstacle() {
        if (this.objObstacle == null) {
            return false;
        }
        if (this.isShieldActive) {
            return false;
        }
        return !this.objObstacle.checkDestroying() && !this.objObstacle.checkDestroyed() && this.objObstacle.getType() == 2 ? CUtility.isCollideRect(this.objPlayerBike.iPosX - (this.objPlayerBike.iWidth >> 3), this.objPlayerBike.iPosY - this.objPlayerBike.iHeight, this.objPlayerBike.iWidth >> 2, this.objPlayerBike.iHeight >> 1, this.objObstacle.iPosX, this.objObstacle.iPosY, this.objObstacle.iWidth, this.objObstacle.iHeigth) : !this.objObstacle.checkDestroying() && !this.objObstacle.checkDestroyed() && this.objPlayerBike.iPosY - this.objPlayerBike.iHeight <= this.objObstacle.iPosY + this.objObstacle.iHeigth && this.objPlayerBike.iPosY - this.objPlayerBike.iHeight > this.objObstacle.iPosY + this.objObstacle.iHeigth - this.iPanningSpeed && this.objPlayerBike.iPosX + (this.objPlayerBike.iWidth >> 2) >= this.objObstacle.iPosX && this.objPlayerBike.iPosX - (this.objPlayerBike.iWidth >> 2) <= this.objObstacle.iPosX + this.objObstacle.iWidth;
    }

    private boolean isSideCollideWithObstacle() {
        if (this.objObstacle == null) {
            return false;
        }
        return CUtility.isCollideRect(this.objPlayerBike.iPosX - (this.objPlayerBike.iWidth >> 1), this.objPlayerBike.iPosY - this.objPlayerBike.iHeight, this.objPlayerBike.iWidth, this.objPlayerBike.iHeight, this.objObstacle.iPosX, this.objObstacle.iPosY, this.objObstacle.iWidth, this.objObstacle.iHeigth) && !this.isFrontCollideWithObstacle();
    }

    private int getCurrentLaneOfPosition(int x) {
        int iOffset = CCanvas.iScreenW - CCanvas.iPlaybleW >> 1;
        if ((x -= iOffset) < CCanvas.iPlaybleW >> 2) {
            return 0;
        }
        if (x < CCanvas.iPlaybleW >> 1) {
            return 1;
        }
        if (x <= CCanvas.iPlaybleW - (CCanvas.iPlaybleW >> 2)) {
            return 2;
        }
        return 3;
    }

    public void gameInterrupted(boolean state) {
        if (state) {
            System.out.println("Inturrepted ....");
            this.isPlayerMoveLeft = false;
            this.isPlayerMoveRight = false;
            this.isPaused = true;
            if (this.isSoundOn) {
                this.objSoundplayer.stopSound(0);
            }
        }
    }
}

