/*
 * Decompiled with CFR 0.152.
 */
package ingame;

import component.CSpriteAnimation;
import game.CCanvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class CPoliceCar {
    private Image imgCar;
    private CSpriteAnimation animLight;
    private Image imgLightSprite;
    private int iPosX;
    private int iPosY;
    private int iHeigth;
    private boolean isVisible;
    private boolean isAppearing;
    private boolean isFallingBack;
    private boolean isCapturing;
    private boolean isCaptured;
    private int iCaptureTargetY;
    private int iSpeed;

    public CPoliceCar(Image img, int x) {
        this.iPosX = x;
        this.iPosY = CCanvas.iScreenH;
        this.imgCar = img;
        this.iHeigth = this.imgCar.getHeight();
        try {
            this.imgLightSprite = Image.createImage((String)"/police_light.png");
            this.animLight = new CSpriteAnimation(this.imgLightSprite, 2, 4, false, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.isVisible = true;
        this.isAppearing = true;
        this.isFallingBack = false;
        this.isCapturing = false;
        this.iCaptureTargetY = 0;
        this.isCaptured = false;
        this.iSpeed = this.iHeigth / 20;
    }

    public void unload() {
        this.imgCar = null;
    }

    public void update(int iTargetX, int speed) {
        if (!this.isVisible) {
            return;
        }
        if (this.isAppearing) {
            if (this.iPosY > CCanvas.iScreenH - (this.iHeigth >> 1)) {
                --this.iPosY;
            } else {
                this.isAppearing = false;
            }
            this.moveX(iTargetX, speed);
        } else if (this.isFallingBack) {
            if (this.iPosY < CCanvas.iScreenH) {
                ++this.iPosY;
            } else {
                this.isFallingBack = false;
                this.isVisible = false;
            }
            this.moveX(iTargetX, speed);
        } else if (this.isCapturing) {
            if (this.iPosY > this.iCaptureTargetY) {
                this.iPosY -= this.iSpeed;
                this.moveX(iTargetX, speed);
            } else {
                this.isCaptured = true;
            }
        } else {
            this.moveX(iTargetX, speed);
        }
        this.animLight.update();
    }

    public boolean checkChasingPlayer() {
        return this.isVisible && !this.isAppearing && !this.isFallingBack && !this.isCapturing;
    }

    public boolean isAppearing() {
        return this.isAppearing;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    private void moveX(int iTargetX, int speed) {
        if (this.iPosX > iTargetX) {
            this.iPosX -= speed >> 1;
        } else if (this.iPosX < iTargetX) {
            this.iPosX += speed >> 1;
        }
    }

    public void show(int iTargetX) {
        if (!this.isAppearing && !this.isVisible) {
            this.isAppearing = true;
            this.isVisible = true;
            this.isFallingBack = false;
            this.iPosY = CCanvas.iScreenH;
            this.iPosX = iTargetX;
        } else if (this.isFallingBack) {
            this.isFallingBack = false;
            this.isAppearing = true;
            this.isVisible = true;
        }
    }

    public void hide() {
        if (!this.isFallingBack && this.isVisible) {
            this.isFallingBack = true;
        }
    }

    public void capturePlayer(int iTargetY) {
        this.iCaptureTargetY = iTargetY;
        this.isCapturing = true;
        this.isAppearing = false;
        this.isFallingBack = false;
        if (!this.isVisible) {
            this.isVisible = true;
            this.iPosX = CCanvas.iScreenW >> 1;
        }
    }

    public boolean isCaptured() {
        return this.isCaptured;
    }

    public void resetPosition() {
        this.iPosX = CCanvas.iScreenW >> 1;
        this.iPosY = CCanvas.iScreenH;
        this.isVisible = true;
        this.isAppearing = true;
        this.isFallingBack = false;
        this.isCapturing = false;
        this.iCaptureTargetY = 0;
        this.isCaptured = false;
    }

    public void paint(Graphics g) {
        if (this.isVisible) {
            g.drawImage(this.imgCar, this.iPosX, this.iPosY, 17);
            this.animLight.paint(g, this.iPosX, this.iPosY + (this.iHeigth >> 1), 3);
        }
    }
}

