/*
 * Decompiled with CFR 0.152.
 */
package mainmenu;

import component.CUtility;
import component.customFont;
import game.CCanvas;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import mainmenu.COptionManager;

public class CAbout {
    private Image imageD3Header;
    private Image imageOptionMenuHeaderBar;
    private Image imageOptionMenuHeader;
    private Image imageUPArrow;
    private Image imageDownArrow;
    private Image imageBack;
    private int iHeaderD3X;
    private int iHeaderD3Y;
    private int iOptionMenuHeaderX;
    private int iOptionMenuHeaderY;
    private int iUpArrowX;
    private int iUpArrowY;
    private int iDownArrowX;
    private int iDownArrowY;
    private int iArrowMoveFacUp;
    private int iArrowMoveFacDown;
    private int iOutSideBorderX;
    private int iOutSideBorderY;
    private int iOutSideBorderWidth;
    private int iOutSideBorderHeight;
    private int iInSideBorderX;
    private int iInSideBorderY;
    private int iInSideBorderWidth;
    private int iInSideBorderHeight;
    private int iMoveSpeed;
    private int iMoveFactor;
    private int iAdjustFactor;
    private int iLargeFontHeight;
    private int iAboutStartX;
    private int iAboutStartY;
    private boolean isUpPressed = false;
    private boolean isDownPressed = false;
    String[] strTextRows = null;
    private customFont objSmallFont = new customFont(0);
    private customFont objLargeFont = new customFont(1);

    public CAbout() {
        this.loadImages();
        this.initialize();
    }

    private void loadImages() {
        try {
            this.imageD3Header = Image.createImage((String)"/header_3.png");
            this.imageOptionMenuHeaderBar = Image.createImage((String)"/header_bar.png");
            this.imageOptionMenuHeader = Image.createImage((String)"/header_about.png");
            this.imageUPArrow = Image.createImage((String)"/arrow.png");
            this.imageBack = Image.createImage((String)"/next.png");
            this.imageBack = Image.createImage((Image)this.imageBack, (int)0, (int)0, (int)this.imageBack.getWidth(), (int)this.imageBack.getHeight(), (int)2);
            this.imageDownArrow = Image.createImage((Image)this.imageUPArrow, (int)0, (int)0, (int)this.imageUPArrow.getWidth(), (int)this.imageUPArrow.getHeight(), (int)3);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void initialize() {
        this.iLargeFontHeight = this.objLargeFont.getHeight();
        this.iAdjustFactor = this.imageOptionMenuHeaderBar.getWidth() * 6 / 100;
        int iTotalHeaderWidth = this.imageD3Header.getWidth() + this.imageOptionMenuHeaderBar.getWidth();
        this.iHeaderD3X = (CCanvas.iScreenW >> 1) - (iTotalHeaderWidth >> 1);
        this.iHeaderD3Y = this.iAdjustFactor >> 1;
        this.iOptionMenuHeaderX = this.iHeaderD3X + this.imageD3Header.getWidth();
        this.iOptionMenuHeaderY = this.iHeaderD3Y + (this.imageD3Header.getHeight() >> 1) - 3;
        this.iOutSideBorderX = CCanvas.iScreenW * 4 / 100;
        this.iOutSideBorderY = this.iOptionMenuHeaderY;
        this.iOutSideBorderWidth = CCanvas.iScreenW - 2 * this.iOutSideBorderX;
        this.iOutSideBorderHeight = CCanvas.iScreenH - (this.iOutSideBorderY + 37);
        this.iUpArrowX = CCanvas.iScreenW >> 1;
        this.iUpArrowY = this.iHeaderD3Y + this.imageD3Header.getHeight();
        this.iDownArrowX = this.iUpArrowX;
        this.iDownArrowY = this.iOutSideBorderY + this.iOutSideBorderHeight - 2 * this.imageDownArrow.getHeight();
        this.iArrowMoveFacUp = 0;
        this.iArrowMoveFacDown = 0;
        this.iInSideBorderX = CCanvas.iScreenW * 12 / 100;
        this.iInSideBorderY = this.iUpArrowY + (3 * this.imageUPArrow.getHeight() >> 1);
        this.iInSideBorderWidth = CCanvas.iScreenW - 2 * this.iInSideBorderX;
        this.iInSideBorderHeight = this.iDownArrowY - ((this.imageDownArrow.getHeight() >> 1) + this.iInSideBorderY);
        this.iMoveSpeed = 10;
        this.iMoveFactor = 0;
        this.iAboutStartX = this.iInSideBorderX + this.iLargeFontHeight;
        this.iAboutStartY = this.iInSideBorderY + this.iLargeFontHeight;
        if (this.strTextRows == null) {
            this.strTextRows = CUtility.getTextRows("Dhoom:3 The Game\nVersion - 1.0.0\nDeveloped At\nRobosoft Technologies Pvt. Ltd.\nPublished By\n99Games Online Pvt. Ltd.\nAll Intellectual Property in Dhoom:3 and its Characters, trademarks, associated artwork and designs are exclusively owned by Yash Raj Films Pvt. Ltd.\n\u00a9 2013 All Rights Reserved.\nAll Intellectual Property in Dhoom:3 The Game software are exclusively owned by 99Games Online Pvt. Ltd.\n\u00a9 2013 All Rights Reserved.\nhttp://www.99games.in/", this.objSmallFont, this.iInSideBorderWidth - 2 * this.iLargeFontHeight);
        }
    }

    public void paint(Graphics g2) {
        CUtility.drawBorder(g2, this.iOutSideBorderX, this.iOutSideBorderY, this.iOutSideBorderWidth, this.iOutSideBorderHeight);
        CUtility.paintSoftKeys(g2, null, this.imageBack);
        g2.drawImage(this.imageOptionMenuHeaderBar, this.iOptionMenuHeaderX, this.iOptionMenuHeaderY, 6);
        g2.drawImage(this.imageOptionMenuHeader, this.iOptionMenuHeaderX + (this.imageOptionMenuHeaderBar.getWidth() >> 1) - this.iAdjustFactor, this.iOptionMenuHeaderY, 3);
        g2.drawImage(this.imageD3Header, this.iHeaderD3X, this.iHeaderD3Y, 0);
        if (this.iMoveFactor + this.iAboutStartY < this.iInSideBorderY + this.iLargeFontHeight) {
            g2.drawImage(this.imageUPArrow, this.iUpArrowX, this.iUpArrowY + this.iArrowMoveFacUp, 17);
        }
        if (this.iMoveFactor + (this.iAboutStartY + this.objSmallFont.getHeight() * this.strTextRows.length) > this.iInSideBorderY + this.iInSideBorderHeight - this.iLargeFontHeight - this.objSmallFont.getHeight()) {
            g2.drawImage(this.imageDownArrow, this.iDownArrowX, this.iDownArrowY + this.iArrowMoveFacDown, 17);
        }
        CUtility.drawBorder(g2, this.iInSideBorderX, this.iInSideBorderY, this.iInSideBorderWidth, this.iInSideBorderHeight);
        g2.setClip(this.iInSideBorderX + this.iLargeFontHeight, this.iInSideBorderY + this.iLargeFontHeight, this.iInSideBorderWidth - 2 * this.iLargeFontHeight, this.iInSideBorderHeight - 2 * this.iLargeFontHeight);
        if (this.strTextRows != null) {
            for (int i2 = 0; i2 < this.strTextRows.length; ++i2) {
                this.objSmallFont.drawString(this.strTextRows[i2], this.iAboutStartX, this.iMoveFactor + (this.iAboutStartY + this.objSmallFont.getHeight() * (i2 + 1)), g2, 6);
            }
        }
        g2.setClip(0, 0, CCanvas.iScreenW, CCanvas.iScreenH);
    }

    public void update() {
    }

    public void handleInput(int key, boolean isPressed) {
        if (isPressed) {
            switch (key) {
                case 202: {
                    if (this.iMoveFactor + this.iAboutStartY >= this.iInSideBorderY + this.iLargeFontHeight) break;
                    this.iArrowMoveFacUp -= 5;
                    this.isUpPressed = true;
                    this.iMoveFactor += this.iMoveSpeed;
                    break;
                }
                case 208: {
                    if (this.iMoveFactor + (this.iAboutStartY + this.objSmallFont.getHeight() * this.strTextRows.length) <= this.iInSideBorderY + this.iInSideBorderHeight - this.iLargeFontHeight - this.objSmallFont.getHeight()) break;
                    this.iArrowMoveFacDown += 5;
                    this.isDownPressed = true;
                    this.iMoveFactor -= this.iMoveSpeed;
                    break;
                }
                case 212: {
                    COptionManager.getInstance().switchToStates(15);
                }
            }
        } else {
            if (this.isUpPressed) {
                this.iArrowMoveFacUp += 5;
                this.isUpPressed = false;
            }
            if (this.isDownPressed) {
                this.iArrowMoveFacDown -= 5;
                this.isDownPressed = false;
            }
        }
    }

    public void handleTouchInput(int pointerX, int pointerY, int iTouchState) {
        if (iTouchState == 0 && !CUtility.isRSKPressed(pointerX, pointerY)) {
            if (CUtility.isPointInRect(pointerX, pointerY, this.iInSideBorderX, 0, this.iInSideBorderWidth, this.iUpArrowY + this.imageUPArrow.getHeight())) {
                if (this.iMoveFactor + this.iAboutStartY < this.iInSideBorderY + this.iLargeFontHeight) {
                    this.iArrowMoveFacUp -= 5;
                    this.isUpPressed = true;
                }
            } else if (CUtility.isPointInRect(pointerX, pointerY, this.iInSideBorderX, this.iDownArrowY, this.iInSideBorderWidth, CCanvas.iScreenH - (this.iDownArrowY + this.imageDownArrow.getHeight())) && this.iMoveFactor + (this.iAboutStartY + this.objSmallFont.getHeight() * this.strTextRows.length) > this.iInSideBorderY + this.iInSideBorderHeight - this.iLargeFontHeight - this.objSmallFont.getHeight()) {
                this.iArrowMoveFacDown += 5;
                this.isDownPressed = true;
            }
        }
        if (iTouchState == 2) {
            if (CUtility.isRSKPressed(pointerX, pointerY)) {
                COptionManager.getInstance().switchToStates(15);
            } else if (CUtility.isPointInRect(pointerX, pointerY, this.iInSideBorderX, 0, this.iInSideBorderWidth, this.iUpArrowY + this.imageUPArrow.getHeight())) {
                if (this.isUpPressed) {
                    this.iMoveFactor += this.iMoveSpeed;
                    this.iArrowMoveFacUp += 5;
                    this.isUpPressed = false;
                }
            } else if (CUtility.isPointInRect(pointerX, pointerY, this.iInSideBorderX, this.iDownArrowY, this.iInSideBorderWidth, CCanvas.iScreenH - (this.iDownArrowY + this.imageDownArrow.getHeight())) && this.isDownPressed) {
                this.iMoveFactor -= this.iMoveSpeed;
                this.iArrowMoveFacDown -= 5;
                this.isDownPressed = false;
            }
        }
    }

    public void unLoadImages() {
        this.imageD3Header = null;
        this.imageOptionMenuHeaderBar = null;
        this.imageOptionMenuHeader = null;
        this.imageUPArrow = null;
        this.imageDownArrow = null;
        this.objSmallFont = null;
        this.objLargeFont = null;
        this.imageBack = null;
    }
}

