/*
 * Decompiled with CFR 0.152.
 */
package com.auer.pLib.common_util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;

public class Comm_util {
    private final short[] SINES;
    private int temp1;
    private int temp2;
    private int temp3;
    private long startTime;
    private long stopTime;
    private boolean keyWaiting;
    private int keyInput;
    private Random rnd;

    public Comm_util() {
        short[] sArray = new short[10];
        sArray[1] = 44;
        sArray[2] = 88;
        sArray[3] = 128;
        sArray[4] = 165;
        sArray[5] = 196;
        sArray[6] = 222;
        sArray[7] = 241;
        sArray[8] = 252;
        sArray[9] = 256;
        this.SINES = sArray;
        this.temp1 = 0;
        this.temp2 = 0;
        this.temp3 = 0;
        this.startTime = 0L;
        this.stopTime = 0L;
        this.keyWaiting = false;
        this.rnd = new Random();
    }

    public short sinTimes256(int degrees) {
        if ((degrees %= 36) <= 9) {
            return this.SINES[degrees];
        }
        if (degrees <= 18) {
            return this.SINES[18 - degrees];
        }
        if (degrees <= 27) {
            return -this.SINES[degrees - 18];
        }
        return -this.SINES[36 - degrees];
    }

    public short cosTimes256(int degrees) {
        return this.sinTimes256(degrees + 9);
    }

    public float fast_atanf(float val) {
        if (Math.abs(val) <= 1.0f) {
            return val / (1.0f + 0.28f * val * val);
        }
        if (val < -1.0f) {
            return -(val / (val * val + 0.28f) + 1.5707963f);
        }
        return 1.5707963f - val / (val * val + 0.28f);
    }

    public float fast_atan2f(float y, float x) {
        if (x == 0.0f) {
            if (y > 0.0f) {
                return 1.5707963f;
            }
            if (y == 0.0f) {
                return 0.0f;
            }
            return -1.5707963f;
        }
        float z = y / x;
        if (Math.abs(z) < 1.0f) {
            if (x < 0.0f) {
                if (y < 0.0f) {
                    return z / (1.0f + 0.28f * z * z) - (float)Math.PI;
                }
                return z / (1.0f + 0.28f * z * z) + (float)Math.PI;
            }
            return z / (1.0f + 0.28f * z * z);
        }
        if (y < 0.0f) {
            return z / (z * z + 0.28f) - 1.5707963f;
        }
        return 1.5707963f - z / (z * z + 0.28f);
    }

    public float arcSin(float val) {
        return this.fast_atanf(val / (float)Math.sqrt(1.0f - val * val));
    }

    public float arcCos(float val) {
        return this.fast_atanf((float)Math.sqrt(1.0f - val * val) / val);
    }

    public int getDigits(int temp) {
        int digits = 0;
        if (temp == 0) {
            return 1;
        }
        if (temp > 0) {
            while (temp != 0) {
                temp /= 10;
                ++digits;
            }
        }
        return digits;
    }

    public int getDigits(long temp) {
        int digits = 0;
        if (temp == 0L) {
            return 1;
        }
        if (temp > 0L) {
            while (temp != 0L) {
                temp /= 10L;
                ++digits;
            }
        }
        return digits;
    }

    public int pow(int tempA, int tempB) {
        int temp = 1;
        if (tempB == 0) {
            return temp;
        }
        int i = 0;
        while (i < tempB) {
            temp *= tempA;
            ++i;
        }
        return temp;
    }

    public int sqrt_Int(int value) {
        int sqrt = 0;
        int tmp = 0;
        int k = 0x40000000;
        while (k != 0) {
            tmp = sqrt + k;
            sqrt >>= 1;
            if (tmp <= value) {
                value -= tmp;
                sqrt += k;
            }
            k >>= 2;
        }
        return sqrt;
    }

    public short var_IncLimiter(int data, int max) {
        return this.var_IncLimiter(data, 0, max);
    }

    public short var_IncLimiter(int data, int min, int max) {
        if (++data > max) {
            data = min;
        }
        return (short)data;
    }

    public short var_DecLimiter(int data, int max) {
        return this.var_DecLimiter(data, 0, max);
    }

    public short var_DecLimiter(int data, int min, int max) {
        if (--data < min) {
            data = max;
        }
        return (short)data;
    }

    public void rotateLeftArray(byte[] data) {
        int i = data.length - 1;
        while (i > 0) {
            data[0] = (byte)(data[0] + data[i]);
            data[i] = (byte)(data[0] - data[i]);
            data[0] = (byte)(data[0] - data[i]);
            --i;
        }
    }

    public void rotateRightArray(byte[] data) {
        int i = 0;
        while (i < data.length - 1) {
            int n = i;
            data[n] = (byte)(data[n] + data[data.length - 1]);
            data[data.length - 1] = (byte)(data[i] - data[data.length - 1]);
            int n2 = i++;
            data[n2] = (byte)(data[n2] - data[data.length - 1]);
        }
    }

    public short[] rotateLeftArray(short[] data) {
        int i = data.length - 1;
        while (i > 0) {
            data[0] = (short)(data[0] + data[i]);
            data[i] = (short)(data[0] - data[i]);
            data[0] = (short)(data[0] - data[i]);
            --i;
        }
        return data;
    }

    public short[] rotateRightArray(short[] data) {
        int i = 0;
        while (i < data.length - 1) {
            int n = i;
            data[n] = (short)(data[n] + data[data.length - 1]);
            data[data.length - 1] = (short)(data[i] - data[data.length - 1]);
            int n2 = i++;
            data[n2] = (short)(data[n2] - data[data.length - 1]);
        }
        return data;
    }

    public short smoothMove(int start, int end) {
        if ((start = end - start) == 0) {
            return 0;
        }
        if (start <= 2 && start >= -2) {
            if (start > 0) {
                return 1;
            }
            return -1;
        }
        return (short)(start / 2);
    }

    public short quickMove(int start, int end, int inc) {
        start = end - start;
        if (inc < 0) {
            inc *= -1;
        } else if (inc == 0) {
            inc *= 1;
        }
        if (start == 0) {
            return 0;
        }
        if (start <= inc && start >= -inc) {
            return (short)start;
        }
        if (start > 0) {
            return (short)inc;
        }
        return (short)(-inc);
    }

    public int rangeRAND(int min, int max) {
        do {
            this.temp1 = this.rnd.nextInt(max + 1);
        } while (this.temp1 < min);
        return this.temp1;
    }

    public boolean gapTime(long timeGap) {
        if (this.startTime == 0L) {
            this.startTime = System.currentTimeMillis();
        } else {
            this.stopTime = System.currentTimeMillis();
            if (this.stopTime - this.startTime > timeGap) {
                this.startTime = 0L;
                this.stopTime = 0L;
                return true;
            }
        }
        return false;
    }

    public void resetGapTimer() {
        this.startTime = 0L;
        this.stopTime = 0L;
    }

    public boolean keyPressWaiting() {
        if (!this.keyWaiting) {
            this.keyWaiting = true;
        } else if (this.keyInput != 0) {
            this.keyWaiting = false;
            this.keyInput = 0;
            return true;
        }
        this.keyInput = 0;
        return false;
    }

    public void keyPressDetector(int keyCode) {
        this.keyInput = keyCode;
    }

    public void resetKeyPressWaiter() {
        this.keyWaiting = false;
        this.keyInput = 0;
    }

    public byte[] getByteArray(String fileStr) {
        boolean lengthNum = false;
        boolean readBuf = false;
        try {
            InputStream is = this.getClass().getResourceAsStream(fileStr);
            byte[] image = this.InputStreamToByte(this.getClass().getResourceAsStream(fileStr));
            is.close();
            int i = 0;
            while (i < image.length) {
                System.out.println("" + image[i]);
                ++i;
            }
            return image;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        return null;
    }

    public byte[] InputStreamToByte(InputStream iStrm) throws IOException {
        int ch;
        ByteArrayOutputStream bytestream = new ByteArrayOutputStream();
        while ((ch = iStrm.read()) != -1) {
            bytestream.write(ch);
        }
        byte[] data = bytestream.toByteArray();
        bytestream.close();
        return data;
    }
}

