/*
 * Decompiled with CFR 0.152.
 */
package role;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Image;

public class PalettedImage {
    public byte[] crc;
    private int[] crc_table;
    private byte[] imgData;
    private int[] orgPalette;
    private int paletteOffset;
    private int CRCOffset;
    private int paletteColors;

    public PalettedImage() {
        byte[] byArray = new byte[12];
        byArray[4] = 73;
        byArray[5] = 69;
        byArray[6] = 78;
        byArray[7] = 68;
        byArray[8] = -82;
        byArray[9] = 66;
        byArray[10] = 96;
        byArray[11] = -126;
        this.crc = byArray;
    }

    public void setImageData(byte[] data) {
        this.imgData = data;
        this.analyze();
    }

    public void setImageSrc(String filename) {
        InputStream is = null;
        ByteArrayOutputStream baos = null;
        try {
            is = filename.getClass().getResourceAsStream(filename);
            if (is == null) {
                System.out.println(String.valueOf(filename) + "no find");
                return;
            }
            baos = new ByteArrayOutputStream();
            int ch = 0;
            while ((ch = is.read()) != -1) {
                baos.write(ch);
            }
            this.setImageData(baos.toByteArray());
            is.close();
            baos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setImageSrc(String filename, int index, byte[] b) {
        InputStream is = null;
        ByteArrayOutputStream baos = null;
        try {
            is = filename.getClass().getResourceAsStream(filename);
            if (is == null) {
                System.out.println(String.valueOf(filename) + "no find");
                return;
            }
            baos = new ByteArrayOutputStream();
            int ch = 0;
            int count = 0;
            while ((ch = is.read()) != -1) {
                if (count == index) {
                    baos.write(b);
                }
                baos.write(ch);
                ++count;
            }
            baos.write(this.crc);
            this.setImageData(baos.toByteArray());
            baos.close();
            is.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setPalette(int[] colors) {
        if (colors == null) {
            throw new NullPointerException();
        }
        if (colors.length != this.paletteColors) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        int offset = this.paletteOffset;
        while (i < colors.length) {
            this.imgData[offset] = (byte)(colors[i] >> 16 & 0xFF);
            this.imgData[offset + 1] = (byte)(colors[i] >> 8 & 0xFF);
            this.imgData[offset + 2] = (byte)(colors[i] & 0xFF);
            ++i;
            offset += 3;
        }
    }

    public int[] getPalette() {
        int[] colors = new int[this.paletteColors];
        int i = 0;
        while (i < this.paletteColors) {
            colors[i] = this.getColor(i);
            ++i;
        }
        return colors;
    }

    private void analyze() {
        int offset = 8;
        int chunkLen = 0;
        while (this.imgData[offset + 4] != 80 || this.imgData[offset + 5] != 76 || this.imgData[offset + 6] != 84 || this.imgData[offset + 7] != 69) {
            chunkLen = this.readInt(offset);
            offset += 8 + chunkLen + 4;
        }
        chunkLen = this.readInt(offset);
        this.paletteColors = chunkLen / 3;
        this.paletteOffset = offset + 8;
        this.CRCOffset = offset + 8 + chunkLen;
    }

    private int readInt(int offset) {
        return (this.imgData[offset] & 0xFF) << 24 | (this.imgData[offset + 1] & 0xFF) << 16 | (this.imgData[offset + 2] & 0xFF) << 8 | this.imgData[offset + 3] & 0xFF;
    }

    public int getColorCount() {
        return this.paletteColors;
    }

    public int getColor(int index) {
        if (index < 0 || index >= this.paletteColors) {
            throw new IllegalArgumentException();
        }
        int offset = this.paletteOffset + index * 3;
        return (this.imgData[offset] & 0xFF) << 16 | (this.imgData[offset + 1] & 0xFF) << 8 | this.imgData[offset + 2] & 0xFF;
    }

    public void setColor(int index, int color) {
        if (index < 0 || index >= this.paletteColors) {
            throw new IllegalArgumentException();
        }
        int offset = this.paletteOffset + index * 3;
        this.imgData[offset] = (byte)(color >> 16 & 0xFF);
        this.imgData[offset + 1] = (byte)(color >> 8 & 0xFF);
        this.imgData[offset + 2] = (byte)(color & 0xFF);
    }

    public void setColor(int index, byte[] color) {
        int i = 0;
        while (i < color.length) {
            this.imgData[index + i] = color[i];
            ++i;
        }
    }

    public void replaceColor(int oldColor, int newColor) {
        byte rr = (byte)(oldColor >> 16 & 0xFF);
        byte gg = (byte)(oldColor >> 8 & 0xFF);
        byte bb = (byte)(oldColor & 0xFF);
        int i = 0;
        int offset = this.paletteOffset;
        while (i < this.paletteColors) {
            if (rr == this.imgData[offset] && gg == this.imgData[offset + 1] && bb == this.imgData[offset + 2]) {
                this.imgData[offset] = (byte)(newColor >> 16 & 0xFF);
                this.imgData[offset + 1] = (byte)(newColor >> 8 & 0xFF);
                this.imgData[offset + 2] = (byte)(newColor & 0xFF);
                break;
            }
            ++i;
            offset += 3;
        }
    }

    public Image getImage() {
        this.CRCChecksum();
        Image image = Image.createImage((byte[])this.imgData, (int)0, (int)this.imgData.length);
        return image;
    }

    public void resetImageData() {
        this.imgData = null;
        this.orgPalette = null;
        this.paletteOffset = 0;
        this.CRCOffset = 0;
        this.paletteColors = 0;
        this.crc_table = null;
    }

    private void CRCChecksum() {
        int checksum = this.checksum(this.imgData, this.paletteOffset - 4, this.paletteColors * 3 + 4);
        this.imgData[this.CRCOffset] = (byte)(checksum >> 24 & 0xFF);
        this.imgData[this.CRCOffset + 1] = (byte)(checksum >> 16 & 0xFF);
        this.imgData[this.CRCOffset + 2] = (byte)(checksum >> 8 & 0xFF);
        this.imgData[this.CRCOffset + 3] = (byte)(checksum & 0xFF);
    }

    private void make_crc_table() {
        this.crc_table = new int[256];
        int c = 0;
        int n = 0;
        while (n < 256) {
            c = n;
            int k = 0;
            while (k < 8) {
                c = (c & 1) == 1 ? 0xEDB88320 ^ c >>> 1 : (c >>>= 1);
                ++k;
            }
            this.crc_table[n] = c;
            ++n;
        }
    }

    private int update_crc(byte[] buf, int off, int len) {
        int c = -1;
        if (this.crc_table == null) {
            this.make_crc_table();
        }
        int n = off;
        while (n < len + off) {
            c = this.crc_table[(c ^ buf[n]) & 0xFF] ^ c >>> 8;
            ++n;
        }
        return c;
    }

    private int checksum(byte[] buf, int off, int len) {
        return ~this.update_crc(buf, off, len);
    }
}

