/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.GContinue;
import game.GForeword;
import game.GGame;
import game.GGameData;
import game.GLogo;
import game.GParam;
import game.GTest;
import game.GTitle;
import game.GameMIDlet;
import game.GameObject;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.GameCanvas;

public class GMain
extends GameCanvas
implements Runnable {
    private static GameObject G_obj_main = null;
    private static boolean flushGraphicsFlag;
    private Display display;
    private GGameData gD = null;
    private boolean sleeping;
    private long frameDelay;
    public static byte inputDelay;
    private int pressKeyCode;
    private short gcCounter;
    private String errStr;
    private int temp1 = 0;
    private int temp2 = 0;
    public byte gameFlow = 0;
    private byte gameFlow_BAK = 0;
    private byte gameFlow_Sub = 0;
    public static final byte GF_LOGO = 1;
    public static final byte GF_TITLE = 2;
    public static final byte GF_TITLE_MENU = 3;
    public static final byte GF_TITLE_BLACK = 4;
    public static final byte GF_FOREWORD = 5;
    public static final byte GF_GAME = 6;
    public static final byte GF_CONTINUE = 7;
    public static final byte GF_EXIT = 50;
    public static final byte GF_TEST = 99;
    public static final byte CALL_SWITCH_VOL = 10;
    public static final byte CALL_SET_VOL = 11;

    public GMain(Display d) {
        super(false);
        this.display = d;
        d.setCurrent((Displayable)this);
        this.setFullScreenMode(true);
        this.gcCounter = 0;
        this.gameFlow = 1;
        this.gD = new GGameData();
        this.gD.dataInitial();
        this.gD.g = this.getGraphics();
        this.frameDelay = 32L;
        inputDelay = 0;
        this.sleeping = false;
        this.preload();
        this.initial();
    }

    private void preload() {
    }

    public void initial() {
        this.gD.realCanvasWidth = (short)this.getWidth();
        this.gD.realCanvasHeight = (short)this.getHeight();
        if (this.gD.realCanvasWidth > 176) {
            this.gD.X_208 = true;
            this.gD.X_Shift = (short)((this.gD.realCanvasWidth - 240) / 2);
        }
        if (this.gD.realCanvasHeight > 195 && this.gD.realCanvasHeight < 220) {
            this.gD.Y_208 = true;
            this.gD.Y_Shift = (short)((this.gD.realCanvasHeight - 274) / 2);
        } else if (this.gD.realCanvasHeight > 274) {
            this.gD.Y_Shift = (short)((this.gD.realCanvasHeight - 274) / 2);
        }
    }

    public void stop() {
        this.sleeping = true;
        GameMIDlet.instance.exit();
    }

    public void keyPressed(int keyCode) {
        this.pressKeyCode = keyCode;
    }

    protected void pointerPressed(int x, int y) {
    }

    protected void pointerReleased(int x, int y) {
        if (x >= GParam.SoftKeyTouchArea[0][0] && x <= GParam.SoftKeyTouchArea[0][2] && y >= GParam.SoftKeyTouchArea[0][1] && y <= GParam.SoftKeyTouchArea[0][3]) {
            this.pressKeyCode = GParam.LeftSoftKey;
        }
        if (x >= GParam.SoftKeyTouchArea[1][0] && x <= GParam.SoftKeyTouchArea[1][2] && y >= GParam.SoftKeyTouchArea[1][1] && y <= GParam.SoftKeyTouchArea[1][3]) {
            this.pressKeyCode = GParam.RightSoftKey;
        }
        if (x >= GParam.SoftKeyTouchArea[2][0] && x <= GParam.SoftKeyTouchArea[2][2] && y >= GParam.SoftKeyTouchArea[2][1] && y <= GParam.SoftKeyTouchArea[2][3]) {
            this.pressKeyCode = -8;
        }
        if (x >= GParam.SoftKeyTouchArea[3][0] && x <= GParam.SoftKeyTouchArea[3][2] && y >= GParam.SoftKeyTouchArea[3][1] && y <= GParam.SoftKeyTouchArea[3][3]) {
            this.pressKeyCode = -9;
        }
    }

    protected void pointerDragged(int x, int y) {
    }

    public void run() {
        Graphics g = this.getGraphics();
        while (!this.sleeping) {
            if (G_obj_main == null) {
                switch (this.gameFlow) {
                    case 1: {
                        G_obj_main = new GLogo(g, this.gD);
                        break;
                    }
                    case 2: {
                        G_obj_main = new GTitle(g, this.gD);
                        G_obj_main.putIn(2);
                        break;
                    }
                    case 5: {
                        G_obj_main = new GForeword(g, this.gD);
                        break;
                    }
                    case 6: {
                        G_obj_main = new GGame(g, this.gD);
                        break;
                    }
                    case 7: {
                        G_obj_main = new GContinue(g, this.gD);
                        break;
                    }
                    case 50: {
                        this.stop();
                        break;
                    }
                    case 99: {
                        G_obj_main = new GTest(g, this.gD);
                    }
                }
            } else {
                if ((inputDelay = (byte)(inputDelay + 1)) > GParam.inputDelay) {
                    G_obj_main.keyProc(this.getKeyStates(), this.pressKeyCode);
                    this.pressKeyCode = 0;
                    inputDelay = 0;
                    short s = this.gcCounter;
                    this.gcCounter = (short)(s + 1);
                    if (s >= 100) {
                        this.gcCounter = 0;
                    }
                }
                G_obj_main.gameProc(0);
                G_obj_main.gamePaint(g);
                if (flushGraphicsFlag) {
                    this.flushGraphics();
                    flushGraphicsFlag = false;
                }
                if (G_obj_main.isStop()) {
                    this.gameFlow = G_obj_main.changeFlow();
                    G_obj_main = null;
                    System.gc();
                }
            }
            try {
                Thread.sleep(this.frameDelay);
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
        }
    }

    public static void flushGraphic() {
        flushGraphicsFlag = true;
    }

    public static boolean callback(int data) {
        if (G_obj_main != null) {
            G_obj_main.putIn(data);
        }
        return false;
    }
}

