/*
 * Decompiled with CFR 0.152.
 */
package role;

import comm.Rect;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;
import role.r_event.ChgAct;
import role.r_event.ChgActIndex;
import role.r_event.ChgActIndexIf_X_Edge;
import role.r_event.ChgActIndexIf_Y_Zero;
import role.r_event.ChgActIndexIf_Z_Edge;
import role.r_event.ChgCI;
import role.r_event.ChgYourAct;
import role.r_event.ClearPath;
import role.r_event.DecActRepeat;
import role.r_event.NewEff;
import role.r_event.NewMagicEff;
import role.r_event.OperLock;
import role.r_event.SetAngle;
import role.r_event.SetComboLock;
import role.r_event.SetDeath;
import role.r_event.SetPath;
import role.r_event.SetVisible;
import role.r_event.ToReadyIfNone;

public class ActFrame {
    public byte frameDelay = 0;
    public byte atk_Judge = 0;
    public byte def_Judge = 0;
    public byte frameIndex = 0;
    public byte[] atkCenPos = new byte[2];
    public Rect atkArea;
    public Vector event;

    public ActFrame(DataInputStream dis) {
        ActFrame.readActFrame(dis, this);
    }

    public static void readActFrame(DataInputStream dis, ActFrame actFrame) {
        try {
            actFrame.frameDelay = dis.readByte();
            actFrame.atk_Judge = dis.readByte();
            actFrame.def_Judge = dis.readByte();
            actFrame.frameIndex = dis.readByte();
            actFrame.atkCenPos[0] = dis.readByte();
            actFrame.atkCenPos[1] = dis.readByte();
            if (actFrame.atk_Judge != 1) {
                actFrame.atkArea = new Rect(dis.readShort(), dis.readShort(), dis.readShort(), dis.readShort());
            } else {
                dis.readShort();
                dis.readShort();
                dis.readShort();
                dis.readShort();
            }
            int eventCount = dis.readByte();
            if (eventCount > 0) {
                actFrame.event = new Vector();
                short event_ID = 0;
                int i = 0;
                while (i < eventCount) {
                    event_ID = dis.readShort();
                    switch (event_ID) {
                        case 1: {
                            actFrame.event.addElement(new SetPath(dis));
                            break;
                        }
                        case 2: {
                            actFrame.event.addElement(new SetVisible(dis));
                            break;
                        }
                        case 3: {
                            actFrame.event.addElement(new ChgActIndex(dis));
                            break;
                        }
                        case 4: {
                            break;
                        }
                        case 5: {
                            break;
                        }
                        case 6: {
                            actFrame.event.addElement(new ChgAct(dis));
                            break;
                        }
                        case 7: {
                            actFrame.event.addElement(new ToReadyIfNone(dis));
                            break;
                        }
                        case 8: {
                            actFrame.event.addElement(new DecActRepeat(dis));
                            break;
                        }
                        case 9: {
                            actFrame.event.addElement(new ClearPath(dis));
                            break;
                        }
                        case 10: {
                            actFrame.event.addElement(new OperLock(dis));
                            break;
                        }
                        case 11: {
                            actFrame.event.addElement(new ChgActIndexIf_Y_Zero(dis));
                            break;
                        }
                        case 12: {
                            actFrame.event.addElement(new SetDeath(dis));
                            break;
                        }
                        case 13: {
                            actFrame.event.addElement(new ChgActIndexIf_X_Edge(dis));
                            break;
                        }
                        case 14: {
                            actFrame.event.addElement(new ChgActIndexIf_Z_Edge(dis));
                            break;
                        }
                        case 15: {
                            actFrame.event.addElement(new NewEff(dis));
                            break;
                        }
                        case 16: {
                            actFrame.event.addElement(new SetAngle(dis));
                            break;
                        }
                        case 17: {
                            actFrame.event.addElement(new ChgCI(dis));
                            break;
                        }
                        case 18: {
                            actFrame.event.addElement(new NewMagicEff(dis));
                            break;
                        }
                        case 19: {
                            actFrame.event.addElement(new SetComboLock(dis));
                            break;
                        }
                        case 50: {
                            actFrame.event.addElement(new ChgYourAct(dis));
                        }
                    }
                    ++i;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Vector get_FrameEvent() {
        return this.event;
    }

    public byte get_FrameDelay() {
        return this.frameDelay;
    }

    public byte get_FrameIndex() {
        return this.frameIndex;
    }

    public byte get_AtkJudge() {
        return this.atk_Judge;
    }

    public byte get_DefJudge() {
        return this.def_Judge;
    }
}

