/*
 * Decompiled with CFR 0.152.
 */
package role;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;
import role.ActFrame;
import role.ComboBrn;
import role.RoleAct;
import role.RoleManager;
import role.SkillCmd;

public class RoleObj {
    public String paleImgFileName;
    public String r_SpriteFName;
    public Sprite r_Sprite = null;
    public boolean r_SpriteRight = true;
    public byte spr_X_Count = 1;
    public byte spr_Y_Count = 1;
    public byte nemaIndex_InInterface = 0;
    public byte r_SkillCount = 0;
    public byte r_Credit = 0;
    public byte r_Camp = 0;
    public byte r_HostileCamp = 0;
    public byte r_Level = 0;
    public short r_Life = 0;
    public short r_MaxLife = 0;
    public short r_Magic = 0;
    public short r_MaxMagic = 0;
    public short r_Exp = 0;
    public short r_NextExp = 0;
    public short ownExp = 1;
    public short r_Kill = 0;
    public short r_pAtk = 0;
    public short r_pDef = 0;
    public short r_fAtk = 0;
    public short r_fDef = 0;
    public short r_mAtk = 0;
    public short r_mDef = 0;
    public short[][] level_table;
    public byte ai_type = 1;
    public boolean r_Visible = true;
    public boolean r_OperLock = false;
    public boolean r_right = true;
    public boolean death = false;
    public boolean lag = false;
    public long lagTime = 0L;
    public short hurtCount = 0;
    public short x_POS_Fix = 0;
    public short x_POS = 0;
    public short y_POS = 0;
    public short z_POS = 0;
    public short x_ORG_POS = 0;
    public short y_ORG_POS = 0;
    public short z_ORG_POS = 0;
    public short x_SCR_POS = 0;
    public short y_SCR_POS = 0;
    public short z_SCR_POS = 0;
    public short actArea_L = 0;
    public short actArea_U = 0;
    public short actArea_R = 0;
    public short actArea_D = 0;
    public byte pathType = 0;
    public byte g = (byte)3;
    public short distance = 0;
    public short fSpd = 0;
    public short vSpd = 0;
    public short time = 0;
    public short timeAdd = 0;
    public short angle = 0;
    public short z_angle = 0;
    public short z_fSpd = 0;
    public short z_vSpd = 0;
    public boolean eventChgActFrameIndex = false;
    public short actFrameIndex = 0;
    public short frameDelayCounter = 0;
    public short roleActRepeat = 0;
    public RoleAct roleAct;
    private int[][] paletteChgTable;
    public SkillCmd[] skillCmds;
    public SkillCmd[] usefulSkillCmd;
    public ComboBrn[] nowCombos;
    public ComboBrn[] comboTree;
    public byte comboRoot = 0;
    public boolean comboLock = false;
    public short comboAllowState = 0;
    public short lastComboAllowState = 0;
    public RoleAct[] standBy_Act;
    public RoleAct[] walk_Act;
    public RoleAct[] skill_Act;
    public RoleAct[] attack_Act;
    public RoleAct[] hurt_Act;
    public RoleAct[] down_Act;
    public RoleAct[] death_Act;
    public RoleAct[] naked_Act;
    public RoleAct[] entry_Act;
    public RoleAct[] levelUp_Act;

    public RoleObj(DataInputStream dis, RoleManager rm) {
        RoleObj.readRoleObj(dis, this);
        this.r_Sprite = rm.findSpr(this.r_SpriteFName, this.paleImgFileName, this.paletteChgTable, this.spr_X_Count, this.spr_Y_Count);
        if (this.comboTree != null) {
            this.getComboRoot(this.comboRoot);
        }
    }

    public void resetRoleObj(DataInputStream dis, RoleManager rm) {
        this.r_SpriteRight = true;
        this.r_SkillCount = 0;
        this.r_Credit = 0;
        this.r_Camp = 0;
        this.r_HostileCamp = 0;
        this.r_Level = 0;
        this.r_Life = 0;
        this.r_MaxLife = 0;
        this.r_Magic = 0;
        this.r_MaxMagic = 0;
        this.r_Exp = 0;
        this.r_NextExp = 0;
        this.ownExp = 0;
        this.r_Kill = 0;
        this.r_pAtk = 0;
        this.r_pDef = 0;
        this.r_fAtk = 0;
        this.r_fDef = 0;
        this.r_mAtk = 0;
        this.r_mDef = 0;
        this.level_table = null;
        this.ai_type = 1;
        this.r_Visible = true;
        this.r_OperLock = false;
        this.r_right = true;
        this.death = false;
        this.lag = false;
        this.lagTime = 0L;
        this.hurtCount = 0;
        this.x_POS_Fix = 0;
        this.x_POS = 0;
        this.y_POS = 0;
        this.z_POS = 0;
        this.x_ORG_POS = 0;
        this.y_ORG_POS = 0;
        this.z_ORG_POS = 0;
        this.x_SCR_POS = 0;
        this.y_SCR_POS = 0;
        this.z_SCR_POS = 0;
        this.actArea_L = 0;
        this.actArea_U = 0;
        this.actArea_R = 0;
        this.actArea_D = 0;
        this.pathType = 0;
        this.g = (byte)3;
        this.distance = 0;
        this.fSpd = 0;
        this.vSpd = 0;
        this.time = 0;
        this.timeAdd = 0;
        this.angle = 0;
        this.z_angle = 0;
        this.z_fSpd = 0;
        this.z_vSpd = 0;
        this.eventChgActFrameIndex = false;
        this.actFrameIndex = 0;
        this.frameDelayCounter = 0;
        this.roleActRepeat = 0;
        this.roleAct = null;
        this.comboRoot = 0;
        this.comboAllowState = 0;
        this.lastComboAllowState = 0;
        RoleObj.readRoleObj(dis, this);
        this.r_Sprite = rm.findSpr(this.r_SpriteFName, this.paleImgFileName, this.paletteChgTable, this.spr_X_Count, this.spr_Y_Count);
        if (this.comboTree != null) {
            this.getComboRoot(this.comboRoot);
        }
    }

    public static void readRoleObj(DataInputStream dis, RoleObj role) {
        Object tempImg = null;
        try {
            role.paleImgFileName = dis.readUTF();
            role.r_SpriteFName = dis.readUTF();
            role.spr_X_Count = dis.readByte();
            role.spr_Y_Count = dis.readByte();
            role.r_Camp = dis.readByte();
            role.r_HostileCamp = dis.readByte();
            role.r_Level = dis.readByte();
            role.r_Life = dis.readShort();
            role.r_MaxLife = dis.readShort();
            role.r_Magic = dis.readShort();
            role.r_MaxMagic = dis.readShort();
            role.r_Exp = dis.readShort();
            role.r_NextExp = dis.readShort();
            role.ownExp = dis.readShort();
            role.r_Kill = 0;
            role.r_pAtk = dis.readShort();
            role.r_pDef = dis.readShort();
            role.r_fAtk = dis.readShort();
            role.r_fDef = dis.readShort();
            role.r_mAtk = dis.readShort();
            role.r_mDef = dis.readShort();
            role.x_POS_Fix = dis.readShort();
            role.level_table = new short[dis.readByte()][dis.readByte()];
            int i = 0;
            while (i < role.level_table.length) {
                int j = 0;
                while (j < role.level_table[0].length) {
                    role.level_table[i][j] = dis.readShort();
                    ++j;
                }
                ++i;
            }
            Vector[] actNameVector = new Vector[10];
            int i2 = 0;
            while (i2 < actNameVector.length) {
                int actCount = dis.readByte();
                if (actCount > 0) {
                    actNameVector[i2] = new Vector();
                    int j = 0;
                    while (j < actCount) {
                        actNameVector[i2].addElement(dis.readUTF());
                        ++j;
                    }
                }
                ++i2;
            }
            int totalActs = dis.readByte();
            String[] roleActNames = new String[totalActs];
            RoleAct[] roleActs = new RoleAct[totalActs];
            int i3 = 0;
            while (i3 < totalActs) {
                roleActNames[i3] = dis.readUTF();
                roleActs[i3] = new RoleAct(dis);
                ++i3;
            }
            i3 = 0;
            while (i3 < actNameVector.length) {
                if (actNameVector[i3] != null) {
                    RoleAct[] tempAct = new RoleAct[actNameVector[i3].size()];
                    int j = 0;
                    while (j < actNameVector[i3].size()) {
                        int k = 0;
                        while (k < roleActNames.length) {
                            if (roleActNames[k].equals((String)actNameVector[i3].elementAt(j))) {
                                tempAct[j] = roleActs[k];
                            }
                            ++k;
                        }
                        ++j;
                    }
                    switch (i3) {
                        case 0: {
                            role.standBy_Act = tempAct;
                            break;
                        }
                        case 1: {
                            role.walk_Act = tempAct;
                            break;
                        }
                        case 2: {
                            role.levelUp_Act = tempAct;
                            break;
                        }
                        case 3: {
                            role.skill_Act = tempAct;
                            break;
                        }
                        case 4: {
                            role.attack_Act = tempAct;
                            break;
                        }
                        case 5: {
                            role.hurt_Act = tempAct;
                            break;
                        }
                        case 6: {
                            role.down_Act = tempAct;
                            break;
                        }
                        case 7: {
                            role.death_Act = tempAct;
                            break;
                        }
                        case 8: {
                            role.naked_Act = tempAct;
                            break;
                        }
                        case 9: {
                            role.entry_Act = tempAct;
                        }
                    }
                }
                ++i3;
            }
            role.readPaletteChgTable(dis, role);
            role.readSkillCmds(dis, role);
            role.readComboTree(dis, role);
            actNameVector = null;
            role.chgAct2Ready(0);
            dis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void readPaletteChgTable(DataInputStream dis, RoleObj role) {
        try {
            int size = dis.readShort();
            if (size > 0) {
                role.paletteChgTable = new int[size][2];
                int i = 0;
                while (i < size) {
                    role.paletteChgTable[i][0] = dis.readInt();
                    role.paletteChgTable[i][1] = dis.readInt();
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void readSkillCmds(DataInputStream dis, RoleObj role) {
        try {
            int size = dis.readByte();
            if (size > 0) {
                role.skillCmds = new SkillCmd[size];
                int i = 0;
                while (i < size) {
                    role.skillCmds[i] = new SkillCmd(dis);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void readComboTree(DataInputStream dis, RoleObj role) {
        try {
            int size = dis.readByte();
            if (size > 0) {
                role.comboTree = new ComboBrn[size];
                int i = 0;
                while (i < size) {
                    role.comboTree[i] = new ComboBrn(dis, 0, 0);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void initial() {
        this.r_SkillCount = 0;
        this.r_Credit = 0;
        this.r_Camp = 0;
        this.r_Level = 0;
        this.r_Life = 0;
        this.r_MaxLife = 0;
        this.r_Magic = 0;
        this.r_MaxMagic = 0;
        this.r_Exp = 0;
        this.r_NextExp = 0;
        this.r_Kill = 0;
        this.r_pAtk = 0;
        this.r_pDef = 0;
        this.r_fAtk = 0;
        this.r_fDef = 0;
        this.r_mAtk = 0;
        this.r_mDef = 0;
        this.r_Visible = true;
        this.r_OperLock = false;
        this.r_right = true;
        this.death = false;
        this.lag = false;
        this.lagTime = 0L;
        this.pathType = 0;
        this.g = 0;
        this.distance = 0;
        this.fSpd = 0;
        this.vSpd = 0;
        this.time = 0;
        this.timeAdd = 0;
        this.angle = 0;
        this.z_angle = 0;
        this.z_fSpd = 0;
        this.z_vSpd = 0;
    }

    public Vector getActEvent() {
        return this.roleAct.getEvent(this.actFrameIndex);
    }

    public void setActArea(int l, int u, int r, int d) {
        this.actArea_L = (short)(l - this.r_Sprite.getWidth() / 2);
        this.actArea_U = (short)(u - this.r_Sprite.getHeight() + 10);
        this.actArea_R = (short)(r - this.r_Sprite.getWidth() / 2);
        this.actArea_D = (short)(d - this.r_Sprite.getHeight() - 5);
    }

    public void setPath(int pathT) {
        this.x_ORG_POS = this.x_POS;
        this.y_ORG_POS = this.y_POS;
        this.z_ORG_POS = this.z_POS;
        if (pathT > -1) {
            this.pathType = (byte)pathT;
            this.time = 0;
        } else {
            System.out.println("Role : setPath Error !");
        }
    }

    public void setPath(int pathT, int G, int d, int fs, int vs, int tAdd, int a) {
        this.x_ORG_POS = this.x_POS;
        this.y_ORG_POS = this.y_POS;
        this.z_ORG_POS = this.z_POS;
        if (pathT >= 0) {
            this.pathType = (byte)pathT;
            this.g = (byte)G;
            this.distance = (short)d;
            this.fSpd = (short)fs;
            this.vSpd = (short)vs;
            this.time = 0;
            this.timeAdd = (short)tAdd;
            this.angle = (short)a;
        } else {
            System.out.println("Role : setPath Error !");
        }
    }

    public void setPath(int pathT, int G, int d, int fs, int vs, int tAdd) {
        this.x_ORG_POS = this.x_POS;
        this.y_ORG_POS = this.y_POS;
        this.z_ORG_POS = this.z_POS;
        if (pathT >= 0) {
            this.pathType = (byte)pathT;
            this.g = (byte)G;
            this.distance = (short)d;
            this.fSpd = (short)fs;
            this.vSpd = (short)vs;
            this.time = 0;
            this.timeAdd = (short)tAdd;
        }
    }

    public void setPath_Line(int vs, int tAdd, int a) {
        this.x_ORG_POS = this.x_POS;
        this.y_ORG_POS = this.y_POS;
        this.z_ORG_POS = this.z_POS;
        this.pathType = 1;
        this.vSpd = (short)vs;
        this.time = 1;
        this.timeAdd = (short)tAdd;
        this.angle = (short)a;
    }

    public void set_VX(int x) {
        this.x_POS = (short)x;
    }

    public short get_VX() {
        return this.x_POS;
    }

    public void set_VY(int y) {
        this.y_POS = (short)y;
    }

    public void set_VZ(int z) {
        this.z_POS = (short)z;
    }

    public short get_VZ() {
        return this.z_POS;
    }

    public void set_SCR_X(int x) {
        this.x_SCR_POS = (short)x;
    }

    public short get_SCR_X() {
        return this.x_SCR_POS;
    }

    public void set_SCR_Y(int y) {
        this.y_SCR_POS = (short)y;
    }

    public void set_SCR_Z(int z) {
        this.z_SCR_POS = (short)(z - this.r_Sprite.getHeight());
    }

    public short get_SCR_Z() {
        return (short)(this.z_POS + this.r_Sprite.getHeight());
    }

    public void set_F_SPD(int fs) {
        this.fSpd = (short)fs;
    }

    public void setAngle(int a) {
        this.angle = (short)a;
    }

    public void setZ_Angle(int a) {
        this.z_angle = (short)a;
    }

    public void setDeath(boolean d) {
        this.death = d;
    }

    public void setLag(int lagtime) {
        this.lag = true;
        this.lagTime = (long)lagtime + System.currentTimeMillis();
    }

    public void checkLag() {
        if (this.lag && System.currentTimeMillis() >= this.lagTime) {
            this.lag = false;
        }
    }

    public boolean isLag() {
        return this.lag;
    }

    public void setComboLock(boolean cl) {
        this.comboLock = cl;
    }

    public void setComboRoot(int b) {
        this.comboRoot = (byte)b;
    }

    public void setComboAllow(int b) {
        this.comboAllowState = (short)b;
    }

    public void countComboAllow() {
        this.lastComboAllowState = this.comboAllowState;
        this.comboAllowState = (short)(this.comboAllowState - 1);
        if (this.comboAllowState <= 0) {
            this.comboAllowState = 0;
            if (this.lastComboAllowState > 0) {
                this.nowCombos = null;
                this.getComboRoot(this.comboRoot);
            }
        }
    }

    public boolean comboAllow() {
        return (!this.comboLock && this.nowCombos[0].comboLayer == 0 || this.comboAllowState > 0) && !this.lag;
    }

    public void getComboRoot(int index) {
        if (index < this.comboTree.length) {
            this.nowCombos = new ComboBrn[1];
            this.nowCombos[0] = this.comboTree[index];
            this.usefulSkillCmd = new SkillCmd[1];
            int j = 0;
            while (j < this.skillCmds.length) {
                if (this.nowCombos[0].skillCode == this.skillCmds[j].skillCode) {
                    this.usefulSkillCmd[0] = this.skillCmds[j];
                }
                ++j;
            }
        }
    }

    public boolean getCombo(int index) {
        if (this.nowCombos == null) {
            return false;
        }
        if (this.nowCombos[index].nextCombo == null) {
            return false;
        }
        this.nowCombos = this.nowCombos[index].nextCombo;
        this.usefulSkillCmd = new SkillCmd[this.nowCombos.length];
        int i = 0;
        while (i < this.nowCombos.length) {
            int j = 0;
            while (j < this.skillCmds.length) {
                if (this.nowCombos[i].skillCode == this.skillCmds[j].skillCode) {
                    this.usefulSkillCmd[i] = this.skillCmds[j];
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public void addKill() {
        this.r_Kill = (short)(this.r_Kill + 1);
    }

    public void addExp(int exp) {
        if (exp <= 0) {
            return;
        }
        this.r_Exp = (short)(this.r_Exp + exp);
        while (this.r_Exp >= this.r_NextExp) {
            this.r_Exp = (short)(this.r_Exp - this.r_NextExp);
            if (this.r_NextExp <= 0) break;
            this.r_Level = (byte)(this.r_Level + 1);
            this.setLevel(this.r_Level);
        }
    }

    public void setLevel(int level) {
        int i = 0;
        while (i < this.level_table.length) {
            int j = 0;
            while (j < this.level_table[0].length) {
                if (this.level_table[i][0] == this.r_Level) {
                    this.r_NextExp = this.level_table[i][1];
                    this.r_MaxLife = this.level_table[i][2];
                    this.r_MaxMagic = this.level_table[i][3];
                    this.r_pAtk = this.level_table[i][4];
                    this.r_pDef = this.level_table[i][5];
                    this.r_fAtk = this.level_table[i][6];
                    this.r_fDef = this.level_table[i][7];
                    this.r_mAtk = this.level_table[i][8];
                    this.r_mDef = this.level_table[i][9];
                }
                ++j;
            }
            ++i;
        }
    }

    public void addLife(int value) {
        this.r_Life = (short)(this.r_Life + (short)value);
        if (value < 0 && this.comboTree != null) {
            this.getComboRoot(this.comboRoot);
        }
        if (this.r_Life < 0) {
            this.r_Life = 0;
        } else if (this.r_Life > this.r_MaxLife) {
            this.r_Life = this.r_MaxLife;
        }
    }

    public void nextFrame() {
        if (this.eventChgActFrameIndex) {
            this.eventChgActFrameIndex = false;
            return;
        }
        this.countComboAllow();
        if (!this.lag) {
            short s = this.frameDelayCounter;
            this.frameDelayCounter = (short)(s + 1);
            if (s >= this.roleAct.getActFrame(this.actFrameIndex).get_FrameDelay()) {
                this.frameDelayCounter = 0;
                short s2 = this.actFrameIndex;
                this.actFrameIndex = (short)(s2 + 1);
                if (s2 >= this.roleAct.actFrames.length - 1) {
                    this.actFrameIndex = 0;
                }
            }
            if ((this.hurtCount = (short)(this.hurtCount - 1)) < 0) {
                this.hurtCount = 0;
            }
        }
        this.checkLag();
    }

    public void chgAct2Ready(int index) {
        if (this.standBy_Act != null && this.roleAct != this.standBy_Act[index]) {
            this.setPath(0);
            this.roleAct = this.standBy_Act[index];
            this.actFrameIndex = 0;
            this.frameDelayCounter = 0;
        }
    }

    public void chgAct2Walk(int index) {
        if (this.walk_Act != null && this.roleAct != this.walk_Act[index]) {
            this.roleAct = this.walk_Act[index];
            this.actFrameIndex = 0;
            this.frameDelayCounter = 0;
        }
    }

    public void chgAct2LevelUp(int index) {
        if (this.levelUp_Act != null && this.roleAct != this.levelUp_Act[index] && index < this.levelUp_Act.length) {
            this.setPath(0);
            this.r_OperLock = true;
            this.comboLock = true;
            this.roleAct = this.levelUp_Act[index];
            this.actFrameIndex = 0;
            this.frameDelayCounter = 0;
        }
    }

    public void chgAct2Skill(int index) {
        if (this.skill_Act != null && this.roleAct != this.skill_Act[index]) {
            this.setPath(0);
            this.r_OperLock = true;
            this.comboLock = true;
            if (this.comboTree != null) {
                this.nowCombos = null;
                this.getComboRoot(this.comboRoot);
            }
            this.roleAct = this.skill_Act[index];
            this.actFrameIndex = 0;
            this.frameDelayCounter = 0;
        }
    }

    public void chgAct2Attack(int index) {
        if (this.attack_Act != null) {
            this.setPath(0);
            this.roleAct = this.attack_Act[index];
            this.actFrameIndex = 0;
            this.frameDelayCounter = 0;
        }
    }

    public void chgAct2Hurt(int index) {
        if (this.hurt_Act != null) {
            this.setPath(0);
            this.r_OperLock = true;
            this.comboLock = true;
            if (this.comboTree != null) {
                this.nowCombos = null;
                this.getComboRoot(this.comboRoot);
            }
            this.roleAct = this.hurt_Act[index];
            this.actFrameIndex = 0;
            this.frameDelayCounter = 0;
        }
    }

    public void chgAct2Down(int index) {
        if (this.down_Act != null && this.roleAct != this.down_Act[index]) {
            this.setPath(0);
            this.r_OperLock = true;
            this.comboLock = true;
            if (this.comboTree != null) {
                this.nowCombos = null;
                this.getComboRoot(this.comboRoot);
            }
            this.roleAct = this.down_Act[index];
            this.actFrameIndex = 0;
            this.frameDelayCounter = 0;
        }
    }

    public void chgAct2Death(int index) {
        if (this.death_Act != null && this.roleAct != this.death_Act[index]) {
            this.setPath(0);
            this.r_OperLock = true;
            this.comboLock = true;
            if (this.comboTree != null) {
                this.nowCombos = null;
                this.getComboRoot(this.comboRoot);
            }
            this.roleAct = this.death_Act[index];
            this.actFrameIndex = 0;
            this.frameDelayCounter = 0;
        }
    }

    public void chgAct2Naked(int index) {
        if (this.naked_Act != null && this.roleAct != this.naked_Act[index]) {
            this.setPath(0);
            this.r_OperLock = true;
            this.roleAct = this.naked_Act[index];
            this.actFrameIndex = 0;
            this.frameDelayCounter = 0;
        }
    }

    public void chgAct2Entry(int index) {
        if (this.entry_Act != null && this.roleAct != this.entry_Act[index]) {
            this.r_OperLock = true;
            this.comboLock = true;
            if (this.comboTree != null) {
                this.nowCombos = null;
                this.getComboRoot(this.comboRoot);
            }
            this.roleAct = this.entry_Act[index];
            this.actFrameIndex = 0;
            this.frameDelayCounter = 0;
        }
    }

    public byte getActFrameDelay() {
        return this.roleAct.actFrames[this.actFrameIndex].get_FrameDelay();
    }

    public boolean isActContains(RoleAct[] roleActArray, RoleAct roleAct) {
        if (roleActArray == null) {
            return false;
        }
        int i = 0;
        while (i < roleActArray.length) {
            if (roleActArray[i] == roleAct) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void chgSide(boolean turn) {
        if (this.r_right != turn) {
            this.r_right = turn;
            if (this.r_right) {
                this.x_POS = (short)(this.x_POS - this.x_POS_Fix);
                this.x_ORG_POS = (short)(this.x_ORG_POS - this.x_POS_Fix);
                this.x_SCR_POS = (short)(this.x_SCR_POS - this.x_POS_Fix);
            } else {
                this.x_POS = (short)(this.x_POS + this.x_POS_Fix);
                this.x_ORG_POS = (short)(this.x_ORG_POS + this.x_POS_Fix);
                this.x_SCR_POS = (short)(this.x_SCR_POS + this.x_POS_Fix);
            }
        }
    }

    public void paintSpr(Graphics g) {
        if (this.r_Visible && (this.x_SCR_POS > -200 || this.x_SCR_POS < 400)) {
            ActFrame actTemp = this.roleAct.actFrames[this.actFrameIndex];
            if (this.r_right == this.r_SpriteRight) {
                this.r_Sprite.setTransform(0);
            } else {
                this.r_Sprite.setTransform(2);
            }
            this.r_Sprite.setPosition((int)this.x_SCR_POS, this.y_POS + this.z_POS);
            this.r_Sprite.setFrame((int)actTemp.get_FrameIndex());
            this.r_Sprite.paint(g);
        }
    }
}

