/*
 * Decompiled with CFR 0.152.
 */
package com.kitmaker.boss;

import WelderTools.WeeldSprite;
import com.kitmaker.finalkombat2.Game;
import com.kitmaker.finalkombat2.Gfx;
import com.kitmaker.finalkombat2.Player;
import com.kitmaker.finalkombat2.enemigos.Bullet;
import com.kitmaker.finalkombat2.enemigos.Enemy;
import com.kitmaker.finalkombat2.resources.MissileRainSystem;
import javax.microedition.lcdui.Graphics;

public class Bazuka
extends Enemy {
    private int width;
    private int height;
    private boolean facingRight;
    private int reactionDistanceXLeft;
    private int reactionDistanceXRight;
    private int reactionDistanceYTop;
    private int reactionDistanceYBottom;
    private int initialPosX;
    private int initialPosY;
    private int fire_rate;
    private int time;
    private int recover_timer;
    private int reaction_timer;
    private int reaction_time;
    private int stunned_time;
    private int special_hit_aiming_time;
    private int special_hit_rest_time;
    private boolean blink;
    private Bullet[] bulletPool = new Bullet[5];
    private MissileRainSystem missile;
    private boolean camera_locked = false;
    private int phase_state;
    private final int PHASE_START;
    private final int PHASE_PROCESING;
    private final int PHASE_ENDED;
    private int phase;
    private int previous_phase;
    private final int PHASE_A;
    private final int PHASE_B;
    private int state;
    public static final int IDLE = 0;
    public static final int PRE_AIM_UP = 1;
    public static final int AIMING_UP = 2;
    public static final int SHOOTING_UP = 3;
    public static final int PRE_AIM_DOWN = 4;
    public static final int AIMING_DOWN = 5;
    public static final int SHOOTING_DOWN = 6;
    public static final int HITTED_UP = 7;
    public static final int HITTED_DOWN = 8;
    public static final int PRE_SPECIAL_HIT_AIM = 9;
    public static final int SPECIAL_HIT_AIMING = 10;
    public static final int SPECIAL_HIT_SHOOTING = 11;
    public static final int DEATH_DOWN = 12;
    public static final int DEATH_UP = 13;
    private String bazukaPngPath = "/bazooka.png";
    private String bazukaAnuPath = "/bazooka.anu";
    private boolean shooted = false;

    public Bazuka(int _ID, int _posX, int _posY) {
        this.PHASE_START = 0;
        this.PHASE_PROCESING = 1;
        this.PHASE_ENDED = 2;
        this.PHASE_A = 0;
        this.PHASE_B = 1;
        this.posX = _posX;
        this.posY = _posY;
        this.width = 64;
        this.height = 64;
        this.state = 0;
        this.health = 13;
        this.initialPosX = this.posX;
        this.initialPosY = this.posY;
        this.reactionDistanceXLeft = this.initialPosX - 256;
        this.reactionDistanceXRight = this.initialPosX + 256;
        this.reactionDistanceYTop = this.initialPosY - 160;
        this.reactionDistanceYBottom = this.initialPosY + 32 + 8;
        this.enemySprite = new WeeldSprite(_ID, new String[]{this.bazukaPngPath, "/fx_01.png", "/fx_04.png"}, this.bazukaAnuPath, _posX, _posY, Gfx.totalWeeldSprite);
        this.enemySprite.loadPoolImage();
        this.enemySprite.setAnimation(0, true);
        this.facingRight = true;
        this.phase = 0;
        this.phase_state = 0;
        this.previous_phase = this.phase = 0;
        this.camera_locked = false;
        this.phase_state = 0;
        for (int i = 0; i < this.bulletPool.length; ++i) {
            this.bulletPool[i] = new Bullet(this.GetPivotX(), this.GetPivotY(), true, true);
            this.bulletPool[i].setAlive(false);
        }
        this.blink = false;
        this.reaction_timer = 0;
        this.recover_timer = (int)System.currentTimeMillis();
        this.time = (int)System.currentTimeMillis();
        this.shooted = false;
        this.reaction_time = 1300;
        this.stunned_time = 1300;
        this.fire_rate = 1100;
        this.special_hit_aiming_time = 700;
        this.special_hit_rest_time = 3000;
        this.missile = new MissileRainSystem(6, this.GetPivotX(), this.GetPivotY() - 128);
    }

    public void UpdateIA() {
        this.runStopframesByHit();
        for (int i = 0; i < this.bulletPool.length; ++i) {
            if (!this.bulletPool[i].isAlive()) continue;
            this.bulletPool[i].update();
        }
        if (this.state != 12 && this.state != 13) {
            this.Flip();
        }
        this.missile.Update();
        this.enemySprite.update();
        if (this.PlayerIsInBossArea()) {
            if ((int)System.currentTimeMillis() - this.reaction_timer > this.reaction_time) {
                this.CheckAnimation();
                if (this.state != 12 && this.state != 13) {
                    if (!Player.isDead()) {
                        this.Behavior();
                    } else if (this.enemySprite.getAnimation() != 0) {
                        this.enemySprite.setAnimation(0, true);
                    }
                }
                if (this.CheckCollisionWithPlayer()) {
                    Player.lessLife(20, !Player.getOrientation(), true, false);
                }
                this.PlayerHitBoss();
            }
        } else if (this.enemySprite.getAnimation() != 0) {
            this.enemySprite.setAnimation(0, true);
        }
        if (Player.getY() + Player.getHeight() > 896) {
            while (Player.getY() + Player.getHeight() > 896) {
                --Player.posYplayer;
            }
        }
    }

    private void CheckAnimation() {
        switch (this.state) {
            case 0: {
                if (this.enemySprite.getAnimation() == 0) break;
                this.enemySprite.setAnimation(0, true);
                break;
            }
            case 1: {
                if (this.enemySprite.getAnimation() != 1) {
                    this.enemySprite.setAnimation(1, false);
                }
                if (!this.enemySprite.loopFinished()) break;
                this.state = 2;
                break;
            }
            case 2: {
                if (this.enemySprite.getAnimation() != 2) {
                    this.enemySprite.setAnimation(2, false);
                }
                if (!this.enemySprite.loopFinished()) break;
                this.state = 3;
                break;
            }
            case 3: {
                if (this.enemySprite.getAnimation() != 3) {
                    this.enemySprite.setAnimation(3, false);
                }
                if (!this.enemySprite.loopFinished()) break;
                this.state = 0;
                break;
            }
            case 4: {
                if (this.enemySprite.getAnimation() != 4) {
                    this.enemySprite.setAnimation(4, false);
                }
                if (!this.enemySprite.loopFinished()) break;
                this.state = 5;
                break;
            }
            case 5: {
                if (this.enemySprite.getAnimation() != 5) {
                    this.enemySprite.setAnimation(5, false);
                }
                if (!this.enemySprite.loopFinished()) break;
                this.state = 6;
                break;
            }
            case 6: {
                if (this.enemySprite.getAnimation() != 6) {
                    this.enemySprite.setAnimation(6, false);
                }
                if (!this.enemySprite.loopFinished()) break;
                this.state = 0;
                break;
            }
            case 7: {
                if (this.enemySprite.getAnimation() != 7) {
                    this.enemySprite.setAnimation(7, false);
                }
                if (!this.enemySprite.loopFinished() || (int)System.currentTimeMillis() - this.time <= this.stunned_time) break;
                this.state = 9;
                break;
            }
            case 8: {
                if (this.enemySprite.getAnimation() != 8) {
                    this.enemySprite.setAnimation(8, false);
                }
                if (!this.enemySprite.loopFinished() || (int)System.currentTimeMillis() - this.time <= this.stunned_time) break;
                this.state = 9;
                break;
            }
            case 9: {
                if (this.enemySprite.getAnimation() != 9) {
                    this.enemySprite.setAnimation(9, false);
                }
                if (!this.enemySprite.loopFinished()) break;
                this.time = (int)System.currentTimeMillis();
                this.state = 10;
                break;
            }
            case 10: {
                if (this.enemySprite.getAnimation() != 10) {
                    this.enemySprite.setAnimation(10, false);
                }
                if (!this.enemySprite.loopFinished() || (int)System.currentTimeMillis() - this.time <= this.special_hit_aiming_time) break;
                this.state = 11;
                break;
            }
            case 11: {
                if (this.enemySprite.getAnimation() != 11) {
                    this.enemySprite.setAnimation(11, false);
                }
                if (!this.enemySprite.loopFinished()) break;
                this.missile.LaunchMissiles();
                this.state = 0;
                this.recover_timer = (int)System.currentTimeMillis();
                break;
            }
            case 12: {
                if (this.enemySprite.getAnimation() != 12) {
                    this.enemySprite.setAnimation(12, false);
                }
                if (!this.enemySprite.loopFinished() || (int)System.currentTimeMillis() - this.time <= 0) break;
                Game.isInTheGetho = true;
                break;
            }
            case 13: {
                if (this.enemySprite.getAnimation() != 13) {
                    this.enemySprite.setAnimation(13, false);
                }
                if (!this.enemySprite.loopFinished() || (int)System.currentTimeMillis() - this.time <= 0) break;
                Game.isInTheGetho = true;
            }
        }
    }

    private void Behavior() {
        block34: {
            block35: {
                block33: {
                    if (this.health < 10) break block33;
                    block0 : switch (this.phase) {
                        case 0: {
                            switch (this.phase_state) {
                                case 0: {
                                    if (this.Recover()) {
                                        this.phase_state = 1;
                                        break block0;
                                    }
                                    break block34;
                                }
                                case 1: {
                                    this.PhaseA();
                                    break block0;
                                }
                                case 2: {
                                    this.previous_phase = this.phase;
                                    this.phase = 0;
                                    this.phase_state = 0;
                                }
                            }
                        }
                    }
                    break block34;
                }
                if (this.health < 6) break block35;
                block8 : switch (this.phase) {
                    case 1: {
                        switch (this.phase_state) {
                            case 0: {
                                if (this.Recover()) {
                                    this.phase_state = 1;
                                    break block8;
                                }
                                break block34;
                            }
                            case 1: {
                                this.PhaseB();
                                break block8;
                            }
                            case 2: {
                                this.previous_phase = this.phase;
                                this.phase = 1;
                                this.phase_state = 0;
                            }
                        }
                    }
                }
                break block34;
            }
            if (this.health < 1) break block34;
            block16 : switch (this.phase) {
                case 0: {
                    switch (this.phase_state) {
                        case 0: {
                            if (!this.Recover()) break;
                            this.phase_state = 1;
                            break;
                        }
                        case 1: {
                            this.PhaseA();
                            break;
                        }
                        case 2: {
                            this.previous_phase = this.phase;
                            this.phase = 1;
                            this.phase_state = 0;
                        }
                    }
                    break;
                }
                case 1: {
                    switch (this.phase_state) {
                        case 0: {
                            if (this.Recover()) {
                                this.phase_state = 1;
                                break block16;
                            }
                            break block34;
                        }
                        case 1: {
                            this.PhaseB();
                            break block16;
                        }
                        case 2: {
                            this.previous_phase = this.phase;
                            this.phase = 0;
                            this.phase_state = 0;
                        }
                    }
                }
            }
        }
    }

    private void PhaseA() {
        if (this.phase != 0) {
            this.phase = 0;
        }
        switch (this.state) {
            case 0: {
                if ((int)System.currentTimeMillis() - this.time <= this.fire_rate) break;
                this.state = 1;
                this.shooted = false;
                break;
            }
            case 3: {
                if (!this.shooted) {
                    for (int i = 0; i < this.bulletPool.length; ++i) {
                        if (this.bulletPool[i].isAlive()) continue;
                        if (this.facingRight) {
                            this.bulletPool[i].setPosX(this.GetPivotX() + 64 - 8);
                        } else {
                            this.bulletPool[i].setPosX(this.GetPivotX() - 64 + 8);
                        }
                        this.bulletPool[i].setPosY(this.GetPivotY() - 32);
                        this.bulletPool[i].setDirection(this.facingRight);
                        this.bulletPool[i].setAlive(true);
                        this.shooted = true;
                        break;
                    }
                }
                if (!this.enemySprite.loopFinished()) break;
                this.time = (int)System.currentTimeMillis();
                this.phase_state = 2;
            }
        }
    }

    private void PhaseB() {
        if (this.phase != 1) {
            this.phase = 1;
        }
        switch (this.state) {
            case 0: {
                if ((int)System.currentTimeMillis() - this.time <= this.fire_rate) break;
                this.state = 4;
                this.shooted = false;
                break;
            }
            case 6: {
                if (!this.shooted) {
                    for (int i = 0; i < this.bulletPool.length; ++i) {
                        if (this.bulletPool[i].isAlive()) continue;
                        if (this.facingRight) {
                            this.bulletPool[i].setPosX(this.GetPivotX() + 64 - 16);
                        } else {
                            this.bulletPool[i].setPosX(this.GetPivotX() - 64 + 16);
                        }
                        this.bulletPool[i].setPosY(this.GetPivotY() - 6);
                        this.bulletPool[i].setDirection(this.facingRight);
                        this.bulletPool[i].setAlive(true);
                        this.shooted = true;
                        break;
                    }
                }
                if (!this.enemySprite.loopFinished()) break;
                this.time = (int)System.currentTimeMillis();
                this.phase_state = 2;
            }
        }
    }

    public void Paint(Graphics g) {
        for (int i = 0; i < this.bulletPool.length; ++i) {
            if (!this.bulletPool[i].isAlive()) continue;
            this.bulletPool[i].paint(g);
        }
        this.enemySprite.setDrawPosition(this.posX + 16 - Game.getScrollX() + this.m_iHittedExtraX, this.posY + 32 - Game.getScrollY());
        if (!this.blink) {
            this.enemySprite.drawFrame(g);
        }
        this.missile.Draw(g);
    }

    private boolean PlayerIsInBossArea() {
        if (Player.getX() >= this.reactionDistanceXLeft && Player.getX() <= this.reactionDistanceXRight && Player.getY() + Player.getHeight() >= this.reactionDistanceYTop && Player.getY() + Player.getHeight() <= this.reactionDistanceYBottom) {
            if (this.reaction_timer == 0) {
                this.reaction_timer = (int)System.currentTimeMillis();
            }
            return true;
        }
        return false;
    }

    private boolean Recover() {
        return this.state == 0 && (int)System.currentTimeMillis() - this.recover_timer > this.special_hit_rest_time;
    }

    public void DeleteMotionWeelderData() {
        try {
            this.enemySprite.unloadPoolImage();
            this.enemySprite.unloadSpriteData();
            this.enemySprite = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int GetPivotX() {
        return this.posX + 16;
    }

    private int GetPivotY() {
        return this.posY;
    }

    private boolean CheckCollisionWithPlayer() {
        return (this.state == 3 || this.state == 6 || this.state == 9 || this.state == 10) && Math.abs(this.GetPivotX() - (Player.getX() + (Player.getWidth() >> 1))) < (this.width >> 1) + (this.width >> 2) && Math.abs(this.GetPivotY() - (Player.getY() + (Player.getHeight() >> 1))) < (this.height >> 1) + (this.height >> 2);
    }

    private void PlayerHitBoss() {
        if (this.m_iHittedCount < Player.ms_lPlayeHitCount && (this.state != 12 || this.state != 13) && this.state != 9 && this.state != 10 && this.state != 11 && this.state != 8 && this.state != 7) {
            if (Math.abs(this.GetPivotX() - (Player.getX() + (Player.getWidth() >> 1))) < this.width && Math.abs(this.GetPivotY() - (Player.getY() + (Player.getHeight() >> 1))) < this.height >> 1) {
                if ((Player.getAnimation() == 2 || Player.getAnimation() == 3 || Player.getAnimation() == 4) && Player.getFrame() == 1) {
                    this.SubstractHealth(1);
                    return;
                }
                if (Player.getAnimation() == 6) {
                    this.SubstractHealth(2);
                    return;
                }
                if (Player.getAnimation() == 13 && Player.getFrame() == 3) {
                    this.SubstractHealth(3);
                    return;
                }
            }
            if (Player.getAnimation() == 15) {
                if (this.GetPivotX() > Player.getX() + (Player.getWidth() >> 1)) {
                    if (Player.getOrientation() && Player.getFrame() > 16 && Player.getFrame() < 24) {
                        this.SubstractHealth(1);
                    }
                } else if (!Player.getOrientation() && Player.getFrame() > 16 && Player.getFrame() < 24) {
                    this.SubstractHealth(1);
                }
            }
        }
    }

    private void SubstractHealth(int amount) {
        this.health -= amount;
        Player.colisionFist(amount, true, true);
        Game.setQuake(35);
        this.time = (int)System.currentTimeMillis();
        if (this.health > 0) {
            switch (this.state) {
                case 0: 
                case 1: 
                case 2: {
                    this.state = 7;
                    break;
                }
                case 4: 
                case 5: {
                    this.state = 8;
                }
            }
        } else {
            this.isDead = true;
            this.health = 0;
            switch (this.state) {
                case 0: 
                case 1: 
                case 2: {
                    this.time = (int)System.currentTimeMillis();
                    Game.time = (int)System.currentTimeMillis();
                    this.state = 13;
                    break;
                }
                case 4: 
                case 5: {
                    this.time = (int)System.currentTimeMillis();
                    Game.time = (int)System.currentTimeMillis();
                    this.state = 12;
                }
            }
        }
        this.initStopframesByHit(amount);
        this.phase_state = 2;
        if (this.health >= 10) {
            this.phase = 0;
        } else if (this.health >= 6) {
            this.phase = 1;
        }
    }

    private void Flip() {
        if (Player.getX() > this.posX && !this.facingRight) {
            this.enemySprite.setSpriteOrientation((byte)0);
            this.facingRight = true;
        } else if (Player.getX() < this.posX && this.facingRight) {
            this.enemySprite.setSpriteOrientation((byte)1);
            this.facingRight = false;
        }
    }
}

