/*
 * Decompiled with CFR 0.152.
 */
package com.kitmaker.boss;

import WelderTools.WeeldSprite;
import com.kitmaker.finalkombat2.Game;
import com.kitmaker.finalkombat2.Gfx;
import com.kitmaker.finalkombat2.Player;
import com.kitmaker.finalkombat2.SP;
import com.kitmaker.finalkombat2.enemigos.Bullet;
import com.kitmaker.finalkombat2.enemigos.Enemy;
import javax.microedition.lcdui.Graphics;

public class MadTank
extends Enemy {
    private int width;
    private int height;
    private int reactionDistanceXLeft;
    private int reactionDistanceXLeftColision;
    private int reactionDistanceXRight;
    private int reactionDistanceYTop;
    private int reactionDistanceYBottom;
    private int initialPosX;
    private int initialPosY;
    private int moveSpeed;
    private int shooting_delay;
    private int time;
    private int reaction_timer;
    private int reaction_time;
    private int stunned_time;
    private int laser_charge_time;
    private boolean blink;
    private boolean blinkLowDevice;
    private boolean startBlinkLowDevice;
    private Bullet[] bulletPool = new Bullet[5];
    private boolean camera_locked = false;
    private int phase_state;
    private final int PHASE_START;
    private final int PHASE_PROCESING;
    private final int PHASE_ENDED;
    private int phase;
    private int previous_phase;
    private final int PHASE_A;
    private final int PHASE_B;
    private final int PHASE_C;
    private int state;
    private final int IDLE;
    private final int SHOOTING;
    private final int PREPARING_LASER;
    private final int CHARGING_LASER;
    private final int LASER;
    private final int START_MOVING;
    private final int MOVING;
    private final int PLAYER_HITTED;
    private final int WALL_HITTED;
    private final int STUNNED;
    private final int HITTED;
    private final int DEAD;
    private final int RECOVER;
    private final int STOP_LASER;
    private int desplazamientoCamara;
    private String tankPngPath = "/tank.png";
    private String tankAnuPath = "/tank.anu";
    private int bullets_count = 0;
    private int moving_phase = 0;
    private final int SWITCH_ON;
    private final int DRIVING;
    private final int FOUND_PLAYER;
    private final int FOUND_WALL;

    public MadTank(int _ID, int _posX, int _posY) {
        this.PHASE_START = 0;
        this.PHASE_PROCESING = 1;
        this.PHASE_ENDED = 2;
        this.PHASE_A = 0;
        this.PHASE_B = 1;
        this.PHASE_C = 2;
        this.IDLE = 0;
        this.SHOOTING = 1;
        this.PREPARING_LASER = 2;
        this.CHARGING_LASER = 3;
        this.LASER = 4;
        this.START_MOVING = 5;
        this.MOVING = 6;
        this.PLAYER_HITTED = 7;
        this.WALL_HITTED = 8;
        this.STUNNED = 9;
        this.HITTED = 10;
        this.DEAD = 11;
        this.RECOVER = 12;
        this.STOP_LASER = 13;
        this.SWITCH_ON = 0;
        this.DRIVING = 1;
        this.FOUND_PLAYER = 2;
        this.FOUND_WALL = 3;
        this.posX = _posX;
        this.posY = _posY;
        this.width = 64;
        this.height = 48;
        this.state = 0;
        this.health = 30;
        this.initialPosX = this.posX;
        this.initialPosY = this.posY;
        this.reactionDistanceXLeft = 824;
        this.reactionDistanceXLeftColision = 832;
        this.reactionDistanceXRight = this.initialPosX + 64;
        this.reactionDistanceYTop = this.initialPosY - 160;
        this.reactionDistanceYBottom = this.initialPosY + 32 + 8;
        this.enemySprite = new WeeldSprite(_ID, new String[]{this.tankPngPath, "/fx_01.png", "/fx_02.png", "/fx_03.png", "/fx_05.png", "/fx_06.png"}, this.tankAnuPath, _posX, _posY, Gfx.totalWeeldSprite);
        this.enemySprite.loadPoolImage();
        this.enemySprite.setAnimation(0, true);
        this.moveSpeed = 8;
        this.reaction_time = 1500;
        this.phase = 0;
        this.phase_state = 0;
        this.previous_phase = this.phase = 0;
        this.camera_locked = false;
        this.shooting_delay = 1600;
        this.phase_state = 0;
        this.stunned_time = 5500;
        this.laser_charge_time = 3000;
        for (int i = 0; i < this.bulletPool.length; ++i) {
            this.bulletPool[i] = new Bullet(this.GetPivotX(), this.GetPivotY(), false, false);
        }
        this.blink = false;
        this.desplazamientoCamara = 7;
    }

    public void UpdateIA() {
        this.runStopframesByHit();
        if (this.camera_locked) {
            if (!SP.TouchDevice) {
                Game.putCamara(this.reactionDistanceXLeft, this.initialPosY - 32 * this.desplazamientoCamara);
            } else {
                Game.putCamara(this.reactionDistanceXLeft, this.initialPosY - 32 * this.desplazamientoCamara + 64);
            }
        }
        for (int i = 0; i < this.bulletPool.length; ++i) {
            if (!this.bulletPool[i].isAlive()) continue;
            this.bulletPool[i].update();
        }
        this.enemySprite.update();
        if (this.PlayerIsInBossArea()) {
            if ((int)System.currentTimeMillis() - this.reaction_timer > this.reaction_time) {
                this.CheckAnimation();
                if (this.state != 10 && this.state != 11) {
                    if (!Player.isDead()) {
                        this.Behavior();
                    } else if (this.enemySprite.getAnimation() != 0) {
                        this.enemySprite.setAnimation(0, true);
                    }
                }
                if (this.CheckCollisionWithPlayer() && this.state != 10 && this.state != 11 && this.state != 9 && this.state != 8) {
                    if (!Player.isCroch) {
                        Player.lessLife(18, false, true, false);
                    } else {
                        Player.lessLife(18, false, false, false);
                    }
                    if (this.state == 6) {
                        this.state = 7;
                        this.moving_phase = 2;
                    }
                }
                this.PlayerHitBoss();
            }
        } else if (this.enemySprite.getAnimation() != 0) {
            this.enemySprite.setAnimation(0, true);
        }
        if (Game.isStopCamera()) {
            while (Player.getX() < 832) {
                Player.moveX(1);
            }
            while (Player.getX() > 1056) {
                Player.moveX(-1);
            }
        }
    }

    private void CheckAnimation() {
        switch (this.state) {
            case 0: {
                if (this.enemySprite.getAnimation() == 0) break;
                this.enemySprite.setAnimation(0, true);
                break;
            }
            case 1: {
                if (this.enemySprite.getAnimation() != 1) {
                    this.enemySprite.setAnimation(1, false);
                }
                if (!this.enemySprite.loopFinished()) break;
                this.state = 0;
                break;
            }
            case 2: {
                if (this.enemySprite.getAnimation() != 2) {
                    this.enemySprite.setAnimation(2, false);
                }
                if (!this.enemySprite.loopFinished()) break;
                this.state = 3;
                this.time = (int)System.currentTimeMillis();
                break;
            }
            case 3: {
                if (this.enemySprite.getAnimation() == 3) break;
                this.enemySprite.setAnimation(3, true);
                break;
            }
            case 4: {
                if (this.enemySprite.getAnimation() != 4) {
                    this.enemySprite.setAnimation(4, false);
                }
                if (!this.enemySprite.loopFinished()) break;
                this.state = 13;
                break;
            }
            case 5: {
                if (this.enemySprite.getAnimation() != 5) {
                    this.enemySprite.setAnimation(5, false);
                }
                if (!this.enemySprite.loopFinished()) break;
                this.state = 6;
                this.moving_phase = 1;
                break;
            }
            case 6: {
                if (this.enemySprite.getAnimation() != 6) {
                    this.enemySprite.setAnimation(6, true);
                }
                if (!this.CheckCollisionWithPlayer()) break;
                this.state = 7;
                this.moving_phase = 2;
                break;
            }
            case 7: {
                if (this.enemySprite.getAnimation() != 7) {
                    this.enemySprite.setAnimation(7, false);
                }
                if (!this.enemySprite.loopFinished()) break;
                this.state = 0;
                break;
            }
            case 8: {
                if (this.enemySprite.getAnimation() != 8) {
                    this.enemySprite.setAnimation(8, false);
                }
                if (!this.enemySprite.loopFinished()) break;
                this.state = 9;
                break;
            }
            case 9: {
                if (this.enemySprite.getAnimation() != 9) {
                    this.enemySprite.setAnimation(9, true);
                }
                if (SP.isFastDevice) {
                    if ((int)System.currentTimeMillis() - this.time <= (this.stunned_time >> 1) + (this.stunned_time >> 2)) break;
                    this.blink = SP.isModule(SP.iFrame);
                    break;
                }
                if ((int)System.currentTimeMillis() - this.time <= (this.stunned_time >> 1) + (this.stunned_time >> 2)) break;
                this.startBlinkLowDevice = true;
                break;
            }
            case 10: {
                if (this.enemySprite.getAnimation() != 10) {
                    this.enemySprite.setAnimation(10, false);
                }
                if (SP.isFastDevice) {
                    if ((int)System.currentTimeMillis() - this.time > (this.stunned_time >> 1) + (this.stunned_time >> 2)) {
                        this.blink = SP.isModule(SP.iFrame);
                    }
                } else {
                    this.startBlinkLowDevice = true;
                }
                if (!this.enemySprite.loopFinished()) break;
                this.state = 9;
                break;
            }
            case 11: {
                if (this.enemySprite.getAnimation() != 11) {
                    this.enemySprite.setAnimation(11, false);
                }
                if (!this.enemySprite.loopFinished() || (int)System.currentTimeMillis() - this.time <= 0) break;
                Game.isInTheGetho = true;
                break;
            }
            case 12: {
                if (this.enemySprite.getAnimation() != 12) {
                    this.enemySprite.setAnimation(12, false);
                }
                if (!this.enemySprite.loopFinished()) break;
                this.state = 0;
                break;
            }
            case 13: {
                if (this.enemySprite.getAnimation() != 13) {
                    this.enemySprite.setAnimation(13, false);
                }
                if (!this.enemySprite.loopFinished()) break;
                this.state = 0;
            }
        }
    }

    private void Behavior() {
        block82: {
            block84: {
                block83: {
                    block81: {
                        if (this.health < 15) break block81;
                        block0 : switch (this.phase) {
                            case 0: {
                                switch (this.phase_state) {
                                    case 0: {
                                        if (!this.Reposition()) break;
                                        this.bullets_count = 0;
                                        this.phase_state = 1;
                                        break block0;
                                    }
                                    case 1: {
                                        if (this.bullets_count <= 4) {
                                            this.PhaseA();
                                            break block0;
                                        }
                                        this.phase_state = 2;
                                        break block0;
                                    }
                                    case 2: {
                                        this.previous_phase = this.phase;
                                        this.phase = 2;
                                        this.phase_state = 0;
                                    }
                                }
                                break;
                            }
                            case 2: {
                                switch (this.phase_state) {
                                    case 0: {
                                        if (this.Reposition()) {
                                            this.moving_phase = 0;
                                            this.phase_state = 1;
                                            break block0;
                                        }
                                        break block82;
                                    }
                                    case 1: {
                                        this.PhaseC();
                                        break block0;
                                    }
                                    case 2: {
                                        this.previous_phase = this.phase;
                                        this.phase = 0;
                                        this.phase_state = 0;
                                    }
                                }
                            }
                        }
                        break block82;
                    }
                    if (this.health < 10) break block83;
                    block14 : switch (this.phase) {
                        case 1: {
                            switch (this.phase_state) {
                                case 0: {
                                    if (!this.Reposition()) break;
                                    this.state = 2;
                                    this.phase_state = 1;
                                    break block14;
                                }
                                case 1: {
                                    this.PhaseB();
                                    break block14;
                                }
                                case 2: {
                                    this.previous_phase = this.phase;
                                    this.phase = 2;
                                    this.phase_state = 0;
                                }
                            }
                            break;
                        }
                        case 2: {
                            switch (this.phase_state) {
                                case 0: {
                                    if (this.Reposition()) {
                                        this.moving_phase = 0;
                                        this.phase_state = 1;
                                        break block14;
                                    }
                                    break block82;
                                }
                                case 1: {
                                    this.PhaseC();
                                    break block14;
                                }
                                case 2: {
                                    this.previous_phase = this.phase;
                                    this.phase = 1;
                                    this.phase_state = 0;
                                }
                            }
                        }
                    }
                    break block82;
                }
                if (this.health < 5) break block84;
                block28 : switch (this.phase) {
                    case 0: {
                        switch (this.phase_state) {
                            case 0: {
                                if (!this.Reposition()) break;
                                this.bullets_count = 0;
                                this.phase_state = 1;
                                break block28;
                            }
                            case 1: {
                                if (this.bullets_count <= 4) {
                                    this.PhaseA();
                                    break block28;
                                }
                                this.phase_state = 2;
                                break block28;
                            }
                            case 2: {
                                if (this.previous_phase != 1) {
                                    this.previous_phase = this.phase;
                                    this.phase = 1;
                                } else {
                                    this.previous_phase = this.phase;
                                    this.phase = 2;
                                }
                                this.phase_state = 0;
                            }
                        }
                        break;
                    }
                    case 1: {
                        switch (this.phase_state) {
                            case 0: {
                                if (!this.Reposition()) break;
                                this.state = 2;
                                this.phase_state = 1;
                                break block28;
                            }
                            case 1: {
                                this.PhaseB();
                                break block28;
                            }
                            case 2: {
                                this.previous_phase = this.phase;
                                this.phase = 0;
                                this.phase_state = 0;
                            }
                        }
                        break;
                    }
                    case 2: {
                        switch (this.phase_state) {
                            case 0: {
                                if (this.Reposition()) {
                                    this.moving_phase = 0;
                                    this.phase_state = 1;
                                    break block28;
                                }
                                break block82;
                            }
                            case 1: {
                                this.PhaseC();
                                break block28;
                            }
                            case 2: {
                                this.previous_phase = this.phase;
                                this.phase = 0;
                                this.phase_state = 0;
                            }
                        }
                    }
                }
                break block82;
            }
            if (this.health < 1) break block82;
            block48 : switch (this.phase) {
                case 0: {
                    switch (this.phase_state) {
                        case 0: {
                            if (!this.Reposition()) break;
                            this.bullets_count = 0;
                            this.phase_state = 1;
                            break;
                        }
                        case 1: {
                            if (this.bullets_count <= 4) {
                                this.PhaseA();
                                break;
                            }
                            this.phase_state = 2;
                            break;
                        }
                        case 2: {
                            if (this.previous_phase != 1) {
                                this.previous_phase = this.phase;
                                this.phase = 1;
                            } else {
                                this.previous_phase = this.phase;
                                this.phase = 2;
                            }
                            this.phase_state = 0;
                        }
                    }
                    break;
                }
                case 1: {
                    switch (this.phase_state) {
                        case 0: {
                            if (!this.Reposition()) break;
                            this.state = 2;
                            this.phase_state = 1;
                            break;
                        }
                        case 1: {
                            this.PhaseB();
                            break;
                        }
                        case 2: {
                            if (this.previous_phase == 0) {
                                this.previous_phase = this.phase;
                                this.phase = 1;
                            } else {
                                this.previous_phase = this.phase;
                                this.phase = 0;
                            }
                            this.phase_state = 0;
                        }
                    }
                    break;
                }
                case 2: {
                    switch (this.phase_state) {
                        case 0: {
                            if (this.Reposition()) {
                                this.moving_phase = 0;
                                this.phase_state = 1;
                                break block48;
                            }
                            break block82;
                        }
                        case 1: {
                            this.PhaseC();
                            break block48;
                        }
                        case 2: {
                            this.previous_phase = this.phase;
                            this.phase = 0;
                            this.phase_state = 0;
                        }
                    }
                }
            }
        }
    }

    private void PhaseA() {
        if (this.phase != 0) {
            this.phase = 0;
        }
        if ((int)System.currentTimeMillis() - this.time > this.shooting_delay) {
            switch (this.state) {
                case 0: {
                    for (int i = 0; i < this.bulletPool.length; ++i) {
                        if (this.bulletPool[i].isAlive()) continue;
                        this.bulletPool[i].setPosX(this.GetPivotX() - 32);
                        this.bulletPool[i].setPosY(this.GetPivotY() - (Gfx.bulletSmall.getHeight() >> 1));
                        this.bulletPool[i].setAlive(true);
                        break;
                    }
                    this.time = (int)System.currentTimeMillis();
                    ++this.bullets_count;
                    this.state = 1;
                }
            }
        }
    }

    private void PhaseB() {
        if (this.phase != 1) {
            this.phase = 1;
        }
        switch (this.state) {
            case 3: {
                if ((int)System.currentTimeMillis() - this.time <= this.laser_charge_time) break;
                this.state = 4;
                break;
            }
            case 4: {
                if ((Player.getY() + Player.getHeight() >= this.GetPivotY() || Player.getY() + Player.getHeight() < this.GetPivotY() - 40) && (Player.getY() + Player.getHeight() <= this.GetPivotY() || Player.getAnimation() == 16)) break;
                Player.lessLife(18, false, true, false);
                break;
            }
            case 13: {
                if (!this.enemySprite.loopFinished()) break;
                this.phase_state = 2;
            }
        }
    }

    private void PhaseC() {
        if (this.phase != 2) {
            this.phase = 2;
        }
        switch (this.moving_phase) {
            case 0: {
                if (!this.enemySprite.loopFinished()) break;
                this.state = 5;
                break;
            }
            case 1: {
                if (this.posX > this.reactionDistanceXLeftColision + 32) {
                    this.posX -= this.moveSpeed;
                    break;
                }
                if (this.posX > this.reactionDistanceXLeftColision + 32) break;
                this.state = 8;
                this.moving_phase = 3;
                this.time = (int)System.currentTimeMillis();
                break;
            }
            case 3: {
                if (this.state == 0) {
                    this.phase_state = 2;
                }
                if ((int)System.currentTimeMillis() - this.time <= this.stunned_time) break;
                this.state = 12;
                this.time = (int)System.currentTimeMillis();
                this.blink = false;
                this.startBlinkLowDevice = false;
                break;
            }
            case 2: {
                if (this.state != 0) break;
                this.phase_state = 2;
            }
        }
    }

    public void Paint(Graphics g) {
        for (int i = 0; i < this.bulletPool.length; ++i) {
            if (!this.bulletPool[i].isAlive()) continue;
            this.bulletPool[i].paint(g);
        }
        this.enemySprite.setDrawPosition(this.posX + 16 - Game.getScrollX() + this.m_iHittedExtraX, this.posY + 32 - Game.getScrollY());
        if (SP.isFastDevice) {
            if (this.state == 11) {
                this.blink = false;
            }
            if (!this.blink) {
                this.enemySprite.drawFrame(g);
            }
        } else {
            if (Player.getAnimation() == 15) {
                this.blinkLowDevice = false;
            }
            if (this.state == 11) {
                this.blinkLowDevice = false;
            }
            if (!this.blinkLowDevice) {
                this.enemySprite.drawFrame(g);
            }
            this.blinkLowDevice = this.startBlinkLowDevice ? SP.isModule(SP.isPaintingScreen) : false;
        }
    }

    private boolean PlayerIsInBossArea() {
        if (Player.getY() + Player.getHeight() <= 416) {
            if (!this.camera_locked) {
                Game.stopCamera(true);
                this.camera_locked = true;
                this.reaction_timer = (int)System.currentTimeMillis();
            }
            return true;
        }
        return false;
    }

    private boolean Reposition() {
        this.state = 0;
        if (this.posX != this.initialPosX) {
            if (this.posX > this.initialPosX) {
                --this.posX;
            } else if (this.posX < this.initialPosX) {
                this.posX += this.moveSpeed >> 1;
            }
            return false;
        }
        this.time = (int)System.currentTimeMillis();
        return true;
    }

    public void DeleteMotionWeelderData() {
        try {
            this.enemySprite.unloadPoolImage();
            this.enemySprite.unloadSpriteData();
            this.enemySprite = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int GetPivotX() {
        return this.posX + 16;
    }

    private int GetPivotY() {
        int fixY = 0;
        return this.posY - fixY;
    }

    private boolean CheckCollisionWithPlayer() {
        return Math.abs(this.GetPivotX() - (Player.getX() + (Player.getWidth() >> 1))) < (this.width >> 1) + (this.width >> 2) && Math.abs(this.GetPivotY() - (Player.getY() + (Player.getHeight() >> 1))) < (this.height >> 1) + this.height / 3;
    }

    private void PlayerHitBoss() {
        if (this.m_iHittedCount < Player.ms_lPlayeHitCount && this.state == 9) {
            if (Math.abs(this.GetPivotX() - (Player.getX() + (Player.getWidth() >> 1))) < (this.width >> 1) + (this.width >> 2) && Math.abs(this.GetPivotY() - (Player.getY() + (Player.getHeight() >> 1))) < (this.height >> 1) + (this.height >> 2)) {
                if ((Player.getAnimation() == 2 || Player.getAnimation() == 3 || Player.getAnimation() == 4) && Player.getFrame() == 1) {
                    this.SubstractHealth(1);
                } else if (Player.getAnimation() == 6) {
                    this.SubstractHealth(2);
                } else if (Player.getAnimation() == 13) {
                    this.SubstractHealth(3);
                }
            }
            if (Player.getAnimation() == 15) {
                if (this.GetPivotX() > Player.getX() + (Player.getWidth() >> 1)) {
                    if (Player.getOrientation() && Player.getFrame() > 16) {
                        this.SubstractHealth(5);
                    }
                } else if (!Player.getOrientation() && Player.getFrame() > 16) {
                    this.SubstractHealth(5);
                }
            }
        }
    }

    private void SubstractHealth(int amount) {
        this.health -= amount;
        Player.colisionFist(amount, true, true);
        if (this.health > 5) {
            this.state = 10;
        } else {
            this.health = 0;
            this.isDead = true;
            this.time = (int)System.currentTimeMillis();
            Game.time = (int)System.currentTimeMillis();
            this.state = 11;
        }
        this.initStopframesByHit(amount);
    }

    public void SetTime(int _time) {
        this.time += _time;
    }
}

