/*
 * Decompiled with CFR 0.152.
 */
package com.kitmaker.finalkombat2;

import com.kitmaker.finalkombat2.MidletPBSP;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;

public class SndManager {
    public static final boolean SOUND_SUPPORTED = true;
    private static final boolean FX_SUPPORTED = false;
    public static final byte MUSIC_NOMUSIC = -1;
    public static final byte MUSIC_MENU = 0;
    public static final byte MUSIC_GAMEPLAY = 1;
    public static final byte MUSIC_FINPARTIDA = 2;
    public static final byte MUSIC_MUERTE = 3;
    public static final byte MUSIC_BOSS = 4;
    static final String[] MUSIC_FILES = new String[]{"/menu.mid", "/gameplay.mid", "/finpartida.mid", "/muerte.mid", "/boss.mid"};
    public static final byte FX_NOFX = -1;
    public static final byte FX_DESACTIVAR_BOMBA = 0;
    public static final byte FX_DISPARO = 1;
    public static final byte FX_EXPLOSION = 2;
    public static final byte FX_MAGIA = 3;
    public static final byte FX_PUNCH = 4;
    static final byte TOTAL_FX = 5;
    static final String[] SNDFX_FILES = new String[]{"/desacbomb.wav", "/disparo.wav", "/explosion.wav", "/magia.wav", "/punch.wav"};
    static final int[] SOUND_VOLUME = new int[]{0, 100};
    public static boolean ms_bSound = false;
    public static int ms_iSoundVolumeIndex = SOUND_VOLUME.length - 1;
    private static boolean ms_bUpdatingSound = false;
    private static int ms_iUpdateFrame;
    private static boolean ms_bNewClip;
    private static final int NUM_MUSIC;
    private static final int NUM_SNDFX;
    private static byte ms_iCurrentFXClip;
    private static long ms_lCurrentClipStartTime;
    public static Player ms_vMusicPlayer;
    private static Player[] ms_vSndFxPlayer;
    private static final int NUM_MUSIC_CLIPS;
    private static byte ms_iCurrentMusicClip;
    private static byte ms_iNewMusicClip;
    private static boolean ms_bCurrentMusicLooping;
    private static boolean ms_bNewMusicLooping;
    private static final int NUM_FX_CLIPS;
    private static final String MEDIAID_MID = "audio/midi";
    private static final String MEDIAID_WAV = "audio/x-wav";
    private static final String MEDIAID_AMR = "audio/amr";
    private static final String MEDIAID_MP3 = "audio/mpeg";
    private static String ms_zMediaId;
    private static boolean ms_bPausedClip;
    private static byte ms_iPausedCurrentClip;
    private static boolean ms_bPausedCurrentLooping;
    private static boolean ms_bAsyncException;
    private static boolean ms_bAsyncLoop;
    private static byte ms_iAsyncClip;
    public static final int TONE_MOVE = 0;
    public static final int TONE_SELECT = 1;
    public static final int TONE_BACK = 2;

    public static void DeleteFX() {
        SndManager.StopFX();
        for (byte i = 0; i < ms_vSndFxPlayer.length; i = (byte)(i + 1)) {
            SndManager.DeleteFX(i);
        }
    }

    public static void DeleteFX(byte _iIndex) {
        if (ms_vSndFxPlayer != null) {
            try {
                ms_vSndFxPlayer[_iIndex].close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            SndManager.ms_vSndFxPlayer[_iIndex] = null;
        }
    }

    public static void LoadFX(byte index) {
        SndManager.ms_vSndFxPlayer[index] = null;
    }

    public static void LoadAllFX() {
        SndManager.ms_vSndFxPlayer[0] = null;
    }

    public static void UpdateMusic() {
        if (!ms_bSound) {
            return;
        }
        ++ms_iUpdateFrame;
        ms_bUpdatingSound = true;
        if (System.currentTimeMillis() >= ms_lCurrentClipStartTime) {
            if (ms_bSound && (ms_bNewClip || ms_bCurrentMusicLooping) && (ms_iCurrentMusicClip == -1 || ms_vMusicPlayer == null || ms_vMusicPlayer.getState() != 400)) {
                if (ms_bNewClip) {
                    if (ms_iCurrentMusicClip != -1 && ms_vMusicPlayer != null) {
                        try {
                            ms_vMusicPlayer.close();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        ms_vMusicPlayer = null;
                    }
                    ms_iCurrentMusicClip = ms_iNewMusicClip;
                    ms_bCurrentMusicLooping = ms_bNewMusicLooping;
                }
                if (ms_vMusicPlayer == null) {
                    try {
                        ms_vMusicPlayer = Manager.createPlayer((InputStream)MidletPBSP.ms_vMain.getClass().getResourceAsStream(MUSIC_FILES[ms_iCurrentMusicClip]), (String)MEDIAID_MID);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (ms_vMusicPlayer != null && ms_vMusicPlayer.getState() != 200) {
                    try {
                        ms_vMusicPlayer.realize();
                    }
                    catch (Exception e) {
                        ms_vMusicPlayer = null;
                    }
                }
                try {
                    ms_vMusicPlayer.start();
                    ms_bAsyncException = false;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (ms_vMusicPlayer.getState() == 200) {
                        ms_bAsyncException = true;
                        ms_iAsyncClip = ms_iCurrentMusicClip;
                        SndManager.StopMusic();
                    }
                    return;
                }
            }
            ms_bNewClip = false;
        }
        ms_bUpdatingSound = false;
    }

    public static void PlayMusic(byte _iSoundID, boolean _bLooping, int _iDelay) {
        if (ms_bSound) {
            ms_zMediaId = MEDIAID_MID;
            ms_bNewMusicLooping = _bLooping;
            ms_lCurrentClipStartTime = System.currentTimeMillis() + (long)_iDelay;
            ms_iCurrentMusicClip = _iSoundID;
            ms_iNewMusicClip = _iSoundID;
            ms_bNewClip = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void StopMusic() {
        if (ms_iCurrentMusicClip != -1) {
            ms_bNewClip = false;
            ms_bNewMusicLooping = false;
            ms_bCurrentMusicLooping = false;
            if (ms_vMusicPlayer != null && ms_vMusicPlayer.getState() != 200) {
                try {
                    ms_vMusicPlayer.stop();
                    ms_vMusicPlayer.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void PauseMusic() {
        if (ms_iCurrentMusicClip != -1) {
            if (!ms_bPausedClip) {
                ms_bPausedClip = true;
                ms_iPausedCurrentClip = ms_iCurrentMusicClip;
                ms_bPausedCurrentLooping = ms_bCurrentMusicLooping;
            }
            ms_bNewClip = false;
            ms_bNewMusicLooping = false;
            ms_bCurrentMusicLooping = false;
            if (ms_vMusicPlayer != null && ms_vMusicPlayer.getState() != 200) {
                try {
                    ms_vMusicPlayer.stop();
                }
                catch (MediaException mediaException) {
                    // empty catch block
                }
            }
        }
    }

    public static void UnpauseMusic() {
        if (ms_bSound && ms_bAsyncException && ms_bAsyncLoop) {
            SndManager.PlayMusic(ms_iAsyncClip, ms_bAsyncLoop, 1000);
            ms_bAsyncException = false;
        }
        if (ms_bSound && ms_bPausedClip && ms_bPausedCurrentLooping) {
            ms_bNewMusicLooping = ms_bPausedCurrentLooping;
            ms_lCurrentClipStartTime = System.currentTimeMillis() + 100L;
            ms_iNewMusicClip = ms_iPausedCurrentClip;
            ms_bNewClip = true;
            ms_bPausedClip = false;
        }
    }

    public static void PlayFX(byte _iFXID) {
    }

    public static void playFK(byte _id) {
        try {
            ms_vSndFxPlayer[_id].start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void StopFX() {
    }

    public static void PlayTone(int _iType) {
        try {
            if (ms_bSound) {
                if (_iType == 0) {
                    Manager.playTone((int)68, (int)50, (int)SOUND_VOLUME[ms_iSoundVolumeIndex]);
                } else if (_iType == 1) {
                    Manager.playTone((int)60, (int)50, (int)SOUND_VOLUME[ms_iSoundVolumeIndex]);
                    Manager.playTone((int)68, (int)200, (int)SOUND_VOLUME[ms_iSoundVolumeIndex]);
                } else if (_iType == 2) {
                    Manager.playTone((int)60, (int)50, (int)SOUND_VOLUME[ms_iSoundVolumeIndex]);
                    Manager.playTone((int)52, (int)200, (int)SOUND_VOLUME[ms_iSoundVolumeIndex]);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void FlushSndManager() {
        ms_bSound = false;
        SndManager.StopMusic();
        SndManager.DeleteFX();
    }

    static {
        NUM_MUSIC = MUSIC_FILES.length;
        NUM_SNDFX = SNDFX_FILES.length;
        ms_iCurrentFXClip = (byte)-1;
        ms_lCurrentClipStartTime = Long.MAX_VALUE;
        ms_vSndFxPlayer = new Player[NUM_SNDFX];
        NUM_MUSIC_CLIPS = MUSIC_FILES.length;
        ms_iCurrentMusicClip = (byte)-1;
        ms_iNewMusicClip = (byte)-1;
        NUM_FX_CLIPS = SNDFX_FILES.length;
        ms_bAsyncException = false;
        ms_bAsyncLoop = false;
    }
}

