/*
 * Decompiled with CFR 0.152.
 */
package com.kitmaker.finalkombat2.enemigos;

import com.kitmaker.finalkombat2.Game;
import com.kitmaker.finalkombat2.Gfx;
import com.kitmaker.finalkombat2.Player;
import com.kitmaker.finalkombat2.SP;
import com.kitmaker.finalkombat2.tool.Math2D;
import javax.microedition.lcdui.Graphics;

public class Bullet {
    private int speed;
    private int posX;
    private int posY;
    private int width;
    private int height;
    private boolean leftAndRight;
    private boolean alive;
    private boolean direction;
    private int angle;
    private int bufferPosX;
    private int bufferPosY;
    private boolean bigBullet;

    public Bullet(int _posX, int _posY, boolean _leftAndRight, boolean _bigBullet) {
        this.leftAndRight = _leftAndRight;
        this.posX = _posX;
        this.posY = _posY;
        this.alive = false;
        this.bigBullet = _bigBullet;
        this.speed = _leftAndRight ? 4 : 120;
        this.width = 8;
        this.height = 20;
        this.angle = 0;
    }

    public void update() {
        if (this.alive) {
            if (this.leftAndRight) {
                this.posX = this.direction ? (this.posX += this.speed) : (this.posX -= this.speed);
                if (Game.chechWallBullet(this.direction, this.posX, this.posY, this.width, this.height)) {
                    this.alive = false;
                }
            } else {
                if (this.angle == 0) {
                    this.angle = Player.getAnimation() == 16 ? Math2D.getAngle360(this.posX, this.posY, Player.getX(), Player.getY() + (Player.getHeight() >> 4)) : Math2D.getAngle360(this.posX, this.posY, Player.getX(), Player.getY() + (Player.getHeight() >> 2));
                }
                this.bufferPosX = (int)((long)this.bufferPosX + Math2D.cos(this.angle) * ((long)this.speed * SP.dt >> 10));
                this.bufferPosY = (int)((long)this.bufferPosY + Math2D.sin(this.angle) * ((long)this.speed * SP.dt >> 10));
                this.posX += this.bufferPosX >> 12;
                this.posY -= this.bufferPosY >> 12;
            }
            if (this.posX - Game.getScrollX() > 360 || this.posX - Game.getScrollX() < -120) {
                this.bufferPosX = 0;
                this.bufferPosY = 0;
                this.angle = 0;
                this.alive = false;
            }
            if (this.CollidesWithPlayer()) {
                if (Player.isCroch) {
                    Player.lessLife(20, this.direction, false, false);
                } else {
                    Player.lessLife(20, this.direction, true, false);
                }
                this.bufferPosX = 0;
                this.bufferPosY = 0;
                this.angle = 0;
                this.alive = false;
            }
        }
    }

    public void paint(Graphics g) {
        if (this.bigBullet) {
            g.drawImage(Gfx.bulletBig, this.posX - Game.getScrollX(), this.posY - Game.getScrollY(), 3);
        } else {
            g.drawImage(Gfx.bulletSmall, this.posX - Game.getScrollX(), this.posY - Game.getScrollY(), 3);
        }
    }

    public int getPosX() {
        return this.posX;
    }

    public void setPosX(int posX) {
        this.posX = posX;
    }

    public int getPosY() {
        return this.posY;
    }

    public void setPosY(int posY) {
        this.posY = posY;
    }

    public boolean isDirection() {
        return this.direction;
    }

    public void setDirection(boolean direction) {
        this.direction = direction;
    }

    public boolean isAlive() {
        return this.alive;
    }

    public void setAlive(boolean alive) {
        this.alive = alive;
    }

    private boolean CollidesWithPlayer() {
        if (!this.bigBullet) {
            return (this.posX - (this.width >> 1) < Player.getX() + Player.getWidth() && this.posX - (this.width >> 1) > Player.getX() || this.posX + (this.width >> 1) > Player.getX() && this.posX + (this.width >> 1) < Player.getX() + Player.getWidth()) && (this.posY - (this.height >> 1) <= Player.getY() + Player.getHeight() - (Player.getHeight() >> 2) && this.posY - (this.height >> 1) >= Player.getY() || this.posY + (this.height >> 1) >= Player.getY() && this.posY + (this.height >> 1) <= Player.getY() + Player.getHeight() - (Player.getHeight() >> 2)) && !Player.isDead();
        }
        return (this.posX - (this.width >> 1) < Player.getX() + Player.getWidth() && this.posX - (this.width >> 1) > Player.getX() || this.posX + (this.width >> 1) > Player.getX() && this.posX + (this.width >> 1) < Player.getX() + Player.getWidth()) && this.posY - (this.height >> 1) <= Player.getY() + Player.getHeight() && this.posY + this.height >= Player.getY() && !Player.isDead();
    }
}

