/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.m3g.Appearance;
import javax.microedition.m3g.CompositingMode;
import javax.microedition.m3g.Fog;
import javax.microedition.m3g.PolygonMode;
import javax.microedition.m3g.Texture2D;

public class S3dAppearance {
    public static final int MODE_REPLACE = 0;
    public static final int MODE_ALPHA = 1;
    public static final int MODE_ALPHA_DEPTH = 2;
    public static final int MODE_ZERO_Z = 3;
    public static final int MODE_MODULATE = 4;
    public static final int MODE_ALPHA_ADD = 5;
    public static final int MODE_LAST = 5;
    public static final int ALPHA_THRESHOLD_MIN = 0;
    public static final int ALPHA_THRESHOLD_MAX = 255;
    public static final int CULL_BACK = 1;
    public static final int CULL_FRONT = 2;
    public static final int CULL_NONE = 3;
    private static final int CULL_MASK = 3;
    public static final int WINDING_CCW = 4;
    public static final int WINDING_CW = 8;
    private static final int WINDING_MASK = 12;
    public static final int SHADING_FLAT = 16;
    public static final int SHADING_SMOOTH = 32;
    private static final int SHADING_MASK = 48;
    public static final int PERSPECTIVE_OFF = 64;
    public static final int PERSPECTIVE_ON = 128;
    private static final int PERSPECTIVE_MASK = 192;
    public static final int LOCAL_CAM_LIGHTING_OFF = 256;
    public static final int LOCAL_CAM_LIGHTING_ON = 512;
    public static final int LOCAL_CAM_LIGHTING_MASK = 768;
    public static final int FILTER_LEVEL_BASE = 1;
    public static final int FILTER_LEVEL_NEAREST = 2;
    public static final int FILTER_LEVEL_LINEAR = 4;
    public static final int FILTER_IMAGE_NEAREST = 8;
    public static final int FILTER_IMAGE_LINEAR = 16;
    public static final int TEX_FUNC_ADD = 32;
    public static final int TEX_FUNC_BLEND = 64;
    public static final int TEX_FUNC_DECAL = 128;
    public static final int TEX_FUNC_MODULATE = 256;
    public static final int TEX_FUNC_REPLACE = 512;
    public static final int ALPHA_WRITE_DISABLED = 1;
    public static final int ALPHA_WRITE_ENABLED = 2;
    public static final int COLOR_WRITE_DISABLED = 4;
    public static final int COLOR_WRITE_ENABLED = 8;
    public static final int DEPTH_TEST_DISABLED = 16;
    public static final int DEPTH_TEST_ENABLED = 32;
    public static final int DEPTH_WRITE_DISABLED = 64;
    public static final int DEPTH_WRITE_ENABLED = 128;
    public static final int STD_RENDER_SKYBOX = 146;
    public static final int STD_RENDER_DRAW_ALWAYS = 19;
    static CompositingMode solidCompositing = new CompositingMode();
    static CompositingMode alphaCompositing;
    static CompositingMode alphaaddCompositing;
    static CompositingMode modulateCompositing;
    static CompositingMode surfaceCompositing;
    static CompositingMode zeroZedCompositing;
    static CompositingMode customCompositing;
    S3dResource texture;
    Appearance app = new Appearance();
    PolygonMode polyMode;
    public static final int NATIVE_BLENDING = 0;
    public static final int NATIVE_ALPHATHRESHOLD = 1;
    public static final int NATIVE_COLOR_WRITE = 2;
    public static final int NATIVE_ALPHA_WRITE = 3;
    public static final int NATIVE_DEPTH_TEST = 4;
    public static final int NATIVE_DEPTH_WRITE = 5;
    public static final int NATIVE_DEPTH_OFFSET_FACTOR = 6;
    public static final int NATIVE_DEPTH_OFFSET_UNITS = 7;
    public static final int NATIVE_PARAMETER_LAST = 7;

    public void setCompositingMode(int n) {
        switch (n) {
            case 0: {
                this.app.setCompositingMode(solidCompositing);
                break;
            }
            case 4: {
                this.app.setCompositingMode(modulateCompositing);
                break;
            }
            case 1: {
                this.app.setCompositingMode(alphaCompositing);
                break;
            }
            case 2: {
                this.app.setCompositingMode(surfaceCompositing);
                break;
            }
            case 3: {
                this.app.setCompositingMode(zeroZedCompositing);
                break;
            }
            case 5: {
                this.app.setCompositingMode(alphaaddCompositing);
                break;
            }
            default: {
                System.err.println("S3dAppearance.setMode has unknown mode '" + n + "'");
            }
        }
    }

    public int getBlendMode() {
        CompositingMode compositingMode = this.app.getCompositingMode();
        int n = compositingMode.getBlending();
        if (n == 68) {
            return 0;
        }
        if (n == 66) {
            return 4;
        }
        if (n == 64) {
            return 1;
        }
        if (n == 65) {
            return 5;
        }
        return -1;
    }

    protected void cloneCompositeMode() {
        this.app.setCompositingMode((CompositingMode)this.app.getCompositingMode().duplicate());
    }

    public void setTextureResource(int n, S3dResource s3dResource) {
        this.app.setTexture(n, s3dResource.getResourceTexture());
        this.texture = s3dResource;
    }

    public void setTexture(int n, Texture2D texture2D) {
        this.app.setTexture(n, texture2D);
    }

    private void pmInit() {
        if (this.polyMode == null) {
            this.polyMode = new PolygonMode();
            this.app.setPolygonMode(this.polyMode);
        }
    }

    public void setFoggingMode(boolean bl, int n, float f, float f2) {
        if (bl) {
            Fog fog = new Fog();
            fog.setColor(n);
            fog.setLinear(f, f2);
            this.app.setFog(fog);
        } else {
            this.app.setFog(null);
        }
    }

    public float getFoggingNearDistance() {
        Fog fog = this.app.getFog();
        return fog == null ? 0.0f : fog.getNearDistance();
    }

    public float getFoggingFarDistance() {
        Fog fog = this.app.getFog();
        return fog == null ? 0.0f : fog.getFarDistance();
    }

    public void setFoggingNearDistance(float f) {
        Fog fog = this.app.getFog();
        if (fog != null) {
            int n = fog.getColor();
            float f2 = fog.getFarDistance();
            this.setFoggingMode(true, n, f, f2);
        }
    }

    public void setFoggingFarDistance(float f) {
        Fog fog = this.app.getFog();
        if (fog != null) {
            int n = fog.getColor();
            float f2 = fog.getNearDistance();
            this.setFoggingMode(true, n, f2, f);
        }
    }

    public void setAlphaThreshold(int n) {
        this.cloneCompositeMode();
        n = GluInt.rangeLimit(n, 0, 255);
        this.app.getCompositingMode().setAlphaThreshold((float)n / 255.0f);
    }

    public void setCullMode(int n) {
        this.pmInit();
        switch (n) {
            case 1: {
                this.polyMode.setCulling(160);
                break;
            }
            case 2: {
                this.polyMode.setCulling(161);
                break;
            }
            case 3: {
                this.polyMode.setCulling(162);
                break;
            }
            default: {
                System.err.println("S3dAppearance.setCullMode has unknown mode '" + n + "'");
            }
        }
    }

    public int getNativeModeParameter(int n) {
        switch (n) {
            case 0: {
                return this.app.getCompositingMode().getBlending();
            }
            case 1: {
                return (int)(this.app.getCompositingMode().getAlphaThreshold() * 255.0f);
            }
            case 2: {
                return this.app.getCompositingMode().isColorWriteEnabled() ? 1 : 0;
            }
            case 3: {
                return this.app.getCompositingMode().isAlphaWriteEnabled() ? 1 : 0;
            }
            case 4: {
                return this.app.getCompositingMode().isDepthTestEnabled() ? 1 : 0;
            }
            case 5: {
                return this.app.getCompositingMode().isDepthWriteEnabled() ? 1 : 0;
            }
            case 6: {
                return (int)this.app.getCompositingMode().getDepthOffsetFactor();
            }
            case 7: {
                return (int)this.app.getCompositingMode().getDepthOffsetUnits();
            }
        }
        return -1;
    }

    public int setNativeModeParameter(int n, int n2) {
        this.cloneCompositeMode();
        switch (n) {
            case 0: {
                n2 = GluInt.rangeWrap(n2, 64, 68);
                this.app.getCompositingMode().setBlending(n2);
                break;
            }
            case 1: {
                n2 = GluInt.rangeLimit(n2, 0, 255);
                this.app.getCompositingMode().setAlphaThreshold((float)n2 / 255.0f);
                break;
            }
            case 2: {
                this.app.getCompositingMode().setColorWriteEnable(n2 != 0);
                break;
            }
            case 3: {
                this.app.getCompositingMode().setAlphaWriteEnable(n2 != 0);
                break;
            }
            case 4: {
                this.app.getCompositingMode().setDepthTestEnable(n2 != 0);
                break;
            }
            case 5: {
                this.app.getCompositingMode().setDepthWriteEnable(n2 != 0);
                break;
            }
            case 6: {
                this.app.getCompositingMode().setDepthOffset((float)n2, this.app.getCompositingMode().getDepthOffsetUnits());
                break;
            }
            case 7: {
                this.app.getCompositingMode().setDepthOffset(this.app.getCompositingMode().getDepthOffsetFactor(), (float)n2);
            }
        }
        return n2;
    }

    public void setWindingMode(int n) {
        this.pmInit();
        if (n == 4) {
            this.polyMode.setWinding(168);
        } else {
            this.polyMode.setWinding(169);
        }
    }

    public void setShadingMode(int n) {
        this.pmInit();
        if (n == 16) {
            this.polyMode.setShading(164);
        } else {
            this.polyMode.setShading(165);
        }
    }

    public void setHintsMode(int n, int n2) {
        this.pmInit();
        if ((n & 0x80) != 0) {
            this.polyMode.setPerspectiveCorrectionEnable(true);
        } else {
            this.polyMode.setPerspectiveCorrectionEnable(false);
        }
    }

    public void setRenderMode(int n) {
        if ((n & 3) != 0) {
            this.setCullMode(n & 3);
        }
        if ((n & 0xC) != 0) {
            this.setWindingMode(n & 0xC);
        }
        if ((n & 0x30) != 0) {
            this.setShadingMode(n & 0x30);
        }
        if ((n & 0xC0) != 0) {
            this.setHintsMode(n & 0xC0, 0);
        }
    }

    public static S3dAppearance createAppearance(S3dResource s3dResource, int n) {
        S3dAppearance s3dAppearance = new S3dAppearance();
        s3dAppearance.setTextureResource(0, s3dResource);
        s3dAppearance.setCompositingMode(n);
        return s3dAppearance;
    }

    public static S3dAppearance createAppearance(int n) {
        S3dAppearance s3dAppearance = new S3dAppearance();
        s3dAppearance.setCompositingMode(n);
        return s3dAppearance;
    }

    static {
        solidCompositing.setBlending(68);
        solidCompositing.setColorWriteEnable(true);
        solidCompositing.setAlphaWriteEnable(false);
        solidCompositing.setDepthTestEnable(false);
        solidCompositing.setDepthWriteEnable(false);
        alphaCompositing = new CompositingMode();
        alphaCompositing.setBlending(64);
        alphaCompositing.setColorWriteEnable(true);
        alphaCompositing.setAlphaWriteEnable(false);
        alphaCompositing.setDepthTestEnable(false);
        alphaCompositing.setDepthWriteEnable(false);
        alphaaddCompositing = new CompositingMode();
        alphaaddCompositing.setBlending(65);
        alphaaddCompositing.setAlphaThreshold(0.5f);
        alphaaddCompositing.setColorWriteEnable(true);
        alphaaddCompositing.setAlphaWriteEnable(false);
        alphaaddCompositing.setDepthTestEnable(true);
        alphaaddCompositing.setDepthWriteEnable(true);
        modulateCompositing = new CompositingMode();
        modulateCompositing.setBlending(66);
        modulateCompositing.setAlphaThreshold(1.0f);
        modulateCompositing.setColorWriteEnable(true);
        modulateCompositing.setAlphaWriteEnable(false);
        modulateCompositing.setDepthTestEnable(true);
        modulateCompositing.setDepthWriteEnable(true);
        surfaceCompositing = new CompositingMode();
        surfaceCompositing.setBlending(64);
        surfaceCompositing.setAlphaThreshold(1.0f);
        surfaceCompositing.setColorWriteEnable(true);
        surfaceCompositing.setAlphaWriteEnable(false);
        surfaceCompositing.setDepthTestEnable(true);
        surfaceCompositing.setDepthWriteEnable(true);
        surfaceCompositing.setDepthOffset(1.0f, 5.0f);
        zeroZedCompositing = new CompositingMode();
        zeroZedCompositing.setDepthTestEnable(false);
        zeroZedCompositing.setDepthWriteEnable(false);
        customCompositing = new CompositingMode();
    }
}

