/*
 * Decompiled with CFR 0.152.
 */
import java.util.Date;
import java.util.Random;

public class ProbabilityDispatcher {
    private static double[] prbts = new double[]{0.87f, 0.85f, 0.83f, 0.76f, 0.75, 0.73f, 0.08f, 0.4f, 0.13f};
    private static double[] alternative_probabilities = new double[]{0.57f, 0.55f, 0.53f, 0.46f, 0.55f, 0.43f, 0.78f, 0.74f, 0.54f};
    private static String[] names = new String[]{"BAR", "BAR2", "BAR3", "SNAIL", "BUTTERFLY", "SEVEN", "JOKER", "SWAMPLAND", "FROG"};
    private static Random rnd = new Random(new Date().getTime());

    public static int getRandom(int n) {
        return rnd.nextInt(n);
    }

    public static boolean getValue(double d) {
        return rnd.nextDouble() <= d;
    }

    private static double getProbability(int n) {
        return prbts[n];
    }

    public static int getRandomCardId(boolean bl) {
        byte by = Card.getCardCount();
        int n = 0;
        if (bl) {
            boolean bl2 = false;
            Card card = null;
            double d = 0.0;
            while (!bl2) {
                n = rnd.nextInt(by);
                card = Datamodule.getCardById(n);
                d = card.getProbability();
                if (!ProbabilityDispatcher.getValue(d)) continue;
                bl2 = true;
            }
        } else {
            n = rnd.nextInt(by);
        }
        return n;
    }

    public static void setCardsProbability() {
        for (int i = 0; i < names.length; ++i) {
            Datamodule.getCardByName(names[i]).setProbability(ProbabilityDispatcher.getProbability(i));
        }
    }

    public static void setAlternativeCardsProbability() {
        for (int i = 0; i < names.length; ++i) {
            Datamodule.getCardByName(names[i]).setProbability(alternative_probabilities[i]);
        }
    }
}

