/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.util.TimerTask;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;

public class MainCanvas
extends Canvas {
    int scrolls = 10;
    private Image gameBK;
    private Image toMenu;
    private Player scrollSound;
    private Player threeFrogs;
    public static Canvas canvas;
    public static boolean altmode;
    public boolean stopAnother;
    private TimerTask timerTask;
    public boolean scrollRunning = false;
    public int delaysleep = 3000;
    public final int BET_INDEX;
    public final int PAID_INDEX;
    public final int CREDITS_INDEX;
    public static String alertMessage;
    public final int BET_PER_LINE;
    public final int LINES_COUNT;
    public Card[] cards;
    private boolean drawMarkedLines = false;
    private int[] markedLines = null;
    private int markedLinesCount = 0;
    public InfoBox[] infoBoxes;
    private boolean onlyShowLinesDefs;
    private final byte ONLY_NUMBERS;
    private int infoColor;
    private final byte ONLY_LINES = (byte)2;
    private final byte LINES_AND_NUMBERS = (byte)3;
    private final byte MARKED_LINES = (byte)4;
    private byte linesMask = (byte)3;
    private boolean markFrogs = false;

    public MainCanvas() {
        this.BET_INDEX = 0;
        this.PAID_INDEX = 1;
        this.CREDITS_INDEX = 2;
        this.BET_PER_LINE = 3;
        this.LINES_COUNT = 4;
        this.ONLY_NUMBERS = 1;
        canvas = this;
        this.setFullScreenMode(true);
        this.initialize();
    }

    public void drawBK(Graphics graphics) {
        graphics.drawImage(this.gameBK, 0, 0, 20);
    }

    public void animateFrogs() {
        for (int i = 0; i < 4; ++i) {
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static void display() {
        MainMidlet.getMidlet().setDisplayable((Displayable)canvas);
        MainMidlet.getMidlet().display();
    }

    public void drawAlert(Graphics graphics) {
        Font font = graphics.getFont();
        int n = graphics.getColor();
        graphics.setColor(Datamodule.alertBKColor);
        graphics.fillRect(0, Library.yToAbs(PU.alertTop) + 2, PU.screenWidth, graphics.getFont().getHeight() + 4);
        graphics.setColor(Datamodule.alertColor);
        graphics.setFont(Font.getFont((int)64, (int)1, (int)16));
        graphics.drawString(alertMessage, Library.xToAbs(50.0f), Library.yToAbs(PU.alertTop), 17);
        graphics.setColor(n);
        graphics.setFont(font);
        alertMessage = null;
    }

    protected void keyPressed(int n) {
        if (!this.stopAnother) {
            this.markFrogs = false;
            this.drawMarkedLines = false;
            if (n == 49) {
                int n2 = Datamodule.getInfoStructure().getBetPerLine();
                if (++n2 > Datamodule.MAX_BET) {
                    n2 = 1;
                }
                Datamodule.getInfoStructure().setBetPerLine(n2);
                Datamodule.getInfoStructure().setBet(Datamodule.getInfoStructure().getBetPerLine() * Datamodule.getInfoStructure().getLinesCount());
                this.updateInfoPanel();
                this.repaint();
            } else if (n == 50) {
                int n3 = Datamodule.getInfoStructure().getLinesCount();
                n3 = n3 < Datamodule.linesDefs.getCount() ? (n3 += 2) : 1;
                Datamodule.getInfoStructure().setLinesCount(n3);
                Datamodule.getInfoStructure().setBet(Datamodule.getInfoStructure().getBetPerLine() * Datamodule.getInfoStructure().getLinesCount());
                this.updateInfoPanel();
                this.repaint();
            } else if (this.getGameAction(n) == 8 || n == 53) {
                if (!this.scrollRunning && this.check() && this.scrollSound.getState() != 400) {
                    if (!altmode && Datamodule.getInfoStructure().getCredits() < 100) {
                        ProbabilityDispatcher.setAlternativeCardsProbability();
                        altmode = true;
                    } else if (altmode && Datamodule.getInfoStructure().getCredits() >= 100) {
                        ProbabilityDispatcher.setCardsProbability();
                        altmode = false;
                    }
                    Datamodule.getInfoStructure().setCredits(Datamodule.getInfoStructure().getCredits() - Datamodule.getInfoStructure().getBet());
                    Datamodule.getInfoStructure().setPaid(0);
                    this.updateInfoPanel();
                    this.scroll();
                }
            } else if (n == 51) {
                this.onlyShowLinesDefs = !this.onlyShowLinesDefs;
                this.repaint();
            } else if (n == -6) {
                MenuForm.display();
            }
        }
    }

    public boolean check() {
        boolean bl;
        boolean bl2 = bl = Datamodule.getInfoStructure().getBet() <= Datamodule.getInfoStructure().getCredits();
        if (!bl) {
            alertMessage = "\u041d\u0435 \u0445\u0432\u0430\u0442\u0430\u0435\u0442 \u0434\u0435\u043d\u0435\u0433.";
            this.repaint();
        }
        return bl;
    }

    private void scroll() {
        new Thread(){

            public void run() {
                int n = -1;
                for (n = 4; n < 2 && PU.maxImageHeight % n != 0; --n) {
                }
                double d = PU.maxImageHeight / n;
                boolean bl = false;
                MainCanvas.this.scrollRunning = true;
                try {
                    if (Datamodule.playSounds) {
                        MainCanvas.this.scrollSound.start();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Datamodule.iconsPanelOffsY = 0;
                long l = MainCanvas.this.scrollSound.getDuration();
                MainCanvas.this.scrolls = l != -1L ? (int)((double)(l / 1000L) / ((double)Datamodule.scrollDelay * ((double)PU.maxImageHeight / d))) : 8;
                int n2 = MainCanvas.this.scrolls - 3;
                for (int i = 0; i < MainCanvas.this.scrolls; ++i) {
                    int n3 = 0;
                    while (n3 < PU.maxImageHeight) {
                        Datamodule.iconsPanelOffsY = n3;
                        MainCanvas.this.repaint();
                        try {
                            Thread.sleep(Datamodule.scrollDelay);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        n3 = (int)((double)n3 + d);
                    }
                    Datamodule.iconsPanelOffsY = 0;
                    bl = i >= n2 - 3;
                    CardHeapHandler.shiftCardHeap(bl);
                }
                MainCanvas.this.calculateResults();
                MainCanvas.this.updateInfoPanel();
                MainCanvas.this.repaint();
                MainCanvas.this.scrollRunning = false;
                if (Datamodule.getInfoStructure().getCredits() <= 0) {
                    Datamodule.gameOver = true;
                }
                if (Datamodule.gameOver) {
                    MainCanvas.this.doGameOver();
                }
            }
        }.start();
    }

    public void doGameOver() {
        new Thread(){

            public void run() {
                try {
                    Datamodule.gameOver = true;
                    MainCanvas.this.repaint();
                    Thread.sleep(4000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                MenuForm.display();
            }
        }.start();
    }

    public void calculateResults() {
        int n;
        Card card = null;
        int n2 = -1;
        int[] nArray = new int[Datamodule.iconsPanelCols];
        int n3 = 0;
        boolean bl = false;
        int n4 = 0;
        int n5 = 0;
        int n6 = -1;
        boolean bl2 = false;
        int n7 = 0;
        this.markedLinesCount = 0;
        n3 = 0;
        for (n = 1; n < Datamodule.iconsPanelRows + 1; ++n) {
            for (int i = 0; i < Datamodule.iconsPanelCols; ++i) {
                if (CardHeapHandler.cardHeap[n][i].isFrog()) {
                    n3 = (byte)(n3 + 1);
                }
                bl = n3 >= 3;
            }
        }
        for (n = 0; n < Datamodule.getInfoStructure().getLinesCount(); ++n) {
            card = null;
            n5 = 0;
            LinesDefs linesDefs = Datamodule.linesDefs;
            for (int i = 0; i < linesDefs.getLineLength(); ++i) {
                n4 = 0;
                bl2 = false;
                if (i < Datamodule.iconsPanelCols - 2) {
                    for (int j = i; j < linesDefs.getLineLength(); ++j) {
                        int n8;
                        card = CardHeapHandler.cardHeap[LinesDefs.defs[n][j] + 1][j];
                        nArray[j - i] = card.getId();
                        if (++n4 < 3 || (n8 = this.getSeqType(nArray, n4)) == -2 || n4 <= n5) continue;
                        n5 = n4;
                        bl2 = true;
                        n6 = n8;
                        n2 = n;
                    }
                }
                if (!bl2) continue;
                n7 += this.getWon(n5, n6, n2);
            }
        }
        Datamodule.getInfoStructure().setCredits(Datamodule.getInfoStructure().getCredits() + n7);
        Datamodule.getInfoStructure().setPaid(n7);
        if (bl) {
            this.haveTreeFrogs();
        }
    }

    private int getWon(int n, int n2, int n3) {
        this.markedLines[this.markedLinesCount] = n3;
        ++this.markedLinesCount;
        this.drawMarkedLines = true;
        if (Datamodule.vibrate) {
            Library.vibrate(Datamodule.vibrateDuration);
        }
        return Datamodule.getInfoStructure().getBetPerLine() * Datamodule.winTables.byId(n2).getPrize(n);
    }

    private void bonus() {
        FrogBonusScene1 frogBonusScene1 = new FrogBonusScene1();
        frogBonusScene1.display();
    }

    public void haveTreeFrogs() {
        try {
            if (Datamodule.playSounds) {
                this.threeFrogs.start();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.markFrogs = true;
        DelayThread delayThread = new DelayThread();
        delayThread.start();
        Datamodule.getInfoStructure().setLastBet(Datamodule.getInfoStructure().getBet());
        this.updateInfoPanel();
    }

    private int getSeqType(int[] nArray, int n) {
        int n2;
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = false;
        int n3 = -1;
        for (n2 = 0; n2 < n; ++n2) {
            bl &= nArray[n2] == Datamodule.jokerId;
            bl2 &= nArray[n2] == Datamodule.swamplandId;
            if (bl3 |= nArray[n2] == Datamodule.frogId) {
                return -2;
            }
            if (n3 != -1) continue;
            if (nArray[n2] != Datamodule.jokerId) {
                n3 = nArray[n2];
            }
            if (nArray[n2] != Datamodule.swamplandId) continue;
            n3 = -2;
        }
        if (bl) {
            return Datamodule.jokerId;
        }
        if (bl2) {
            return Datamodule.swamplandId;
        }
        for (n2 = 0; n2 < n; ++n2) {
            if (nArray[n2] != Datamodule.jokerId) continue;
            nArray[n2] = n3;
        }
        n2 = 1;
        for (int i = 0; i < n; ++i) {
            n2 &= nArray[i] == n3 ? 1 : 0;
        }
        if (n2 != 0) {
            return n3;
        }
        return -2;
    }

    public void initialize() {
        alertMessage = null;
        try {
            InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream(PU.resourcePath + "/krutit.mid");
            this.scrollSound = Manager.createPlayer((InputStream)inputStream, (String)"audio/midi");
            inputStream = ((Object)((Object)this)).getClass().getResourceAsStream(PU.resourcePath + "/kva.mid");
            this.threeFrogs = Manager.createPlayer((InputStream)inputStream, (String)"audio/midi");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.toMenu = Image.createImage((String)(PU.resourcePath + "/menu.png"));
            this.gameBK = Image.createImage((String)(PU.resourcePath + "/GameBK.png"));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.cards = Datamodule.getCards();
        this.infoBoxes = new InfoBox[5];
        this.infoBoxes[1] = new InfoBox(Library.xToAbs(PU.gamePaidLeft), Library.yToAbs(PU.gamePaidTop), 0, 0, "\u0432\u044b\u0439\u0433");
        this.infoBoxes[2] = new InfoBox(Library.xToAbs(PU.gameCreditsLeft), Library.yToAbs(PU.gameCreditsTop), 0, 0, "\u0441\u0443\u043c\u043c");
        this.infoBoxes[2].setValue(Datamodule.getInfoStructure().getCredits());
        this.infoBoxes[0] = new InfoBox(Library.xToAbs(PU.gameBetLeft), Library.yToAbs(PU.gameBetTop), 0, 0, "\u0421\u0442\u0430\u0432");
        this.infoBoxes[0].setValue(Datamodule.getInfoStructure().getBet());
        this.infoBoxes[3] = new InfoBox(Library.xToAbs(PU.gameBetPerLineLeft), Library.yToAbs(PU.gameBetPerLineTop), 0, 0, "\u041d\u0430 \u043b\u0438\u043d.");
        this.infoBoxes[3].setValue(Datamodule.getInfoStructure().getBetPerLine());
        this.infoBoxes[4] = new InfoBox(Library.xToAbs(PU.gameLinesCountLeft), Library.yToAbs(PU.gameLinesCountTop), 0, 0, "\u041a\u043e\u043b.\u043b\u0438\u043d.");
        this.infoBoxes[4].setValue(Datamodule.getInfoStructure().getLinesCount());
        this.infoColor = ColorUtils.toRGB(248, 168, 0);
        CardHeapHandler.createCardHeap();
        CardHeapHandler.initCardHeap();
        this.onlyShowLinesDefs = false;
        this.markedLines = new int[Datamodule.linesDefs.getCount()];
    }

    public void fadeout(Graphics graphics) {
        int n = graphics.getStrokeStyle();
        int n2 = graphics.getColor();
        graphics.setStrokeStyle(1);
        graphics.setColor(Datamodule.dieGridColor);
        for (int i = 0; i < PU.screenWidth; ++i) {
            graphics.drawLine(i, i % 2, i, PU.screenHeight);
        }
        graphics.setStrokeStyle(n);
        graphics.setColor(n2);
    }

    public void drawDieScreen(Graphics graphics) {
        this.fadeout(graphics);
        Font font = graphics.getFont();
        int n = graphics.getColor();
        graphics.setColor(Datamodule.dieFontColor);
        graphics.setFont(Font.getFont((int)64, (int)1, (int)16));
        graphics.drawString(Datamodule.gameOverString, Library.xToAbs(50.0f), Library.yToAbs(50.0f), 65);
        graphics.setColor(n);
        graphics.setFont(font);
    }

    public void paint(Graphics graphics) {
        this.updateInfoPanel();
        Datamodule.paintClipRect(graphics);
        this.drawBK(graphics);
        graphics.setColor(Datamodule.infoColor);
        graphics.setFont(Datamodule.infoFont);
        graphics.drawString("\u041c\u0435\u043d\u044e", 1, PU.screenHeight, 36);
        Datamodule.drawInfoPanel(graphics, this.infoBoxes, Datamodule.infoFont, this.infoColor);
        if (this.onlyShowLinesDefs) {
            this.linesMask = (byte)3;
            this.drawLines(graphics);
        } else {
            this.linesMask = 1;
            this.drawLines(graphics);
            this.drawIconsPanel(graphics);
        }
        if (this.drawMarkedLines) {
            this.linesMask = (byte)7;
            this.drawLines(graphics);
        }
        graphics.setClip(0, 0, PU.screenWidth, PU.screenHeight);
        if (alertMessage != null) {
            this.drawAlert(graphics);
        }
        if (Datamodule.gameOver) {
            this.drawDieScreen(graphics);
        }
    }

    public void drawIconsPanel(Graphics graphics, int n, int n2) {
        int n3 = n - PU.iconsPanelWidth / 2;
        int n4 = Library.xToAbs(PU.iconsPanelClipCenter) - PU.iconsPanelWidth / 2;
        for (int i = 0; i < Datamodule.iconsPanelRows + 1; ++i) {
            for (int j = 0; j < Datamodule.iconsPanelCols; ++j) {
                graphics.setClip(n4, Library.yToAbs(PU.iconsPanelClipTop), PU.iconsPanelWidth, PU.iconsPanelHeight);
                Card card = CardHeapHandler.cardHeap[i][j];
                int n5 = n3 + j * PU.maxImageWidth;
                int n6 = n2 + i * PU.maxImageHeight;
                graphics.drawImage(card.getImage(), n5, n6, 20);
                if (!card.isFrog() || !this.markFrogs) continue;
                int n7 = graphics.getColor();
                graphics.setColor(65280);
                graphics.drawRect(n5, n6, Card.getMaxImageWidth() - 2, Card.getMaxImageHeight() - 2);
                graphics.drawRect(n5 + 1, n6 + 1, Card.getMaxImageWidth() - 4, Card.getMaxImageHeight() - 4);
                graphics.drawRect(n5 + 2, n6 + 2, Card.getMaxImageWidth() - 6, Card.getMaxImageHeight() - 6);
                graphics.setColor(n7);
            }
        }
    }

    public void drawIconsPanel(Graphics graphics) {
        this.drawIconsPanel(graphics, Library.xToAbs(PU.iconsPanelCenter), Datamodule.iconsPanelOffsY + Library.yToAbs(PU.iconsPanelTop) - PU.maxImageHeight);
    }

    public void drawLines(Graphics graphics) {
        int n = Card.getMaxImageHeight();
        int n2 = Card.getMaxImageWidth();
        int n3 = Library.yToAbs(PU.iconsPanelClipTop) + n / 2;
        int n4 = n3 + n;
        int n5 = n4 + n;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = -18;
        int n12 = -18;
        int n13 = -18;
        int n14 = 0;
        graphics.setStrokeStyle(0);
        graphics.setFont(Font.getFont((int)64, (int)1, (int)8));
        LinesDefs linesDefs = Datamodule.linesDefs;
        for (int i = 0; i < linesDefs.getCount(); ++i) {
            int n15 = LinesDefs.linesColors[i];
            int n16 = graphics.getColor();
            graphics.setColor(n15);
            n9 = Library.xToAbs(PU.iconsPanelClipCenter) - PU.iconsPanelWidth / 2 + n2 / 2;
            n10 = i - 7;
            for (int j = 0; j < linesDefs.getLineLength(); ++j) {
                byte by = LinesDefs.defs[i][j];
                if (by == LinesDefs.TOP) {
                    n8 = n3;
                } else if (by == LinesDefs.CENTER) {
                    n8 = n4;
                } else if (by == LinesDefs.BOTTOM) {
                    n8 = n5;
                }
                if (j == 0) {
                    n6 = n9;
                    n7 = n8;
                    if (n7 == n3) {
                        n14 = n11;
                        n11 = (byte)(n11 + 12);
                    } else if (n7 == n4) {
                        n14 = n12;
                        n12 = (byte)(n12 + 12);
                    } else if (n7 == n5) {
                        n14 = n13;
                        n13 = (byte)(n13 + 12);
                    }
                    if ((this.linesMask & 1) != 0) {
                        Font font = graphics.getFont();
                        if (i < Datamodule.getInfoStructure().getLinesCount()) {
                            graphics.setFont(Font.getFont((int)0, (int)3, (int)0));
                        }
                        graphics.drawString(String.valueOf(i + 1), Library.xToAbs(PU.numbersLeftOffset), n7 + n14, 20);
                        graphics.drawString(String.valueOf(i + 1), Library.xToAbs(PU.numbersRightOffset), n7 + n14, 24);
                        graphics.setFont(font);
                    }
                }
                if ((this.linesMask & 2) != 0) {
                    boolean bl = false;
                    if ((this.linesMask & 4) != 0) {
                        for (int k = 0; k < this.markedLinesCount; ++k) {
                            if (this.markedLines[k] != i) continue;
                            bl = true;
                        }
                    } else {
                        bl = true;
                    }
                    if (bl) {
                        graphics.drawLine(n6, n10 + n7, n9, n10 + n8);
                        if (i < Datamodule.getInfoStructure().getLinesCount()) {
                            graphics.drawLine(n6, n10 + n7 + 1, n9, n10 + n8 + 1);
                            graphics.drawLine(n6, n10 + n7 + 2, n9, n10 + n8 + 2);
                            graphics.drawLine(n6, n10 + n7 + 3, n9, n10 + n8 + 3);
                        }
                    }
                }
                n6 = n9;
                n7 = n8;
                n9 += n2;
            }
            graphics.setColor(n16);
        }
    }

    public void updateInfoPanel() {
        this.infoBoxes[0].setValue(Datamodule.getInfoStructure().getBet());
        this.infoBoxes[3].setValue(Datamodule.getInfoStructure().getBetPerLine());
        this.infoBoxes[2].setValue(Datamodule.getInfoStructure().getCredits());
        this.infoBoxes[1].setValue(Datamodule.getInfoStructure().getPaid());
        this.infoBoxes[4].setValue(Datamodule.getInfoStructure().getLinesCount());
    }

    static {
        altmode = false;
    }

    public class DelayThread
    extends Thread {
        public void run() {
            MainCanvas.this.stopAnother = true;
            MainCanvas.this.repaint();
            try {
                Thread.sleep(MainCanvas.this.delaysleep);
            }
            catch (InterruptedException interruptedException) {
                MainCanvas.this.stopAnother = false;
            }
            MainCanvas.this.stopAnother = false;
            MainCanvas.this.bonus();
        }
    }
}

