/*
 * Decompiled with CFR 0.152.
 */
package example.fireworks;

import com.nokia.mid.ui.FullCanvas;
import example.fireworks.DoublyLinkedList;
import example.fireworks.FireworksMIDlet;
import example.fireworks.Spark;
import java.util.Random;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Graphics;
import javax.microedition.midlet.MIDlet;

class FireworksCanvas
extends FullCanvas
implements Runnable {
    static final int FIXED_POINT_SHIFT = 8;
    private static final int MILLIS_PER_TICK = 100;
    private static final int TICKS_PER_EXPLOSION = 10;
    private static final int SPARK_LIFE_IN_TICKS = 20;
    private static final int SPARK_RANDOM_LIFE_IN_TICKS = 20;
    private static final int SPARK_VELOCITY = 2;
    private static final int[] colours;
    private final FireworksMIDlet parent;
    private final boolean useColour;
    private final Random random = new Random();
    private final DoublyLinkedList sparkList = new DoublyLinkedList();
    private volatile Thread animationThread = null;
    private static final int[] SINES;

    FireworksCanvas(FireworksMIDlet parent) {
        this.parent = parent;
        this.useColour = Display.getDisplay((MIDlet)parent).isColor();
    }

    synchronized void start() {
        this.animationThread = new Thread(this);
        this.animationThread.start();
    }

    synchronized void stop() {
        this.animationThread = null;
    }

    /*
     * Exception decompiling
     */
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void paint(Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.drawAllSparks(g);
    }

    public void keyPressed(int keyCode) {
        this.parent.exitRequested();
    }

    private synchronized void tick() {
        Spark currentSpark = (Spark)this.sparkList.getFirst();
        while (currentSpark != null) {
            Spark nextSpark = (Spark)this.sparkList.getNext(currentSpark);
            currentSpark.tick();
            currentSpark = nextSpark;
        }
        if (this.sparkList.isEmpty() || this.rand(10) == 0) {
            this.explode();
        }
    }

    private void explode() {
        int colour = this.useColour ? colours[this.rand(colours.length)] : 0xFFFFFF;
        int x = this.rand(this.getWidth() / 2) + this.getWidth() / 4 << 8;
        int y = this.rand(this.getHeight() / 2) + this.getHeight() / 4 << 8;
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 6; ++j) {
                int projectedAngle = i * 3 + this.rand(3);
                int planeAngle = j * 3 + this.rand(3);
                int magnitudeTimes256 = 2 * FireworksCanvas.cosineTimes256(planeAngle);
                int vx = FireworksCanvas.cosineTimes256(projectedAngle) * magnitudeTimes256 << 8 >> 16;
                int vy = FireworksCanvas.sineTimes256(projectedAngle) * magnitudeTimes256 << 8 >> 16;
                int timeToLive = 20 + this.rand(20);
                Spark spark = new Spark(x, y, vx, vy, colour, timeToLive);
                this.sparkList.addFirst(spark);
            }
        }
    }

    private synchronized void drawAllSparks(Graphics g) {
        Spark currentSpark = (Spark)this.sparkList.getFirst();
        while (currentSpark != null) {
            Spark nextSpark = (Spark)this.sparkList.getNext(currentSpark);
            currentSpark.draw(g);
            currentSpark = nextSpark;
        }
    }

    private int rand(int scale) {
        return (this.random.nextInt() << 1 >>> 1) % scale;
    }

    private static int sineTimes256(int angle) {
        if ((angle %= 36) <= 9) {
            return SINES[angle];
        }
        if (angle <= 18) {
            return SINES[18 - angle];
        }
        if (angle <= 27) {
            return -SINES[angle - 18];
        }
        return -SINES[36 - angle];
    }

    private static int cosineTimes256(int angle) {
        return FireworksCanvas.sineTimes256(angle + 9);
    }

    static {
        FIXED_POINT_SHIFT = 8;
        MILLIS_PER_TICK = 100;
        TICKS_PER_EXPLOSION = 10;
        SPARK_LIFE_IN_TICKS = 20;
        SPARK_RANDOM_LIFE_IN_TICKS = 20;
        SPARK_VELOCITY = 2;
        colours = new int[]{0xFF0000, 65280, 0xFFFF00, 0xFF00FF, 65535};
        SINES = new int[]{0, 44, 88, 128, 165, 196, 222, 241, 252, 256};
    }
}

