/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Image;

public class GS60_DynamicImage {
    private int w;
    private int h;
    public int num_pal_entries;
    private boolean transparent;
    public byte[] buf;
    public int buf_len;
    private int pix_data_index;
    private int bias_color;

    private int stuff32(int n, int n2) {
        this.buf[n] = (byte)(n2 >> 24);
        this.buf[n + 1] = (byte)(n2 >> 16);
        this.buf[n + 2] = (byte)(n2 >> 8);
        this.buf[n + 3] = (byte)n2;
        return n + 4;
    }

    private int stuff16(int n, int n2) {
        this.buf[n] = (byte)(n2 >> 8);
        this.buf[n + 1] = (byte)n2;
        return n + 2;
    }

    static int GetColorAtXYFromRLEBitstream(GS60_BitStreamReader gS60_BitStreamReader, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8 = gS60_BitStreamReader.Read(8);
        int n9 = gS60_BitStreamReader.Read(8);
        if (n9 == 0) {
            n9 = gS60_BitStreamReader.Read(16);
        }
        if ((n7 = gS60_BitStreamReader.Read(8)) == 0) {
            n7 = gS60_BitStreamReader.Read(16);
        }
        if ((n6 = gS60_BitStreamReader.Read(8)) == 0) {
            n6 = 256;
        }
        int n10 = GS60_BitStreamReader.Utility_BitsReqdToRepresentIntRange(n6);
        int n11 = gS60_BitStreamReader.Read(4);
        int n12 = gS60_BitStreamReader.GetOffset();
        gS60_BitStreamReader.Skip(n6 * 3 * n11);
        int n13 = gS60_BitStreamReader.Read(3);
        int n14 = gS60_BitStreamReader.Read(3);
        int n15 = -1;
        for (n5 = 0; n5 < n7; ++n5) {
            n4 = 0;
            while (n4 < n9) {
                int n16;
                n3 = gS60_BitStreamReader.Read(1);
                if (n3 != 0) {
                    n16 = gS60_BitStreamReader.Read(n13);
                    if (n2 == n5 && n < (n4 += n16)) {
                        n15 = gS60_BitStreamReader.Read(n10);
                        break;
                    }
                    gS60_BitStreamReader.Skip(n10);
                    continue;
                }
                n16 = gS60_BitStreamReader.Read(n14);
                if (n2 == n5 && n < (n4 += n16)) {
                    gS60_BitStreamReader.Skip(n10 * (n - (n4 - n16)));
                    n15 = gS60_BitStreamReader.Read(n10);
                    break;
                }
                gS60_BitStreamReader.Skip(n10 * n16);
            }
            if (n15 >= 0) break;
        }
        gS60_BitStreamReader.SetOffset(n12 + 3 * n15 * n11);
        n5 = gS60_BitStreamReader.Read(n11) << 8 - n11;
        n4 = gS60_BitStreamReader.Read(n11) << 8 - n11;
        n3 = gS60_BitStreamReader.Read(n11) << 8 - n11;
        return (n5 << 16) + (n4 << 8) + n3;
    }

    public void ReloadFromAdaptiveRleBitstream(GS60_BitStreamReader gS60_BitStreamReader) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = gS60_BitStreamReader.Read(8);
        int n7 = gS60_BitStreamReader.Read(8);
        if (n7 == 0) {
            n7 = gS60_BitStreamReader.Read(16);
        }
        if ((n5 = gS60_BitStreamReader.Read(8)) == 0) {
            n5 = gS60_BitStreamReader.Read(16);
        }
        this.Resize(n7, n5);
        int n8 = gS60_BitStreamReader.Read(8);
        if (n8 == 0) {
            n8 = 256;
        }
        int n9 = GS60_BitStreamReader.Utility_BitsReqdToRepresentIntRange(n8);
        int n10 = gS60_BitStreamReader.Read(4);
        int n11 = this.GetPaletteIndex() + 0;
        int n12 = this.bias_color >> 16 & 0xFF;
        int n13 = this.bias_color >> 8 & 0xFF;
        int n14 = this.bias_color & 0xFF;
        for (n4 = 0; n4 < n8; ++n4) {
            n3 = gS60_BitStreamReader.Read(n10) << 8 - n10;
            n2 = gS60_BitStreamReader.Read(n10) << 8 - n10;
            n = gS60_BitStreamReader.Read(n10) << 8 - n10;
            n3 += n12;
            n2 += n13;
            n += n14;
            if (n6 == 2) {
                n3 -= 128;
                n2 -= 128;
                n -= 128;
            }
            if (n3 < 0) {
                n3 = 0;
            }
            if (n2 < 0) {
                n2 = 0;
            }
            if (n < 0) {
                n = 0;
            }
            if (n3 > 255) {
                n3 = 255;
            }
            if (n2 > 255) {
                n2 = 255;
            }
            if (n > 255) {
                n = 255;
            }
            this.buf[n11++] = (byte)n3;
            this.buf[n11++] = (byte)n2;
            this.buf[n11++] = (byte)n;
        }
        this.calcPalChecksum();
        n4 = gS60_BitStreamReader.Read(3);
        n3 = gS60_BitStreamReader.Read(3);
        n2 = this.GetPixelDataIndex(0);
        n = this.GetPixelDataStride();
        int n15 = 0;
        while (n15 < n5) {
            n11 = n2;
            int n16 = 0;
            while (n16 < n7) {
                int n17;
                int n18 = gS60_BitStreamReader.Read(1);
                if (n18 != 0) {
                    n17 = gS60_BitStreamReader.Read(n4);
                    n16 += n17;
                    byte by = (byte)gS60_BitStreamReader.Read(n9);
                    while (n17-- != 0) {
                        this.buf[n11++] = by;
                    }
                    continue;
                }
                n17 = gS60_BitStreamReader.Read(n3);
                n16 += n17;
                while (n17-- != 0) {
                    this.buf[n11++] = (byte)gS60_BitStreamReader.Read(n9);
                }
            }
            ++n15;
            n2 += n;
        }
        this.calcImageChecksum();
    }

    public void LoadFromAdaptiveRleBitstream(GS60_BitStreamReader gS60_BitStreamReader, boolean bl) {
        int n;
        int n2;
        int n3 = gS60_BitStreamReader.GetOffset();
        int n4 = gS60_BitStreamReader.Read(8);
        int n5 = gS60_BitStreamReader.Read(8);
        if (n5 == 0) {
            n5 = gS60_BitStreamReader.Read(16);
        }
        if ((n2 = gS60_BitStreamReader.Read(8)) == 0) {
            n2 = gS60_BitStreamReader.Read(16);
        }
        if ((n = gS60_BitStreamReader.Read(8)) == 0) {
            n = 256;
        }
        gS60_BitStreamReader.SetOffset(n3);
        this.Init(n5, n2, n, bl);
        this.ReloadFromAdaptiveRleBitstream(gS60_BitStreamReader);
    }

    public void LoadFromAdaptiveRleFile(gs60bjc2 gs60bjc22, String string, boolean bl) {
        byte[] byArray = GS60_AssetMgr.LoadBinaryData(string);
        GS60_BitStreamReader gS60_BitStreamReader = new GS60_BitStreamReader();
        gS60_BitStreamReader.Init(byArray);
        this.LoadFromAdaptiveRleBitstream(gS60_BitStreamReader, bl);
        byArray = null;
    }

    public void TintPalette(int n, int n2, int n3, int[] nArray, int[] nArray2) {
        if (n2 != 0) {
            int n4;
            int n5 = this.num_pal_entries;
            int n6 = n2 * (n >> 16 & 0xFF);
            int n7 = n2 * (n >> 8 & 0xFF);
            int n8 = n2 * (n & 0xFF);
            n2 = 16384 - n2;
            int n9 = n4 = this.GetPaletteIndex() + 0;
            while (n5-- > 0) {
                int n10 = this.buf[n4++];
                int n11 = this.buf[n4++];
                int n12 = this.buf[n4++];
                int n13 = ((n10 & 0xFF) << 16) + ((n11 & 0xFF) << 8) + (n12 & 0xFF);
                n10 = n13 >> 16 & 0xFF;
                n11 = n13 >> 8 & 0xFF;
                n12 = n13 & 0xFF;
                int n14 = n6 + n2 * n10 >> 14;
                int n15 = n7 + n2 * n11 >> 14;
                int n16 = n8 + n2 * n12 >> 14;
                for (int i = 0; i < n3; ++i) {
                    if (n13 != nArray[i]) continue;
                    n14 = nArray2[i] >> 16 & 0xFF;
                    n15 = nArray2[i] >> 8 & 0xFF;
                    n16 = nArray2[i] & 0xFF;
                    break;
                }
                this.buf[n9++] = (byte)n14;
                this.buf[n9++] = (byte)n15;
                this.buf[n9++] = (byte)n16;
            }
            this.calcPalChecksum();
        }
    }

    public void StencilPalette(int n, int n2) {
        int n3 = this.num_pal_entries;
        int n4 = this.GetPaletteIndex() + 0;
        while (n3-- > 0) {
            int n5 = this.buf[n4] & 0xFF;
            this.buf[n4++] = (byte)(((n2 >> 16 & 0xFF) - (n >> 16 & 0xFF)) * n5 / 255 + (n >> 16 & 0xFF));
            this.buf[n4++] = (byte)(((n2 >> 8 & 0xFF) - (n >> 8 & 0xFF)) * n5 / 255 + (n >> 8 & 0xFF));
            this.buf[n4++] = (byte)(((n2 & 0xFF) - (n & 0xFF)) * n5 / 255 + (n & 0xFF));
        }
        this.calcPalChecksum();
    }

    public void ChangePaletteColor(int n, int n2) {
        int n3 = this.num_pal_entries;
        int n4 = this.GetPaletteIndex() + 0;
        while (n3-- >= 0) {
            byte by;
            byte by2;
            int n5;
            int n6 = n4;
            byte by3 = this.buf[n4++];
            if ((n5 = ((by3 & 0xFF) << 16) + (((by2 = this.buf[n4++]) & 0xFF) << 8) + ((by = this.buf[n4++]) & 0xFF)) != n) continue;
            this.buf[n6++] = (byte)(n2 >> 16 & 0xFF);
            this.buf[n6++] = (byte)(n2 >> 8 & 0xFF);
            this.buf[n6++] = (byte)(n2 & 0xFF);
        }
        this.calcPalChecksum();
    }

    static Image LoadRLECompressedImage(gs60bjc2 gs60bjc22, String string, boolean bl, int n) {
        Image image = null;
        byte[] byArray = GS60_AssetMgr.LoadBinaryData(string);
        GS60_DynamicImage gS60_DynamicImage = new GS60_DynamicImage();
        GS60_BitStreamReader gS60_BitStreamReader = new GS60_BitStreamReader();
        gS60_BitStreamReader.Init(byArray);
        gS60_DynamicImage.bias_color = n;
        gS60_DynamicImage.LoadFromAdaptiveRleBitstream(gS60_BitStreamReader, bl);
        image = Image.createImage((byte[])gS60_DynamicImage.buf, (int)0, (int)gS60_DynamicImage.buf_len);
        gS60_DynamicImage = null;
        byArray = null;
        return image;
    }

    public void Init(int n, int n2, int n3, boolean bl) {
        this.transparent = bl;
        this.w = n;
        this.h = n2;
        this.num_pal_entries = n3;
        this.buf_len = (1 + n) * n2 + 3 * n3 + 80 + (this.transparent ? 13 : 0);
        this.buf = new byte[this.buf_len];
        this.Resize(this.w, this.h);
    }

    public void Resize(int n, int n2) {
        this.buf_len = (1 + n) * n2 + 3 * this.num_pal_entries + 80 + (this.transparent ? 13 : 0);
        int n3 = 7;
        int n4 = n * n2;
        if (n4 <= 256) {
            n3 = 1;
        } else if (n4 <= 512) {
            n3 = 2;
        } else if (n4 <= 1024) {
            n3 = 3;
        } else if (n4 <= 2048) {
            n3 = 4;
        } else if (n4 <= 4096) {
            n3 = 5;
        } else if (n4 <= 8192) {
            n3 = 6;
        }
        this.w = n;
        this.h = n2;
        this.stuff32(0, -1991225785);
        this.stuff32(4, 218765834);
        this.stuff32(8, 13);
        this.stuff32(12, 1229472850);
        this.stuff32(16, this.w);
        this.stuff32(20, this.h);
        this.buf[24] = 8;
        this.buf[25] = 3;
        this.buf[26] = 0;
        this.buf[27] = 0;
        this.buf[28] = 0;
        this.stuff32(29, gs60bjc2.static_applet.png_checksum__compute_crc(this.buf, 29, 12));
        this.stuff32(33, 3 * this.num_pal_entries);
        this.stuff32(37, 1347179589);
        int n5 = 45 + 3 * this.num_pal_entries;
        if (this.transparent) {
            n5 = this.stuff32(n5, 1);
            n5 = this.stuff32(n5, 1951551059);
            this.buf[n5++] = 0;
            this.stuff32(n5, gs60bjc2.static_applet.png_checksum__compute_crc(this.buf, n5, n5 - 5));
            n5 += 4;
        }
        n5 = this.stuff32(n5, 11 + (1 + this.w) * this.h);
        n5 = this.stuff32(n5, 1229209940);
        int n6 = (n3 << 12) + 2240;
        n6 = n6 + 31 - n6 % 31;
        n5 = this.stuff16(n5, n6);
        this.buf[n5++] = 1;
        int n7 = this.h * (this.w + 1);
        if (n7 > 65535) {
            // empty if block
        }
        n7 = (n7 >> 8) + (n7 << 8);
        n5 = this.stuff16(n5, n7);
        this.pix_data_index = n5 = this.stuff16(n5, n7 ^ 0xFFFF);
        for (int i = this.h - 1; i >= 0; --i) {
            this.buf[this.pix_data_index + (this.w + 1) * i] = 0;
        }
        n5 = this.pix_data_index + (1 + this.w) * this.h + 8;
        n5 = this.stuff32(n5, 0);
        n5 = this.stuff32(n5, 1229278788);
        n5 = this.stuff32(n5, -1371381630);
    }

    public int GetPaletteIndex() {
        return 41;
    }

    public int GetPixelDataIndex(int n) {
        return this.pix_data_index + (this.w + 1) * n + 1;
    }

    public int GetPixelDataStride() {
        return this.w + 1;
    }

    public Image GetImage() {
        return Image.createImage((byte[])this.buf, (int)0, (int)this.buf_len);
    }

    public void calcPalChecksum() {
        this.stuff32(41 + 3 * this.num_pal_entries, gs60bjc2.static_applet.png_checksum__compute_crc(this.buf, 41 + 3 * this.num_pal_entries, 37));
    }

    public void calcImageChecksum() {
        int n = this.pix_data_index + (this.w + 1) * this.h;
        this.stuff32(n, (int)gs60bjc2.static_applet.png_checksum__adler32(this.buf, this.pix_data_index, (this.w + 1) * this.h));
        this.stuff32(n + 4, gs60bjc2.static_applet.png_checksum__compute_crc(this.buf, n + 4, this.pix_data_index - 11));
    }
}

