/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Image;

class GS60_Image_Pipeline {
    private int width;
    private int height;
    public int pal_entries_used;
    private byte[] pal_red = new byte[256];
    private byte[] pal_grn = new byte[256];
    private byte[] pal_blu = new byte[256];
    private byte[] pal_remapper = new byte[256];
    private byte[] image = null;
    private short[] light_channel = null;

    public void Init(int n, int n2) {
        this.Unload();
        this.width = n + 1 & 0xFFFFFFFE;
        this.height = n2;
        this.pal_entries_used = 2;
        this.pal_red[1] = -1;
        this.pal_grn[1] = 0;
        this.pal_blu[1] = -1;
        this.image = new byte[this.width * this.height];
        this.light_channel = new short[this.width * this.height];
        for (int i = this.width * this.height - 1; i >= 0; --i) {
            this.image[i] = 1;
            this.light_channel[i] = 0;
        }
    }

    public void Unload() {
        this.image = null;
        this.light_channel = null;
    }

    public Image CreateImage(gs60bjc2 gs60bjc22, Image image, boolean bl) {
        int n;
        this.QuantizeLightmap(bl);
        GS60_DynamicImage gS60_DynamicImage = new GS60_DynamicImage();
        gS60_DynamicImage.Init(this.width, this.height, this.pal_entries_used - 1, bl);
        int n2 = gS60_DynamicImage.GetPaletteIndex() + 0;
        for (n = 1; n < this.pal_entries_used; ++n) {
            gS60_DynamicImage.buf[n2++] = this.pal_red[n];
            gS60_DynamicImage.buf[n2++] = this.pal_grn[n];
            gS60_DynamicImage.buf[n2++] = this.pal_blu[n];
        }
        gS60_DynamicImage.calcPalChecksum();
        n = 0;
        for (int i = 0; i < this.height; ++i) {
            n2 = gS60_DynamicImage.GetPixelDataIndex(i);
            for (int j = 0; j < this.width; ++j) {
                int n3 = n;
                this.image[n3] = (byte)(this.image[n3] - 1);
                gS60_DynamicImage.buf[n2++] = this.image[n++];
            }
        }
        gS60_DynamicImage.calcImageChecksum();
        image = Image.createImage((byte[])gS60_DynamicImage.buf, (int)0, (int)gS60_DynamicImage.buf_len);
        gS60_DynamicImage = null;
        return image;
    }

    private void QuantizeLightmap(boolean bl) {
        int n = 0;
        int n2 = 16;
        int n3 = n2 >> 1;
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                int n4 = this.light_channel[n] + n3 & ~(n2 - 1);
                int n5 = this.light_channel[n] - n4;
                int n6 = this.image[n] & 0xFF;
                if (!bl || this.pal_red[n6] != 255 || this.pal_grn[n6] != 0 || this.pal_blu[n6] != 255) {
                    int n7 = n5 >> 1;
                    int n8 = n5 - n7;
                    if (j < this.width - 1) {
                        int n9 = n + 1;
                        this.light_channel[n9] = (short)(this.light_channel[n9] + n7);
                    }
                    if (i < this.height - 1) {
                        int n10 = n + this.width;
                        this.light_channel[n10] = (short)(this.light_channel[n10] + n8);
                    }
                    if (n4 != 0) {
                        this.image[n] = this.AllocatePaletteEntry_Lit(this.pal_red[n6 &= 0xFF], this.pal_grn[n6], this.pal_blu[n6], n4);
                    }
                }
                ++n;
            }
        }
    }

    private byte AllocatePaletteEntry_Unlit(byte by, byte by2, byte by3) {
        for (int i = 1; i < this.pal_entries_used; ++i) {
            if (this.pal_red[i] != by || this.pal_grn[i] != by2 || this.pal_blu[i] != by3) continue;
            return (byte)i;
        }
        if (this.pal_entries_used >= 256) {
            this.pal_entries_used = 255;
        }
        this.pal_red[this.pal_entries_used] = by;
        this.pal_grn[this.pal_entries_used] = by2;
        this.pal_blu[this.pal_entries_used] = by3;
        return (byte)this.pal_entries_used++;
    }

    private byte AllocatePaletteEntry_Lit(byte by, byte by2, byte by3, int n) {
        int n2;
        if (n != 0) {
            n2 = n + (by & 0xFF);
            int n3 = n + (by2 & 0xFF);
            int n4 = n + (by3 & 0xFF);
            by = n2 < 0 ? (byte)0 : (n2 > 255 ? (byte)-1 : (byte)n2);
            by2 = n3 < 0 ? (byte)0 : (n3 > 255 ? (byte)-1 : (byte)n3);
            by3 = n4 < 0 ? (byte)0 : (n4 > 255 ? (byte)-1 : (byte)n4);
        }
        for (n2 = 1; n2 < this.pal_entries_used; ++n2) {
            if (this.pal_red[n2] != by || this.pal_grn[n2] != by2 || this.pal_blu[n2] != by3) continue;
            return (byte)n2;
        }
        if (this.pal_entries_used >= 256) {
            this.pal_entries_used = 255;
        }
        this.pal_red[this.pal_entries_used] = by;
        this.pal_grn[this.pal_entries_used] = by2;
        this.pal_blu[this.pal_entries_used] = by3;
        return (byte)this.pal_entries_used++;
    }

    public void Fill(int n) {
        byte by = (byte)(n >> 16 & 0xFF);
        byte by2 = (byte)(n >> 8 & 0xFF);
        byte by3 = (byte)(n & 0xFF);
        byte by4 = this.AllocatePaletteEntry_Unlit(by, by2, by3);
        for (int i = this.width * this.height - 1; i >= 0; --i) {
            this.image[i] = by4;
        }
    }

    public void AddSpotlight(int n, int n2, int n3, int n4, int n5) {
        int n6 = (int)(0x10000000L / (long)((n5 <<= 14) - (n4 <<= 14)));
        int n7 = 0;
        for (int i = 0; i < this.height; ++i) {
            int n8 = i - n2 << 14;
            for (int j = 0; j < this.width; ++j) {
                int n9;
                int n10;
                int n11 = (n8 < 0 ? -n8 : n8) > ((n10 = j - n << 14) < 0 ? -n10 : n10) ? (n8 < 0 ? -n8 : n8) - ((n8 < 0 ? -n8 : n8) >> 5) - ((n8 < 0 ? -n8 : n8) >> 7) + (((n10 < 0 ? -n10 : n10) + ((n10 < 0 ? -n10 : n10) >> 1) >> 2) + ((n10 < 0 ? -n10 : n10) + ((n10 < 0 ? -n10 : n10) >> 1) >> 6)) : (n9 = (n10 < 0 ? -n10 : n10) - ((n10 < 0 ? -n10 : n10) >> 5) - ((n10 < 0 ? -n10 : n10) >> 7) + (((n8 < 0 ? -n8 : n8) + ((n8 < 0 ? -n8 : n8) >> 1) >> 2) + ((n8 < 0 ? -n8 : n8) + ((n8 < 0 ? -n8 : n8) >> 1) >> 6)));
                if (n9 < n5) {
                    if (n9 > n4) {
                        int n12 = (int)((long)(n5 - n9) * (long)n6 >> 14);
                        int n13 = n7;
                        this.light_channel[n13] = (short)(this.light_channel[n13] + (int)((long)n3 * (long)n12 >> 14));
                    } else {
                        int n14 = n7;
                        this.light_channel[n14] = (short)(this.light_channel[n14] + n3);
                    }
                }
                ++n7;
            }
        }
    }

    public void AddFromRLE_LightmapStencilOrImage(byte[] byArray, int n, int n2, int n3, int n4, int n5) {
        GS60_BitStreamReader gS60_BitStreamReader = new GS60_BitStreamReader();
        gS60_BitStreamReader.Init(byArray);
        this.AddFromRLE_LightmapStencilOrImage(gS60_BitStreamReader, n, n2, n3, n4, n5);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void AddFromRLE_LightmapStencilOrImage(GS60_BitStreamReader gS60_BitStreamReader, int n, int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        boolean bl = (n5 & 0x10) != 0;
        boolean bl2 = (n5 & 8) != 0;
        boolean bl3 = (n5 & 0x20) != 0;
        boolean bl4 = (n5 & 1) != 0;
        int n11 = n3 >> 16 & 0xFF;
        int n12 = n3 >> 8 & 0xFF;
        int n13 = n3 & 0xFF;
        int n14 = (n4 >> 16 & 0xFF) - (n3 >> 16 & 0xFF);
        int n15 = (n4 >> 8 & 0xFF) - (n3 >> 8 & 0xFF);
        int n16 = (n4 & 0xFF) - (n3 & 0xFF);
        int n17 = gS60_BitStreamReader.Read(8);
        int n18 = gS60_BitStreamReader.Read(8);
        if (n18 == 0) {
            n18 = gS60_BitStreamReader.Read(16);
        }
        int n19 = n18;
        int n20 = gS60_BitStreamReader.Read(8);
        if (n20 == 0) {
            n20 = gS60_BitStreamReader.Read(16);
        }
        int n21 = n18;
        int n22 = 0;
        int n23 = 0;
        int n24 = n - ((n5 & 2) != 0 ? n18 >> 1 : 0);
        int n25 = n2 - ((n5 & 4) != 0 ? n20 >> 1 : 0);
        if (n25 < 0) {
            n20 += n25;
            n23 = -n25;
            n25 = 0;
            if (n20 <= 0) {
                return;
            }
        }
        if (n20 + n25 > this.height) {
            n20 = this.height - n25;
        }
        if (n20 <= 0) {
            return;
        }
        if (n24 < 0) {
            n18 += n24;
            n22 = -n24;
            n24 = 0;
            if (n18 < 0) {
                return;
            }
        }
        if (n18 + n24 > this.width) {
            n18 = this.width - n24;
        }
        if (n18 <= 0) {
            return;
        }
        int n26 = gS60_BitStreamReader.Read(8);
        if (n26 == 0) {
            n26 = 256;
        }
        int n27 = GS60_BitStreamReader.Utility_BitsReqdToRepresentIntRange(n26);
        int n28 = gS60_BitStreamReader.Read(4);
        for (int i = 0; i < n26; ++i) {
            n10 = gS60_BitStreamReader.Read(n28) << 8 - n28;
            n9 = gS60_BitStreamReader.Read(n28) << 8 - n28;
            n8 = gS60_BitStreamReader.Read(n28) << 8 - n28;
            if (bl) {
                this.pal_remapper[i] = (byte)(n10 - 128);
                continue;
            }
            n7 = 0;
            if (bl3) {
                if (n10 == 255 && n8 == 255 && n9 == 0) {
                    n8 = 0;
                    n10 = 0;
                }
                if (n8 == 0 && bl4) {
                    n7 = 1;
                } else {
                    n10 = n11 + n14 * (n8 & 0xFF) / 255;
                    n9 = n12 + n15 * (n8 & 0xFF) / 255;
                    n8 = n13 + n16 * (n8 & 0xFF) / 255;
                }
            }
            if (bl2 && bl4 && n10 == 255 && n8 == 255 && n9 == 0) {
                n7 = 1;
            }
            this.pal_remapper[i] = n7 != 0 ? (byte)0 : this.AllocatePaletteEntry_Unlit((byte)n10, (byte)n9, (byte)n8);
        }
        n10 = gS60_BitStreamReader.Read(3);
        n9 = gS60_BitStreamReader.Read(3);
        while (true) {
            if (n23 <= 0) break;
            for (int i = 0; i < n21; i += n6) {
                if (gS60_BitStreamReader.Read(1) != 0) {
                    n6 = gS60_BitStreamReader.Read(n10);
                    gS60_BitStreamReader.Skip(n27);
                    continue;
                }
                n6 = gS60_BitStreamReader.Read(n9);
                gS60_BitStreamReader.Skip(n6 * n27);
            }
            --n23;
        }
        n8 = n25 * this.width + n24;
        int n29 = n25 * this.width + n24;
        int n30 = this.width;
        while (true) {
            int n31;
            int n32;
            block55: {
                short s;
                int n33;
                int n34;
                block57: {
                    block53: {
                        if (n20 <= 0) {
                            return;
                        }
                        n7 = n8;
                        n8 += n30;
                        n34 = n29;
                        n29 += n30;
                        n32 = n19;
                        int n35 = n22;
                        while (true) {
                            if ((n31 = gS60_BitStreamReader.Read(1)) != 0) {
                                n6 = gS60_BitStreamReader.Read(n10);
                                n32 -= n6;
                                if (n6 <= n35) {
                                    n35 -= n6;
                                    gS60_BitStreamReader.Skip(n27);
                                    continue;
                                }
                                n6 -= n35;
                                break block53;
                            }
                            n6 = gS60_BitStreamReader.Read(n9);
                            n32 -= n6;
                            if (n6 > n35) break;
                            n35 -= n6;
                            gS60_BitStreamReader.Skip(n27 * n6);
                        }
                        n6 -= n35;
                        gS60_BitStreamReader.Skip(n27 * n35);
                    }
                    n33 = n18;
                    if (!bl) break block57;
                    while (true) {
                        block54: {
                            block58: {
                                if (n31 == 0) break block58;
                                s = this.pal_remapper[gS60_BitStreamReader.Read(n27)];
                                if (n6 < n33) {
                                    n33 -= n6;
                                    if (s == 0) {
                                        n7 += n6;
                                        break block54;
                                    } else {
                                        while (n6-- != 0) {
                                            int n36 = n7++;
                                            this.light_channel[n36] = (short)(this.light_channel[n36] + s);
                                        }
                                    }
                                    break block54;
                                } else {
                                    if (s != 0) {
                                        while (n33-- != 0) {
                                            int n37 = n7++;
                                            this.light_channel[n37] = (short)(this.light_channel[n37] + s);
                                        }
                                    }
                                    break block55;
                                }
                            }
                            if (n6 >= n33) {
                                n6 -= n33;
                                while (n33-- != 0) {
                                    int n38 = n7++;
                                    this.light_channel[n38] = (short)(this.light_channel[n38] + this.pal_remapper[gS60_BitStreamReader.Read(n27)]);
                                }
                                gS60_BitStreamReader.Skip(n6 * n27);
                                break block55;
                            }
                            n33 -= n6;
                            while (n6-- != 0) {
                                int n39 = n7++;
                                this.light_channel[n39] = (short)(this.light_channel[n39] + this.pal_remapper[gS60_BitStreamReader.Read(n27)]);
                            }
                        }
                        n6 = gS60_BitStreamReader.Read((n31 = gS60_BitStreamReader.Read(1)) != 0 ? n10 : n9);
                        n32 -= n6;
                    }
                }
                while (true) {
                    block56: {
                        block59: {
                            if (n31 == 0) break block59;
                            s = this.pal_remapper[gS60_BitStreamReader.Read(n27)];
                            if (n6 < n33) {
                                n33 -= n6;
                                if (s == 0) {
                                    n34 += n6;
                                    break block56;
                                } else {
                                    while (n6-- != 0) {
                                        this.image[n34++] = s;
                                    }
                                }
                                break block56;
                            } else {
                                if (s == 0) break;
                                while (n33-- != 0) {
                                    this.image[n34++] = s;
                                }
                                break;
                            }
                        }
                        if (n6 < n33) {
                            n33 -= n6;
                            while (n6-- != 0) {
                                s = this.pal_remapper[gS60_BitStreamReader.Read(n27)];
                                if (s != 0) {
                                    this.image[n34] = s;
                                }
                                ++n34;
                            }
                        } else {
                            n6 -= n33;
                            while (n33-- != 0) {
                                s = this.pal_remapper[gS60_BitStreamReader.Read(n27)];
                                if (s != 0) {
                                    this.image[n34] = s;
                                }
                                ++n34;
                            }
                            gS60_BitStreamReader.Skip(n6 * n27);
                            break;
                        }
                    }
                    n6 = gS60_BitStreamReader.Read((n31 = gS60_BitStreamReader.Read(1)) != 0 ? n10 : n9);
                    n32 -= n6;
                }
            }
            while (n32 != 0) {
                n31 = gS60_BitStreamReader.Read(1);
                if (n31 != 0) {
                    n6 = gS60_BitStreamReader.Read(n10);
                    gS60_BitStreamReader.Skip(n27);
                } else {
                    n6 = gS60_BitStreamReader.Read(n9);
                    gS60_BitStreamReader.Skip(n27 * n6);
                }
                n32 -= n6;
            }
            --n20;
        }
    }

    public int GetColor(int n) {
        return (this.pal_red[n] << 16) + (this.pal_grn[n] << 8) + this.pal_blu[n];
    }

    public void SetColor(int n, int n2) {
        this.pal_red[n] = (byte)(n2 >> 16 & 0xFF);
        this.pal_grn[n] = (byte)(n2 >> 8 & 0xFF);
        this.pal_blu[n] = (byte)(n2 & 0xFF);
    }
}

