/*
 * Decompiled with CFR 0.152.
 */
package temp.shared;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.microedition.lcdui.Graphics;
import temp.Solitaire8x1;

public class Card {
    public int value;
    public int color;
    public int etat;
    public int x;
    public int y;
    public int xTarget;
    public int yTarget;
    public int vx;
    public int vy;
    public int xfp;
    public int yfp;
    private static final int SHIFT = 8;
    public int stepAnim;
    public int MaxStepAnim;
    public boolean isSelected = false;
    public boolean isAnim = false;
    public boolean isDistributed = true;
    public boolean retournement = false;
    public boolean isInTableau;
    public int pos = -1;

    public Card() {
    }

    public Card(int i, int e) {
        this.value = (i - 1) % 13 + 1;
        this.color = (i - 1) / 13;
        this.etat = e;
    }

    public Card(int val, int col, int e) {
        this.value = val;
        this.color = col;
        this.etat = e;
    }

    public boolean move() {
        this.xfp += this.vx;
        this.yfp += this.vy;
        this.x = this.xfp >> 8;
        this.y = this.yfp >> 8;
        if (this.stepAnim++ == this.MaxStepAnim) {
            this.x = this.xTarget;
            this.y = this.yTarget;
            return true;
        }
        return false;
    }

    public void paint(Graphics g, boolean isCardTab) {
        if (!this.isAnim && this.isDistributed) {
            Solitaire8x1.instance.game.drawCard(g, this, isCardTab, false);
        }
    }

    public boolean isVisible() {
        return this.etat == 1;
    }

    public boolean isSameColor(Card c) {
        return this.isBlack() && c.isBlack() || !this.isBlack() && !c.isBlack();
    }

    public boolean isBlack() {
        return this.color == 0 || this.color == 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] write() {
        byte[] byArray;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream os = new DataOutputStream(baos);
        try {
            os.writeInt(this.value);
            os.writeInt(this.color);
            os.writeInt(this.etat);
            os.writeInt(this.x);
            os.writeInt(this.y);
            os.writeBoolean(this.isSelected);
            os.writeBoolean(this.isAnim);
            os.writeBoolean(this.isDistributed);
            os.writeBoolean(this.retournement);
            os.writeBoolean(this.isInTableau);
            os.writeInt(this.pos);
            byArray = baos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                os.close();
                baos.close();
                throw throwable;
            }
            catch (Exception exception) {
                return baos.toByteArray();
            }
        }
        os.close();
        baos.close();
        return byArray;
    }

    public void read(byte[] b) {
        ByteArrayInputStream bios = new ByteArrayInputStream(b);
        DataInputStream is = new DataInputStream(bios);
        try {
            this.value = is.readInt();
            this.color = is.readInt();
            this.etat = is.readInt();
            this.x = is.readInt();
            this.y = is.readInt();
            this.isSelected = is.readBoolean();
            this.isAnim = is.readBoolean();
            this.isDistributed = is.readBoolean();
            this.retournement = is.readBoolean();
            this.isInTableau = is.readBoolean();
            this.pos = is.readInt();
            is.close();
            bios.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

