/*
 * Decompiled with CFR 0.152.
 */
package temp.shared;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.microedition.lcdui.Graphics;
import temp.Solitaire8x1;
import temp.shared.Card;

public class CardStack {
    public int nbCards = 0;
    public Card[] Cards;
    public int pos;
    public Card selectionnable;
    public int topCard;
    public int bottomCard;

    public CardStack() {
    }

    public CardStack(int i, int p) {
        this.Cards = new Card[i];
        this.pos = p;
    }

    public void paint(Graphics g) {
        if (this.last().isInTableau) {
            for (int i = 0; i < this.nbCards; ++i) {
                if (this.nbCards != -1) {
                    if (this.Cards[i].isVisible()) {
                        this.Cards[i].paint(g, true);
                        continue;
                    }
                    if (!this.Cards[i].isDistributed) continue;
                    Solitaire8x1.instance.game.paint_carte_retourne(g, this.Cards[i].x, this.Cards[i].y);
                    continue;
                }
                this.nbCards = -1;
            }
        } else {
            this.last().paint(g, true);
        }
    }

    public void paint_bis(Graphics g) {
        for (int i = this.topCard; i <= this.bottomCard; ++i) {
            if (this.nbCards == -1 || this.Cards[i].isAnim) continue;
            if (this.Cards[i].isVisible()) {
                this.Cards[i].paint(g, true);
                continue;
            }
            if (!this.Cards[i].isDistributed) continue;
            Solitaire8x1.instance.game.paint_carte_retourne(g, this.Cards[i].x, this.Cards[i].y);
        }
    }

    public void addCard(Card c) {
        this.Cards[this.nbCards++] = c;
    }

    public void remove() {
        this.last().etat = -1;
        --this.nbCards;
    }

    public void remove(Card c) {
        if (this.nbCards != 0) {
            int pos = -1;
            for (int i = 0; i < this.nbCards; ++i) {
                if (this.Cards[i] != c) continue;
                pos = i;
                break;
            }
            for (int j = pos; j < this.nbCards - 1; ++j) {
                this.Cards[j] = this.Cards[j + 1];
            }
            --this.nbCards;
        }
    }

    public Card last() {
        return this.Cards[this.nbCards - 1];
    }

    public boolean isSelectionnable(int p) {
        return p < this.nbCards && this.Cards[p] == this.selectionnable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] write() {
        byte[] byArray;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream os = new DataOutputStream(baos);
        try {
            os.writeInt(this.nbCards);
            os.writeInt(this.topCard);
            os.writeInt(this.bottomCard);
            os.writeInt(this.pos);
            byte[] temp = new byte[29];
            for (int i = 0; i < this.nbCards; ++i) {
                temp = this.Cards[i].write();
                os.write(temp, 0, temp.length);
            }
            temp = null;
            byArray = baos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                os.close();
                baos.close();
                throw throwable;
            }
            catch (Exception e) {
                e.printStackTrace();
                return baos.toByteArray();
            }
        }
        os.close();
        baos.close();
        return byArray;
    }

    public void read(byte[] b) {
        ByteArrayInputStream bios = new ByteArrayInputStream(b);
        DataInputStream is = new DataInputStream(bios);
        try {
            this.nbCards = is.readInt();
            this.topCard = is.readInt();
            this.bottomCard = is.readInt();
            this.pos = is.readInt();
            byte[] temp = new byte[29];
            for (int i = 0; i < this.nbCards; ++i) {
                this.Cards[i] = new Card();
                is.readFully(temp);
                this.Cards[i].read(temp);
            }
            temp = null;
            is.close();
            bios.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

