/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;

public class ScreenMenu
implements IScreen {
    final int MODE_LOADING_RES;
    final int MODE_MENU;
    final int MODE_INSTRUCTIONS;
    final int MODE_ABOUT;
    final int MODE_QUIT;
    final int MODE_TOP_SCORE;
    final int MODE_RESET;
    final int MODE_TEQ;
    static int MENUITEM_NEWGAME = 0;
    static int MENUITEM_INFO = 1;
    static int MENUITEM_SCORES = 2;
    static int MENUITEM_ABOUT = 3;
    static int MENUITEM_RESET = 4;
    Canvas canvas;
    int mode;
    int iSelectedItem = -1;
    private static String[] menuStrings = new String[5];
    private static String sBack;
    private static String sOK;
    private static String sName;
    private static String sVersion;
    private static String sQuit;
    private static String sTopScores;
    private static String sResetGame;
    private static String sReset;
    public int startSpeed;
    public int bufferRatio;
    public int SPACING;
    public int DDA_SHIFT = 1;
    public int SHAKE_BOUNCE = 0;
    public int generatingH = 0;
    public int objectXVel = 2;
    public int ySpeedDec = 5;

    public ScreenMenu(Canvas canvas) {
        this.MODE_LOADING_RES = 0;
        this.MODE_MENU = 1;
        this.MODE_INSTRUCTIONS = 2;
        this.MODE_ABOUT = 3;
        this.MODE_QUIT = 4;
        this.MODE_TOP_SCORE = 5;
        this.MODE_RESET = 6;
        this.MODE_TEQ = 7;
        System.out.println("screenMENU");
        this.canvas = canvas;
        this.loadMenuStrings();
        this.mode = 0;
        this.iSelectedItem = 0;
    }

    private void loadMenuStrings() {
        ScreenMenu.menuStrings[0] = XX.texts.getHashedString("NEW_GAME").toUpperCase();
        ScreenMenu.menuStrings[1] = XX.texts.getHashedString("CONTINUE").toUpperCase();
        ScreenMenu.menuStrings[2] = XX.texts.getHashedString("INSTRUCTIONS").toUpperCase();
        ScreenMenu.menuStrings[3] = XX.texts.getHashedString("ABOUT").toUpperCase();
        ScreenMenu.menuStrings[4] = XX.texts.getHashedString("RESET_GAME").toUpperCase();
        System.out.println("adasdasdasd");
        sBack = XX.texts.getHashedString("BACK").toUpperCase();
        sOK = XX.texts.getHashedString("OK").toUpperCase();
        sName = XX.texts.getHashedString("NAME").toUpperCase();
        sVersion = XX.texts.getHashedString("VERSION").toUpperCase();
        sQuit = XX.texts.getHashedString("REALY_QUIT").toUpperCase();
        sTopScores = XX.texts.getHashedString("TOP_SCORES").toUpperCase();
        sResetGame = XX.texts.getHashedString("RESET_G").toUpperCase();
        sReset = XX.texts.getHashedString("RESET").toUpperCase();
    }

    public int getActualMode() {
        return this.mode;
    }

    public String getActualModeName() {
        return "Screen menu";
    }

    public void update(long tick) {
        switch (this.mode) {
            case 7: {
                XX.game.startTequila();
                break;
            }
            case 0: {
                Resources.loadMenuResources();
                if (Settings.bMusic) {
                    XX.soundManager.Stop();
                    XX.soundManager.SetSoundOn(true);
                    XX.soundManager.Play(XX.MUSIC_MENU_ID, -1);
                } else {
                    XX.soundManager.Stop();
                    XX.soundManager.SetSoundOn(false);
                }
                this.mode = 1;
                break;
            }
        }
        this.canvas.repaint();
        this.canvas.serviceRepaints();
    }

    public void keyReleased(int keyCode) {
        switch (this.mode) {
            case 0: {
                break;
            }
        }
    }

    private void openLeaderBoard() {
        MainCanvas.bSyncing = true;
        XX.game.leaderBoards = null;
        MainCanvas.tequila.showContestAnnouncementDialog();
        this.canvas.repaint();
        this.canvas.serviceRepaints();
    }

    public void keyPressed(int keyCode) {
        if (XX.game.bTequilaActive) {
            int iTQPKeyCode = -1;
            if (Keys.key_num2 || Keys.key_up) {
                iTQPKeyCode = 64;
            }
            if (Keys.key_num4 || Keys.key_left) {
                iTQPKeyCode = 66;
            }
            if (Keys.key_num6 || Keys.key_right) {
                iTQPKeyCode = 67;
            }
            if (Keys.key_num8 || Keys.key_down) {
                iTQPKeyCode = 65;
            }
            if (Keys.key_num5 || Keys.key_fire) {
                iTQPKeyCode = 68;
            }
            if (Keys.key_fn1) {
                iTQPKeyCode = 69;
            }
            if (Keys.key_fn2) {
                iTQPKeyCode = 70;
            }
            if (MainCanvas.tequila != null) {
                MainCanvas.tequila.keyActionPressed(iTQPKeyCode);
                return;
            }
        }
        switch (this.mode) {
            case 2: 
            case 3: {
                if (Keys.key_fn1) {
                    this.mode = 1;
                }
                if ((Keys.key_right || Keys.key_down || Keys.key_fn2 || Keys.key_num6 || Keys.key_num8) && ++Resources.iTextStartLine > Resources.iEndLine) {
                    Resources.iTextStartLine = Resources.iEndLine;
                }
                if (!Keys.key_left && !Keys.key_up && !Keys.key_fn1 && !Keys.key_num4 && !Keys.key_num2 || --Resources.iTextStartLine >= 0) break;
                Resources.iTextStartLine = 0;
                break;
            }
            case 4: {
                if (Keys.key_fn2) {
                    this.mode = 7;
                    XX.game.bQuitApp = true;
                    MainCanvas.tequila.showAdvertisementDialog();
                    this.canvas.repaint();
                    this.canvas.serviceRepaints();
                    return;
                }
                if (!Keys.key_fn1) break;
                this.mode = 1;
                return;
            }
            case 1: {
                int ikeysCount = 3;
                if (state.canLoadTable()) {
                    ikeysCount = 4;
                }
                if (Keys.key_fn2) {
                    this.mode = 4;
                    return;
                }
                if (Keys.key_fn1) {
                    Settings.bMusic = !Settings.bMusic;
                    Settings.saveSettings();
                    if (Settings.bMusic) {
                        XX.soundManager.Stop();
                        XX.soundManager.SetSoundOn(true);
                        XX.soundManager.Play(XX.MUSIC_MENU_ID, -1);
                    } else {
                        XX.soundManager.Stop();
                        XX.soundManager.SetSoundOn(false);
                    }
                    return;
                }
                if (Keys.key_left || Keys.key_up || Keys.key_num4 || Keys.key_num2) {
                    this.iSelectedItem = this.iSelectedItem - 1 < 0 ? ikeysCount : --this.iSelectedItem;
                }
                if (Keys.key_right || Keys.key_down || Keys.key_num6 || Keys.key_num8) {
                    this.iSelectedItem = this.iSelectedItem + 1 > ikeysCount ? 0 : ++this.iSelectedItem;
                }
                if (!Keys.key_fire) break;
                if (this.iSelectedItem == MENUITEM_INFO) {
                    Resources.prepareText(XX.texts.getHashedString("INSTRUCTION_TEXT").toUpperCase());
                    this.mode = 2;
                    return;
                }
                if (this.iSelectedItem == MENUITEM_ABOUT) {
                    this.mode = 3;
                    return;
                }
                if (this.iSelectedItem == MENUITEM_SCORES) {
                    this.openLeaderBoard();
                    this.mode = 5;
                }
                if (this.iSelectedItem == MENUITEM_RESET) {
                    Resources.prepareText(menuStrings[4]);
                    this.mode = 6;
                    return;
                }
                if (this.iSelectedItem != MENUITEM_NEWGAME) break;
                if (state.canLoad()) {
                    Resources.releaseMenuResources();
                    MainCanvas.scrGame = new ScreenGame(this.canvas, false);
                    MainCanvas.activeScreen = MainCanvas.scrGame;
                    MainCanvas.scrMenu = null;
                    return;
                }
                Resources.releaseMenuResources();
                MainCanvas.scrGame = new ScreenGame(this.canvas, true);
                MainCanvas.activeScreen = MainCanvas.scrGame;
                MainCanvas.scrMenu = null;
                return;
            }
            case 5: {
                if (Keys.key_down || Keys.key_right || Keys.key_num6 || Keys.key_num8) {
                    if (XX.game.iTopScoreOffset < XX.game.iMaxTopScoreOffset) {
                        ++XX.game.iTopScoreOffset;
                    }
                }
                if (Keys.key_up || Keys.key_left || Keys.key_num4 || Keys.key_num2) {
                    if (XX.game.iTopScoreOffset > 0) {
                        --XX.game.iTopScoreOffset;
                    }
                }
                if (!Keys.key_fn1) break;
                this.mode = 1;
                break;
            }
            case 6: {
                if (Keys.key_fn1) {
                    this.mode = 1;
                }
                if (!Keys.key_fn2) break;
                state.deleteGame();
                state.deleteTable();
                this.mode = 1;
                this.iSelectedItem = 0;
            }
        }
        this.canvas.repaint();
        this.canvas.serviceRepaints();
    }

    public void paint(Graphics g2) {
        g2.setColor(0);
        g2.fillRect(0, Defines.HEIGHT, Defines.WIDTH, Defines.HEIGHT);
        if (MainCanvas.bSyncing) {
            return;
        }
        if (XX.game.bTequilaActive) {
            MainCanvas.tequila.paint(g2);
            return;
        }
        switch (this.mode) {
            case 0: {
                Resources.paintBackground(g2);
                break;
            }
            case 1: {
                this.paintMenu(g2);
                break;
            }
            case 2: {
                this.paintInstructions(g2);
                break;
            }
            case 3: {
                this.paintAbout(g2);
                break;
            }
            case 4: {
                this.paintQuit(g2);
                break;
            }
            case 5: {
                this.paintTopScore(g2);
                break;
            }
            case 6: {
                this.paintReset(g2);
            }
        }
    }

    public void paintTopScore(Graphics g2) {
        Resources.paintBackground(g2);
        g2.drawImage(Resources.imgUpperPanel, 0, 0, 0);
        int iPosBordY = (Resources.iUpperPanelH - Resources.iBorderOnH) / 2;
        String message = sTopScores;
        Fonts.drawStr(message, (Defines.WIDTH - Fonts.strWidth(message)) / 2, iPosBordY + (Resources.iBorderOnH - Resources.iFont1H) / 2, g2);
        int iW = Defines.WIDTH - (this.SPACING << 1);
        int iH = Defines.HEIGHT - (this.SPACING << 1) - this.SPACING - Resources.iIconsH - Resources.iIconsH / 4;
        Font fnt = XX.mediumFont;
        int iPosYTop = this.SPACING * 2 + Resources.iUpperPanelH + 8;
        int iPosY = this.SPACING * 2 + Resources.iUpperPanelH + 12;
        int iSize = 0;
        if (XX.game.leaderBoards != null) {
            iSize = XX.game.strLeaderboardRanks.length;
        }
        g2.setColor(0xFFFFFF);
        Font scoreFont = XX.smallFont;
        g2.setFont(scoreFont);
        int iTitleLines = 0;
        if (MainCanvas.vecLeaderboardTitle != null) {
            iTitleLines = MainCanvas.vecLeaderboardTitle.size();
        }
        if (iTitleLines > 0) {
            g2.setColor(0xFF0000);
            g2.fillRect(this.SPACING, iPosY, iW, scoreFont.getHeight());
            g2.setColor(0xFFFFFF);
            for (int i2 = 0; i2 < iTitleLines; ++i2) {
                g2.drawString((String)MainCanvas.vecLeaderboardTitle.elementAt(i2), this.SPACING * 2, iPosY, 0);
                iPosY += scoreFont.getHeight();
            }
            iPosY += 2;
        }
        int iLeaderboardH = iH - iPosY;
        int iLeaderBoardRecH = scoreFont.getHeight() + 1;
        int iMaxRecsOnPage = iLeaderboardH / iLeaderBoardRecH;
        XX.game.iMaxTopScoreOffset = iSize - iMaxRecsOnPage;
        boolean bCanGoUp = XX.game.iTopScoreOffset > 0;
        boolean bCanGoDown = XX.game.iTopScoreOffset < XX.game.iMaxTopScoreOffset;
        int iPosX = this.SPACING * 2;
        for (int i3 = 0; i3 < iSize && i3 < iMaxRecsOnPage; ++i3) {
            int iNameLen = scoreFont.stringWidth(XX.game.strLeaderboardNickNames[i3 + XX.game.iTopScoreOffset]);
            int iScoreLen = scoreFont.stringWidth(XX.game.strLeaderboardScores[i3 + XX.game.iTopScoreOffset]);
            int iMaxSize = iW - iScoreLen - 5;
            if (MainCanvas.playerName != null) {
                if (MainCanvas.playerName.compareTo(XX.game.strLeaderboardNickNames[i3 + XX.game.iTopScoreOffset]) == 0) {
                    g2.setColor(16744193);
                    g2.fillRect(0, iPosY, Defines.WIDTH, scoreFont.getHeight());
                    g2.setColor(0xFFFFFF);
                }
            }
            g2.setClip(this.SPACING, 0, iMaxSize, Defines.HEIGHT);
            g2.drawString(XX.game.strLeaderboardRanks[i3 + XX.game.iTopScoreOffset] + ". " + XX.game.strLeaderboardNickNames[i3 + XX.game.iTopScoreOffset], iPosX, iPosY, 0);
            g2.setClip(0, 0, Defines.WIDTH, Defines.HEIGHT);
            g2.drawString(XX.game.strLeaderboardScores[i3 + XX.game.iTopScoreOffset], Defines.WIDTH - this.SPACING * 2, iPosY, 24);
            iPosY += iLeaderBoardRecH;
        }
        iPosX = Defines.WIDTH / 2;
        iPosY += 4;
        if (bCanGoUp && bCanGoDown) {
            g2.fillTriangle(iPosX, iPosYTop - 5, iPosX + 5, iPosYTop, iPosX - 5, iPosYTop);
            g2.fillTriangle(iPosX, iPosY, iPosX - 4, iPosY - 4, iPosX + 4, iPosY - 4);
        } else {
            if (bCanGoUp) {
                g2.fillTriangle(iPosX, iPosYTop - 5, iPosX + 5, iPosYTop, iPosX - 5, iPosYTop);
            }
            if (bCanGoDown) {
                g2.fillTriangle(iPosX, iPosY, iPosX - 4, iPosY - 4, iPosX + 4, iPosY - 4);
            }
        }
        Resources.paintControls(g2, 8);
    }

    public void paintRaster(Graphics g2) {
        int x2 = 0;
        for (int y2 = 0; y2 <= Defines.HEIGHT; y2 += Resources.iRasterH) {
            while (x2 <= Defines.WIDTH) {
                g2.drawImage(Resources.imgRaster, x2, y2, 0);
                x2 += Resources.iRasterW;
            }
            x2 = 0;
        }
    }

    public void paintQuit(Graphics g2) {
        this.paintRaster(g2);
        Resources.paintControls(g2, 7);
        Resources.paintMenuBG(10, 3, sQuit, g2);
    }

    public void paintReset(Graphics g2) {
        this.paintRaster(g2);
        Resources.paintControls(g2, 7);
        Resources.paintMenuBG(15, 8, sResetGame, g2);
        Resources.paintTextIntoTable(15, 10, g2);
    }

    public void paintNewGame(Graphics g2) {
        Resources.paintControls(g2, 7);
        Resources.paintMenuBG(15, 8, menuStrings[0], g2);
        Resources.paintTextIntoTable(15, 10, g2);
    }

    public void paintInstructions(Graphics g2) {
        this.paintRaster(g2);
        Resources.paintMenuBG(15, 13, menuStrings[2], g2);
        Resources.paintTextIntoTable(15, 13, g2);
        Resources.paintControls(g2, 8);
        g2.setColor(0xFFFFFF);
        int iPosX = Defines.WIDTH / 2;
        int iPosYTop = (Defines.HEIGHT - Resources.iInfoBarH * 13) / 2 + Resources.TEXT_DIFF_Y - 10;
        int iPosY = iPosYTop + Resources.TEXT_DIFF_Y + 15;
        g2.fillTriangle(iPosX, iPosYTop - 7, iPosX + 7, iPosYTop, iPosX - 7, iPosYTop);
        g2.fillTriangle(iPosX, iPosY, iPosX - 6, iPosY - 6, iPosX + 6, iPosY - 6);
    }

    public void paintAbout(Graphics g2) {
        this.paintRaster(g2);
        Resources.paintControls(g2, 8);
        Resources.paintMenuBG(16, 15, menuStrings[3], g2);
        int iHeight = Resources.iInfoBarH * 15;
        g2.drawImage(Resources.imgInlLogo, (Defines.WIDTH - Resources.iInlLogoW) / 2, (Defines.HEIGHT - Resources.iInlLogoH) / 2, 0);
        String name = (sName + ": " + XX.singleton.getAppProperty("MIDlet-Name")).toUpperCase();
        String version = (sVersion + ": " + XX.singleton.getAppProperty("MIDlet-Version")).toUpperCase();
        Fonts.drawStr(name, (Defines.WIDTH - Fonts.strWidth(name)) / 2, iHeight + (Defines.HEIGHT - iHeight) / 2 - Resources.iFont1H * 2 - Resources.iFont1H, g2);
        Fonts.drawStr(version, (Defines.WIDTH - Fonts.strWidth(version)) / 2, iHeight + (Defines.HEIGHT - iHeight) / 2 - Resources.iFont1H - Resources.iFont1H, g2);
    }

    public void paintMenu(Graphics g2) {
        Resources.paintBackground(g2);
        g2.drawImage(Resources.imgPokerLogo, (Defines.WIDTH - Resources.iPokerLogoW) / 2, Resources.LOGO_Y, 0);
        if (Settings.bMusic) {
            Resources.paintControls(g2, 6);
        } else {
            Resources.paintControls(g2, 1);
        }
        int iPosX = (Defines.WIDTH - Resources.iIconsMenuW) / 2;
        int iPosY = Resources.MENU_POS_Y;
        int x2 = (Defines.WIDTH - Resources.iIconsMenuW) / 2;
        if (0 == this.iSelectedItem) {
            Resources.sprIconsMENU.setFrame(1);
        } else {
            Resources.sprIconsMENU.setFrame(0);
        }
        Resources.sprIconsMENU.setPosition(iPosX, Resources.MENU_BUTTONS_OFFSET + iPosY);
        Resources.sprIconsMENU.paint(g2);
        iPosY = Resources.MENU_POS_Y + 1 * (Resources.iIconsMenuH + Resources.MENU_BUTTONS_OFFSET);
        for (int i2 = 1; i2 < 4; ++i2) {
            Sprite tmpSpr = i2 != this.iSelectedItem ? Resources.sprIconsOFF : Resources.sprIconsON;
            tmpSpr.setFrame(10);
            if (i2 == 2) {
                iPosX = (Defines.WIDTH - Resources.iIconsW) / 2;
                tmpSpr.setFrame(4);
            }
            if (i2 == 3) {
                iPosX = Defines.WIDTH - Resources.iIconsW - (Defines.WIDTH - Resources.iIconsMenuW) / 2;
                tmpSpr.setFrame(11);
            }
            tmpSpr.setPosition(iPosX, iPosY + Resources.MENU_BUTTONS_OFFSET);
            tmpSpr.paint(g2);
        }
        if (state.canLoadTable()) {
            this.paintResetButton(g2);
        }
    }

    public void paintResetButton(Graphics g2) {
        if (this.iSelectedItem == MENUITEM_RESET) {
            Resources.sprResetButton.setFrame(0);
        } else {
            Resources.sprResetButton.setFrame(1);
        }
        Resources.sprResetButton.setPosition((Defines.WIDTH - Resources.iResetButtonW) / 2, Defines.HEIGHT - Resources.iIconsH - Resources.iResetButtonH - Resources.MENU_BUTTONS_OFFSET);
        Resources.sprResetButton.paint(g2);
        String reset = sReset;
        Fonts.drawStr(reset, (Defines.WIDTH - Fonts.strWidth(reset)) / 2, Defines.HEIGHT - Resources.iIconsH - Resources.iResetButtonH - Resources.MENU_BUTTONS_OFFSET + (Resources.iResetButtonH - Resources.iFont1H) / 2, g2);
    }

    public void invokeGameMenu() {
        XX.soundManager.Stop();
    }

    public void pointerPressed(int x2, int y2) {
        switch (this.mode) {
            case 1: 
            case 4: {
                this.pointerPressedMenu(x2, y2);
                break;
            }
            case 2: 
            case 3: {
                this.pointerPressedAbout(x2, y2);
                break;
            }
            case 5: {
                this.pointerPrScores(x2, y2);
                break;
            }
            case 6: {
                this.pointerPrReset(x2, y2);
            }
        }
    }

    public void pointerPrReset(int x2, int y2) {
        if (Resources.isInLeftButton(x2, y2)) {
            Keys.key_fn1 = true;
            this.keyPressed(Keys.iLeftKey);
            Keys.key_fn1 = false;
        }
        if (Resources.isInRightButton(x2, y2)) {
            Keys.key_fn2 = true;
            this.keyPressed(Keys.iRightKey);
            Keys.key_fn2 = false;
        }
    }

    public void pointerPrScores(int x2, int y2) {
        if (Resources.isInLeftButton(x2, y2)) {
            Keys.key_fn1 = true;
            this.keyPressed(Keys.iLeftKey);
            Keys.key_fn1 = false;
            return;
        }
        if (y2 > Defines.WIDTH / 2) {
            Keys.key_down = true;
            this.keyPressed(Keys.iRightKey);
            Keys.key_down = false;
            return;
        }
        if (y2 < Defines.WIDTH / 2) {
            Keys.key_up = true;
            this.keyPressed(Keys.iLeftKey);
            Keys.key_up = false;
            return;
        }
    }

    public void pointerPressedAbout(int x2, int y2) {
        if (Resources.isInLeftButton(x2, y2)) {
            Keys.key_fn1 = true;
            this.keyPressed(Keys.iLeftKey);
            Keys.key_fn1 = false;
        }
        int tableTop = (Defines.HEIGHT - Resources.iInfoBarH * 13) / 2;
        int tableHeight = Resources.iInfoBarH * 13;
        int tableLeft = (Defines.HEIGHT - Resources.iInfoBarW * 15) / 2;
        int tablewidth = Resources.iInfoBarW * 15;
        if (x2 > tableLeft && x2 < tableLeft + tablewidth) {
            if (y2 > tableTop && y2 < tableTop + tableHeight / 2) {
                Keys.key_up = true;
                this.keyPressed(0);
                Keys.key_up = false;
            }
            if (y2 > tableTop + tableHeight / 2 && y2 < tableTop + tableHeight) {
                Keys.key_down = true;
                this.keyPressed(0);
                Keys.key_down = false;
            }
        }
        Keys.key_fire = true;
        this.keyPressed(Keys.iEnterKey);
        Keys.key_fire = false;
        this.canvas.repaint();
        this.canvas.serviceRepaints();
    }

    public void pointerPressedMenu(int x2, int y2) {
        int buttonPressed = Resources.whichMenuButton(x2, y2);
        switch (buttonPressed) {
            case 1: {
                this.iSelectedItem = MENUITEM_NEWGAME;
                break;
            }
            case 2: {
                this.iSelectedItem = MENUITEM_INFO;
                break;
            }
            case 3: {
                this.iSelectedItem = MENUITEM_SCORES;
                break;
            }
            case 4: {
                this.iSelectedItem = MENUITEM_ABOUT;
                break;
            }
            default: {
                this.iSelectedItem = -1;
            }
        }
        int posX = (Defines.WIDTH - Resources.iResetButtonW) / 2;
        int posY = Defines.HEIGHT - Resources.iIconsH - Resources.iResetButtonH - Resources.MENU_BUTTONS_OFFSET;
        if (x2 > posX && x2 < posX + Resources.iResetButtonW && state.canLoad() && y2 > posY && y2 < posY + Resources.iResetButtonH) {
            this.iSelectedItem = MENUITEM_RESET;
        }
        if (Resources.isInLeftButton(x2, y2)) {
            Keys.key_fn1 = true;
            this.keyPressed(Keys.iLeftKey);
            Keys.key_fn1 = false;
        }
        if (Resources.isInRightButton(x2, y2)) {
            Keys.key_fn2 = true;
            this.keyPressed(Keys.iRightKey);
            Keys.key_fn2 = false;
        }
        this.canvas.repaint();
        this.canvas.serviceRepaints();
    }

    public void pointerReleased(int x2, int y2) {
        if (this.mode == 1) {
            Keys.key_fire = true;
            this.keyPressed(Keys.iEnterKey);
            Keys.key_fire = false;
            this.iSelectedItem = -1;
        }
    }
}

