/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import net.sourceforge.jmicropolygon.PolygonGraphics;

public class AstralSpiral
extends Visual {
    Random rand;
    int angleDistanceAdjuster;
    int colorMode;
    Graphics buffer;
    int t;
    int radieMax;
    int sizecorr;
    int sizecorr2;
    int mode;
    Image bufferImage;
    int colour;
    boolean paintBackground = true;
    int centerX;
    int centerY;
    int counter;
    int[] xPoints;
    int[] yPoints;
    int[] radies;
    int[] simp1;
    int spiralOrbits;
    int[][] polysX;
    int[][] polysY;
    int[] bgClr;
    int[] AstralSpiralClr;
    int vertices;
    boolean AstralSpiralIn = true;
    int angle;
    int screenSizeAdjuster;
    int angleDistance;
    int r;
    int x = 0;
    int y = 0;
    ColorCreaterSmooth rb1;
    ColorCreaterSmooth rb2;
    int colorIncr;
    private Image image;
    Graphics g;
    boolean billsColors;
    int[][] palette;
    int[][] palette2;
    int[][] totalX;
    int[][] totalY;
    private int[] colorValues;
    private int[] colorValues2;
    int numClrs = 256;
    int curClr = 0;
    int clrIncr = 5;
    int clrLimit = this.numClrs - this.clrIncr;
    int redStart;
    int greenStart;
    int blueStart;
    int startChooser;

    public void init(String args) {
        if (s_screenWidth < 140) {
            AstralEffects.setloopDelay(60);
        } else if (s_screenWidth < 180 && s_screenWidth >= 140) {
            AstralEffects.setloopDelay(50);
        } else {
            AstralEffects.setloopDelay(50);
        }
        this.image = Image.createImage((int)s_screenWidth, (int)s_screenHeight);
        this.g = this.image.getGraphics();
        this.colorValues = new int[3];
        this.colorValues2 = new int[3];
        this.rand = new Random(System.currentTimeMillis());
        this.centerX = s_screenWidth / 2;
        this.centerY = s_screenHeight / 2;
        int maxr = 100 + RandomLibrary.Intervall(this.rand, 0, 155);
        int maxg = 100 + RandomLibrary.Intervall(this.rand, 0, 155);
        int maxb = 100 + RandomLibrary.Intervall(this.rand, 0, 155);
        this.setValues();
        this.totalX = new int[this.vertices * this.spiralOrbits][4];
        this.totalY = new int[this.vertices * this.spiralOrbits][4];
        this.rb1 = new ColorCreaterSmooth(this, maxr / 2, maxg / 2, maxb / 2, maxr, maxg, maxb, this.colorIncr, 1);
        maxr = 100 + RandomLibrary.Intervall(this.rand, 0, 155);
        maxg = 100 + RandomLibrary.Intervall(this.rand, 0, 155);
        maxb = 100 + RandomLibrary.Intervall(this.rand, 0, 155);
        this.rb2 = new ColorCreaterSmooth(this, maxr / 2, maxg / 2, maxb / 2, maxr, maxg, maxb, this.colorIncr, 1);
        this.countArrayindices();
        this.calculateRotatedAstralSpiralPoints();
        this.SetUpPalette();
        this.palette2 = new int[this.numClrs][3];
        this.CreateRandomPalette();
    }

    protected void chooseStartColors() {
        if (!this.billsColors) {
            this.startChooser = RandomLibrary.Intervall(this.rand, 0, 70) / 10;
        }
        switch (this.startChooser) {
            case 0: {
                this.redStart = 218;
                this.greenStart = 140;
                this.blueStart = 245;
                break;
            }
            case 1: {
                this.redStart = 250;
                this.greenStart = 101;
                this.blueStart = 126;
                break;
            }
            case 2: {
                this.redStart = 147;
                this.greenStart = 246;
                this.blueStart = 137;
                break;
            }
            case 3: {
                this.redStart = 32;
                this.greenStart = 31;
                this.blueStart = 50;
                break;
            }
            case 4: {
                this.redStart = 12;
                this.greenStart = 27;
                this.blueStart = 116;
                break;
            }
            case 5: {
                this.redStart = 231;
                this.greenStart = 232;
                this.blueStart = 37;
                break;
            }
            case 6: {
                this.redStart = 52;
                this.greenStart = 204;
                this.blueStart = 82;
            }
        }
    }

    private void CreateRandomPalette() {
        int bIncr;
        int gIncr;
        int rIncr;
        int rr = 0;
        int gg = 0;
        int bt = 0;
        this.chooseStartColors();
        rr = this.redStart;
        gg = this.greenStart;
        bt = this.blueStart;
        int c = 3;
        int d = (c - 1) / 2;
        while ((rIncr = c - d) == 0) {
        }
        while ((gIncr = c - d) == 0) {
        }
        while ((bIncr = c - d) == 0) {
        }
        for (int index = 0; index < 256; ++index) {
            int red = rr;
            do {
                if (red > 255) {
                    red = 255 - (red - 255);
                }
                if (red >= 0) continue;
                red = -red;
            } while (red > 255 || red < 0);
            int green = gg;
            do {
                if (green > 255) {
                    green = 255 - (green - 255);
                }
                if (green >= 0) continue;
                green = -green;
            } while (green > 255 || green < 0);
            int blue = bt;
            do {
                if (blue > 255) {
                    blue = 255 - (blue - 255);
                }
                if (blue >= 0) continue;
                blue = -blue;
            } while (blue > 255 || blue < 0);
            this.palette2[index][0] = red;
            this.palette2[index][1] = green;
            this.palette2[index][2] = blue;
            rr += rIncr;
            gg += gIncr;
            bt += bIncr;
        }
    }

    private void SetUpPalette() {
        int i;
        this.palette = new int[this.numClrs][3];
        int r = 255;
        int g = 0;
        int b = 0;
        for (i = 0; i <= 50; ++i) {
            this.palette[i][0] = r;
            this.palette[i][1] = g;
            this.palette[i][2] = b;
            g += 5;
        }
        r = 255;
        g = 255;
        b = 0;
        for (i = 51; i <= 101; ++i) {
            this.palette[i][0] = r;
            this.palette[i][1] = g;
            this.palette[i][2] = b;
            r -= 5;
        }
        r = 0;
        g = 255;
        b = 0;
        for (i = 102; i <= 152; ++i) {
            this.palette[i][0] = r;
            this.palette[i][1] = g;
            this.palette[i][2] = b;
            g -= 5;
            b += 5;
        }
        r = 0;
        g = 0;
        b = 255;
        for (i = 153; i <= 203; ++i) {
            this.palette[i][0] = r;
            this.palette[i][1] = g;
            this.palette[i][2] = b;
            r += 5;
        }
        r = 255;
        g = 0;
        b = 255;
        for (i = 204; i <= 255; ++i) {
            this.palette[i][0] = r;
            this.palette[i][1] = g;
            this.palette[i][2] = b;
            b -= 5;
        }
        this.clrIncr = 1;
        this.clrLimit = this.numClrs - this.clrIncr;
    }

    protected void setValues() {
        this.spiralOrbits = 8;
        this.mode = 0;
        this.screenSizeAdjuster = 6200 * s_screenWidth / 98;
        this.vertices = 240;
        this.angleDistanceAdjuster = 18;
        this.colorIncr = 1;
    }

    public void calculateRotatedAstralSpiralPoints() {
        int j;
        int i;
        this.polysX = new int[this.spiralOrbits][this.vertices];
        this.polysY = new int[this.spiralOrbits][this.vertices];
        for (int j2 = 0; j2 < this.spiralOrbits; ++j2) {
            int ang = j2 * (460 / this.spiralOrbits);
            for (i = 0; i < this.vertices; ++i) {
                long mult1 = (long)TrigLookupTable.getCosinus(ang) * (long)this.xPoints[i];
                long mult2 = (long)this.yPoints[i] * (long)TrigLookupTable.getSinus(ang);
                long mult3 = (long)TrigLookupTable.getSinus(ang) * (long)this.xPoints[i];
                long mult4 = (long)TrigLookupTable.getCosinus(ang) * (long)this.yPoints[i];
                this.polysX[j2][i] = this.centerX + (int)((mult1 - mult2) / 100000L);
                this.polysY[j2][i] = this.centerY + (int)((mult3 + mult4) / 100000L);
            }
        }
        int tcount = 0;
        for (j = 0; j < this.spiralOrbits - 1; ++j) {
            for (i = 0; i < this.vertices - 1; ++i) {
                this.totalX[tcount][0] = this.polysX[j][i];
                this.totalX[tcount][1] = this.polysX[j + 1][i];
                this.totalX[tcount][2] = this.polysX[j + 1][i + 1];
                this.totalX[tcount][3] = this.polysX[j][i + 1];
                ++tcount;
            }
        }
        tcount = 0;
        for (j = 0; j < this.spiralOrbits - 1; ++j) {
            for (i = 0; i < this.vertices - 1; ++i) {
                this.totalY[tcount][0] = this.polysY[j][i];
                this.totalY[tcount][1] = this.polysY[j + 1][i];
                this.totalY[tcount][2] = this.polysY[j + 1][i + 1];
                this.totalY[tcount][3] = this.polysY[j][i + 1];
                ++tcount;
            }
        }
    }

    public void randomize2() {
        this.rb1.reset(105 + RandomLibrary.Intervall(this.rand, 0, 150), 105 + RandomLibrary.Intervall(this.rand, 0, 150), 105 + RandomLibrary.Intervall(this.rand, 0, 150));
        this.rb2.reset(105 + RandomLibrary.Intervall(this.rand, 0, 150), 105 + RandomLibrary.Intervall(this.rand, 0, 150), 105 + RandomLibrary.Intervall(this.rand, 0, 150));
    }

    public void countArrayindices() {
        this.angle = 0;
        int spiralDistanceIncreaser = 0;
        int spiralDistanceConstant = 100;
        int spiralDistanceIncreaserIncr = 57;
        this.r = 0;
        this.xPoints = new int[this.vertices];
        this.yPoints = new int[this.vertices];
        this.radies = new int[this.vertices];
        for (int i = 0; i < this.vertices; ++i) {
            this.r = (int)((long)this.screenSizeAdjuster * (long)spiralDistanceIncreaser / (10000L * (long)spiralDistanceConstant));
            this.xPoints[i] = this.r * TrigLookupTable.getCosinus(this.angle) / 100000;
            this.yPoints[i] = this.r * TrigLookupTable.getSinus(this.angle) / 100000;
            this.radies[i] = this.r;
            this.angleDistance = this.angleDistanceAdjuster - this.angleDistanceAdjuster * this.r / s_screenWidth;
            this.angle += this.angleDistance;
            spiralDistanceIncreaser += spiralDistanceIncreaserIncr;
        }
        this.radieMax = this.r;
    }

    public void garbageCollect() {
        this.image = null;
        this.rand = null;
        this.rb1.garbageCollect();
        this.rb1 = null;
        this.rb2.garbageCollect();
        this.rb2 = null;
        this.polysX = null;
        this.polysY = null;
        this.xPoints = null;
        this.yPoints = null;
        this.radies = null;
    }

    public void manageKeyPress(int keyCode) {
        boolean handled = true;
    }

    public void paintVisual() {
        this.paint();
    }

    public void paint() {
        int j2 = 0;
        ++this.counter;
        if (this.counter % this.spiralOrbits == 0) {
            int modeChooser = RandomLibrary.Intervall(this.rand, 0, 100);
            this.mode = 0;
            if (RandomLibrary.Intervall(this.rand, 0, 100) < 20) {
                this.billsColors = true;
            } else {
                this.billsColors = false;
                this.palette2 = new int[this.numClrs][3];
                this.CreateRandomPalette();
            }
        }
        if (this.mode == 0) {
            for (int i = 0; i < s_screenWidth * 24 / 10; i += AstralEffects.imageW2) {
                for (int j = 0; j < s_screenHeight * 24 / 10; j += AstralEffects.imageH2) {
                    this.g.drawImage(AstralEffects.source2, AstralEffects.imageW2 / 2 + i, AstralEffects.imageH2 / 2 + j, 3);
                    if (RandomLibrary.Intervall(this.rand, 0, 8000) >= 2500) continue;
                    this.randomize2();
                }
            }
        }
        for (int j = 0; j < 1 * (this.vertices - 1); ++j) {
            if (this.mode == 0) {
                j2 = this.counter % (this.spiralOrbits - 1);
                this.colorValues = this.rb1.createColor();
                this.colorValues2 = this.rb2.createColor();
                if (this.billsColors) {
                    this.g.setColor(this.palette[this.curClr][0], this.palette[this.curClr][1], this.palette[this.curClr][2]);
                    this.curClr += this.clrIncr;
                    if (this.curClr >= this.clrLimit) {
                        this.curClr -= this.clrLimit;
                    }
                } else {
                    this.g.setColor(this.palette2[this.curClr][0], this.palette2[this.curClr][1], this.palette2[this.curClr][2]);
                    this.curClr += this.clrIncr;
                    if (this.curClr >= this.clrLimit) {
                        this.curClr -= this.clrLimit;
                    }
                }
            } else {
                j2 = j + 100000 - this.counter;
                if (j2 < 0) {
                    j2 = 100000;
                }
                j2 %= this.spiralOrbits - 1;
                if (this.billsColors) {
                    this.g.setColor(this.palette[this.curClr][0], this.palette[this.curClr][1], this.palette[this.curClr][2]);
                    this.curClr += this.clrIncr;
                    if (this.curClr >= this.clrLimit) {
                        this.curClr -= this.clrLimit;
                    }
                } else {
                    this.g.setColor(this.palette2[this.curClr][0], this.palette2[this.curClr][1], this.palette2[this.curClr][2]);
                    this.curClr += this.clrIncr;
                    if (this.curClr >= this.clrLimit) {
                        this.curClr -= this.clrLimit;
                    }
                }
            }
            PolygonGraphics.fillPolygon(this.g, this.totalX[j + j2 * this.vertices], this.totalY[j + j2 * this.vertices]);
        }
        this.paintCommands(this.g);
    }

    public Image getImage() {
        return this.image;
    }
}

