/*
 * Decompiled with CFR 0.152.
 */
package bj;

import bj.BJPlayer;
import bj.Card;
import bj.Dealer;
import bj.Game;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;
import main.Common;
import main.Debug;
import main.Defines;
import main.Fonts;
import main.IScreen;
import main.Keys;
import main.MainCanvas;
import main.Resources;
import main.ScreenMenu;
import main.Settings;
import main.X;
import main.stateBJ;

public class ScreenGameBJ
implements IScreen {
    public static Card actualCard;
    public static boolean bPlusPressed;
    public static boolean bMinusPressed;
    public static int iKeyPressedDelay;
    public static int iWaitTime;
    public static int DEFAULT_WAIT_TIME;
    public static boolean bSendNewCard;
    private static int iWinFrame;
    private static Canvas canvas;
    public static int mode;
    static final int MODE_LOADING_RES = 0;
    static final int MODE_NEW_ROUND = 1;
    static final int MODE_DISTRIBUTION = 2;
    static final int MODE_PLAYER_MOVE = 3;
    static final int MODE_DEALER_MOVE = 4;
    static final int MODE_ROUND_OVER = 5;
    static final int MODE_PAUSE = 6;
    static final int MODE_STATISTICS = 7;
    static final int MODE_GAME_OVER = 8;
    static final int MODE_SPLITTING = 9;
    static final int MODE_RESTART = 10;
    static final int ACTION_1 = 0;
    static final int ACTION_2 = 1;
    public static int LAST_MODE;
    public static int iPlayerBet;
    private static int iSelectedAction;
    static final int ACTION_HIT = 0;
    static final int ACTION_STAND = 1;
    static final int ACTION_DOUBLE_DOWN = 2;
    static final int ACTION_SPLIT = 3;
    static final int ACTION_INSURANCE = 4;
    static final int ACTION_DEAL = 5;
    static final int ACTION_PAUSE = 6;
    static final int ACTION_OK = 7;
    private static int iDistributionX;
    private static int iDistributionY;
    private static String[] menuStrings;
    private static String[] actionStrings;
    private static String[] gameModeStrings;
    private static String sWins;
    private static String sPlayer;
    private static String sSplit;
    private static String sRound;
    private static String sStats;
    private static String sGameMenu;
    private static String sPot;
    private static String sRestart;
    private static String sSetBet;
    private static String sInsur;
    private static String sBoth;
    private static String sLeft;
    private static String sRight;
    private static String sBet;
    private static String sYour;
    private static String sEnd;
    private static int iSelectedSubMenuItem;
    static final int ITEM_CONTINUE = 0;
    static final int ITEM_RESTART = 1;
    static final int ITEM_MAIN_MENU = 2;

    private void loadStrings() {
        ScreenGameBJ.menuStrings[0] = X.texts.getHashedString("CONTINUE").toUpperCase();
        ScreenGameBJ.menuStrings[1] = X.texts.getHashedString("RESTART").toUpperCase();
        ScreenGameBJ.menuStrings[2] = X.texts.getHashedString("MAIN_MENU").toUpperCase();
        ScreenGameBJ.actionStrings[0] = X.texts.getHashedString("HIT").toUpperCase();
        ScreenGameBJ.actionStrings[1] = X.texts.getHashedString("STAND").toUpperCase();
        ScreenGameBJ.actionStrings[2] = X.texts.getHashedString("DOUBLE").toUpperCase();
        ScreenGameBJ.actionStrings[3] = X.texts.getHashedString("SPLIT").toUpperCase();
        ScreenGameBJ.actionStrings[4] = X.texts.getHashedString("INSURANCE").toUpperCase();
        ScreenGameBJ.actionStrings[5] = X.texts.getHashedString("PAUSE").toUpperCase();
        ScreenGameBJ.actionStrings[6] = X.texts.getHashedString("OK").toUpperCase();
        ScreenGameBJ.actionStrings[7] = X.texts.getHashedString("DEAL").toUpperCase();
        ScreenGameBJ.gameModeStrings[0] = X.texts.getHashedString("DISTRIBUTION").toUpperCase();
        ScreenGameBJ.gameModeStrings[1] = X.texts.getHashedString("END_OF_ROUND").toUpperCase();
        ScreenGameBJ.gameModeStrings[2] = X.texts.getHashedString("GAME_OVER").toUpperCase();
        sWins = X.texts.getHashedString("WINS").toUpperCase();
        sPlayer = X.texts.getHashedString("PLAYER").toUpperCase();
        sGameMenu = X.texts.getHashedString("GAME_MENU").toUpperCase();
        sPot = X.texts.getHashedString("POT").toUpperCase();
        sSetBet = X.texts.getHashedString("SET_BET").toUpperCase();
        sInsur = X.texts.getHashedString("INSURANCE").toUpperCase();
        sRestart = X.texts.getHashedString("NEW_GAME").toUpperCase();
        sBoth = X.texts.getHashedString("BOTH_HANDS").toUpperCase();
        sLeft = X.texts.getHashedString("LEFT").toUpperCase();
        sRight = X.texts.getHashedString("RIGHT").toUpperCase();
        sBet = X.texts.getHashedString("BET").toUpperCase();
        sYour = X.texts.getHashedString("YOUR_TURN").toUpperCase();
        sEnd = X.texts.getHashedString("END_OF_ROUND").toUpperCase();
    }

    public ScreenGameBJ(Canvas canvas, boolean newGame) {
        Debug.traceIn("> ScreenGame.ScreenGame()");
        System.out.println("screengame");
        ScreenGameBJ.canvas = canvas;
        this.loadStrings();
        bSendNewCard = false;
        bPlusPressed = false;
        bMinusPressed = false;
        iKeyPressedDelay = 0;
        Game.iBet = 0;
        Game.player = new BJPlayer();
        Game.dealer = new Dealer();
        iPlayerBet = Game.player.iChips > 10 ? 20 : 10;
        iSelectedAction = 5;
        Game.deleteCards();
        System.out.println(newGame);
        if (newGame) {
            mode = 0;
        } else {
            this.loadGame();
        }
    }

    public void loadGame() {
        Resources.loadGameBJResources();
        for (int i = 0; i < 9; ++i) {
            Game.player.cards[i] = new Card(0, 0);
            Game.dealer.cards[i] = new Card(0, 0);
            Game.player.hand2Cards[i] = new Card(0, 0);
        }
        stateBJ.loadGame(this);
        System.out.println("mod hry po nacitani " + mode);
        if (Settings.bMusic) {
            X.soundManager.Stop();
            X.soundManager.SetSoundOn(true);
            X.soundManager.Play(X.MUSIC_MENU_ID, -1);
        } else {
            X.soundManager.Stop();
            X.soundManager.SetSoundOn(false);
        }
        if (mode == 3) {
            iSelectedAction = 0;
        }
        if (mode == 5) {
            iSelectedAction = 7;
        }
    }

    private void resetDistributionCoordinates() {
        iDistributionX = 0;
        iDistributionY = 0;
    }

    public String getActualModeName() {
        return "Screen game";
    }

    public void invokeGameMenu() {
        stateBJ.saveGame(this);
        mode = 6;
        X.soundManager.Stop();
        canvas.repaint();
        canvas.serviceRepaints();
    }

    public void update(long tick) {
        switch (mode) {
            case 0: {
                Resources.loadGameBJResources();
                mode = 1;
                canvas.repaint();
                canvas.serviceRepaints();
                if (Settings.bMusic) {
                    X.soundManager.Stop();
                    X.soundManager.SetSoundOn(true);
                    X.soundManager.Play(X.MUSIC_MENU_ID, -1);
                    break;
                }
                X.soundManager.Stop();
                X.soundManager.SetSoundOn(false);
                break;
            }
            case 1: {
                if (bPlusPressed) {
                    if (iPlayerBet + 1000 < Game.player.iChips && ++iKeyPressedDelay > 50 && iKeyPressedDelay % 5 == 0) {
                        iPlayerBet += 1000;
                    } else if (iPlayerBet + 100 < Game.player.iChips && iKeyPressedDelay % 5 == 0) {
                        iPlayerBet += 100;
                    }
                }
                if (bMinusPressed) {
                    if (iPlayerBet - 1000 > 20 && ++iKeyPressedDelay > 50 && iKeyPressedDelay % 5 == 0) {
                        iPlayerBet -= 1000;
                    } else if (iPlayerBet - 100 > 20 && iKeyPressedDelay % 5 == 0) {
                        iPlayerBet -= 100;
                    }
                }
                canvas.repaint();
                canvas.serviceRepaints();
                if (Game.iBet != 0) {
                    System.out.println("-----------------------------------\nCHIPS:    " + Game.player.iChips + "\nBET:      " + iPlayerBet);
                    iSelectedAction = -1;
                    Game.player.b2Hands = false;
                    Game.player.bDD = false;
                    Game.player.b2HandDD = false;
                    Game.iInsurance = 0;
                    stateBJ.saveGame(this);
                    mode = 2;
                    break;
                }
                if (Game.player.iChips > 0) break;
                mode = 8;
                break;
            }
            case 2: {
                if (Game.dealer.iCardsCount + Game.player.iCardsCount < 4) break;
                Game.iInsurance = 0;
                mode = 3;
                iSelectedAction = 0;
                break;
            }
            case 4: {
                if (Game.dealer.iCardsValue1 <= 16 || Game.dealer.iCardsValue2 <= 16) {
                    if (Game.dealer.iCardsValue1 > 17 && Game.dealer.iCardsValue1 <= 21) {
                        Game.compareCards();
                        mode = 5;
                        stateBJ.saveGame(this);
                        iSelectedAction = 7;
                    } else {
                        bSendNewCard = true;
                    }
                } else {
                    Game.compareCards();
                    mode = 5;
                    stateBJ.saveGame(this);
                    iSelectedAction = 7;
                }
                canvas.repaint();
                canvas.serviceRepaints();
                break;
            }
            case 3: {
                if (!Game.player.b2Hands) {
                    if (Game.player.iCardsValue2 >= 21 || Game.player.iCardsValue1 == 21) {
                        mode = 4;
                        if (Game.player.iCardsValue2 > 21) {
                            mode = 5;
                            Game.compareCards();
                        }
                        stateBJ.saveGame(this);
                        iSelectedAction = 7;
                    }
                } else if (Game.player.i2HandCardsCount > 1 && Game.player.i2HandCardsValue2 >= 21 || Game.player.i2HandCardsValue1 == 21) {
                    mode = 4;
                    if (Game.player.iCardsValue2 > 21 && Game.player.i2HandCardsValue2 > 21) {
                        mode = 5;
                        Game.compareCards();
                    }
                    stateBJ.saveGame(this);
                    iSelectedAction = 7;
                } else if (Game.player.iCardsValue2 >= 21 || Game.player.iCardsValue1 == 21) {
                    if (Game.bPlayingLeftHand) {
                        bSendNewCard = true;
                        iSelectedAction = 0;
                    }
                    Game.bPlayingLeftHand = false;
                }
                canvas.repaint();
                canvas.serviceRepaints();
                break;
            }
            case 5: {
                canvas.repaint();
                canvas.serviceRepaints();
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                canvas.repaint();
                canvas.serviceRepaints();
                break;
            }
            case 6: {
                iSelectedAction = 7;
                canvas.repaint();
                canvas.serviceRepaints();
            }
        }
        canvas.repaint();
        canvas.serviceRepaints();
    }

    public boolean isEndOfGame() {
        return Game.player.iChips == 0;
    }

    public static void waiter() {
        int start = (int)System.currentTimeMillis() / 1000;
        int end = (int)System.currentTimeMillis() / 1000;
        while (end - start < iWaitTime) {
            end = (int)System.currentTimeMillis() / 1000;
        }
    }

    private Card generateCard() {
        Card tmpCard = new Card(Common.getRandomUInt(13), Common.getRandomUInt(4));
        while (this.isOnTable(tmpCard)) {
            tmpCard = new Card(Common.getRandomUInt(13), Common.getRandomUInt(4));
        }
        return tmpCard;
    }

    private boolean isOnTable(Card card) {
        int i;
        for (i = 0; i < Game.player.iCardsCount; ++i) {
            if (!card.getCardString().equals(Game.player.cards[i].getCardString())) continue;
            return true;
        }
        for (i = 0; i < Game.dealer.iCardsCount; ++i) {
            if (!card.getCardString().equals(Game.dealer.cards[i].getCardString())) continue;
            return true;
        }
        return false;
    }

    public void paint(Graphics g) {
        switch (mode) {
            case 10: {
                this.paintRestart(g);
                break;
            }
            case 0: {
                this.paintGameLoading(g);
                break;
            }
            case 1: {
                this.paintGame(g);
                this.paintControls(g);
                break;
            }
            case 2: {
                this.paintGame(g);
                this.paintControls(g);
                this.paintCardDistribution(g);
                break;
            }
            case 3: 
            case 4: {
                this.paintGame(g);
                this.paintControls(g);
                this.paintCardsSum(g);
                if (!bSendNewCard) break;
                this.paintCardDistribution(g);
                break;
            }
            case 9: {
                this.paintGame(g);
                this.paintControls(g);
                this.paintCardsSum(g);
                this.paintSplitting(g);
                break;
            }
            case 5: {
                this.paintGame(g);
                this.paintControls(g);
                this.paintWin(g);
                this.paintCardsSum(g);
                break;
            }
            case 6: {
                this.paintPause(g);
                this.paintControls(g);
                break;
            }
            case 7: {
                Resources.paintStatusBar(g, 2);
                this.paintStats(g);
                this.paintControls(g);
                break;
            }
            case 8: {
                this.paintGameOver(g);
            }
        }
    }

    public void paintRestart(Graphics g) {
        this.paintGame(g);
        Resources.paintStatusBar(g, 7);
        Resources.paintMenuBG(15, 7, sRestart, g);
        Resources.paintTextIntoTable(15, 10, g);
    }

    public void paintSplitting(Graphics g) {
        int deltaX = Resources.iCardW;
        Sprite sprTmpCards = null;
        switch (Game.player.cards[0].getColNr()) {
            case 0: {
                sprTmpCards = Resources.sprHearts;
                break;
            }
            case 1: {
                sprTmpCards = Resources.sprDiamonds;
                break;
            }
            case 2: {
                sprTmpCards = Resources.sprClubs;
                break;
            }
            case 3: {
                sprTmpCards = Resources.sprSpades;
            }
        }
        sprTmpCards.setFrame(Game.player.cards[0].getValue() - 1);
        sprTmpCards.setPosition(iDistributionX, Resources.PLAYER_CARD_Y);
        sprTmpCards.paint(g);
        switch (Game.player.hand2Cards[0].getColNr()) {
            case 0: {
                sprTmpCards = Resources.sprHearts;
                break;
            }
            case 1: {
                sprTmpCards = Resources.sprDiamonds;
                break;
            }
            case 2: {
                sprTmpCards = Resources.sprClubs;
                break;
            }
            case 3: {
                sprTmpCards = Resources.sprSpades;
            }
        }
        sprTmpCards.setFrame(Game.player.hand2Cards[0].getValue() - 1);
        sprTmpCards.setPosition(Defines.WIDTH - Resources.iCardW - iDistributionX, Resources.PLAYER_CARD_Y);
        sprTmpCards.paint(g);
        if (iDistributionX > Resources.PLAYER_CARD_SIDE_X) {
            iDistributionX -= deltaX;
        }
        if (iDistributionX <= Resources.PLAYER_CARD_SIDE_X) {
            iDistributionX = Resources.PLAYER_CARD_SIDE_X;
            iSelectedAction = 0;
            bSendNewCard = true;
            this.resetDistributionCoordinates();
            mode = 3;
        }
    }

    public void paintCardsSum(Graphics g) {
        String message = "";
        if (!Game.player.b2Hands) {
            message = Game.player.iCardsValue1 == Game.player.iCardsValue2 ? message + Game.player.iCardsValue1 : message + Game.player.iCardsValue1 + "-" + Game.player.iCardsValue2;
            if (Game.player.haveBJ()) {
                message = "BLACKJACK";
            }
            if (Game.player.iCardsValue2 > 21) {
                message = Game.player.iCardsValue2 + "-BUST";
            }
            Fonts.drawStr(message, (Defines.WIDTH - Resources.iCardW) / 2 + Resources.DEALER_CARD_X, Resources.PLAYER_CARD_Y + Resources.iCardH, g);
        } else {
            message = Game.player.iCardsValue1 == Game.player.iCardsValue2 ? message + Game.player.iCardsValue1 : message + Game.player.iCardsValue1 + "-" + Game.player.iCardsValue2;
            if (Game.player.haveBJ()) {
                message = "BLACKJACK";
            }
            if (Game.player.iCardsValue2 > 21) {
                message = Game.player.iCardsValue2 + "-BUST";
            }
            Fonts.drawStr(message, Resources.PLAYER_CARD_SIDE_X, Resources.PLAYER_CARD_Y + Resources.iCardH, g);
            message = "";
            message = Game.player.i2HandCardsValue1 == Game.player.i2HandCardsValue2 ? message + Game.player.i2HandCardsValue1 : message + Game.player.i2HandCardsValue1 + "-" + Game.player.i2HandCardsValue2;
            if (Game.player.haveBJ2Hand()) {
                message = "BLACKJACK";
            }
            if (Game.player.i2HandCardsValue2 > 21) {
                message = Game.player.i2HandCardsValue2 + "-BUST";
            }
            Fonts.drawStr(message, Defines.WIDTH - Resources.iCardW - Resources.PLAYER_CARD_SIDE_X, Resources.PLAYER_CARD_Y + Resources.iCardH, g);
        }
        message = "";
        if (mode == 3 || mode == 9) {
            message = Game.dealer.cards[0].getValueAceModif() != 14 ? message + Game.dealer.cards[0].getValueBJModif() : "11-1";
        } else {
            message = Game.dealer.iCardsValue1 == Game.dealer.iCardsValue2 ? message + Game.dealer.iCardsValue1 : message + Game.dealer.iCardsValue1 + "-" + Game.dealer.iCardsValue2;
            if (Game.dealer.haveBJ()) {
                message = "BLACKJACK";
            }
            if (Game.dealer.iCardsValue2 > 21) {
                message = Game.dealer.iCardsValue2 + "-BUST";
            }
        }
        Fonts.drawStr(message, (Defines.WIDTH - Resources.iCardW) / 2 + Resources.DEALER_CARD_X, Resources.DEALER_CARD_Y - Resources.iFont1H, g);
        if ((mode == 3 || mode == 4 || mode == 9) && Game.iInsurance != 0) {
            int areaH = Defines.HEIGHT - Resources.iStatusBarH - Resources.iPlayerPanelH;
            areaH = Resources.iUpperPanelH + (areaH - Resources.iTableH) / 2;
            message = sInsur + ": " + Game.iInsurance + "$";
            if (Defines.HEIGHT > 299) {
                Fonts.drawStr(message, (Defines.WIDTH - Fonts.strWidth(message)) / 2, areaH + Resources.iTableH + Resources.iFont1H / 2, g);
            } else {
                areaH = Defines.HEIGHT - Resources.iStatusBarH - Resources.iPlayerPanelH;
                Fonts.drawStr(message, (Defines.WIDTH - Fonts.strWidth(message)) / 2, Resources.iUpperPanelH + (areaH - Resources.iTableH) / 2 - Resources.iFont1H - Resources.iFont1H / 2, g);
            }
        }
    }

    public void paintGameOver(Graphics g) {
        Resources.paintBackground(g);
        this.paintRaster(g);
        int xParts = Defines.WIDTH / Resources.iInfoBarW - 5;
        int yParts = (Defines.HEIGHT - Resources.iBorderOffH - Resources.iIconsH) / Resources.iInfoBarH - 5;
        Resources.paintMenuBG(xParts, yParts, gameModeStrings[2], g);
        Resources.iGameOverW = Resources.imgGameOver.getWidth();
        Resources.iGameOverH = Resources.imgGameOver.getHeight();
        g.drawImage(Resources.imgGameOver, (Defines.WIDTH - Resources.iGameOverW) / 2, (Defines.HEIGHT - Resources.iGameOverH) / 2, 0);
        int iPosX = (Defines.WIDTH - Resources.iInfoBarW * xParts) / 2;
        int iPosY = (Defines.HEIGHT - Resources.iInfoBarH * yParts) / 2;
        int iWidth = Resources.iInfoBarW * 12;
        int iHeight = Resources.iInfoBarH * 12;
        String sValue = "";
        boolean switchIndex = false;
        int iPosXButt = (Defines.WIDTH - Resources.iInfoBarW * xParts) / 2;
        int iPosYButt = (Defines.HEIGHT - Resources.iInfoBarH * yParts) / 2;
        if (iSelectedAction == 0) {
            Resources.sprIconsON.setFrame(0);
            Resources.sprIconsON.setPosition(iPosXButt + Resources.iIconsW / 4, Defines.HEIGHT - iPosYButt - Resources.iIconsH - Resources.iIconsW / 4);
            Resources.sprIconsON.paint(g);
        } else {
            Resources.sprIconsOFF.setFrame(0);
            Resources.sprIconsOFF.setPosition(iPosXButt + Resources.iIconsW / 4, Defines.HEIGHT - iPosYButt - Resources.iIconsH - Resources.iIconsW / 4);
            Resources.sprIconsOFF.paint(g);
        }
        if (iSelectedAction == 1) {
            Resources.sprIconsON.setFrame(3);
            Resources.sprIconsON.setPosition(Defines.WIDTH - iPosXButt - Resources.iIconsW - Resources.iIconsW / 4, Defines.HEIGHT - iPosYButt - Resources.iIconsH - Resources.iIconsW / 4);
            Resources.sprIconsON.paint(g);
        } else {
            Resources.sprIconsOFF.setFrame(3);
            Resources.sprIconsOFF.setPosition(Defines.WIDTH - iPosXButt - Resources.iIconsW - Resources.iIconsW / 4, Defines.HEIGHT - iPosYButt - Resources.iIconsH - Resources.iIconsW / 4);
            Resources.sprIconsOFF.paint(g);
        }
    }

    public void paintRaster(Graphics g) {
        int x = 0;
        for (int y = 0; y <= Defines.HEIGHT; y += Resources.iRasterH) {
            while (x <= Defines.WIDTH) {
                g.drawImage(Resources.imgRaster, x, y, 0);
                x += Resources.iRasterW;
            }
            x = 0;
        }
    }

    public void paintWin(Graphics g) {
        int areaH;
        if (!Game.player.b2Hands) {
            this.paint1HandWin(g);
        } else {
            areaH = Defines.HEIGHT - Resources.iStatusBarH - Resources.iPlayerPanelH;
            areaH = Resources.iUpperPanelH + (areaH - Resources.iTableH) / 2;
            String sWinMessage = "";
            int offset = 0;
            if (Defines.HEIGHT < 325 && Defines.HEIGHT > 300) {
                offset = 10;
            }
            if (Game.player.bWin && Game.player.bWin2Hand) {
                Resources.sprWin.setFrame(iWinFrame >> 1);
                Resources.sprWin.setPosition((Defines.WIDTH - Resources.iWinW) / 2, (Defines.HEIGHT - Resources.iTableH + Resources.iUpperPanelH) / 2 / 2 - offset);
                Resources.sprWin.paint(g);
                if (++iWinFrame > 19) {
                    iWinFrame = 0;
                }
                if (Game.player.bDD || Game.player.b2HandDD) {
                    sWinMessage = sPlayer + " " + sWins + " " + Game.player.iActualBet * 6 + "$";
                }
                if (Game.player.bDD && Game.player.b2HandDD) {
                    sWinMessage = sPlayer + " " + sWins + " " + Game.player.iActualBet * 8 + "$";
                }
                if (!Game.player.bDD && !Game.player.b2HandDD) {
                    sWinMessage = sPlayer + " " + sWins + " " + Game.player.iActualBet * 4 + "$";
                }
                Fonts.drawStr(sWinMessage, (Defines.WIDTH - Fonts.strWidth(sWinMessage)) / 2, areaH + Resources.iTableH / 2, g);
            }
            if (!Game.dealer.bWin && !Game.dealer.bWin2Hand && Game.player.bWin && !Game.player.bWin2Hand) {
                if (Defines.HEIGHT < 325 && Defines.HEIGHT > 300) {
                    offset = 10;
                }
                Resources.sprWin.setFrame(iWinFrame >> 1);
                Resources.sprWin.setPosition((Defines.WIDTH - Resources.iWinW) / 2, (Defines.HEIGHT - Resources.iTableH + Resources.iUpperPanelH) / 2 / 2 - offset);
                Resources.sprWin.paint(g);
                if (++iWinFrame > 19) {
                    iWinFrame = 0;
                }
                sWinMessage = Game.player.bDD ? sPlayer + " " + sWins + " " + Game.player.iActualBet * 5 + "$" : sPlayer + " " + sWins + " " + Game.player.iActualBet * 2 + "$";
                Fonts.drawStr(sWinMessage, (Defines.WIDTH - Fonts.strWidth(sWinMessage)) / 2, areaH + Resources.iTableH / 2, g);
            }
            if (!Game.dealer.bWin && !Game.dealer.bWin2Hand && !Game.player.bWin && Game.player.bWin2Hand) {
                Resources.sprWin.setFrame(iWinFrame >> 1);
                Resources.sprWin.setPosition((Defines.WIDTH - Resources.iWinW) / 2, (Defines.HEIGHT - Resources.iTableH + Resources.iUpperPanelH) / 2 / 2 - offset);
                Resources.sprWin.paint(g);
                if (++iWinFrame > 19) {
                    iWinFrame = 0;
                }
                sWinMessage = Game.player.b2HandDD ? sPlayer + " " + sWins + " " + Game.player.iActualBet * 5 + "$" : sPlayer + " " + sWins + " " + Game.player.iActualBet * 2 + "$";
                Fonts.drawStr(sWinMessage, (Defines.WIDTH - Fonts.strWidth(sWinMessage)) / 2, areaH + Resources.iTableH / 2, g);
            }
            if (!(Game.player.bWin || Game.player.bWin2Hand || Game.dealer.bWin || Game.dealer.bWin2Hand)) {
                sWinMessage = actionStrings[3] + " " + sBoth;
                Fonts.drawStr(sWinMessage, (Defines.WIDTH - Fonts.strWidth(sWinMessage)) / 2, areaH + Resources.iTableH / 2, g);
            }
            if (!Game.player.bWin && Game.player.bWin2Hand && Game.dealer.bWin && !Game.dealer.bWin2Hand) {
                sWinMessage = sRight + " " + sWins;
                Fonts.drawStr(sWinMessage, (Defines.WIDTH - Fonts.strWidth(sWinMessage)) / 2, areaH + Resources.iTableH / 2, g);
            }
            if (Game.player.bWin && !Game.player.bWin2Hand && !Game.dealer.bWin && Game.dealer.bWin2Hand) {
                sWinMessage = sLeft + " " + sWins;
                Fonts.drawStr(sWinMessage, (Defines.WIDTH - Fonts.strWidth(sWinMessage)) / 2, areaH + Resources.iTableH / 2, g);
            }
            if (!Game.player.bWin && !Game.player.bWin2Hand && Game.dealer.bWin && Game.dealer.bWin2Hand) {
                sWinMessage = "DEALER " + sWins;
                Fonts.drawStr(sWinMessage, (Defines.WIDTH - Fonts.strWidth(sWinMessage)) / 2, areaH + Resources.iTableH / 2, g);
            }
            if (!Game.player.bWin && !Game.player.bWin2Hand && (!Game.dealer.bWin && Game.dealer.bWin2Hand || Game.dealer.bWin && !Game.dealer.bWin2Hand)) {
                sWinMessage = "DEALER " + sWins;
                Fonts.drawStr(sWinMessage, (Defines.WIDTH - Fonts.strWidth(sWinMessage)) / 2, areaH + Resources.iTableH / 2, g);
            }
            if (!Game.player.bWin && !Game.player.bWin2Hand && (!Game.dealer.bWin && Game.dealer.bWin2Hand || Game.dealer.bWin && !Game.dealer.bWin2Hand)) {
                sWinMessage = "DEALER " + sWins;
                Fonts.drawStr(sWinMessage, (Defines.WIDTH - Fonts.strWidth(sWinMessage)) / 2, areaH + Resources.iTableH / 2, g);
            }
        }
        if (Game.dealer.haveBJ() && Game.iInsurance > 0) {
            areaH = Defines.HEIGHT - Resources.iStatusBarH - Resources.iPlayerPanelH;
            areaH = Resources.iUpperPanelH + (areaH - Resources.iTableH) / 2;
            String message = sInsur + ": " + Game.iInsurance * 2 + "$";
            if (Defines.HEIGHT > 299) {
                Fonts.drawStr(message, (Defines.WIDTH - Fonts.strWidth(message)) / 2, areaH + Resources.iTableH + Resources.iFont1H / 2, g);
            } else {
                areaH = Defines.HEIGHT - Resources.iStatusBarH - Resources.iPlayerPanelH;
                Fonts.drawStr(message, (Defines.WIDTH - Fonts.strWidth(message)) / 2, Resources.iUpperPanelH + (areaH - Resources.iTableH) / 2 - Resources.iFont1H - Resources.iFont1H / 2, g);
            }
        }
    }

    public static int getHalf(int iActualBet) {
        int ins = iActualBet / 2;
        if (ins % 10 != 0) {
            ins -= 5;
        }
        return ins;
    }

    public void paint1HandWin(Graphics g) {
        String sWinMessage = "";
        int offset = 0;
        if (Defines.HEIGHT < 325 && Defines.HEIGHT > 300) {
            offset = 10;
        }
        if (Game.player.bWin) {
            Resources.sprWin.setFrame(iWinFrame >> 1);
            Resources.sprWin.setPosition((Defines.WIDTH - Resources.iWinW) / 2, (Defines.HEIGHT - Resources.iTableH + Resources.iUpperPanelH) / 2 / 2 - offset);
            Resources.sprWin.paint(g);
            if (++iWinFrame > 19) {
                iWinFrame = 0;
            }
            sWinMessage = Game.player.haveBJ() ? sPlayer + " " + sWins + " " + (Game.player.iActualBet * 2 + ScreenGameBJ.getHalf(Game.player.iActualBet)) + "$" : sPlayer + " " + sWins + " " + Game.player.iActualBet * 2 + "$";
        } else {
            sWinMessage = Game.dealer.bWin ? "DEALER " + sWins : actionStrings[3];
        }
        int areaH = Defines.HEIGHT - Resources.iStatusBarH - Resources.iPlayerPanelH;
        areaH = Resources.iUpperPanelH + (areaH - Resources.iTableH) / 2;
        Fonts.drawStr(sWinMessage, (Defines.WIDTH - Fonts.strWidth(sWinMessage)) / 2, areaH + Resources.iTableH / 2, g);
    }

    public void paintStats(Graphics g) {
    }

    public void paintPause(Graphics g) {
        this.paintGame(g);
        this.paintRaster(g);
        Resources.paintMenuBG(12, 10, sGameMenu, g);
        int iPosX = 0;
        int iPosY = 0;
        int x = (Defines.WIDTH - Resources.iBorderOnW * 8) / 2;
        for (int i = 0; i < 3; ++i) {
            if (i == iSelectedSubMenuItem) {
                Resources.paintBorder(2, true, 8, x, Resources.SUBMENU_POS_Y + i * (Resources.iBorderOnH + Resources.MENU_BUTTONS_OFFSET), g);
            } else {
                Resources.paintBorder(2, false, 8, x, Resources.SUBMENU_POS_Y + i * (Resources.iBorderOnH + Resources.MENU_BUTTONS_OFFSET), g);
            }
            iPosX = (Defines.WIDTH - Fonts.strWidth(menuStrings[i])) / 2;
            iPosY = Resources.SUBMENU_POS_Y + i * (Resources.iBorderOnH + Resources.MENU_BUTTONS_OFFSET) + (Resources.iBorderOnH - Resources.iFont1H) / 2;
            Fonts.drawStr(menuStrings[i], iPosX, iPosY, g);
        }
        Resources.paintStatusBar(g, 5);
    }

    public void paintControls(Graphics g) {
        int iActionIndex = -1;
        switch (iSelectedAction) {
            case 0: {
                iActionIndex = 0;
                break;
            }
            case 1: {
                iActionIndex = 1;
                break;
            }
            case 2: {
                iActionIndex = 2;
                break;
            }
            case 3: {
                iActionIndex = 3;
                break;
            }
            case 7: {
                iActionIndex = 6;
                break;
            }
            case 4: {
                iActionIndex = 4;
                break;
            }
            case 6: {
                iActionIndex = 5;
                break;
            }
            case 5: {
                iActionIndex = 7;
            }
        }
        if (iActionIndex != -1) {
            Fonts.drawStr(actionStrings[iActionIndex], (Defines.WIDTH - Fonts.strWidth(actionStrings[iActionIndex])) / 2, Defines.HEIGHT - Resources.STATUSBAR_STRING, g);
        }
    }

    public void paintGameLoading(Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, Defines.WIDTH, Defines.HEIGHT);
        Resources.paintLoading(g);
    }

    public void paintGame(Graphics g) {
        Resources.paintBackground(g);
        this.paintTable(g);
        this.paintUpperSheet(g);
        if (mode == 1) {
            Resources.paintStatusBar(g, 3);
        } else {
            Resources.paintStatusBar(g, 2);
        }
        this.paintPlayerPanel(g);
    }

    public void paintTable(Graphics g) {
        int areaH = Defines.HEIGHT - Resources.iStatusBarH - Resources.iPlayerPanelH;
        g.drawImage(Resources.imgTable, (Defines.WIDTH - Resources.iTableW) / 2, Resources.iUpperPanelH + (areaH - Resources.iTableH) / 2, 0);
        Sprite sprTmpCards = null;
        for (int i = 0; i < Game.dealer.iCardsCount; ++i) {
            if (!Game.dealer.cards[i].isDistributed()) continue;
            if (i == 0 && (mode == 2 || mode == 3) || mode != 2 || mode != 3) {
                switch (Game.dealer.cards[i].getColNr()) {
                    case 0: {
                        sprTmpCards = Resources.sprHearts;
                        break;
                    }
                    case 1: {
                        sprTmpCards = Resources.sprDiamonds;
                        break;
                    }
                    case 2: {
                        sprTmpCards = Resources.sprClubs;
                        break;
                    }
                    case 3: {
                        sprTmpCards = Resources.sprSpades;
                    }
                }
                sprTmpCards.setFrame(Game.dealer.cards[i].getValue() - 1);
            }
            if (i != 0 && (mode == 2 || mode == 3 || mode == 9)) {
                sprTmpCards = Resources.sprCardRub;
                sprTmpCards.setFrame(1);
            }
            sprTmpCards.setPosition((Defines.WIDTH - Resources.iCardW) / 2 + Resources.DEALER_CARD_X + i * (Resources.iCardW / 2), Resources.DEALER_CARD_Y);
            sprTmpCards.paint(g);
        }
        if (mode == 9) {
            return;
        }
        if (!Game.player.b2Hands) {
            this.paintOneHand(g);
        } else {
            this.paintTwoHands(g);
        }
    }

    public void paintTwoHands(Graphics g) {
        int i;
        Sprite sprTmpCards = null;
        for (i = 0; i < Game.player.iCardsCount; ++i) {
            if (!Game.player.cards[i].isDistributed()) continue;
            switch (Game.player.cards[i].getColNr()) {
                case 0: {
                    sprTmpCards = Resources.sprHearts;
                    break;
                }
                case 1: {
                    sprTmpCards = Resources.sprDiamonds;
                    break;
                }
                case 2: {
                    sprTmpCards = Resources.sprClubs;
                    break;
                }
                case 3: {
                    sprTmpCards = Resources.sprSpades;
                }
            }
            if (!Game.player.cards[i].isDistributed()) continue;
            sprTmpCards.setFrame(Game.player.cards[i].getValue() - 1);
            sprTmpCards.setPosition(Resources.PLAYER_CARD_SIDE_X + i * (Resources.iCardW / 2), Resources.PLAYER_CARD_Y);
            sprTmpCards.paint(g);
        }
        for (i = 0; i < Game.player.i2HandCardsCount; ++i) {
            if (!Game.player.hand2Cards[i].isDistributed()) continue;
            switch (Game.player.hand2Cards[i].getColNr()) {
                case 0: {
                    sprTmpCards = Resources.sprHearts;
                    break;
                }
                case 1: {
                    sprTmpCards = Resources.sprDiamonds;
                    break;
                }
                case 2: {
                    sprTmpCards = Resources.sprClubs;
                    break;
                }
                case 3: {
                    sprTmpCards = Resources.sprSpades;
                }
            }
            if (!Game.player.hand2Cards[i].isDistributed()) continue;
            sprTmpCards.setFrame(Game.player.hand2Cards[i].getValue() - 1);
            sprTmpCards.setPosition(Defines.WIDTH - Resources.iCardW - Resources.PLAYER_CARD_SIDE_X + i * (Resources.iCardW / 2), Resources.PLAYER_CARD_Y);
            sprTmpCards.paint(g);
        }
    }

    public void paintOneHand(Graphics g) {
        Sprite sprTmpCards = null;
        for (int i = 0; i < Game.player.iCardsCount; ++i) {
            if (!Game.player.cards[i].isDistributed()) continue;
            switch (Game.player.cards[i].getColNr()) {
                case 0: {
                    sprTmpCards = Resources.sprHearts;
                    break;
                }
                case 1: {
                    sprTmpCards = Resources.sprDiamonds;
                    break;
                }
                case 2: {
                    sprTmpCards = Resources.sprClubs;
                    break;
                }
                case 3: {
                    sprTmpCards = Resources.sprSpades;
                }
            }
            if (!Game.player.cards[i].isDistributed()) continue;
            sprTmpCards.setFrame(Game.player.cards[i].getValue() - 1);
            sprTmpCards.setPosition((Defines.WIDTH - Resources.iCardW) / 2 + Resources.PLAYER_CARD_MIDDLE_X + i * (Resources.iCardW / 2), Resources.PLAYER_CARD_Y);
            sprTmpCards.paint(g);
        }
    }

    public void paintPlayerPanel(Graphics g) {
        int panelY = Defines.HEIGHT - Resources.iStatusBarH - Resources.iPlayerPanelH + Resources.iStatusBarH / 6;
        int panelX = (Defines.WIDTH - Resources.iPlayerPanelW) / 2;
        if (mode == 1 || mode == 3) {
            g.drawImage(Resources.imgPlayerPanel, panelX, panelY, 0);
        } else {
            g.drawImage(Resources.imgPlayerPanelOff, panelX, panelY, 0);
        }
        String message1 = "";
        String message2 = "";
        if (mode == 1) {
            message1 = sSetBet;
            message2 = iPlayerBet + " $";
        }
        if (mode == 3) {
            message1 = sBet + ": " + iPlayerBet + "$";
        }
        Fonts.drawStr(message1, (Defines.WIDTH - Fonts.strWidth(message1)) / 2, panelY + (Resources.imgPlayerPanel.getHeight() - Resources.iFont1H) / 6, g);
        Fonts.drawStr(message2, (Defines.WIDTH - Fonts.strWidth(message2)) / 2, panelY + Resources.imgPlayerPanel.getHeight() - Resources.iFont1H - (Resources.imgPlayerPanel.getHeight() - Resources.iFont1H) / 6, g);
        if (Game.player.b2Hands && mode == 3) {
            message1 = Game.bPlayingLeftHand ? sLeft : sRight;
            Fonts.drawStr(message1, (Defines.WIDTH - Fonts.strWidth(message1)) / 2, panelY + Resources.imgPlayerPanel.getHeight() - Resources.iFont1H - (Resources.imgPlayerPanel.getHeight() - Resources.iFont1H) / 6, g);
        }
    }

    public void paintUpperSheet(Graphics g) {
        g.drawImage(Resources.imgUpperPanel, 0, 0, 0);
        int iPosBordX = (Defines.WIDTH - Resources.iBorderOnW * (Resources.UPPER_PANEL1_PARTS + Resources.UPPER_PANEL2_PARTS)) / 2;
        int iPosBordY = (Resources.iUpperPanelH - Resources.iBorderOffH) / 2;
        Resources.paintBorder(2, true, Resources.UPPER_PANEL1_PARTS, iPosBordX, iPosBordY, g);
        String message1 = "";
        String message2 = Game.player.iChips + "$";
        switch (mode) {
            case 1: {
                message1 = sSetBet;
                break;
            }
            case 2: {
                message1 = gameModeStrings[0];
                break;
            }
            case 3: {
                message1 = sYour;
                break;
            }
            case 5: {
                message1 = sEnd;
            }
        }
        Fonts.drawStr(message1, iPosBordX + (Resources.iBorderOnW * Resources.UPPER_PANEL1_PARTS - Fonts.strWidth(message1)) / 2, iPosBordY + (Resources.iBorderOffH - Resources.iFont1H) / 2, g);
        iPosBordY = (Resources.iUpperPanelH - Resources.iBorderOffH) / 2;
        Resources.paintBorder(2, false, Resources.UPPER_PANEL2_PARTS, iPosBordX += Resources.iBorderOnW * Resources.UPPER_PANEL1_PARTS, iPosBordY, g);
        Fonts.drawStr(message2, iPosBordX + (Resources.iBorderOnW * Resources.UPPER_PANEL2_PARTS - Fonts.strWidth(message2)) / 2, iPosBordY + (Resources.iBorderOffH - Resources.iFont1H) / 2, g);
    }

    public void paintCardDistribution(Graphics g) {
        int iDefinedPositionX = 0;
        int iDefinedPositionY = 0;
        int deltaX = 0;
        int deltaY = 0;
        if (iDistributionX == 0 && iDistributionY == 0) {
            actualCard = this.generateCard();
        }
        int cardsCount = Game.dealer.iCardsCount + Game.player.iCardsCount;
        if (mode == 2 && (cardsCount == 0 || cardsCount == 2) || mode == 3) {
            if (!Game.player.b2Hands) {
                iDefinedPositionX = (Defines.WIDTH - Resources.iCardW) / 2 + Resources.PLAYER_CARD_MIDDLE_X;
                iDefinedPositionY = Resources.PLAYER_CARD_Y;
                deltaX = Resources.iCardW / 2;
                deltaY = Resources.iCardH / 2;
                if (Defines.WIDTH <= 330 && Defines.WIDTH >= 310 && Defines.HEIGHT <= 250 && Defines.HEIGHT >= 230) {
                    deltaX = Resources.iCardW / 2;
                    deltaY = Resources.iCardH / 4;
                }
            } else if (Game.bPlayingLeftHand) {
                iDefinedPositionX = Resources.PLAYER_CARD_SIDE_X;
                iDefinedPositionY = Resources.PLAYER_CARD_Y;
                deltaX = Resources.iCardW / 4;
                deltaY = Resources.iCardW / 2;
                if (Defines.WIDTH <= 330 && Defines.WIDTH >= 310 && Defines.HEIGHT <= 250 && Defines.HEIGHT >= 230) {
                    deltaX = Resources.iCardW / 4;
                    deltaY = Resources.iCardW / 4;
                }
            } else {
                iDefinedPositionX = Defines.WIDTH - Resources.iCardW - Resources.PLAYER_CARD_SIDE_X;
                iDefinedPositionY = Resources.PLAYER_CARD_Y;
                deltaX = Resources.iCardH / 2;
                deltaY = Resources.iCardH / 2;
                if (Defines.WIDTH <= 330 && Defines.WIDTH >= 310 && Defines.HEIGHT <= 250 && Defines.HEIGHT >= 230) {
                    deltaX = Resources.iCardW / 2;
                    deltaY = Resources.iCardW / 3;
                }
            }
        }
        if (mode == 2 && (cardsCount == 1 || cardsCount == 3) || mode == 4) {
            iDefinedPositionX = (Defines.WIDTH - Resources.iCardW) / 2 + Resources.DEALER_CARD_X;
            iDefinedPositionY = Resources.DEALER_CARD_Y;
            deltaX = Resources.iCardW / 2;
            deltaY = Resources.iCardW / 2;
            if (Defines.WIDTH <= 330 && Defines.WIDTH >= 310 && Defines.HEIGHT <= 250 && Defines.HEIGHT >= 230) {
                deltaX = Resources.iCardW / 2;
                deltaY = Resources.iCardW / 3;
            }
        }
        iDistributionX += deltaX;
        iDistributionY += deltaY;
        Sprite sprTmpCards = null;
        switch (actualCard.getColNr()) {
            case 0: {
                sprTmpCards = Resources.sprHearts;
                break;
            }
            case 1: {
                sprTmpCards = Resources.sprDiamonds;
                break;
            }
            case 2: {
                sprTmpCards = Resources.sprClubs;
                break;
            }
            case 3: {
                sprTmpCards = Resources.sprSpades;
            }
        }
        sprTmpCards.setFrame(actualCard.getValue() - 1);
        if (mode == 2 && cardsCount == 3) {
            sprTmpCards = Resources.sprCardRub;
            sprTmpCards.setFrame(1);
        }
        sprTmpCards.setPosition(iDistributionX, iDistributionY);
        sprTmpCards.paint(g);
        boolean bHelp1 = false;
        boolean bHelp2 = false;
        if (iDistributionX < iDefinedPositionX) {
            iDistributionX += deltaX;
        }
        if (iDistributionX >= iDefinedPositionX) {
            bHelp1 = true;
            iDistributionX = iDefinedPositionX;
        }
        if (iDistributionY < iDefinedPositionY) {
            iDistributionY += deltaY;
        }
        if (iDistributionY >= iDefinedPositionY) {
            bHelp2 = true;
            iDistributionY = iDefinedPositionY;
        }
        if (bHelp1 && bHelp2) {
            if (mode == 2 && (cardsCount == 0 || cardsCount == 2) || mode == 3) {
                Game.player.receiveCard(actualCard);
            }
            if (mode == 2 && (cardsCount == 1 || cardsCount == 3) || mode == 4) {
                Game.dealer.receiveCard(actualCard);
            }
            this.resetDistributionCoordinates();
            bHelp1 = false;
            bHelp2 = false;
            bSendNewCard = false;
        }
    }

    public static void nextPlayer() {
    }

    public void keyPressed(int keyCode) {
        switch (mode) {
            case 1: {
                this.newRoundKeyPr(keyCode);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.playerMoveKeyPr(keyCode);
                break;
            }
            case 6: {
                this.PauseKeyPr(keyCode);
                break;
            }
            case 5: {
                this.RoundOverKeyPr(keyCode);
                break;
            }
            case 8: {
                this.keyPrGameOver(keyCode);
                break;
            }
            case 10: {
                this.restartKeyPr(keyCode);
            }
        }
    }

    public void restartKeyPr(int keyCode) {
        if (Keys.key_fn2) {
            mode = 1;
            Game.player.iActualBet = 0;
            Game.player.iChips = 1000;
            Game.iBet = 0;
            iPlayerBet = Game.player.iChips > 10 ? 20 : 10;
            Game.deleteCards();
        }
        if (Keys.key_fn1) {
            iSelectedSubMenuItem = -10;
            mode = 6;
            X.soundManager.Stop();
        }
    }

    public void keyPrGameOver(int keyCode) {
        if ((Keys.key_up || Keys.key_num2 || Keys.key_left || Keys.key_num4) && --iSelectedAction < 0) {
            iSelectedAction = 1;
        }
        if ((Keys.key_down || Keys.key_num8 || Keys.key_right || Keys.key_num6) && ++iSelectedAction > 1) {
            iSelectedAction = 0;
        }
        if (Keys.key_fire || Keys.key_num5) {
            switch (iSelectedAction) {
                case 0: {
                    mode = -1;
                    stateBJ.deleteScore();
                    mode = 1;
                    Game.player.iActualBet = 0;
                    Game.player.iChips = 1000;
                    Game.iBet = 0;
                    iPlayerBet = Game.player.iChips > 10 ? 20 : 10;
                    Game.deleteCards();
                    break;
                }
                case 1: {
                    stateBJ.deleteScore();
                    Resources.releaseGamePokResources();
                    MainCanvas.scrMenu = new ScreenMenu(canvas, 1);
                    MainCanvas.activeScreen = MainCanvas.scrMenu;
                    MainCanvas.scrGameBJ = null;
                }
            }
        }
    }

    public void RoundOverKeyPr(int keyCode) {
        if ((Keys.key_right || Keys.key_up || Keys.key_fn2 || Keys.key_num6 || Keys.key_num2) && ++iSelectedAction > 7) {
            iSelectedAction = 6;
        }
        if ((Keys.key_left || Keys.key_down || Keys.key_fn1 || Keys.key_num4 || Keys.key_num8) && --iSelectedAction < 6) {
            iSelectedAction = 7;
        }
        if (Keys.key_fire || Keys.key_num5) {
            switch (iSelectedAction) {
                case 6: {
                    LAST_MODE = mode;
                    stateBJ.saveGame(this);
                    mode = 6;
                    X.soundManager.Stop();
                    break;
                }
                case 7: {
                    Game.deleteCards();
                    iPlayerBet = Game.player.iChips > 10 ? 20 : 10;
                    Game.player.iActualBet = 0;
                    Game.iBet = 0;
                    if (Game.player.iChips <= 0) {
                        mode = 8;
                        stateBJ.deleteScore();
                        break;
                    }
                    mode = 1;
                }
            }
        }
    }

    public void PauseKeyPr(int keyCode) {
        if (Keys.key_right || Keys.key_up || Keys.key_fn2 || Keys.key_num6 || Keys.key_num2) {
            iSelectedSubMenuItem = iSelectedSubMenuItem - 1 < 0 ? 2 : --iSelectedSubMenuItem;
        }
        if (Keys.key_left || Keys.key_down || Keys.key_fn1 || Keys.key_num4 || Keys.key_num8) {
            iSelectedSubMenuItem = iSelectedSubMenuItem + 1 > 2 ? 0 : ++iSelectedSubMenuItem;
        }
        if (Keys.key_fire || Keys.key_num5) {
            if (iSelectedSubMenuItem == 1) {
                mode = 10;
            }
            if (iSelectedSubMenuItem == 0) {
                mode = LAST_MODE;
                if (mode == 3) {
                    iSelectedAction = 0;
                }
                if (mode == 5) {
                    iSelectedAction = 7;
                }
                if (Settings.bMusic) {
                    X.soundManager.Stop();
                    X.soundManager.SetSoundOn(true);
                    X.soundManager.Play(X.MUSIC_MENU_ID, -1);
                } else {
                    X.soundManager.Stop();
                    X.soundManager.SetSoundOn(false);
                }
            }
            if (iSelectedSubMenuItem == 2) {
                Resources.releaseGameBJResources();
                MainCanvas.scrMenu = new ScreenMenu(canvas, 1);
                MainCanvas.activeScreen = MainCanvas.scrMenu;
                MainCanvas.scrGameBJ = null;
                return;
            }
        }
    }

    public void playerMoveKeyPr(int keyCode) {
        if (Keys.key_right || Keys.key_up || Keys.key_fn2 || Keys.key_num6 || Keys.key_num2) {
            ++iSelectedAction;
            if (!Game.player.b2Hands || Game.bPlayingLeftHand) {
                if (!(iSelectedAction != 2 || Game.player.iChips >= Game.iBet && Game.player.iCardsCount <= 2 && (Game.player.iCardsValue1 >= 9 && Game.player.iCardsValue1 <= 11 || Game.player.iCardsValue2 >= 9 && Game.player.iCardsValue2 <= 11))) {
                    ++iSelectedAction;
                }
                if (iSelectedAction == 3 && (Game.player.iChips < Game.iBet || Game.player.b2Hands || Game.player.iCardsCount > 2 || Game.player.cards[0].getValueBJModif() != Game.player.cards[1].getValueBJModif())) {
                    ++iSelectedAction;
                }
                if (iSelectedAction == 4 && (Game.player.iCardsCount != 2 || Game.dealer.cards[0].getValueAceModif() != 14 || Game.player.iChips < Game.iBet / 2 || Game.iInsurance != 0 || Game.iBet == 10)) {
                    ++iSelectedAction;
                }
                if (iSelectedAction == 5) {
                    ++iSelectedAction;
                }
                if (iSelectedAction == 7) {
                    ++iSelectedAction;
                }
                if (iSelectedAction > 7) {
                    iSelectedAction = 0;
                }
            } else {
                if (!(iSelectedAction != 2 || Game.player.iChips >= Game.iBet && Game.player.i2HandCardsCount <= 2 && (Game.player.i2HandCardsValue1 >= 9 && Game.player.i2HandCardsValue1 <= 11 || Game.player.i2HandCardsValue2 >= 9 && Game.player.i2HandCardsValue2 <= 11))) {
                    ++iSelectedAction;
                }
                if (iSelectedAction == 3) {
                    ++iSelectedAction;
                }
                if (iSelectedAction == 4) {
                    ++iSelectedAction;
                }
                if (iSelectedAction == 5) {
                    ++iSelectedAction;
                }
                if (iSelectedAction == 7) {
                    ++iSelectedAction;
                }
                if (iSelectedAction > 7) {
                    iSelectedAction = 0;
                }
            }
        }
        if (Keys.key_left || Keys.key_down || Keys.key_fn1 || Keys.key_num4 || Keys.key_num8) {
            --iSelectedAction;
            if (!Game.player.b2Hands || Game.bPlayingLeftHand) {
                if (iSelectedAction == 7) {
                    --iSelectedAction;
                }
                if (iSelectedAction == 5) {
                    --iSelectedAction;
                }
                if (iSelectedAction == 4 && (Game.player.iCardsCount != 2 || Game.dealer.cards[0].getValueAceModif() != 14 || Game.player.iChips < Game.iBet / 2 || Game.iInsurance != 0 || Game.iBet == 10)) {
                    --iSelectedAction;
                }
                if (iSelectedAction == 3 && (Game.player.iChips < Game.iBet || Game.player.b2Hands || Game.player.i2HandCardsCount > 2 || Game.player.cards[0].getValueBJModif() != Game.player.cards[1].getValueBJModif())) {
                    --iSelectedAction;
                }
                if (!(iSelectedAction != 2 || Game.player.iChips >= Game.iBet && Game.player.iCardsCount <= 2 && (Game.player.iCardsValue1 >= 9 && Game.player.iCardsValue1 <= 11 || Game.player.iCardsValue2 >= 9 && Game.player.iCardsValue2 <= 11))) {
                    --iSelectedAction;
                }
                if (iSelectedAction < 0) {
                    iSelectedAction = 6;
                }
            } else {
                if (iSelectedAction == 7) {
                    --iSelectedAction;
                }
                if (iSelectedAction == 5) {
                    --iSelectedAction;
                }
                if (iSelectedAction == 4) {
                    --iSelectedAction;
                }
                if (iSelectedAction == 3) {
                    --iSelectedAction;
                }
                if (!(iSelectedAction != 2 || Game.player.iChips >= Game.iBet && Game.player.i2HandCardsCount <= 2 && (Game.player.i2HandCardsValue1 >= 9 && Game.player.i2HandCardsValue1 <= 11 || Game.player.i2HandCardsValue2 >= 9 && Game.player.i2HandCardsValue2 <= 11))) {
                    --iSelectedAction;
                }
                if (iSelectedAction < 0) {
                    iSelectedAction = 6;
                }
            }
        }
        if (Keys.key_fire || Keys.key_num5) {
            switch (iSelectedAction) {
                case 2: {
                    bSendNewCard = true;
                    Game.player.DoubleDown();
                    while (bSendNewCard) {
                        canvas.repaint();
                        canvas.serviceRepaints();
                    }
                    if (!Game.player.b2Hands) {
                        mode = 4;
                        break;
                    }
                    if (Game.player.i2HandCardsCount > 1) {
                        mode = 4;
                        break;
                    }
                    Game.bPlayingLeftHand = false;
                    bSendNewCard = true;
                    iSelectedAction = 0;
                    break;
                }
                case 0: {
                    bSendNewCard = true;
                    break;
                }
                case 4: {
                    Game.player.insurance();
                    iSelectedAction = 0;
                    break;
                }
                case 3: {
                    Game.player.split();
                    iDistributionX = (Defines.WIDTH - Resources.iCardW) / 2 + Resources.PLAYER_CARD_MIDDLE_X;
                    iSelectedAction = -10;
                    mode = 9;
                    break;
                }
                case 1: {
                    if (!Game.player.b2Hands) {
                        mode = 4;
                        break;
                    }
                    if (Game.player.i2HandCardsCount > 1) {
                        mode = 4;
                        break;
                    }
                    Game.bPlayingLeftHand = false;
                    bSendNewCard = true;
                    iSelectedAction = 0;
                    break;
                }
                case 6: {
                    LAST_MODE = mode;
                    stateBJ.saveGame(this);
                    mode = 6;
                    X.soundManager.Stop();
                }
            }
        }
    }

    public void newRoundKeyPr(int keyCode) {
        if (Keys.key_right || Keys.key_up || Keys.key_fn2 || Keys.key_num6 || Keys.key_num2) {
            bPlusPressed = true;
            if (iPlayerBet != Game.player.iChips) {
                iPlayerBet += 10;
            }
        }
        if (Keys.key_left || Keys.key_down || Keys.key_fn1 || Keys.key_num4 || Keys.key_num8) {
            bMinusPressed = true;
            if (iPlayerBet > 20) {
                iPlayerBet -= 10;
            }
        }
        if (Keys.key_fire || Keys.key_num5) {
            Game.iBet = iPlayerBet;
            Game.player.addBet(iPlayerBet);
        }
    }

    public void continuePlaying() {
        iWaitTime = DEFAULT_WAIT_TIME;
    }

    public void keyReleased(int keyCode) {
        bPlusPressed = false;
        bMinusPressed = false;
        iKeyPressedDelay = 0;
    }

    public void pointerDragged(int x, int y) {
    }

    public void pointerPressed(int x, int y) {
        if (Resources.isInLeftButton(x, y)) {
            Keys.key_fn1 = true;
            this.keyPressed(Keys.iLeftKey);
            Keys.key_fn1 = false;
        }
        if (Resources.isInRightButton(x, y)) {
            Keys.key_fn2 = true;
            this.keyPressed(Keys.iRightKey);
            Keys.key_fn2 = false;
        }
        if (Resources.isMiddleButton(x, y)) {
            Keys.key_fire = true;
            this.keyPressed(Keys.iEnterKey);
            Keys.key_fire = false;
        }
        if (mode == 6) {
            int buttonPressed = Resources.whichSubMenuButton(x, y);
            switch (buttonPressed) {
                case 1: {
                    iSelectedSubMenuItem = 0;
                    break;
                }
                case 2: {
                    iSelectedSubMenuItem = 1;
                    break;
                }
                case 3: {
                    iSelectedSubMenuItem = 2;
                    break;
                }
                default: {
                    iSelectedSubMenuItem = -1;
                }
            }
        }
    }

    public void pointerReleased(int x, int y) {
        bPlusPressed = false;
        bMinusPressed = false;
        iKeyPressedDelay = 0;
        if (mode == 6) {
            Keys.key_fire = true;
            this.keyPressed(Keys.iEnterKey);
            Keys.key_fire = false;
            iSelectedSubMenuItem = -1;
            canvas.repaint();
            canvas.serviceRepaints();
        }
    }

    public int getActualMode() {
        return mode;
    }

    static {
        DEFAULT_WAIT_TIME = 2;
        iDistributionX = 0;
        iDistributionY = 0;
        menuStrings = new String[3];
        actionStrings = new String[8];
        gameModeStrings = new String[4];
        iSelectedSubMenuItem = -1;
    }
}

