/*
 * Decompiled with CFR 0.152.
 */
package pok;

import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;
import main.Common;
import main.Debug;
import main.Defines;
import main.Fonts;
import main.IScreen;
import main.Keys;
import main.MainCanvas;
import main.Resources;
import main.ScreenMenu;
import main.Settings;
import main.X;
import main.statePok;
import pok.Card;
import pok.Game;
import pok.GameHandling;
import pok.PokerPlayer;

public class ScreenGamePok
implements IScreen {
    private String[] playerNames = new String[]{"NICK", "JOE", "PAUL", "JOHN", "FRED", "CARL", "ADAM", "WILL", "VILMA", "LUCY", "EMMA", "EVA", "STACY", "JILL", "JANE", "PENNY"};
    private static final int SEX_SEPARATOR = 7;
    public static Game Game;
    public static GameHandling GameHandling;
    public static int playerPanelYOffset;
    public static int tableYOffset;
    public static boolean bSkipOn;
    public static boolean bPlusPressed;
    public static boolean bMinusPressed;
    public static int iKeyPressedDelay;
    public static int iWaitTime;
    public static int DEFAULT_WAIT_TIME;
    public static int iBlickTime;
    private static int iWinFrame;
    public static int iDealerIndex;
    public static int iSBIndex;
    public static int iBBIndex;
    public static int iPutBlinds;
    public static int actualPlayer;
    public static int step;
    public static int iDistributionRound;
    private static Canvas canvas;
    public static int mode;
    public static int old_mode;
    static final int MODE_LOADING_RES = 0;
    static final int MODE_NEW_ROUND = 1;
    static final int MODE_DISTRIBUTION = 2;
    static final int MODE_PLAYING = 3;
    static final int MODE_PLAYER_MOVE = 4;
    static final int MODE_ROUND_OVER = 5;
    static final int MODE_PAUSE = 6;
    static final int MODE_STATISTICS = 7;
    static final int MODE_GAME_OVER = 8;
    static final int MODE_PUT_BLINDS = 9;
    static final int MODE_MOVING_UP = 10;
    static final int MODE_MOVING_DOWN = 11;
    static final int MODE_WELCOME = 12;
    private static int iSelectedAction;
    static final int ACTION_1 = 0;
    static final int ACTION_2 = 1;
    static final int ACTION_3 = 2;
    private static int iDistributionX;
    private static int iDistributionY;
    private static String[] menuStrings;
    private static String[] actionStrings;
    private static String[] gameModeStrings;
    private static String sWins;
    private static String sPlayer;
    private static String sSplit;
    private static String sRound;
    private static String sStats;
    private static String sGameMenu;
    private static String sPot;
    private static String sBack;
    private static String sTotScore;
    private static String sScore;
    private static String[] sRewards;
    private static String sReallyQuit;
    private static String[] quitMessage;
    private static String sWelcome;
    private static String sCash;
    private static String sLose;
    private static String sCongrat;
    private static String[] buyMore;
    private static String[] playOnNext;
    private static String actTable;
    private static int iSelectedSubMenuItem;
    static final int ITEM_CONTINUE = 0;
    static final int ITEM_RESTART = 1;
    static final int ITEM_MAIN_MENU = 2;
    public static boolean bNextGameMode;
    private Card[] cardArray;
    int iShownCardsCount;
    public static int iPlayerBet;

    private void loadStrings() {
        ScreenGamePok.menuStrings[0] = X.texts.getHashedString("CONTINUE").toUpperCase();
        ScreenGamePok.menuStrings[1] = X.texts.getHashedString("RESTART").toUpperCase();
        ScreenGamePok.menuStrings[2] = X.texts.getHashedString("MAIN_MENU").toUpperCase();
        ScreenGamePok.actionStrings[0] = X.texts.getHashedString("CHECK").toUpperCase();
        ScreenGamePok.actionStrings[1] = X.texts.getHashedString("CALL").toUpperCase();
        ScreenGamePok.actionStrings[2] = X.texts.getHashedString("BET").toUpperCase();
        ScreenGamePok.actionStrings[3] = X.texts.getHashedString("RAISE").toUpperCase();
        ScreenGamePok.actionStrings[4] = X.texts.getHashedString("FOLD").toUpperCase();
        ScreenGamePok.actionStrings[5] = X.texts.getHashedString("ALL_IN").toUpperCase();
        ScreenGamePok.gameModeStrings[0] = X.texts.getHashedString("DISTRIBUTION").toUpperCase();
        ScreenGamePok.gameModeStrings[1] = X.texts.getHashedString("SMALL_BLIND").toUpperCase();
        ScreenGamePok.gameModeStrings[2] = X.texts.getHashedString("BIG_BLIND").toUpperCase();
        ScreenGamePok.gameModeStrings[3] = X.texts.getHashedString("FLOP").toUpperCase();
        ScreenGamePok.gameModeStrings[4] = X.texts.getHashedString("TURN").toUpperCase();
        ScreenGamePok.gameModeStrings[5] = X.texts.getHashedString("RIVER").toUpperCase();
        ScreenGamePok.gameModeStrings[6] = X.texts.getHashedString("END_OF_ROUND").toUpperCase();
        ScreenGamePok.gameModeStrings[7] = X.texts.getHashedString("GAME_OVER").toUpperCase();
        ScreenGamePok.gameModeStrings[8] = X.texts.getHashedString("YOU_WIN").toUpperCase();
        sWins = X.texts.getHashedString("WINS").toUpperCase();
        sPlayer = X.texts.getHashedString("PLAYER").toUpperCase();
        sSplit = X.texts.getHashedString("SPLIT_POT").toUpperCase();
        sRound = X.texts.getHashedString("ROUND").toUpperCase();
        sStats = X.texts.getHashedString("STATS").toUpperCase();
        sGameMenu = X.texts.getHashedString("GAME_MENU").toUpperCase();
        sPot = X.texts.getHashedString("POT").toUpperCase();
        sBack = X.texts.getHashedString("BACK").toUpperCase();
        sTotScore = X.texts.getHashedString("TOTAL_SCORE").toUpperCase();
        sScore = X.texts.getHashedString("SCORE").toUpperCase();
        ScreenGamePok.sRewards[0] = X.texts.getHashedString("PLAYING_HAND").toUpperCase();
        ScreenGamePok.sRewards[1] = X.texts.getHashedString("WINNING_HAND").toUpperCase();
        ScreenGamePok.sRewards[2] = X.texts.getHashedString("WIN_CARDS").toUpperCase();
        ScreenGamePok.sRewards[3] = X.texts.getHashedString("ALL_IN_WIN").toUpperCase();
        ScreenGamePok.sRewards[4] = X.texts.getHashedString("WIN_TIMES").toUpperCase();
        ScreenGamePok.sRewards[5] = X.texts.getHashedString("TOTAL").toUpperCase();
        sReallyQuit = X.texts.getHashedString("REALLY_QUIT_GAME").toUpperCase();
        ScreenGamePok.quitMessage[0] = X.texts.getHashedString("IF_QUIT_1").toUpperCase();
        ScreenGamePok.quitMessage[1] = X.texts.getHashedString("IF_QUIT_2").toUpperCase();
        ScreenGamePok.quitMessage[2] = X.texts.getHashedString("IF_QUIT_3").toUpperCase();
        ScreenGamePok.quitMessage[3] = X.texts.getHashedString("IF_QUIT_4").toUpperCase();
        ScreenGamePok.quitMessage[4] = X.texts.getHashedString("IF_QUIT_5").toUpperCase();
        ScreenGamePok.quitMessage[5] = X.texts.getHashedString("IF_QUIT_6").toUpperCase();
        sWelcome = X.texts.getHashedString("WELCOME").toUpperCase();
        sCash = X.texts.getHashedString("CASH").toUpperCase();
        sLose = X.texts.getHashedString("YOU_LOSE").toUpperCase();
        sCongrat = X.texts.getHashedString("CONGRAT").toUpperCase();
        ScreenGamePok.buyMore[0] = X.texts.getHashedString("BUY_MORE_1").toUpperCase();
        ScreenGamePok.buyMore[1] = X.texts.getHashedString("BUY_MORE_2").toUpperCase();
        ScreenGamePok.buyMore[2] = X.texts.getHashedString("BUY_MORE_3").toUpperCase();
        ScreenGamePok.playOnNext[0] = X.texts.getHashedString("PLAY_ON_NEXT_1").toUpperCase();
        ScreenGamePok.playOnNext[1] = X.texts.getHashedString("PLAY_ON_NEXT_2").toUpperCase();
        ScreenGamePok.playOnNext[2] = X.texts.getHashedString("PLAY_ON_NEXT_3").toUpperCase();
        actTable = X.texts.getHashedString("ACT_TABLE").toUpperCase();
    }

    ScreenGamePok(Canvas canvas, int level) {
        Debug.traceIn("> ScreenGame.ScreenGame()");
        System.out.println("screengame");
        ScreenGamePok.canvas = canvas;
        this.resetDistributionCoordinates();
        this.loadStrings();
        iWaitTime = DEFAULT_WAIT_TIME;
        bPlusPressed = false;
        bMinusPressed = false;
        iKeyPressedDelay = 0;
        GameHandling = new GameHandling(level, false);
        Game = new Game(pok.GameHandling.iBigBlinds[pok.GameHandling.iLevel]);
        this.createPlayers();
        mode = 0;
        old_mode = 1;
        iSelectedAction = 1;
    }

    public ScreenGamePok(Canvas canvas, boolean newGame) {
        Debug.traceIn("> ScreenGame.ScreenGame()");
        System.out.println("screengame");
        ScreenGamePok.canvas = canvas;
        this.resetDistributionCoordinates();
        this.loadStrings();
        iWaitTime = DEFAULT_WAIT_TIME;
        bPlusPressed = false;
        bMinusPressed = false;
        iKeyPressedDelay = 0;
        GameHandling = new GameHandling(newGame);
        Game = newGame ? new Game(pok.GameHandling.iBigBlinds[pok.GameHandling.iLevel]) : new Game();
        this.createPlayers();
        if (newGame) {
            mode = 0;
            old_mode = 1;
        } else {
            this.loadGame();
        }
        playerPanelYOffset = 0;
        tableYOffset = 0;
        iSelectedAction = 1;
    }

    public void loadGame() {
        playerPanelYOffset = 0;
        tableYOffset = 0;
        Resources.loadGamePokResources();
        for (int i = 0; i < 5; ++i) {
            pok.Game.players[i].cards[0] = new Card(0, 0);
            pok.Game.players[i].cards[0].setDistrib(true);
            pok.Game.players[i].cards[1] = new Card(0, 0);
            pok.Game.players[i].cards[1].setDistrib(true);
            pok.Game.tableCards[i] = new Card(0, 0);
            pok.Game.tableCards[i].setDistrib(true);
        }
        statePok.loadGame(this);
        char[] playerSex = new char[4];
        for (int i = 1; i < 5; ++i) {
            playerSex[i - 1] = pok.Game.players[i].nameIndx <= 7 ? 109 : 119;
        }
        Resources.loadPlayerFaces(playerSex);
        if (mode == 2) {
            mode = 9;
        }
        if ((old_mode = mode) == 12) {
            old_mode = 1;
        }
        mode = 12;
        iSelectedAction = 0;
    }

    private void resetDistributionCoordinates() {
        iDistributionX = 0;
        iDistributionY = 0;
    }

    public boolean bojkoAlreadyIs(int ix) {
        boolean value = false;
        for (int i = 0; i < ix; ++i) {
            if (pok.Game.players[i].iPlayingStyle != 4) continue;
            value = true;
        }
        return value;
    }

    public int createStyle(int i) {
        int style = 0;
        int random = Common.getRandomUInt(10);
        switch (pok.GameHandling.iLevel) {
            case 0: {
                if (this.bojkoAlreadyIs(i)) {
                    random = 4;
                }
                if (random < 5) {
                    style = 0;
                    break;
                }
                style = 4;
                break;
            }
            case 1: {
                if (random < 3) {
                    style = 0;
                    break;
                }
                if (random < 5) {
                    style = 4;
                    break;
                }
                style = 1;
                break;
            }
            case 2: {
                if (random < 3) {
                    style = 0;
                    break;
                }
                if (random < 6) {
                    style = 1;
                    break;
                }
                if (random < 8) {
                    style = 4;
                    break;
                }
                style = 3;
                break;
            }
            case 3: {
                if (random < 2) {
                    style = 0;
                    break;
                }
                if (random < 4) {
                    style = 3;
                    break;
                }
                if (random < 6) {
                    style = 4;
                    break;
                }
                if (random < 8) {
                    style = 1;
                    break;
                }
                style = 2;
                break;
            }
            case 4: {
                if (random < 2) {
                    style = 4;
                    break;
                }
                if (random < 4) {
                    style = 3;
                    break;
                }
                if (random < 6) {
                    style = 2;
                    break;
                }
                if (random < 8) {
                    style = 1;
                    break;
                }
                style = 5;
                break;
            }
            case 5: {
                if (random < 5) {
                    style = 5;
                    break;
                }
                if (random < 7) {
                    style = 3;
                    break;
                }
                if (random < 8) {
                    style = 2;
                    break;
                }
                if (random < 9) {
                    style = 1;
                    break;
                }
                style = 4;
                break;
            }
            case 6: {
                if (random < 5) {
                    style = 5;
                    break;
                }
                if (random < 7) {
                    style = 3;
                    break;
                }
                if (random < 8) {
                    style = 2;
                    break;
                }
                style = 4;
                break;
            }
            case 7: {
                style = random < 4 ? 5 : (random < 7 ? 3 : 2);
            }
        }
        return style;
    }

    public void createPlayers() {
        char[] playerSex = new char[4];
        pok.Game.players[0] = new PokerPlayer(pok.GameHandling.iMoneyPerPlayer);
        for (int i = 1; i < 5; ++i) {
            int style = this.createStyle(i);
            int tmpPlayerNameIndex = Common.getRandomUInt(16);
            while (i > 0 && this.checkNames(i, tmpPlayerNameIndex)) {
                tmpPlayerNameIndex = Common.getRandomUInt(16);
            }
            pok.Game.players[i] = new PokerPlayer(tmpPlayerNameIndex, pok.GameHandling.iMoneyPerPlayer, style);
            playerSex[i - 1] = tmpPlayerNameIndex <= 7 ? 109 : 119;
        }
        Resources.loadPlayerFaces(playerSex);
        iDealerIndex = 0;
    }

    private boolean checkNames(int count, int value) {
        for (int i = 1; i < count; ++i) {
            if (value != pok.Game.players[i].nameIndx) continue;
            return true;
        }
        return false;
    }

    public int getActualMode() {
        return mode;
    }

    public String getActualModeName() {
        return "Screen game";
    }

    public void invokeGameMenu() {
        statePok.saveGame(this);
        statePok.saveTable(this);
        iSelectedSubMenuItem = 0;
        old_mode = mode;
        if (old_mode == 2 || old_mode == 6) {
            old_mode = actualPlayer != 0 ? 3 : 10;
        }
        if (mode == 2) {
            this.skipCardDistribution();
        }
        mode = 6;
        X.soundManager.Stop();
        canvas.repaint();
        canvas.serviceRepaints();
    }

    public void update(long tick) {
        if (pok.Game.iRaise == 0) {
            if (iPlayerBet < pok.Game.iBlind) {
                iPlayerBet = pok.Game.iBlind;
            }
        } else if (iPlayerBet < pok.Game.iRaise) {
            iPlayerBet = pok.Game.iRaise;
        }
        switch (mode) {
            case 0: {
                Resources.loadGamePokResources();
                mode = 12;
                iSelectedAction = 1;
                canvas.repaint();
                canvas.serviceRepaints();
                if (Settings.bMusic) {
                    X.soundManager.Stop();
                    X.soundManager.SetSoundOn(true);
                    X.soundManager.Play(X.MUSIC_MENU_ID, -1);
                    break;
                }
                X.soundManager.Stop();
                X.soundManager.SetSoundOn(false);
                break;
            }
            case 12: {
                canvas.repaint();
                canvas.serviceRepaints();
                break;
            }
            case 1: {
                if (!this.isEndOfGame()) {
                    iWaitTime = DEFAULT_WAIT_TIME;
                    Game.nextRound();
                    this.generateCards();
                    iPutBlinds = 0;
                    ScreenGamePok.setBlinds();
                    this.iShownCardsCount = 0;
                    canvas.repaint();
                    canvas.serviceRepaints();
                    actualPlayer = iDealerIndex < 4 ? iDealerIndex + 1 : 0;
                    while (true) {
                        if (pok.Game.players[ScreenGamePok.actualPlayer].playing) break;
                        if (++actualPlayer != 5) continue;
                        actualPlayer = 0;
                    }
                    iDistributionRound = 0;
                    step = 0;
                    mode = 2;
                    break;
                }
                if (playerPanelYOffset != 0) {
                    mode = 11;
                }
                mode = 8;
                iSelectedAction = 0;
                if (pok.Game.players[0].iChips == 0) {
                    statePok.saveGame(this);
                    statePok.saveTable(this);
                    break;
                }
                statePok.saveGame(this);
                statePok.saveTable(this);
                iSelectedAction = 0;
                break;
            }
            case 2: {
                iPutBlinds = 0;
                if (iDistributionRound == 3) {
                    iPutBlinds = 0;
                    mode = 9;
                    break;
                }
                canvas.repaint();
                canvas.serviceRepaints();
                if (!bSkipOn) break;
                this.skipCardDistribution();
                break;
            }
            case 9: {
                tableYOffset = 0;
                playerPanelYOffset = 0;
                if (iPutBlinds < 2) {
                    this.putBlinds();
                } else {
                    step = 0;
                    mode = 3;
                    if (actualPlayer == 0) {
                        mode = 10;
                        iSelectedAction = 0;
                    }
                }
                canvas.repaint();
                canvas.serviceRepaints();
                break;
            }
            case 3: {
                if (pok.Game.game_mode < 4) {
                    ScreenGamePok.playingRound();
                }
                if (pok.Game.game_mode == 4) {
                    Game.checkPlayersHands();
                    Game.evaluation();
                    mode = 5;
                    canvas.repaint();
                    canvas.serviceRepaints();
                }
                canvas.repaint();
                canvas.serviceRepaints();
                break;
            }
            case 4: {
                if (actualPlayer != 0) {
                    mode = 3;
                    return;
                }
                if (playerPanelYOffset == 0 || tableYOffset == 0) {
                    mode = 10;
                    return;
                }
                if (bPlusPressed) {
                    ++iKeyPressedDelay;
                    if (pok.Game.players[0].iPlayerAction == 1) {
                        if (iPlayerBet + 100 < pok.Game.players[0].iChips && iKeyPressedDelay == 5) {
                            iPlayerBet += 100;
                            iKeyPressedDelay = 0;
                        }
                    }
                    if (pok.Game.players[0].iPlayerAction == 2) {
                        if (iPlayerBet + pok.Game.iBetPerPlayer - pok.Game.players[0].iActualBet + 100 < pok.Game.players[0].iChips && iKeyPressedDelay == 5) {
                            iPlayerBet += 100;
                            iKeyPressedDelay = 0;
                        }
                    }
                }
                if (bMinusPressed) {
                    ++iKeyPressedDelay;
                    if (pok.Game.players[0].iPlayerAction == 1) {
                        if (iPlayerBet - 100 > pok.Game.iBlind && iKeyPressedDelay == 5) {
                            iPlayerBet -= 100;
                            iKeyPressedDelay = 0;
                        }
                    }
                    if (pok.Game.players[0].iPlayerAction == 2) {
                        if (iPlayerBet - 100 > pok.Game.iRaise && iKeyPressedDelay == 5) {
                            iPlayerBet -= 100;
                            iKeyPressedDelay = 0;
                        }
                    }
                }
                canvas.repaint();
                canvas.serviceRepaints();
            }
            case 5: 
            case 7: 
            case 8: {
                canvas.repaint();
                canvas.serviceRepaints();
                break;
            }
            case 6: {
                canvas.repaint();
                canvas.serviceRepaints();
                break;
            }
            case 10: {
                if (pok.Game.players[0].fold) {
                    mode = 3;
                    return;
                }
                for (int i = 0; i < 5; ++i) {
                    pok.Game.players[i].active = false;
                }
                int buttons = 3;
                playerPanelYOffset = playerPanelYOffset < buttons * Resources.iBorderOffH ? (playerPanelYOffset += Resources.imgPlayerPanel.getHeight() / 4) : buttons * Resources.iBorderOffH;
                tableYOffset = tableYOffset < (Defines.HEIGHT - Resources.iTableH) / 2 - Resources.iTableH / 3 - Resources.iUpperPanelH ? (tableYOffset += Resources.imgPlayerPanel.getHeight() / 4) : (Defines.HEIGHT - Resources.iTableH) / 2 - Resources.iTableH / 3 - Resources.iUpperPanelH;
                if (playerPanelYOffset == buttons * Resources.iBorderOffH && tableYOffset == (Defines.HEIGHT - Resources.iTableH) / 2 - Resources.iTableH / 3 - Resources.iUpperPanelH) {
                    mode = 4;
                    pok.Game.players[0].active = true;
                    iSelectedAction = 0;
                }
                canvas.repaint();
                canvas.serviceRepaints();
                break;
            }
            case 11: {
                for (int i = 0; i < 5; ++i) {
                    pok.Game.players[i].active = false;
                }
                playerPanelYOffset = playerPanelYOffset >= 0 ? (playerPanelYOffset -= Resources.imgPlayerPanel.getHeight() / 4) : 0;
                tableYOffset = tableYOffset > 0 ? (tableYOffset -= Resources.imgPlayerPanel.getHeight() / 4) : 0;
                if (playerPanelYOffset == 0 && tableYOffset == 0) {
                    this.continuePlaying();
                }
                canvas.repaint();
                canvas.serviceRepaints();
            }
        }
    }

    public boolean isEndOfGame() {
        int iPlayingCPUPlayers = 4;
        for (int i = 4; i > 0; --i) {
            if (pok.Game.players[i].iChips != 0) continue;
            --iPlayingCPUPlayers;
        }
        return pok.Game.players[0].iChips == 0 || iPlayingCPUPlayers == 0;
    }

    public static void setBlinds() {
        actualPlayer = iDealerIndex;
        ScreenGamePok.nextPlayer();
        iSBIndex = actualPlayer;
        ScreenGamePok.nextPlayer();
        iBBIndex = actualPlayer;
    }

    public void putBlinds() {
        pok.Game.players[ScreenGamePok.actualPlayer].active = false;
        if (iPutBlinds == 0) {
            actualPlayer = iDealerIndex;
            ScreenGamePok.nextPlayer();
            pok.Game.players[ScreenGamePok.actualPlayer].active = true;
            iSBIndex = actualPlayer;
            if (pok.Game.players[ScreenGamePok.actualPlayer].iChips <= pok.Game.iBlind / 2) {
                pok.Game.addToPot(pok.Game.players[ScreenGamePok.actualPlayer].iChips);
                pok.Game.players[actualPlayer].addBet(pok.Game.players[ScreenGamePok.actualPlayer].iChips);
                pok.Game.players[ScreenGamePok.actualPlayer].iChips = 0;
                pok.Game.players[ScreenGamePok.actualPlayer].bAllIn = true;
            } else {
                pok.Game.players[actualPlayer].removeChips(pok.Game.iBlind / 2);
                pok.Game.addToPot(pok.Game.iBlind / 2);
                pok.Game.players[actualPlayer].addBet(pok.Game.iBlind / 2);
            }
            canvas.repaint();
            canvas.serviceRepaints();
            ScreenGamePok.nextPlayer();
            if (!bSkipOn) {
                ScreenGamePok.waiter();
            }
        }
        if (iPutBlinds == 1) {
            pok.Game.players[ScreenGamePok.actualPlayer].active = true;
            iBBIndex = actualPlayer;
            if (pok.Game.players[ScreenGamePok.actualPlayer].iChips <= pok.Game.iBlind) {
                pok.Game.addToPot(pok.Game.players[ScreenGamePok.actualPlayer].iChips);
                pok.Game.players[actualPlayer].addBet(pok.Game.players[ScreenGamePok.actualPlayer].iChips);
                pok.Game.players[ScreenGamePok.actualPlayer].iChips = 0;
                pok.Game.players[ScreenGamePok.actualPlayer].bAllIn = true;
            } else {
                pok.Game.players[actualPlayer].removeChips(pok.Game.iBlind);
                pok.Game.addToPot(pok.Game.iBlind);
                pok.Game.players[actualPlayer].addBet(pok.Game.iBlind);
            }
            canvas.repaint();
            canvas.serviceRepaints();
            ScreenGamePok.nextPlayer();
            if (!bSkipOn) {
                ScreenGamePok.waiter();
            }
        }
        ++iPutBlinds;
    }

    public static void waiter() {
        int start = (int)System.currentTimeMillis() / 1000;
        int end = (int)System.currentTimeMillis() / 1000;
        while (end - start < iWaitTime) {
            end = (int)System.currentTimeMillis() / 1000;
        }
    }

    public static void playingRound() {
        if (Game.compareBets() && step >= 5) {
            ScreenGamePok.nextGameMode();
            return;
        }
        System.out.println("aktivny hrac: " + actualPlayer);
        int i = 1;
        while (true) {
            if (i >= pok.Game.players.length) break;
            pok.Game.players[i].active = actualPlayer == i;
            ++i;
        }
        pok.Game.players[0].active = false;
        if (actualPlayer != 0 && mode != 3) {
            mode = 3;
        }
        if (step == 0) {
            Game.checkTable();
            Game.checkPlayersHands();
        }
        if (actualPlayer == 0) {
            if (!pok.Game.players[0].fold) {
                System.out.println("****************************************\nplayer 0: ");
                mode = 10;
                iSelectedAction = 0;
                pok.Game.players[0].iPlayerAction = 0;
                System.out.println("raise: " + pok.Game.iRaise + " -------------------------------------------------------");
                iPlayerBet = pok.Game.iRaise == 0 ? pok.Game.iBlind : pok.Game.iRaise;
                return;
            }
        }
        canvas.repaint();
        canvas.serviceRepaints();
        if (!bSkipOn) {
            ScreenGamePok.waiter();
        }
        if (actualPlayer == 0) {
            ScreenGamePok.playingRound();
            return;
        }
        pok.Game.calculatePlayerMove(actualPlayer);
        canvas.repaint();
        canvas.serviceRepaints();
        ScreenGamePok.waiter();
        ScreenGamePok.nextPlayer();
        i = 1;
        while (true) {
            if (i >= pok.Game.players.length) break;
            pok.Game.players[i].active = actualPlayer == i;
            ++i;
        }
        if (Game.compareBets() && step >= 5) {
            ScreenGamePok.nextGameMode();
            return;
        }
    }

    public static void nextGameMode() {
        if (pok.Game.game_mode < 4) {
            ++pok.Game.game_mode;
            actualPlayer = iDealerIndex;
            bNextGameMode = true;
            canvas.repaint();
            canvas.serviceRepaints();
            ScreenGamePok.waiter();
            ScreenGamePok.nextPlayer();
        } else if (mode == 3 || mode == 4) {
            mode = 5;
            int i = 0;
            while (true) {
                if (i < pok.Game.players.length) {
                    pok.Game.players[i].active = false;
                    ++i;
                    continue;
                }
                break;
            }
        } else if (mode == 5) {
            mode = 7;
        } else {
            mode = 1;
            ScreenGamePok.nextDealer();
            ScreenGamePok.setBlinds();
        }
        step = 0;
        Game.nextGameMode();
    }

    public static void nextDealer() {
        iDealerIndex = iDealerIndex < 4 ? ++iDealerIndex : 0;
        if (!pok.Game.players[ScreenGamePok.iDealerIndex].playing) {
            ScreenGamePok.nextDealer();
        }
    }

    private void TESTgenerateCards() {
        int i;
        this.cardArray = new Card[15];
        this.cardArray[0] = new Card(0, 1);
        this.cardArray[1] = new Card(0, 2);
        this.cardArray[2] = new Card(3, 1);
        this.cardArray[3] = new Card(2, 2);
        this.cardArray[4] = new Card(3, 3);
        this.cardArray[5] = new Card(2, 2);
        this.cardArray[6] = new Card(3, 0);
        this.cardArray[7] = new Card(2, 1);
        this.cardArray[8] = new Card(3, 2);
        this.cardArray[9] = new Card(2, 1);
        this.cardArray[10] = new Card(0, 3);
        this.cardArray[11] = new Card(0, 4);
        this.cardArray[12] = new Card(4, 1);
        this.cardArray[13] = new Card(10, 2);
        this.cardArray[14] = new Card(7, 2);
        int cardIndx = 0;
        for (i = 0; i < 5; ++i) {
            if (pok.Game.players[i].isPlaying()) {
                pok.Game.players[i].setCards(this.cardArray[cardIndx], this.cardArray[cardIndx + 1]);
            }
            cardIndx += 2;
        }
        System.out.println("stol: ");
        for (i = 0; i < 5; ++i) {
            pok.Game.tableCards[i] = this.cardArray[cardIndx + i];
            System.out.print(this.cardArray[cardIndx + i].getCardString() + ",  ");
        }
        this.cardArray = null;
        System.out.println("");
        System.gc();
    }

    private void generateCards() {
        int i;
        int cardCount = 7;
        for (i = 0; i < 5; ++i) {
            if (!pok.Game.players[i].isPlaying()) continue;
            cardCount += 2;
        }
        this.cardArray = new Card[cardCount];
        for (i = 0; i < cardCount; ++i) {
            Card tmpCard = new Card(Common.getRandomUInt(13), Common.getRandomUInt(4));
            while (i > 0 && this.checkCards(i, tmpCard)) {
                tmpCard = new Card(Common.getRandomUInt(13), Common.getRandomUInt(4));
            }
            this.cardArray[i] = tmpCard;
        }
        int cardIndx = 0;
        for (i = 0; i < 5; ++i) {
            if (!pok.Game.players[i].isPlaying()) continue;
            pok.Game.players[i].setCards(this.cardArray[cardIndx], this.cardArray[cardIndx + 1]);
            cardIndx += 2;
        }
        System.out.println("stol: ");
        for (i = 0; i < 5; ++i) {
            pok.Game.tableCards[i] = this.cardArray[cardIndx + i];
            System.out.print(this.cardArray[cardIndx + i].getCardString() + ",  ");
        }
        this.cardArray = null;
        System.gc();
    }

    private boolean checkCards(int count, Card card) {
        for (int i = 0; i < count; ++i) {
            if (!card.getCardString().equals(this.cardArray[i].getCardString())) continue;
            return true;
        }
        return false;
    }

    public void paint(Graphics g) {
        switch (mode) {
            case 0: {
                this.paintGameLoading(g);
                break;
            }
            case 12: {
                Resources.paintBackground(g);
                g.drawImage(Resources.imgTable, (Defines.WIDTH - Resources.iTableW) / 2, (Defines.HEIGHT - Resources.iTableH) / 2 - tableYOffset, 0);
                this.paintPlayers(g);
                this.paintRaster(g);
                this.paintWelcomeScreen(g);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                this.paintGame(g);
                pok.Game.game_mode = 0;
                if (iDistributionRound >= 3) break;
                this.paintCardDistribution(g);
                break;
            }
            case 9: {
                tableYOffset = 0;
                playerPanelYOffset = 0;
            }
            case 3: 
            case 4: 
            case 10: 
            case 11: {
                this.paintGame(g);
                break;
            }
            case 5: {
                this.paintGame(g);
                this.paintWin(g);
                break;
            }
            case 6: {
                this.paintPause(g);
                break;
            }
            case 7: {
                Resources.paintControls(g, 2);
                this.paintStats(g);
                this.paintUpperSheet(g);
                break;
            }
            case 8: {
                this.paintGame(g);
                this.paintGameOver(g);
            }
        }
        g.setColor(0);
        g.fillRect(0, Defines.HEIGHT, Defines.WIDTH, Defines.HEIGHT);
    }

    public void paintWelcomeScreen(Graphics g) {
        int xParts = Defines.WIDTH / Resources.iInfoBarW - 2;
        int yParts = 15;
        Resources.paintMenuBG(xParts, yParts, sWelcome + " " + (pok.GameHandling.iTableNr + 1), g);
        int iPosX = (Defines.WIDTH - Resources.iInfoBarW * xParts) / 2;
        int iPosY = (Defines.HEIGHT - Resources.iInfoBarH * yParts) / 2;
        int iWidth = Resources.iInfoBarW * 12;
        int iHeight = Resources.iInfoBarH * 12;
        String sValue = "";
        boolean switchIndex = false;
        String infoString = "";
        for (int i = 0; i < 2; ++i) {
            if (i == 0) {
                infoString = sCash + ":";
                sValue = pok.GameHandling.iTableInputs[pok.GameHandling.iLevel] + "$";
            } else {
                infoString = "BLIND:";
                sValue = pok.GameHandling.iBigBlinds[pok.GameHandling.iLevel] / 2 + "$, " + pok.GameHandling.iBigBlinds[pok.GameHandling.iLevel] + "$";
            }
            Fonts.drawStr(infoString, iPosX + 15, iPosY + (i + 1) * iHeight / 5 + 15, g);
            Fonts.drawStr(sValue, iPosX + 15 + iWidth / 5 * 2, iPosY + (i + 1) * iHeight / 5 + 15, g);
        }
        int iPosXButt = (Defines.WIDTH - Resources.iInfoBarW * xParts) / 2;
        int iPosYButt = (Defines.HEIGHT - Resources.iInfoBarH * yParts) / 2;
        if (iSelectedAction == 0) {
            iSelectedAction = 1;
        }
        if (iSelectedAction == 1) {
            Resources.sprIconsON.setFrame(0);
            Resources.sprIconsON.setPosition(iPosXButt + Resources.iIconsW / 4, Defines.HEIGHT - iPosYButt - Resources.iIconsH - Resources.iIconsW / 4);
            Resources.sprIconsON.paint(g);
        } else {
            Resources.sprIconsOFF.setFrame(0);
            Resources.sprIconsOFF.setPosition(iPosXButt + Resources.iIconsW / 4, Defines.HEIGHT - iPosYButt - Resources.iIconsH - Resources.iIconsW / 4);
            Resources.sprIconsOFF.paint(g);
        }
        if (iSelectedAction == 2) {
            Resources.sprIconsON.setFrame(3);
            Resources.sprIconsON.setPosition(Defines.WIDTH - iPosXButt - Resources.iIconsW - Resources.iIconsW / 4, Defines.HEIGHT - iPosYButt - Resources.iIconsH - Resources.iIconsW / 4);
            Resources.sprIconsON.paint(g);
        } else {
            Resources.sprIconsOFF.setFrame(3);
            Resources.sprIconsOFF.setPosition(Defines.WIDTH - iPosXButt - Resources.iIconsW - Resources.iIconsW / 4, Defines.HEIGHT - iPosYButt - Resources.iIconsH - Resources.iIconsW / 4);
            Resources.sprIconsOFF.paint(g);
        }
    }

    public void paintGameOver(Graphics g) {
        Resources.paintBackground(g);
        int xParts = Defines.WIDTH / Resources.iInfoBarW - 2;
        int yParts = (Defines.HEIGHT - Resources.iBorderOffH - Resources.iIconsH) / Resources.iInfoBarH - 2;
        if (Defines.HEIGHT > 300) {
            yParts = 15;
        }
        if (pok.Game.players[0].iChips == 0) {
            Resources.paintMenuBG(xParts, yParts, sLose, g);
        } else {
            Resources.paintMenuBG(xParts, yParts, sCongrat, g);
        }
        if (Defines.WIDTH > 130) {
            if (pok.Game.players[0].iChips == 0) {
                g.drawImage(Resources.imgGameOverLoos, (Defines.WIDTH - Resources.iGameOverLoosW) / 2, (Defines.HEIGHT - Resources.iGameOverLoosH) / 2 + Resources.iBorderOffH - Resources.iFont1H, 0);
            } else {
                g.drawImage(Resources.imgGameOverWin, (Defines.WIDTH - Resources.iGameOverWinW) / 2, (Defines.HEIGHT - Resources.iGameOverWinH) / 2 + Resources.iBorderOffH - Resources.iFont1H, 0);
            }
        }
        int iPosX = (Defines.WIDTH - Resources.iInfoBarW * xParts) / 2;
        int iPosY = (Defines.HEIGHT - Resources.iInfoBarH * yParts) / 2;
        int iWidth = Resources.iInfoBarW * 12;
        int iHeight = Resources.iInfoBarH * 12;
        String sValue = "";
        boolean switchIndex = false;
        String infoString = "";
        for (int i = 0; i < 3; ++i) {
            if (i == 0) {
                infoString = pok.Game.players[0].iChips == 0 ? buyMore[0] : playOnNext[0];
            }
            if (i == 1) {
                infoString = pok.Game.players[0].iChips == 0 ? buyMore[1] : playOnNext[1];
            }
            if (i == 2) {
                infoString = pok.Game.players[0].iChips == 0 ? buyMore[2] : playOnNext[2];
            }
            Fonts.drawStr(infoString, (Defines.WIDTH - Fonts.strWidth(infoString)) / 2, iPosY + (i + 1) * Resources.iFont1H + Resources.LINE_OFFSET, g);
        }
        int iPosXButt = (Defines.WIDTH - Resources.iInfoBarW * xParts) / 2;
        int iPosYButt = (Defines.HEIGHT - Resources.iInfoBarH * yParts) / 2;
        if (iSelectedAction == 0) {
            if (pok.Game.players[0].iChips == 0) {
                Resources.sprIconsON.setFrame(7);
            } else {
                Resources.sprIconsON.setFrame(0);
            }
            Resources.sprIconsON.setPosition(iPosXButt + Resources.iIconsW / 4, Defines.HEIGHT - iPosYButt - Resources.iIconsH - Resources.iIconsW / 4);
            Resources.sprIconsON.paint(g);
        } else {
            if (pok.Game.players[0].iChips == 0) {
                Resources.sprIconsOFF.setFrame(7);
            } else {
                Resources.sprIconsOFF.setFrame(0);
            }
            Resources.sprIconsOFF.setPosition(iPosXButt + Resources.iIconsW / 4, Defines.HEIGHT - iPosYButt - Resources.iIconsH - Resources.iIconsW / 4);
            Resources.sprIconsOFF.paint(g);
        }
        if (iSelectedAction == 2) {
            Resources.sprIconsON.setFrame(3);
            Resources.sprIconsON.setPosition(Defines.WIDTH - iPosXButt - Resources.iIconsW - Resources.iIconsW / 4, Defines.HEIGHT - iPosYButt - Resources.iIconsH - Resources.iIconsW / 4);
            Resources.sprIconsON.paint(g);
        } else {
            Resources.sprIconsOFF.setFrame(3);
            Resources.sprIconsOFF.setPosition(Defines.WIDTH - iPosXButt - Resources.iIconsW - Resources.iIconsW / 4, Defines.HEIGHT - iPosYButt - Resources.iIconsH - Resources.iIconsW / 4);
            Resources.sprIconsOFF.paint(g);
        }
    }

    public void paintWin(Graphics g) {
        String sWinMessage = "";
        int[] iWinnerID = new int[5];
        int iWinnersCount = 0;
        if (pok.Game.players[0].bWin) {
            Resources.sprWin.setFrame(iWinFrame >> 1);
            Resources.sprWin.setPosition((Defines.WIDTH - Resources.iWinW) / 2, (Defines.HEIGHT - Resources.iTableH + Resources.iUpperPanelH) / 2 / 2);
            Resources.sprWin.paint(g);
            if (++iWinFrame > 19) {
                iWinFrame = 0;
            }
        }
        for (int i = 0; i < 5; ++i) {
            if (!pok.Game.players[i].bWin) continue;
            iWinnerID[iWinnersCount] = i;
            ++iWinnersCount;
        }
        sWinMessage = iWinnersCount == 1 ? (iWinnerID[0] > 0 ? this.playerNames[pok.Game.players[iWinnerID[0]].nameIndx] + " " + sWins + " " + (pok.Game.players[iWinnerID[0]].iRoundReward + pok.Game.players[iWinnerID[0]].iActualBet) + " $" : sPlayer + " " + sWins + " " + (pok.Game.players[iWinnerID[0]].iRoundReward + pok.Game.players[iWinnerID[0]].iActualBet) + " $") : sSplit;
        Fonts.drawStr(sWinMessage, (Defines.WIDTH - Fonts.strWidth(sWinMessage)) / 2, (Defines.HEIGHT - Resources.iTableH + Resources.iUpperPanelH) / 2 + Resources.iFont1H / 2, g);
    }

    public void paintStats(Graphics g) {
        int i;
        Resources.paintBackground(g);
        this.paintTable(g);
        this.paintPlayers(g);
        if (!bSkipOn) {
            Resources.paintControls(g, 2);
        } else {
            Resources.paintControls(g, 3);
        }
        this.paintPlayerPanel(g);
        this.paintBlinds(g);
        Resources.paintMenuBG(15, 15, sRound + " " + pok.Game.iRoundNr + ": " + sStats, g);
        int iPosX = (Defines.WIDTH - Resources.iInfoBarW * 15) / 2;
        int iPosY = (Defines.HEIGHT - Resources.iInfoBarH * 15) / 2;
        int iWidth = Resources.iInfoBarW * 12;
        int iHeight = Resources.iInfoBarH * 12;
        int iChipsInRound = 0;
        int switchIndex = 0;
        int[] SortedPlayersByChips = new int[]{0, 1, 2, 3, 4};
        for (i = 1; i < 5; ++i) {
            switchIndex = SortedPlayersByChips[i];
            for (int j = i; j > 0; --j) {
                if (pok.Game.players[SortedPlayersByChips[j - 1]].iChips >= pok.Game.players[switchIndex].iChips) break;
                SortedPlayersByChips[j] = SortedPlayersByChips[j - 1];
            }
            SortedPlayersByChips[j] = switchIndex;
        }
        for (i = 0; i < 5; ++i) {
            String playName = pok.Game.players[SortedPlayersByChips[i]].nameIndx == -1 ? sPlayer : this.playerNames[pok.Game.players[SortedPlayersByChips[i]].nameIndx];
            Fonts.drawStr(playName, iPosX + 15, iPosY + (i + 1) * iHeight / 5 + 15, g);
            iChipsInRound = pok.Game.players[SortedPlayersByChips[i]].iRoundReward;
            String sChipsInRound = iChipsInRound < 0 ? iChipsInRound + "$" : "+" + iChipsInRound + "$";
            Fonts.drawStr(sChipsInRound, iPosX + 15 + iWidth / 5 * 2, iPosY + (i + 1) * iHeight / 5 + 15, g);
            Fonts.drawStr(pok.Game.players[SortedPlayersByChips[i]].iChips + "$", iPosX + 15 + iWidth / 5 * 4, iPosY + (i + 1) * iHeight / 5 + 15, g);
        }
    }

    public void paintRaster(Graphics g) {
        int x = 0;
        for (int y = 0; y <= Defines.HEIGHT; y += Resources.iRasterH) {
            while (x <= Defines.WIDTH) {
                g.drawImage(Resources.imgRaster, x, y, 0);
                x += Resources.iRasterW;
            }
            x = 0;
        }
    }

    public void paintPause(Graphics g) {
        Resources.paintBackground(g);
        this.paintTable(g);
        this.paintPlayers(g);
        this.paintPlayerPanel(g);
        this.paintBlinds(g);
        this.paintOptions(g);
        this.paintRaster(g);
        this.paintUpperSheet(g);
        Resources.paintMenuBG(12, 10, sGameMenu, g);
        int iPosX = 0;
        int iPosY = 0;
        int x = (Defines.WIDTH - Resources.iBorderOnW * 8) / 2;
        int submenuPos = Resources.SUBMENU_POS_Y;
        for (int i = 0; i < 3; ++i) {
            if (i == iSelectedSubMenuItem) {
                Resources.paintBorder(2, true, 8, x, submenuPos + i * (Resources.iBorderOnH + Resources.MENU_BUTTONS_OFFSET), g);
            } else {
                Resources.paintBorder(2, false, 8, x, submenuPos + i * (Resources.iBorderOnH + Resources.MENU_BUTTONS_OFFSET), g);
            }
            iPosX = (Defines.WIDTH - Fonts.strWidth(menuStrings[i])) / 2;
            iPosY = submenuPos + i * (Resources.iBorderOnH + Resources.MENU_BUTTONS_OFFSET) + (Resources.iBorderOnH - Resources.iFont1H) / 2;
            Fonts.drawStr(menuStrings[i], iPosX, iPosY, g);
        }
    }

    public void paintGameLoading(Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, Defines.WIDTH, Defines.HEIGHT);
        Resources.paintLoading(g);
    }

    public void paintGame(Graphics g) {
        Resources.paintBackground(g);
        this.paintTable(g);
        this.paintPlayers(g);
        this.paintUpperSheet(g);
        if (!bSkipOn) {
            Resources.paintControls(g, 2);
        } else {
            Resources.paintControls(g, 3);
        }
        this.paintPlayerPanel(g);
        this.paintBlinds(g);
        if (mode == 4 || mode == 11 || mode == 10) {
            this.paintOptions(g);
        }
        g.setColor(0);
        g.fillRect(0, Defines.HEIGHT, Defines.WIDTH, Defines.HEIGHT);
    }

    public void paintOptions(Graphics g) {
        int iPosY;
        int x;
        int buttons;
        block21: {
            block20: {
                g.setClip(0, 0, Defines.WIDTH, Defines.HEIGHT);
                buttons = 3;
                x = (Defines.WIDTH - Resources.iBorderOffW * 6) / 2;
                boolean iPosX = false;
                iPosY = Defines.HEIGHT - playerPanelYOffset;
                if (pok.Game.players[0].iPlayerAction == 2) break block20;
                if (pok.Game.players[0].iPlayerAction != 1) break block21;
            }
            if (iSelectedAction == 0) {
                Resources.sprPlusMinus.setFrame(1);
                Resources.sprPlusMinus.setPosition(x - Resources.iPlusMinusW + Resources.iPlusMinusW / 7, iPosY + Resources.iBorderOffH / 2);
                Resources.sprPlusMinus.paint(g);
                Resources.sprPlusMinus.setFrame(0);
                Resources.sprPlusMinus.setPosition(x + Resources.iBorderOffW * 6 - Resources.iPlusMinusW / 7, iPosY + Resources.iBorderOffH / 2);
                Resources.sprPlusMinus.paint(g);
            }
        }
        for (int i = 0; i < buttons; ++i) {
            iPosY = Defines.HEIGHT - playerPanelYOffset;
            if (i == iSelectedAction) {
                Resources.paintBorder(2, true, 6, x, iPosY + i * Resources.iBorderOffH, g);
            } else {
                Resources.paintBorder(2, false, 6, x, iPosY + i * Resources.iBorderOffH, g);
            }
            iPosY = Defines.HEIGHT - playerPanelYOffset + i * Resources.iBorderOffH + (Resources.iBorderOffH - Resources.iFont1H) / 2;
            if (pok.Game.players[0].iPlayerAction == 0) {
                if (Game.compareBets()) {
                    if (i == 0) {
                        Fonts.drawStr(actionStrings[0], (Defines.WIDTH - Fonts.strWidth(actionStrings[0])) / 2, iPosY, g);
                    }
                    if (i == 1) {
                        Fonts.drawStr(actionStrings[2], (Defines.WIDTH - Fonts.strWidth(actionStrings[2])) / 2, iPosY, g);
                    }
                    if (i == 2) {
                        Fonts.drawStr(actionStrings[4], (Defines.WIDTH - Fonts.strWidth(actionStrings[4])) / 2, iPosY, g);
                    }
                } else {
                    if (i == 0) {
                        Fonts.drawStr(actionStrings[1], (Defines.WIDTH - Fonts.strWidth(actionStrings[1])) / 2, iPosY, g);
                    }
                    if (i == 1) {
                        Fonts.drawStr(actionStrings[3], (Defines.WIDTH - Fonts.strWidth(actionStrings[3])) / 2, iPosY, g);
                    }
                    if (i == 2) {
                        Fonts.drawStr(actionStrings[4], (Defines.WIDTH - Fonts.strWidth(actionStrings[4])) / 2, iPosY, g);
                    }
                }
            }
            if (pok.Game.players[0].iPlayerAction != 1) {
                if (pok.Game.players[0].iPlayerAction != 2) continue;
            }
            if (i == 0) {
                Fonts.drawStr(iPlayerBet + " $", (Defines.WIDTH - Fonts.strWidth(iPlayerBet + " $")) / 2, iPosY, g);
            }
            if (i == 1) {
                Fonts.drawStr(actionStrings[5], (Defines.WIDTH - Fonts.strWidth(actionStrings[5])) / 2, iPosY, g);
            }
            if (i != 2) continue;
            Fonts.drawStr(sBack, (Defines.WIDTH - Fonts.strWidth(sBack)) / 2, iPosY, g);
        }
        g.setClip(0, 0, Defines.WIDTH * 2, Defines.HEIGHT * 2);
        g.setColor(0);
        g.fillRect(0, Defines.HEIGHT, Defines.WIDTH, Defines.HEIGHT);
    }

    public void paintTable(Graphics g) {
        g.drawImage(Resources.imgTable, (Defines.WIDTH - Resources.iTableW) / 2, (Defines.HEIGHT - Resources.iTableH) / 2 - tableYOffset, 0);
        int iTmpX = 0;
        Sprite sprTmpCards = null;
        if (pok.Game.game_mode == 1) {
            this.iShownCardsCount = 3;
        }
        if (pok.Game.game_mode == 2) {
            this.iShownCardsCount = 4;
        }
        if (pok.Game.game_mode == 3) {
            this.iShownCardsCount = 5;
        }
        if (pok.Game.game_mode == 4) {
            if (!pok.Game.bWinByFold) {
                this.iShownCardsCount = 5;
            }
        }
        for (int i = 0; i <= 4; ++i) {
            switch (i) {
                case 0: {
                    iTmpX = Resources.TABLE_X1;
                    break;
                }
                case 1: {
                    iTmpX = Resources.TABLE_X2;
                    break;
                }
                case 2: {
                    iTmpX = Resources.TABLE_X3;
                    break;
                }
                case 3: {
                    iTmpX = Resources.TABLE_X4;
                    break;
                }
                case 4: {
                    iTmpX = Resources.TABLE_X5;
                }
            }
            if (this.iShownCardsCount <= i) {
                if (!pok.Game.tableCards[i].isDistributed()) continue;
                Resources.sprCardRub.setFrame(1);
                Resources.sprCardRub.setPosition(iTmpX, (Defines.HEIGHT - Resources.iCardH) / 2 - tableYOffset);
                Resources.sprCardRub.paint(g);
                continue;
            }
            switch (pok.Game.tableCards[i].getColNr()) {
                case 0: {
                    sprTmpCards = Resources.sprHearts;
                    break;
                }
                case 1: {
                    sprTmpCards = Resources.sprDiamonds;
                    break;
                }
                case 2: {
                    sprTmpCards = Resources.sprClubs;
                    break;
                }
                case 3: {
                    sprTmpCards = Resources.sprSpades;
                }
            }
            sprTmpCards.setFrame(pok.Game.tableCards[i].getValue() - 1);
            sprTmpCards.setPosition(iTmpX, (Defines.HEIGHT - Resources.iCardH) / 2 - tableYOffset);
            sprTmpCards.paint(g);
            if (mode != 5) continue;
            if (pok.Game.tableCards[i].bWinCard) continue;
            if (pok.Game.bWinByFold) continue;
            g.drawImage(Resources.imgCardShade, iTmpX, (Defines.HEIGHT - Resources.iCardH) / 2 - tableYOffset, 0);
        }
    }

    public void paintPlayerPanel(Graphics g) {
        int buttons = 0;
        if (mode == 4) {
            buttons = 3;
        }
        if (bNextGameMode && mode == 11 || mode == 5 || mode == 9) {
            int i = 0;
            while (true) {
                if (i >= pok.Game.players.length) break;
                pok.Game.players[i].active = false;
                ++i;
            }
            playerPanelYOffset = 0;
            tableYOffset = 0;
        }
        if (actualPlayer == 0 && mode == 9) {
            pok.Game.players[0].active = true;
            buttons = 0;
        }
        int panelY = Defines.HEIGHT - Resources.iPlayerPanelH - playerPanelYOffset;
        int panelX = (Defines.WIDTH - Resources.iPlayerPanelW) / 2;
        if (pok.Game.players[0].active) {
            panelY = Defines.HEIGHT - Resources.iPlayerPanelH - buttons * Resources.iBorderOffH;
            g.drawImage(Resources.imgPlayerPanel, panelX, panelY, 0);
        } else {
            g.drawImage(Resources.imgPlayerPanelOff, panelX, panelY, 0);
        }
        Fonts.drawStr(pok.Game.players[0].getChipsString(), panelX + Resources.iPlayerPanelW - Fonts.strWidth(pok.Game.players[0].getChipsString() + " "), panelY + (Resources.iPlayerPanelH / 2 - Resources.iFont1H) / 2, g);
        Sprite sprTmpCards = null;
        int iTmpPosX = 0;
        for (int i = 0; i < 2; ++i) {
            switch (pok.Game.players[0].cards[i].getColNr()) {
                case 0: {
                    sprTmpCards = Resources.sprHearts;
                    break;
                }
                case 1: {
                    sprTmpCards = Resources.sprDiamonds;
                    break;
                }
                case 2: {
                    sprTmpCards = Resources.sprClubs;
                    break;
                }
                case 3: {
                    sprTmpCards = Resources.sprSpades;
                }
            }
            if (i == 0) {
                iTmpPosX = Resources.PLAYER_X1;
            }
            if (i == 1) {
                iTmpPosX = Resources.PLAYER_X2;
            }
            if (!pok.Game.players[0].fold) {
                if (pok.Game.players[0].cards[i].isDistributed()) {
                    sprTmpCards.setFrame(pok.Game.players[0].cards[i].getValue() - 1);
                    sprTmpCards.setPosition(iTmpPosX, panelY + Resources.PLAYER_Y);
                    sprTmpCards.paint(g);
                }
                if (mode != 5) continue;
                if (pok.Game.players[0].cards[i].bWinCard) continue;
                if (pok.Game.bWinByFold) continue;
                g.drawImage(Resources.imgCardShade, iTmpPosX, panelY + Resources.PLAYER_Y, 0);
                continue;
            }
            Resources.sprCardRub.setFrame(0);
            Resources.sprCardRub.setPosition(iTmpPosX, panelY + Resources.PLAYER_Y);
            Resources.sprCardRub.paint(g);
        }
        if (mode == 4 && iSelectedAction == 0) {
            if (pok.Game.players[0].iPlayerAction == 0) {
                if (pok.Game.iBetPerPlayer - pok.Game.players[0].iActualBet >= pok.Game.players[0].iChips) {
                    Fonts.drawStr(actionStrings[5], panelX + Resources.iPlayerPanelW - Fonts.strWidth(actionStrings[5] + " "), panelY + (Resources.iPlayerPanelH - Resources.iFont1H - Resources.BET_OFFSET), g);
                } else {
                    Fonts.drawStr(pok.Game.iBetPerPlayer - pok.Game.players[0].iActualBet + " $", panelX + Resources.iPlayerPanelW - Fonts.strWidth(pok.Game.iBetPerPlayer - pok.Game.players[0].iActualBet + " $" + " "), panelY + (Resources.iPlayerPanelH - Resources.iFont1H - Resources.BET_OFFSET), g);
                }
            }
        }
    }

    public void paintUpperSheet(Graphics g) {
        g.drawImage(Resources.imgUpperPanel, 0, 0, 0);
        int iPosBordX = (Defines.WIDTH - Resources.iBorderOnW * (Resources.UPPER_PANEL1_PARTS + Resources.UPPER_PANEL2_PARTS)) / 2;
        int iPosBordY = (Resources.iUpperPanelH - Resources.iBorderOffH) / 2;
        Resources.paintBorder(2, true, Resources.UPPER_PANEL1_PARTS, iPosBordX, iPosBordY, g);
        String message = "";
        String message2 = "";
        if (mode == 3 || mode == 4) {
            if (actualPlayer != 0) {
                message = this.playerNames[pok.Game.players[ScreenGamePok.actualPlayer].nameIndx];
            }
            if (actualPlayer == 0) {
                message = sPlayer;
            }
            int color = 0;
            if (actualPlayer != 0) {
                switch (pok.Game.players[ScreenGamePok.actualPlayer].iPlayerAction) {
                    case 1: {
                        message = this.playerNames[pok.Game.players[ScreenGamePok.actualPlayer].nameIndx] + ": " + actionStrings[2] + " " + (pok.Game.iBetPerPlayer - pok.Game.players[ScreenGamePok.actualPlayer].iLastBet) + " $";
                        message2 = actionStrings[2];
                        color = 0;
                        break;
                    }
                    case 2: {
                        message = this.playerNames[pok.Game.players[ScreenGamePok.actualPlayer].nameIndx] + ": " + actionStrings[3] + " " + pok.Game.players[ScreenGamePok.actualPlayer].iRaise + " $";
                        message2 = actionStrings[3];
                        color = 0;
                        break;
                    }
                    case 4: {
                        message = this.playerNames[pok.Game.players[ScreenGamePok.actualPlayer].nameIndx] + ": " + actionStrings[1] + " " + (pok.Game.iBetPerPlayer - pok.Game.players[ScreenGamePok.actualPlayer].iLastBet) + " $";
                        message2 = actionStrings[1];
                        color = 1;
                        break;
                    }
                    case 3: {
                        message = this.playerNames[pok.Game.players[ScreenGamePok.actualPlayer].nameIndx] + ": " + actionStrings[0];
                        message2 = actionStrings[0];
                        color = 1;
                        break;
                    }
                    case 5: {
                        message = this.playerNames[pok.Game.players[ScreenGamePok.actualPlayer].nameIndx] + ": " + actionStrings[4];
                        message2 = actionStrings[4];
                        color = 2;
                        break;
                    }
                    case 6: {
                        message = this.playerNames[pok.Game.players[ScreenGamePok.actualPlayer].nameIndx] + ": " + actionStrings[5];
                        message2 = actionStrings[5];
                        color = 0;
                    }
                }
            }
            if (mode == 3 && !bNextGameMode) {
                if (pok.Game.players[ScreenGamePok.actualPlayer].iPlayerAction != 0) {
                    this.paintPlayerActionMessage(actualPlayer, message2, g, color);
                }
            }
            if (bNextGameMode) {
                int i = 0;
                while (true) {
                    if (i >= pok.Game.players.length) break;
                    pok.Game.players[i].active = false;
                    ++i;
                }
                switch (pok.Game.game_mode) {
                    case 1: {
                        message = gameModeStrings[3];
                        break;
                    }
                    case 2: {
                        message = gameModeStrings[4];
                        break;
                    }
                    case 3: {
                        message = gameModeStrings[5];
                        break;
                    }
                    default: {
                        message = "";
                    }
                }
                if (message != "") {
                    g.setColor(0);
                    g.fillRect(0, (Defines.HEIGHT - (Resources.iFont1H + Resources.iFont1H / 2)) / 2, Defines.WIDTH, Resources.iFont1H + Resources.iFont1H / 2);
                    Fonts.drawStr(message, (Defines.WIDTH - Fonts.strWidth(message)) / 2, (Defines.HEIGHT - Resources.iFont1H) / 2, g);
                    System.out.println("                round part: " + message);
                }
                bNextGameMode = false;
            }
        }
        if (mode == 2) {
            message = gameModeStrings[0];
        }
        if (mode == 9) {
            if (iPutBlinds == 0) {
                this.paintPlayerActionMessage(actualPlayer, gameModeStrings[1], g, 1);
                message = message.concat(" " + gameModeStrings[1]);
            }
            if (iPutBlinds == 1) {
                this.paintPlayerActionMessage(actualPlayer, gameModeStrings[2], g, 1);
                message = message.concat(" " + gameModeStrings[2]);
            }
        }
        if (mode == 5) {
            message = gameModeStrings[6];
        }
        Fonts.drawStr(message, iPosBordX + (Resources.iBorderOnW * Resources.UPPER_PANEL1_PARTS - Fonts.strWidth(message)) / 2, iPosBordY + (Resources.iBorderOffH - Resources.iFont1H) / 2, g);
        iPosBordY = (Resources.iUpperPanelH - Resources.iBorderOffH) / 2;
        Resources.paintBorder(2, false, Resources.UPPER_PANEL2_PARTS, iPosBordX += Resources.iBorderOnW * Resources.UPPER_PANEL1_PARTS, iPosBordY, g);
        Fonts.drawStr(sPot + " " + pok.Game.iPot + "$", iPosBordX + (Resources.iBorderOnW * Resources.UPPER_PANEL2_PARTS - Fonts.strWidth(sPot + " " + pok.Game.iPot + "$")) / 2, iPosBordY + (Resources.iBorderOffH - Resources.iFont1H) / 2, g);
        if (mode == 7 || mode == 6) {
            g.drawImage(Resources.imgUpperPanel, 0, 0, 0);
            int count = Defines.WIDTH / Resources.iBorderOffW - 2;
            Resources.paintBorder(2, true, count, (Defines.WIDTH - count * Resources.iBorderOffW) / 2, (Resources.iUpperPanelH - Resources.iBorderOffH) / 2, g);
            iPosBordY = (Resources.iUpperPanelH - Resources.iBorderOffH) / 2;
            message = actTable + ": " + (pok.GameHandling.iTableNr + 1);
            Fonts.drawStr(message, (Defines.WIDTH - Fonts.strWidth(message)) / 2, iPosBordY + (Resources.iBorderOffH - Resources.iFont1H) / 2, g);
        }
    }

    public void paintPlayerActionMessage(int actualPlayer, String message2, Graphics g, int color) {
        if (actualPlayer == 0) {
            return;
        }
        int iWidth = Resources.iPlayerBGW * Resources.PLAYER_BG_PARTS;
        int iHeight = Resources.iFont1H + Resources.iFont1H / 2;
        int iPosX = 0;
        int iPosY = (Resources.iPlayerBGH - iHeight) / 2;
        switch (actualPlayer) {
            case 1: {
                iPosX = 0;
                iPosY += (Defines.HEIGHT - Resources.iTableH) / 2 + Resources.iTableH - Resources.iTableH / 4 - Resources.DOWN_PLAYERS_OFFSET - tableYOffset;
                break;
            }
            case 2: {
                iPosX = 0;
                iPosY += (Defines.HEIGHT - Resources.iTableH) / 2 - Resources.iTableH / 3 - tableYOffset;
                break;
            }
            case 3: {
                iPosX = Defines.WIDTH - iWidth;
                iPosY += (Defines.HEIGHT - Resources.iTableH) / 2 - Resources.iTableH / 3 - tableYOffset;
                break;
            }
            case 4: {
                iPosX = Defines.WIDTH - iWidth;
                iPosY += (Defines.HEIGHT - Resources.iTableH) / 2 + Resources.iTableH - Resources.iTableH / 4 - Resources.DOWN_PLAYERS_OFFSET - tableYOffset;
            }
        }
        if (color == 0) {
            g.setColor(0xFF0000);
        }
        if (color == 1) {
            g.setColor(0x22FF22);
        }
        if (color == 2) {
            g.setColor(255);
        }
        g.fillRect(iPosX, iPosY, iWidth, iHeight);
        g.setColor(0);
        g.drawRect(iPosX, iPosY, iWidth, iHeight);
        Fonts.drawStr(message2, iPosX + (iWidth - Fonts.strWidth(message2)) / 2, iPosY + (iHeight - Resources.iFont1H) / 2, g);
    }

    public void paintBlinds(Graphics g) {
        int iPosXD = 0;
        int iPosYD = 0;
        int iPosXS = 0;
        int iPosYS = 0;
        int iPosXB = 0;
        int iPosYB = 0;
        switch (iDealerIndex) {
            case 0: {
                iPosXD = (Defines.WIDTH - Resources.iBlindW) / 2;
                iPosYD = Defines.HEIGHT - Resources.iPlayerPanelH - Resources.iBlindH - playerPanelYOffset;
                break;
            }
            case 1: {
                iPosXD = Resources.PLAYER_FOTO_X;
                iPosYD = (Defines.HEIGHT - Resources.iTableH) / 2 + Resources.iTableH - Resources.iTableH / 4 - Resources.iBlindH - Resources.DOWN_PLAYERS_OFFSET;
                break;
            }
            case 2: {
                iPosXD = Resources.PLAYER_FOTO_X;
                iPosYD = (Defines.HEIGHT - Resources.iTableH) / 2 - Resources.iTableH / 3 - Resources.iBlindH;
                break;
            }
            case 3: {
                iPosXD = Defines.WIDTH - Resources.PLAYER_FOTO_X - Resources.iBlindW;
                iPosYD = (Defines.HEIGHT - Resources.iTableH) / 2 - Resources.iTableH / 3 - Resources.iBlindH;
                break;
            }
            case 4: {
                iPosXD = Defines.WIDTH - Resources.PLAYER_FOTO_X - Resources.iBlindW;
                iPosYD = (Defines.HEIGHT - Resources.iTableH) / 2 + Resources.iTableH - Resources.iTableH / 4 - Resources.iBlindH - Resources.DOWN_PLAYERS_OFFSET;
            }
        }
        switch (iSBIndex) {
            case 1: {
                iPosXS = Resources.PLAYER_FOTO_X;
                iPosYS = (Defines.HEIGHT - Resources.iTableH) / 2 + Resources.iTableH - Resources.iTableH / 4 - Resources.iBlindH - Resources.DOWN_PLAYERS_OFFSET;
                break;
            }
            case 2: {
                iPosXS = Resources.PLAYER_FOTO_X;
                iPosYS = (Defines.HEIGHT - Resources.iTableH) / 2 - Resources.iTableH / 3 - Resources.iBlindH;
                break;
            }
            case 3: {
                iPosXS = Defines.WIDTH - Resources.PLAYER_FOTO_X - Resources.iBlindW;
                iPosYS = (Defines.HEIGHT - Resources.iTableH) / 2 - Resources.iTableH / 3 - Resources.iBlindH;
                break;
            }
            case 4: {
                iPosXS = Defines.WIDTH - Resources.PLAYER_FOTO_X - Resources.iBlindW;
                iPosYS = (Defines.HEIGHT - Resources.iTableH) / 2 + Resources.iTableH - Resources.iTableH / 4 - Resources.iBlindH - Resources.DOWN_PLAYERS_OFFSET;
                break;
            }
            case 0: {
                iPosXS = (Defines.WIDTH - Resources.iBlindW) / 2;
                iPosYS = Defines.HEIGHT - Resources.iPlayerPanelH - Resources.iBlindH - playerPanelYOffset;
            }
        }
        switch (iBBIndex) {
            case 2: {
                iPosXB = Resources.PLAYER_FOTO_X;
                iPosYB = (Defines.HEIGHT - Resources.iTableH) / 2 - Resources.iTableH / 3 - Resources.iBlindH;
                break;
            }
            case 3: {
                iPosXB = Defines.WIDTH - Resources.PLAYER_FOTO_X - Resources.iBlindW;
                iPosYB = (Defines.HEIGHT - Resources.iTableH) / 2 - Resources.iTableH / 3 - Resources.iBlindH;
                break;
            }
            case 4: {
                iPosXB = Defines.WIDTH - Resources.PLAYER_FOTO_X - Resources.iBlindW;
                iPosYB = (Defines.HEIGHT - Resources.iTableH) / 2 + Resources.iTableH - Resources.iTableH / 4 - Resources.iBlindH - Resources.DOWN_PLAYERS_OFFSET;
                break;
            }
            case 0: {
                iPosXB = (Defines.WIDTH - Resources.iBlindW) / 2;
                iPosYB = Defines.HEIGHT - Resources.iPlayerPanelH - Resources.iBlindH - playerPanelYOffset;
                break;
            }
            case 1: {
                iPosXB = Resources.PLAYER_FOTO_X;
                iPosYB = (Defines.HEIGHT - Resources.iTableH) / 2 + Resources.iTableH - Resources.iTableH / 4 - Resources.iBlindH - Resources.DOWN_PLAYERS_OFFSET;
            }
        }
        Resources.sprBlinds.setFrame(0);
        Resources.sprBlinds.setPosition(iPosXD, iPosYD);
        Resources.sprBlinds.paint(g);
        Resources.sprBlinds.setFrame(1);
        Resources.sprBlinds.setPosition(iPosXS, iPosYS);
        Resources.sprBlinds.paint(g);
        Resources.sprBlinds.setFrame(2);
        Resources.sprBlinds.setPosition(iPosXB, iPosYB);
        Resources.sprBlinds.paint(g);
    }

    public void paintPlayers(Graphics g) {
        int iPosY2;
        int iPosY1;
        block60: {
            block59: {
                block58: {
                    block57: {
                        String playName;
                        int iPosBordY;
                        int iPosBordX;
                        iPosY1 = (Defines.HEIGHT - Resources.iTableH) / 2 - Resources.iTableH / 3 - tableYOffset;
                        iPosY2 = (Defines.HEIGHT - Resources.iTableH) / 2 + Resources.iTableH - Resources.iTableH / 4 - Resources.DOWN_PLAYERS_OFFSET - tableYOffset;
                        if (bNextGameMode || mode == 5) {
                            int i = 0;
                            while (true) {
                                if (i >= pok.Game.players.length) break;
                                pok.Game.players[i].active = false;
                                ++i;
                            }
                            tableYOffset = 0;
                        }
                        if (pok.Game.players[2].playing) {
                            if (!pok.Game.players[2].active) {
                                Resources.paintPlayerBG(false, 0, iPosY1, g);
                            } else {
                                Resources.paintPlayerBG(true, 0, iPosY1, g);
                            }
                            iPosBordX = Resources.NAMES_OFFSET;
                            iPosBordY = iPosY1 + Resources.iPlayerBGH - Resources.iBorderOnH - Resources.NAMES_OFFSET;
                            g.drawImage(Resources.imgPlFoto2, Resources.PLAYER_FOTO_X, iPosY1 + Resources.PLAYER_FOTO_Y, 0);
                            playName = this.playerNames[pok.Game.players[2].nameIndx];
                            Fonts.drawStr(playName, Resources.PLAYER_FOTO_X + (Resources.iPlFotoW - Fonts.strWidth(playName)) / 2, iPosBordY + (Resources.iBorderOnH - Resources.iFont1H) / 2, g);
                            Fonts.drawStr(pok.Game.players[2].getChipsString(), Resources.iPlayerBGW * Resources.PLAYER_BG_PARTS - Fonts.strWidth(pok.Game.players[2].getChipsString()) - Resources.NAMES_OFFSET, iPosY1 + Resources.NAMES_OFFSET, g);
                            if (!pok.Game.players[2].active && mode != 5) {
                                g.drawImage(Resources.imgFaceShade, Resources.PLAYER_FOTO_X, iPosY1 + Resources.PLAYER_FOTO_Y, 0);
                            }
                        }
                        if (pok.Game.players[1].playing) {
                            if (!pok.Game.players[1].active) {
                                Resources.paintPlayerBG(false, 0, iPosY2, g);
                            } else {
                                Resources.paintPlayerBG(true, 0, iPosY2, g);
                            }
                            iPosBordX = Resources.NAMES_OFFSET;
                            iPosBordY = iPosY2 + Resources.iPlayerBGH - Resources.iBorderOnH - Resources.NAMES_OFFSET;
                            g.drawImage(Resources.imgPlFoto1, Resources.PLAYER_FOTO_X, iPosY2 + Resources.PLAYER_FOTO_Y, 0);
                            if (!pok.Game.players[1].active && mode != 5) {
                                g.drawImage(Resources.imgFaceShade, Resources.PLAYER_FOTO_X, iPosY2 + Resources.PLAYER_FOTO_Y, 0);
                            }
                            playName = this.playerNames[pok.Game.players[1].nameIndx];
                            Fonts.drawStr(playName, Resources.PLAYER_FOTO_X + (Resources.iPlFotoW - Fonts.strWidth(playName)) / 2, iPosBordY + (Resources.iBorderOnH - Resources.iFont1H) / 2, g);
                            Fonts.drawStr(pok.Game.players[1].getChipsString(), Resources.iPlayerBGW * Resources.PLAYER_BG_PARTS - Fonts.strWidth(pok.Game.players[1].getChipsString()) - Resources.NAMES_OFFSET, iPosY2 + Resources.NAMES_OFFSET, g);
                        }
                        if (pok.Game.players[3].playing) {
                            if (!pok.Game.players[3].active) {
                                Resources.paintPlayerBG(false, Defines.WIDTH - Resources.iPlayerBGW * Resources.PLAYER_BG_PARTS, iPosY1, g);
                            } else {
                                Resources.paintPlayerBG(true, Defines.WIDTH - Resources.iPlayerBGW * Resources.PLAYER_BG_PARTS, iPosY1, g);
                            }
                            iPosBordX = Defines.WIDTH - Resources.iPlFotoW - Resources.NAMES_OFFSET;
                            iPosBordY = iPosY1 + Resources.iPlayerBGH - Resources.iBorderOnH - Resources.NAMES_OFFSET;
                            g.drawImage(Resources.imgPlFoto3, Defines.WIDTH - Resources.PLAYER_FOTO_X - Resources.iPlFotoW, iPosY1 + Resources.PLAYER_FOTO_Y, 0);
                            if (!pok.Game.players[3].active && mode != 5) {
                                g.drawImage(Resources.imgFaceShade, Defines.WIDTH - Resources.PLAYER_FOTO_X - Resources.iPlFotoW, iPosY1 + Resources.PLAYER_FOTO_Y, 0);
                            }
                            playName = this.playerNames[pok.Game.players[3].nameIndx];
                            Fonts.drawStr(playName, iPosBordX + (Resources.iPlFotoW - Fonts.strWidth(playName)) / 2, iPosBordY + (Resources.iBorderOnH - Resources.iFont1H) / 2, g);
                            Fonts.drawStr(pok.Game.players[3].getChipsString(), Defines.WIDTH - Resources.iPlayerBGW * Resources.PLAYER_BG_PARTS + Resources.NAMES_OFFSET, iPosY1 + Resources.NAMES_OFFSET, g);
                        }
                        if (pok.Game.players[4].playing) {
                            if (!pok.Game.players[4].active) {
                                Resources.paintPlayerBG(false, Defines.WIDTH - Resources.iPlayerBGW * Resources.PLAYER_BG_PARTS, iPosY2, g);
                            } else {
                                Resources.paintPlayerBG(true, Defines.WIDTH - Resources.iPlayerBGW * Resources.PLAYER_BG_PARTS, iPosY2, g);
                            }
                            iPosBordX = Defines.WIDTH - Resources.iPlFotoW - Resources.NAMES_OFFSET;
                            iPosBordY = iPosY2 + Resources.iPlayerBGH - Resources.iBorderOnH - Resources.NAMES_OFFSET;
                            g.drawImage(Resources.imgPlFoto4, Defines.WIDTH - Resources.PLAYER_FOTO_X - Resources.iPlFotoW, iPosY2 + Resources.PLAYER_FOTO_Y, 0);
                            if (!pok.Game.players[4].active && mode != 5) {
                                g.drawImage(Resources.imgFaceShade, Defines.WIDTH - Resources.PLAYER_FOTO_X - Resources.iPlFotoW, iPosY2 + Resources.PLAYER_FOTO_Y, 0);
                            }
                            playName = this.playerNames[pok.Game.players[4].nameIndx];
                            Fonts.drawStr(playName, iPosBordX + (Resources.iPlFotoW - Fonts.strWidth(playName)) / 2, iPosBordY + (Resources.iBorderOnH - Resources.iFont1H) / 2, g);
                            Fonts.drawStr(pok.Game.players[4].getChipsString(), Defines.WIDTH - Resources.iPlayerBGW * Resources.PLAYER_BG_PARTS + Resources.NAMES_OFFSET, iPosY2 + Resources.NAMES_OFFSET, g);
                        }
                        if (mode == 12) {
                            return;
                        }
                        if (pok.Game.players[0].cards[0] == null) break block57;
                        if (pok.Game.players[1].cards[0] == null) break block57;
                        if (pok.Game.players[2].cards[0] == null) break block57;
                        if (pok.Game.players[3].cards[0] == null) break block57;
                        if (pok.Game.players[4].cards[0] != null) break block58;
                    }
                    if (mode == 8) {
                        return;
                    }
                }
                if (pok.Game.players[0].cards[0] == null) break block59;
                if (pok.Game.players[1].cards[0] == null) break block59;
                if (pok.Game.players[2].cards[0] == null) break block59;
                if (pok.Game.players[3].cards[0] == null) break block59;
                if (pok.Game.players[4].cards[0] != null) break block60;
            }
            if (mode != 8) {
                mode = 8;
                return;
            }
        }
        int iTmpX = 0;
        int iTmpY = 0;
        Sprite sprTmpCards = null;
        for (int i = 1; i <= 4; ++i) {
            switch (i) {
                case 1: {
                    iTmpY = iPosY2 + Resources.CARD_Y;
                    break;
                }
                case 2: {
                    iTmpY = iPosY1 + Resources.CARD_Y;
                    break;
                }
                case 3: {
                    iTmpY = iPosY1 + Resources.CARD_Y;
                    break;
                }
                case 4: {
                    iTmpY = iPosY2 + Resources.CARD_Y;
                }
            }
            for (int j = 0; j <= 1; ++j) {
                if (i == 1 && j == 0) {
                    iTmpX = Resources.CARD_X1;
                }
                if (i == 1 && j == 1) {
                    iTmpX = Resources.CARD_X2;
                }
                if (i == 2 && j == 0) {
                    iTmpX = Resources.CARD_X1;
                }
                if (i == 2 && j == 1) {
                    iTmpX = Resources.CARD_X2;
                }
                if (i == 3 && j == 0) {
                    iTmpX = Defines.WIDTH - Resources.CARD_X2 - Resources.iCardW;
                }
                if (i == 3 && j == 1) {
                    iTmpX = Defines.WIDTH - Resources.CARD_X1 - Resources.iCardW;
                }
                if (i == 4 && j == 0) {
                    iTmpX = Defines.WIDTH - Resources.CARD_X2 - Resources.iCardW;
                }
                if (i == 4 && j == 1) {
                    iTmpX = Defines.WIDTH - Resources.CARD_X1 - Resources.iCardW;
                }
                if (pok.Game.game_mode != 4) {
                    if (!pok.Game.players[i].playing) continue;
                    if (!pok.Game.players[i].cards[j].isDistributed()) continue;
                    if (!pok.Game.players[i].fold) {
                        Resources.sprCardRub.setFrame(1);
                    } else {
                        Resources.sprCardRub.setFrame(0);
                    }
                    Resources.sprCardRub.setPosition(iTmpX, iTmpY);
                    Resources.sprCardRub.paint(g);
                    continue;
                }
                if (!pok.Game.players[i].playing) continue;
                if (!pok.Game.players[i].fold) {
                    if (!pok.Game.bWinByFold) {
                        switch (pok.Game.players[i].cards[j].getColNr()) {
                            case 0: {
                                sprTmpCards = Resources.sprHearts;
                                break;
                            }
                            case 1: {
                                sprTmpCards = Resources.sprDiamonds;
                                break;
                            }
                            case 2: {
                                sprTmpCards = Resources.sprClubs;
                                break;
                            }
                            case 3: {
                                sprTmpCards = Resources.sprSpades;
                            }
                        }
                        sprTmpCards.setFrame(pok.Game.players[i].cards[j].getValue() - 1);
                    }
                }
                if (!pok.Game.players[i].fold) {
                    if (pok.Game.bWinByFold) {
                        sprTmpCards = Resources.sprCardRub;
                        sprTmpCards.setFrame(1);
                    }
                }
                if (pok.Game.players[i].fold) {
                    sprTmpCards = Resources.sprCardRub;
                    sprTmpCards.setFrame(0);
                }
                sprTmpCards.setPosition(iTmpX, iTmpY);
                sprTmpCards.paint(g);
                if (mode != 5) continue;
                if (pok.Game.players[i].cards[j].bWinCard) continue;
                if (pok.Game.players[i].fold) continue;
                if (!pok.Game.players[i].playing) continue;
                if (pok.Game.bWinByFold) continue;
                g.drawImage(Resources.imgCardShade, iTmpX, iTmpY, 0);
            }
        }
    }

    public void paintCardDistribution(Graphics g) {
        int tmpX = 0;
        int tmpY = 0;
        int deltaX = 0;
        int deltaY = 0;
        int iPosY1 = (Defines.HEIGHT - Resources.iTableH) / 2 - Resources.iTableH / 3;
        int iPosY2 = (Defines.HEIGHT - Resources.iTableH) / 2 + Resources.iTableH - Resources.iTableH / 4;
        if (iDistributionRound < 2) {
            switch (actualPlayer) {
                case 0: {
                    if (iDistributionRound == 0) {
                        tmpX = Resources.PLAYER_X1;
                    }
                    if (iDistributionRound == 1) {
                        tmpX = Resources.PLAYER_X2;
                    }
                    tmpY = Defines.HEIGHT - Resources.iPlayerPanelH + Resources.PLAYER_Y;
                    deltaX = Resources.iCardH / 3;
                    deltaY = Resources.iCardH;
                    break;
                }
                case 1: {
                    if (iDistributionRound == 0) {
                        tmpX = Resources.CARD_X1;
                    }
                    if (iDistributionRound == 1) {
                        tmpX = Resources.CARD_X2;
                    }
                    tmpY = iPosY2 + Resources.CARD_Y;
                    deltaX = Resources.iCardW;
                    deltaY = Resources.iCardH;
                    break;
                }
                case 2: {
                    if (iDistributionRound == 0) {
                        tmpX = Resources.CARD_X1;
                    }
                    if (iDistributionRound == 1) {
                        tmpX = Resources.CARD_X2;
                    }
                    tmpY = iPosY1 + Resources.CARD_Y;
                    deltaX = Resources.iCardH;
                    deltaY = Resources.iCardH;
                    break;
                }
                case 3: {
                    if (iDistributionRound == 0) {
                        tmpX = Defines.WIDTH - Resources.CARD_X2 - Resources.iCardW;
                    }
                    if (iDistributionRound == 1) {
                        tmpX = Defines.WIDTH - Resources.CARD_X1 - Resources.iCardW;
                    }
                    tmpY = iPosY1 + Resources.CARD_Y;
                    deltaX = Resources.iCardH;
                    deltaY = Resources.iCardW / 2;
                    break;
                }
                case 4: {
                    if (iDistributionRound == 0) {
                        tmpX = Defines.WIDTH - Resources.CARD_X2 - Resources.iCardW;
                    }
                    if (iDistributionRound == 1) {
                        tmpX = Defines.WIDTH - Resources.CARD_X1 - Resources.iCardW;
                    }
                    tmpY = iPosY2 + Resources.CARD_Y;
                    deltaX = Resources.iCardH;
                    deltaY = Resources.iCardH;
                }
            }
        } else {
            int i = 0;
            while (true) {
                if (i >= pok.Game.tableCards.length) break;
                if (!pok.Game.tableCards[i].isDistributed()) {
                    step = i;
                    break;
                }
                if (i == pok.Game.tableCards.length - 1) {
                    ++iDistributionRound;
                }
                ++i;
            }
            tmpY = (Defines.HEIGHT - Resources.iCardH) / 2;
            switch (step) {
                case 0: {
                    tmpX = Resources.TABLE_X1;
                    deltaX = 30;
                    deltaY = 30;
                    break;
                }
                case 1: {
                    tmpX = Resources.TABLE_X2;
                    deltaX = 30;
                    deltaY = 30;
                    break;
                }
                case 2: {
                    tmpX = Resources.TABLE_X3;
                    deltaX = 35;
                    deltaY = 30;
                    break;
                }
                case 3: {
                    tmpX = Resources.TABLE_X4;
                    deltaX = 40;
                    deltaY = 30;
                    break;
                }
                case 4: {
                    tmpX = Resources.TABLE_X5;
                    deltaX = 45;
                    deltaY = 30;
                }
            }
        }
        boolean bHelp1 = false;
        boolean bHelp2 = false;
        Resources.sprCardRub.setFrame(1);
        Resources.sprCardRub.setPosition(iDistributionX, iDistributionY);
        Resources.sprCardRub.paint(g);
        if (iDistributionX < tmpX) {
            iDistributionX += deltaX;
        }
        if (iDistributionX >= tmpX) {
            bHelp1 = true;
            iDistributionX = tmpX;
        }
        if (iDistributionY < tmpY) {
            iDistributionY += deltaY;
        }
        if (iDistributionY >= tmpY) {
            bHelp2 = true;
            iDistributionY = tmpY;
        }
        if (bHelp1 && bHelp2 && step < 5) {
            if (iDistributionRound == 0) {
                pok.Game.players[ScreenGamePok.actualPlayer].cards[0].setDistrib(true);
                ScreenGamePok.nextPlayer();
            }
            if (iDistributionRound == 1) {
                pok.Game.players[ScreenGamePok.actualPlayer].cards[1].setDistrib(true);
                ScreenGamePok.nextPlayer();
            }
            if (iDistributionRound == 2) {
                pok.Game.tableCards[step].setDistrib(true);
                ++step;
            }
            this.resetDistributionCoordinates();
            bHelp1 = false;
            bHelp2 = false;
        }
        if (step >= 5) {
            step = 0;
            ++iDistributionRound;
            actualPlayer = iDealerIndex < 4 ? iDealerIndex + 1 : 0;
            while (true) {
                if (pok.Game.players[ScreenGamePok.actualPlayer].playing) break;
                if (++actualPlayer != 5) continue;
                actualPlayer = 0;
            }
            step = 0;
            this.resetDistributionCoordinates();
        }
        this.paintUpperSheet(g);
    }

    public static void nextPlayer() {
        block7: {
            block6: {
                actualPlayer = actualPlayer < 4 ? ++actualPlayer : 0;
                pok.Game.players[ScreenGamePok.actualPlayer].iPlayerAction = 0;
                ++step;
                if (pok.Game.players[ScreenGamePok.actualPlayer].fold) break block6;
                if (pok.Game.players[ScreenGamePok.actualPlayer].bAllIn) break block6;
                if (pok.Game.players[ScreenGamePok.actualPlayer].playing) break block7;
            }
            if (pok.Game.game_mode != 4) {
                ScreenGamePok.nextPlayer();
                return;
            }
        }
        if (actualPlayer == 0 && mode == 3) {
            for (int i = 0; i < 5; ++i) {
                pok.Game.players[i].active = false;
            }
        }
    }

    public void keyPressed(int keyCode) {
        if (Keys.key_num0) {
            for (int i = 0; i < 5; ++i) {
                System.out.println("player " + i + " actualBet: " + pok.Game.players[i].iActualBet);
                System.out.println("player style: " + pok.Game.players[i].iPlayingStyle);
            }
            System.out.println("bet per player: " + pok.Game.iBetPerPlayer);
        }
        if (Keys.key_fn2 && mode != 8 && mode != 6 && mode != 12) {
            old_mode = mode;
            if (mode == 2) {
                this.skipCardDistribution();
            }
            statePok.saveGame(this);
            statePok.saveTable(this);
            mode = 6;
            X.soundManager.Stop();
            iSelectedSubMenuItem = 0;
            return;
        }
        if (Keys.key_fn1 && mode != 8 && mode != 6) {
            bSkipOn = !bSkipOn;
            canvas.repaint();
            canvas.serviceRepaints();
        }
        switch (mode) {
            case 12: {
                this.keyPrWelcome(keyCode);
                break;
            }
            case 6: {
                this.keyPrPause(keyCode);
                break;
            }
            case 4: {
                this.keyPrPlayerMove(keyCode);
                break;
            }
            case 5: {
                ScreenGamePok.nextGameMode();
                break;
            }
            case 7: {
                if (!Keys.key_fire && !Keys.key_num5 || !Keys.key_fire && !Keys.key_num5) break;
                statePok.saveTable(this);
                ScreenGamePok.nextGameMode();
                break;
            }
            case 8: {
                this.keyPrGameOver(keyCode);
            }
        }
        canvas.repaint();
        canvas.serviceRepaints();
    }

    public void keyPrGameOver(int keyCode) {
        if (Keys.key_up || Keys.key_num2 || Keys.key_left || Keys.key_num4) {
            --iSelectedAction;
            if (--iSelectedAction < 0) {
                iSelectedAction = 2;
            }
        }
        if (Keys.key_down || Keys.key_num8 || Keys.key_right || Keys.key_num6) {
            ++iSelectedAction;
            if (++iSelectedAction > 2) {
                iSelectedAction = 0;
            }
        }
        if (Keys.key_fire || Keys.key_num5) {
            switch (iSelectedAction) {
                case 0: {
                    if (pok.Game.players[0].iChips == 0) {
                        mode = -1;
                        statePok.saveTable(this);
                        statePok.deleteGame();
                        Game = new Game(pok.GameHandling.iBigBlinds[pok.GameHandling.iLevel]);
                        pok.Game.iRoundNr = 0;
                        playerPanelYOffset = 0;
                        tableYOffset = 0;
                        this.createPlayers();
                        this.generateCards();
                        iPutBlinds = 0;
                        mode = 0;
                        old_mode = 1;
                        break;
                    }
                    mode = -1;
                    GameHandling.newTable();
                    statePok.saveTable(this);
                    statePok.deleteGame();
                    Game = new Game(pok.GameHandling.iBigBlinds[pok.GameHandling.iLevel]);
                    pok.Game.iRoundNr = 0;
                    playerPanelYOffset = 0;
                    tableYOffset = 0;
                    this.createPlayers();
                    this.generateCards();
                    iPutBlinds = 0;
                    mode = 0;
                    old_mode = 1;
                    break;
                }
                case 1: {
                    System.out.println("odosielam skore");
                    break;
                }
                case 2: {
                    if (pok.Game.players[0].iChips == 0) {
                        statePok.deleteTable();
                        statePok.deleteGame();
                        Resources.releaseGamePokResources();
                        MainCanvas.scrMenu = new ScreenMenu(canvas, 0);
                        MainCanvas.activeScreen = MainCanvas.scrMenu;
                        MainCanvas.scrGamePok = null;
                        break;
                    }
                    Resources.releaseGamePokResources();
                    MainCanvas.scrMenu = new ScreenMenu(canvas, 0);
                    MainCanvas.activeScreen = MainCanvas.scrMenu;
                    MainCanvas.scrGamePok = null;
                    return;
                }
            }
        }
    }

    public void keyPrWelcome(int keyCode) {
        if ((Keys.key_up || Keys.key_num2 || Keys.key_left || Keys.key_num4) && --iSelectedAction < 1) {
            iSelectedAction = 2;
        }
        if ((Keys.key_down || Keys.key_num8 || Keys.key_right || Keys.key_num6) && ++iSelectedAction > 2) {
            iSelectedAction = 1;
        }
        if (Keys.key_fire || Keys.key_num5) {
            switch (iSelectedAction) {
                case 0: {
                    break;
                }
                case 1: {
                    mode = old_mode;
                    break;
                }
                case 2: {
                    Resources.releaseGamePokResources();
                    MainCanvas.scrMenu = new ScreenMenu(canvas, 0);
                    MainCanvas.activeScreen = MainCanvas.scrMenu;
                    MainCanvas.scrGamePok = null;
                }
            }
        }
    }

    public void keyPrPlayerMove(int keyCode) {
        if (Keys.key_up || Keys.key_num2) {
            --iSelectedAction;
            if (pok.Game.players[0].iChips <= pok.Game.iBetPerPlayer - pok.Game.players[0].iActualBet) {
                --iSelectedAction;
            }
            if (iSelectedAction < 0) {
                iSelectedAction = 2;
            }
        }
        if (Keys.key_down || Keys.key_num8) {
            ++iSelectedAction;
            if (pok.Game.players[0].iChips <= pok.Game.iBetPerPlayer - pok.Game.players[0].iActualBet) {
                ++iSelectedAction;
            }
            if (iSelectedAction > 2) {
                iSelectedAction = 0;
            }
        }
        if (pok.Game.players[0].iPlayerAction == 0) {
            if (Keys.key_fire || Keys.key_num5) {
                switch (iSelectedAction) {
                    case 0: {
                        if (Game.compareBets()) {
                            mode = 11;
                            break;
                        }
                        pok.Game.checkOrCall(0);
                        mode = 11;
                        break;
                    }
                    case 1: {
                        if (Game.compareBets()) {
                            iPlayerBet = pok.Game.iBlind;
                            pok.Game.players[0].iPlayerAction = 1;
                        } else {
                            iPlayerBet = pok.Game.iRaise;
                            pok.Game.players[0].iPlayerAction = 2;
                        }
                        iSelectedAction = 0;
                        break;
                    }
                    case 2: {
                        pok.Game.fold(0);
                        mode = 11;
                    }
                }
            }
        } else if (pok.Game.players[0].iPlayerAction == 1) {
            if ((Keys.key_right || Keys.key_num6) && iSelectedAction == 0) {
                bPlusPressed = true;
                if (iPlayerBet != pok.Game.players[0].iChips) {
                    iPlayerBet += 10;
                }
            }
            if ((Keys.key_left || Keys.key_num4) && iSelectedAction == 0) {
                bMinusPressed = true;
                if (iPlayerBet != pok.Game.iBlind) {
                    iPlayerBet -= 10;
                }
            }
            if ((Keys.key_fire || Keys.key_num5) && iSelectedAction == 0) {
                System.out.println("Bet :" + iPlayerBet);
                pok.Game.players[0].removeChips(iPlayerBet);
                pok.Game.addToPot(iPlayerBet);
                pok.Game.bRaise = true;
                pok.Game.iBetPerPlayer += iPlayerBet;
                pok.Game.players[0].addBet(iPlayerBet);
                pok.Game.iRaise = iPlayerBet;
                if (iPlayerBet == pok.Game.players[0].iChips) {
                    pok.Game.players[0].bAllIn = true;
                }
                mode = 11;
            }
            if ((Keys.key_fire || Keys.key_num5) && iSelectedAction == 1) {
                pok.Game.AllIn(0);
                mode = 11;
            }
            if ((Keys.key_fire || Keys.key_num5) && iSelectedAction == 2) {
                pok.Game.players[0].iPlayerAction = 0;
                iSelectedAction = 0;
            }
        } else if (pok.Game.players[0].iPlayerAction == 2) {
            if ((Keys.key_right || Keys.key_num6) && iSelectedAction == 0) {
                bPlusPressed = true;
                if (iPlayerBet + pok.Game.iBetPerPlayer - pok.Game.players[0].iActualBet < pok.Game.players[0].iChips) {
                    iPlayerBet += 10;
                }
            }
            if ((Keys.key_left || Keys.key_num4) && iSelectedAction == 0) {
                bMinusPressed = true;
                if (iPlayerBet != pok.Game.iRaise) {
                    iPlayerBet -= 10;
                }
            }
            if ((Keys.key_fire || Keys.key_num5) && iSelectedAction == 0) {
                System.out.println("call: " + (pok.Game.iBetPerPlayer - pok.Game.players[0].iActualBet) + " + raise:" + iPlayerBet);
                pok.Game.players[0].removeChips(iPlayerBet + pok.Game.iBetPerPlayer - pok.Game.players[0].iActualBet);
                pok.Game.addToPot(iPlayerBet + pok.Game.iBetPerPlayer - pok.Game.players[0].iActualBet);
                pok.Game.bRaise = true;
                pok.Game.players[0].addBet(iPlayerBet + (pok.Game.iBetPerPlayer - pok.Game.players[0].iActualBet));
                pok.Game.iBetPerPlayer += iPlayerBet;
                pok.Game.iRaise += iPlayerBet;
                if (iPlayerBet + pok.Game.iBetPerPlayer - pok.Game.players[0].iActualBet == pok.Game.players[0].iChips) {
                    pok.Game.players[0].bAllIn = true;
                }
                mode = 11;
            }
            if ((Keys.key_fire || Keys.key_num5) && iSelectedAction == 1) {
                pok.Game.AllIn(0);
                mode = 11;
            }
            if ((Keys.key_fire || Keys.key_num5) && iSelectedAction == 2) {
                pok.Game.players[0].iPlayerAction = 0;
                iSelectedAction = 0;
            }
        }
    }

    public void keyPrPause(int keyCode) {
        if (Keys.key_right || Keys.key_up || Keys.key_num6 || Keys.key_num2) {
            iSelectedSubMenuItem = iSelectedSubMenuItem - 1 < 0 ? 2 : --iSelectedSubMenuItem;
        }
        if (Keys.key_left || Keys.key_down || Keys.key_num4 || Keys.key_num8) {
            iSelectedSubMenuItem = iSelectedSubMenuItem + 1 > 2 ? 0 : ++iSelectedSubMenuItem;
        }
        if (Keys.key_fire || Keys.key_num5) {
            if (iSelectedSubMenuItem == 0) {
                mode = iPutBlinds < 2 ? 9 : old_mode;
                if (Settings.bMusic) {
                    X.soundManager.Stop();
                    X.soundManager.SetSoundOn(true);
                    X.soundManager.Play(X.MUSIC_MENU_ID, -1);
                } else {
                    X.soundManager.Stop();
                    X.soundManager.SetSoundOn(false);
                }
            }
            if (iSelectedSubMenuItem == 1) {
                mode = -1;
                statePok.saveTable(this);
                statePok.deleteGame();
                Game = new Game(pok.GameHandling.iBigBlinds[pok.GameHandling.iLevel]);
                pok.Game.iRoundNr = 0;
                playerPanelYOffset = 0;
                tableYOffset = 0;
                this.createPlayers();
                this.generateCards();
                iPutBlinds = 0;
                mode = 0;
                old_mode = 1;
            }
            if (iSelectedSubMenuItem == 2) {
                Resources.releaseGamePokResources();
                MainCanvas.scrMenu = new ScreenMenu(canvas, 0);
                MainCanvas.activeScreen = MainCanvas.scrMenu;
                MainCanvas.scrGamePok = null;
                return;
            }
        }
    }

    public void continuePlaying() {
        mode = 3;
        pok.Game.players[0].active = false;
        canvas.repaint();
        canvas.serviceRepaints();
        if (step == 0) {
            Game.checkPlayersHands();
        }
        if (Game.compareBets() && step >= 5) {
            ScreenGamePok.nextGameMode();
        } else {
            ScreenGamePok.nextPlayer();
        }
        int i = 0;
        while (true) {
            if (i >= pok.Game.players.length) break;
            pok.Game.players[i].active = actualPlayer == i;
            ++i;
        }
        mode = 3;
    }

    public void skipCardDistribution() {
        for (int i = 0; i < 5; ++i) {
            pok.Game.players[i].cards[0].setDistrib(true);
            pok.Game.players[i].cards[1].setDistrib(true);
            pok.Game.tableCards[i].setDistrib(true);
        }
        iWaitTime = 0;
        iPutBlinds = 0;
        mode = 9;
        step = 0;
        iWaitTime = DEFAULT_WAIT_TIME;
        canvas.repaint();
        canvas.serviceRepaints();
    }

    public void keyReleased(int keyCode) {
        bPlusPressed = false;
        bMinusPressed = false;
        iKeyPressedDelay = 0;
    }

    public void pointerDragged(int x, int y) {
    }

    public void pointerPressed(int x, int y) {
        if (Resources.isInLeftButton(x, y)) {
            Keys.key_fn1 = true;
            this.keyPressed(Keys.iLeftKey);
            Keys.key_fn1 = false;
        }
        if (Resources.isInRightButton(x, y)) {
            Keys.key_fn2 = true;
            this.keyPressed(Keys.iRightKey);
            Keys.key_fn2 = false;
        }
        if (mode == 6) {
            int buttonPressed = Resources.whichSubMenuButton(x, y);
            switch (buttonPressed) {
                case 1: {
                    iSelectedSubMenuItem = 0;
                    break;
                }
                case 2: {
                    iSelectedSubMenuItem = 1;
                    break;
                }
                case 3: {
                    iSelectedSubMenuItem = 2;
                    break;
                }
                default: {
                    iSelectedSubMenuItem = -1;
                }
            }
        }
        switch (mode) {
            case 5: 
            case 12: {
                iSelectedAction = Resources.WhichWelcomeButton(x, y);
                if (iSelectedAction == 0) {
                    iSelectedAction = 1;
                }
                Keys.key_fire = true;
                this.keyPressed(Keys.iEnterKey);
                Keys.key_fire = false;
                break;
            }
            case 4: {
                int button = Resources.whichGameControlButton(x, y, playerPanelYOffset);
                if (button < 0 || button > 2) {
                    iSelectedAction = 0;
                } else {
                    iSelectedAction = button;
                    Keys.key_fire = true;
                    this.keyPressed(Keys.iEnterKey);
                    Keys.key_fire = false;
                }
                if (button == 3) {
                    iSelectedAction = 0;
                    Keys.key_left = true;
                    this.keyPressed(Keys.iLeftKey);
                    Keys.key_left = false;
                }
                if (button != 4) break;
                iSelectedAction = 0;
                Keys.key_right = true;
                this.keyPressed(Keys.iRightKey);
                Keys.key_right = false;
                break;
            }
            case 8: {
                iSelectedAction = Resources.WhichWelcomeButton(x, y);
                Keys.key_fire = true;
                this.keyPressed(Keys.iEnterKey);
                Keys.key_fire = false;
                break;
            }
            default: {
                Keys.key_fire = true;
                this.keyPressed(Keys.iEnterKey);
                Keys.key_fire = false;
            }
        }
    }

    public void pointerReleased(int x, int y) {
        bPlusPressed = false;
        bMinusPressed = false;
        iKeyPressedDelay = 0;
        if (mode == 6) {
            Keys.key_fire = true;
            this.keyPressed(Keys.iEnterKey);
            Keys.key_fire = false;
            iSelectedSubMenuItem = -1;
            canvas.repaint();
            canvas.serviceRepaints();
        }
        if (mode != 4) {
            // empty if block
        }
    }

    static {
        playerPanelYOffset = 0;
        tableYOffset = 0;
        DEFAULT_WAIT_TIME = 1;
        iBlickTime = 500;
        actualPlayer = 0;
        step = 0;
        iDistributionRound = 0;
        menuStrings = new String[3];
        actionStrings = new String[6];
        gameModeStrings = new String[9];
        sRewards = new String[6];
        quitMessage = new String[6];
        buyMore = new String[3];
        playOnNext = new String[3];
        iSelectedSubMenuItem = -1;
        bNextGameMode = false;
    }
}

