/*
 * Decompiled with CFR 0.152.
 */
package com.annimon;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.microedition.lcdui.Image;
import net.sf.zipme.CRC32;
import net.sf.zipme.Deflater;
import net.sf.zipme.DeflaterOutputStream;

public class PngWriter {
    private CRC32 crc;
    private int w;
    private int h;
    private boolean alpha;

    public void encode(DataOutputStream dos, Image img, boolean alpha) throws IOException {
        this.w = img.getWidth();
        this.h = img.getHeight();
        this.crc = new CRC32();
        this.alpha = alpha;
        ((OutputStream)dos).write(new byte[]{-119, 80, 78, 71, 13, 10, 26, 10});
        this.writeIHDR(dos);
        this.writeIDAT(dos, img);
        this.writeIEND(dos);
        this.crc = null;
        System.gc();
    }

    private void writeIHDR(DataOutputStream dos) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream b2 = new DataOutputStream(baos);
        ((OutputStream)b2).write(new byte[]{73, 72, 68, 82});
        b2.writeInt(this.w);
        b2.writeInt(this.h);
        b2.writeByte(8);
        b2.writeByte(this.alpha ? 6 : 2);
        b2.writeByte(0);
        b2.writeByte(0);
        b2.writeByte(0);
        b2.close();
        dos.writeInt(baos.size() - 4);
        ((OutputStream)dos).write(baos.toByteArray());
        this.crc.reset();
        this.crc.update(baos.toByteArray());
        dos.writeInt((int)this.crc.getValue());
    }

    private void writeIDAT(DataOutputStream dos, Image img) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream b2 = new DataOutputStream(baos);
        DeflaterOutputStream def = new DeflaterOutputStream(baos, new Deflater(9, false));
        int[] imageline = new int[this.w];
        byte[] byteline = new byte[this.w * (this.alpha ? 4 : 3) + 1];
        for (int y2 = 0; y2 < this.h; ++y2) {
            int index = 0;
            byteline[0] = 0;
            img.getRGB(imageline, 0, this.w, 0, y2, this.w, 1);
            for (int x2 = 0; x2 < this.w; ++x2) {
                byteline[++index] = (byte)(imageline[x2] >> 16 & 0xFF);
                byteline[++index] = (byte)(imageline[x2] >> 8 & 0xFF);
                byteline[++index] = (byte)(imageline[x2] & 0xFF);
                if (!this.alpha) continue;
                byteline[++index] = (byte)(imageline[x2] >> 24 & 0xFF);
            }
            def.write(byteline);
        }
        def.close();
        def = null;
        byte[] compressedLines = baos.toByteArray();
        int nCompressed = compressedLines.length;
        byte[] IDAT = new byte[]{73, 68, 65, 84};
        this.crc.reset();
        dos.writeInt(nCompressed);
        ((OutputStream)dos).write(IDAT);
        this.crc.update(IDAT);
        ((OutputStream)dos).write(compressedLines);
        this.crc.update(compressedLines, 0, nCompressed);
        dos.writeInt((int)this.crc.getValue());
        b2.close();
    }

    private void writeIEND(DataOutputStream dos) throws IOException {
        dos.writeInt(0);
        byte[] IEND = new byte[]{73, 69, 78, 68};
        ((OutputStream)dos).write(IEND);
        this.crc.reset();
        this.crc.update(IEND);
        dos.writeInt((int)this.crc.getValue());
    }
}

