/*
 * Decompiled with CFR 0.152.
 */
package net.sf.zipme;

import net.sf.zipme.Checksum;

public class CRC32
implements Checksum {
    private int crc = 0;
    private static int[] crc_table = CRC32.make_crc_table();

    private static int[] make_crc_table() {
        int[] crc_table = new int[256];
        for (int n2 = 0; n2 < 256; ++n2) {
            int c2 = n2;
            int k2 = 8;
            while (--k2 >= 0) {
                if ((c2 & 1) != 0) {
                    c2 = 0xEDB88320 ^ c2 >>> 1;
                    continue;
                }
                c2 >>>= 1;
            }
            crc_table[n2] = c2;
        }
        return crc_table;
    }

    public long getValue() {
        return (long)this.crc & 0xFFFFFFFFL;
    }

    public void reset() {
        this.crc = 0;
    }

    public void update(int bval) {
        int c2 = ~this.crc;
        c2 = crc_table[(c2 ^ bval) & 0xFF] ^ c2 >>> 8;
        this.crc = ~c2;
    }

    public void update(byte[] buf, int off, int len) {
        int c2 = ~this.crc;
        while (--len >= 0) {
            c2 = crc_table[(c2 ^ buf[off++]) & 0xFF] ^ c2 >>> 8;
        }
        this.crc = ~c2;
    }

    public void update(byte[] buf) {
        this.update(buf, 0, buf.length);
    }
}

