/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.io.file.FileSystemRegistry;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.TextBox;
import javax.microedition.media.MediaException;
import javax.microedition.midlet.MIDlet;

public class MiniXplorer
extends MIDlet
implements CommandListener {
    private String version = "1.0.2";
    private Command exit = new Command("Exit", 7, 13);
    private Command cmdBack = new Command("Back", 2, 12);
    private Command cmdAbout = new Command("About", 8, 11);
    private Command cmdDetail = new Command("Properties", 8, 10);
    private Command cmdRF = new Command("Rename", 8, 9);
    private Command cmdAddMark = new Command("Mark", 8, 8);
    private Command cmdRemMark = new Command("UnMark", 8, 8);
    private Command cmdMark = new Command("Mark Several", 8, 8);
    private Command cmdPaste = new Command("Paste", 8, 7);
    private Command cmdCut = new Command("Cut", 8, 6);
    private Command cmdCopy = new Command("Copy", 8, 5);
    private Command cmdDel = new Command("Delete", 8, 4);
    private Command cmdNewFile = new Command("New Text File", 8, 3);
    private Command cmdMkdir = new Command("New Folder", 8, 2);
    private Command cmdOpen = new Command("Open", 8, 1);
    private Command ConfYES = new Command("OK", 4, 1);
    private Command ConfNO = new Command("Cancel", 3, 2);
    private Command cmdStop = new Command("Stop", 6, 1);
    private Command cmdOK = new Command("OK", 4, 1);
    private Command cmdRFOK = new Command("OK", 4, 1);
    private Command cmdSaveAsOK = new Command("Save", 4, 1);
    private Command plyBack = new Command("Back", 7, 1);
    private Command cmdClose = new Command("Close", 7, 1);
    private Command cmdEdit = new Command("Edit", 4, 1);
    private Command cmdSave = new Command("Save", 4, 1);
    private Command cmdSaveAs = new Command("Save", 4, 1);
    private Command cmdNext = new Command("Next Page", 8, 1);
    private Command cmdPrev = new Command("Previous Page", 8, 1);
    private Command cmdGoto = new Command("Goto", 8, 1);
    private Command cmdToPage = new Command("Ok", 4, 1);
    private Command cmdChange = new Command("Ok", 4, 1);
    private static final String UP_DIRECTORY = "..";
    private static final String MEGA_ROOT = "/";
    private static final String SEP_STR = "/";
    private static final char SEP = '/';
    private String currDirName = "/";
    private String _Path;
    private String _Mode;
    private String txt;
    private String _textpath;
    private List fileList;
    private TextBox tb;
    private StringBuffer sb = new StringBuffer();
    private Vector currfile = new Vector();
    private FileCanvas canvas;
    private Vector arr;
    private int page;
    private int totalpage;
    public ChoiceGroup cRead;
    public ChoiceGroup cWrite;
    public ChoiceGroup cHidden;
    private String viewfile;

    public void startApp() {
        boolean isAPIAvailable = false;
        if (System.getProperty("microedition.io.file.FileConnection.version") != null) {
            isAPIAvailable = true;
            try {
                this.OpenDir();
            }
            catch (SecurityException e) {
            }
            catch (Exception e) {}
        } else {
            StringBuffer splashText = new StringBuffer(this.getAppProperty("MIDlet-Name")).append("\n").append(this.getAppProperty("MIDlet-Vendor")).append(isAPIAvailable ? "" : "\nFileConnection API not available");
            Alert splashScreen = new Alert(null, splashText.toString(), null, AlertType.INFO);
            splashScreen.setTimeout(3000);
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)splashScreen);
        }
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean cond) {
        this.notifyDestroyed();
    }

    public void MakeDirProc() {
        if ("".equals(this.tb.getString())) {
            this.msg("Error", "File/ Folder name can not be empty", -2, AlertType.ERROR);
        } else {
            this.createDIR("file://localhost/" + this.currDirName + this.tb.getString());
        }
        this.currfile.removeAllElements();
        this.OpenDir();
    }

    public void RenProc() {
        String newName = this.tb.getString();
        if ("".equals(newName)) {
            this.msg("Error", "File/ Folder name can not be empty", -2, AlertType.ERROR);
        } else {
            String currentPath = "file://localhost/" + this.currDirName + this.currfile.elementAt(0).toString();
            System.out.println(currentPath);
            FileConnection fc = null;
            try {
                fc = (FileConnection)Connector.open((String)currentPath, (int)3);
                fc.rename(this.tb.getString());
                fc.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        this.currfile.removeAllElements();
        this.OpenDir();
    }

    public void GetFileProc(String fpath, String Mode) {
        this._Path = fpath;
        this._Mode = Mode;
        this.fileList.removeCommand(this.cmdRF);
        this.fileList.removeCommand(this.cmdCut);
        this.fileList.removeCommand(this.cmdCopy);
        this.fileList.removeCommand(this.cmdMark);
        this.fileList.removeCommand(this.cmdDel);
        this.fileList.setSelectCommand(this.cmdOpen);
        this.fileList.addCommand(this.cmdMkdir);
        this.fileList.addCommand(this.cmdPaste);
        this.fileList.addCommand(this.cmdBack);
        this.fileList.addCommand(this.cmdAbout);
        this.fileList.addCommand(this.exit);
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.fileList);
    }

    public void msg(String title, String desc, int timeout, AlertType type) {
        Alert alert = new Alert(title, desc, null, null);
        alert.setTimeout(timeout);
        alert.setType(type);
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)alert);
    }

    public void createDIR(String dirname) {
        try {
            FileConnection conn = (FileConnection)Connector.open((String)dirname, (int)3);
            conn.mkdir();
            conn.close();
        }
        catch (IOException io) {
            this.msg("Error", "Some error have occur while creating the folder.", 3000, AlertType.ERROR);
            this.OpenDir();
        }
    }

    public void copyFILE(String fileFrom, String fileTo) {
        try {
            FileConnection src = (FileConnection)Connector.open((String)fileFrom, (int)1);
            FileConnection des = (FileConnection)Connector.open((String)fileTo, (int)3);
            if (!des.exists()) {
                des.create();
            }
            DataInputStream dis = src.openDataInputStream();
            DataOutputStream dos = des.openDataOutputStream();
            byte[] _buffer = new byte[1024];
            int len = 0;
            while ((len = dis.read(_buffer)) > 0) {
                dos.write(_buffer, 0, len);
            }
            dos.flush();
            dos.close();
            dis.close();
            des.close();
            src.close();
        }
        catch (IOException io) {
            this.msg("Error", "Some error have occur when copying the file.", 3000, AlertType.ERROR);
            this.OpenDir();
        }
    }

    public void removeItem(String url) {
        try {
            FileConnection conn = null;
            conn = (FileConnection)Connector.open((String)url);
            conn.delete();
            conn.close();
        }
        catch (IOException io) {
            this.msg("Error", "Some error have occur when deleting the folder.", 3000, AlertType.ERROR);
            this.OpenDir();
        }
    }

    public void copyDIR(String fromDir, String toDir) {
        boolean success;
        Enumeration e;
        Vector<String> b = new Vector<String>();
        Vector<String> c = new Vector<String>();
        try {
            FileConnection fc = (FileConnection)Connector.open((String)("file://localhost/" + this._Path + fromDir), (int)1);
            e = fc.list();
            fc.close();
            System.out.println("Buffer :file://localhost/" + this._Path + fromDir);
            if (e.hasMoreElements()) {
                while (e.hasMoreElements()) {
                    String f = (String)e.nextElement();
                    if (f.endsWith("/")) {
                        this.createDIR("file://localhost/" + this.currDirName + toDir + f);
                        b.addElement("file://localhost/" + this._Path + fromDir + f);
                        c.addElement("file://localhost/" + this.currDirName + toDir + f);
                        System.out.println("Create Dir: file://localhost/" + this.currDirName + toDir + f);
                        continue;
                    }
                    System.out.println("create file://localhost/" + this.currDirName + toDir + f);
                    this.copyFILE("file://localhost/" + this._Path + fromDir + f, "file://localhost/" + this.currDirName + toDir + f);
                }
            }
            success = true;
        }
        catch (IOException io) {
            success = false;
        }
        e = null;
        while (b.size() > 0) {
            String f = null;
            for (int i = 0; i < b.size(); ++i) {
                try {
                    FileConnection fc = (FileConnection)Connector.open((String)((String)b.elementAt(i)), (int)1);
                    e = fc.list();
                    fc.close();
                    if (e.hasMoreElements()) {
                        while (e.hasMoreElements()) {
                            f = (String)e.nextElement();
                            System.out.println("Content :" + (String)b.elementAt(i) + f);
                            if (f.endsWith("/")) {
                                this.createDIR((String)c.elementAt(i) + f);
                                b.addElement((String)b.elementAt(i) + f);
                                c.addElement((String)c.elementAt(i) + f);
                                System.out.println("Create sub DIR: " + (String)b.elementAt(i) + f);
                                continue;
                            }
                            this.copyFILE((String)b.elementAt(i) + f, (String)c.elementAt(i) + f);
                            System.out.println("Create file: " + (String)c.elementAt(i) + f);
                        }
                    }
                    b.removeElementAt(i);
                    c.removeElementAt(i);
                    success = true;
                    continue;
                }
                catch (IOException io) {
                    success = false;
                }
            }
        }
        if (success) {
            if ("CUT".equals(this._Mode) && success) {
                this.msg("Information", "Done", 3000, AlertType.INFO);
                new Thread(new Runnable(){

                    public void run() {
                        MiniXplorer.this.DelProc(MiniXplorer.this._Path);
                    }
                }).start();
            } else if ("COPY".equals(this._Mode) && success) {
                this._Mode = null;
                this.currfile.removeAllElements();
                this.msg("Information", "Done", 3000, AlertType.INFO);
                this.OpenDir();
            }
        } else {
            this.currfile.removeAllElements();
            this.msg("Error", "Some file missing", 3000, AlertType.ERROR);
            this.OpenDir();
        }
    }

    public void delDIR(String p) {
        Vector<String> b = new Vector<String>();
        try {
            FileConnection fc = (FileConnection)Connector.open((String)p);
            Enumeration e = fc.list();
            if (e.hasMoreElements()) {
                while (e.hasMoreElements()) {
                    String fn = (String)e.nextElement();
                    if (fn.endsWith("/")) {
                        b.addElement(p + fn);
                        System.out.println(p + fn);
                        continue;
                    }
                    this.removeItem(p + fn);
                    System.out.println(p + fn);
                }
            } else {
                this.removeItem(p);
            }
            e = null;
            while (fc.exists()) {
                if (b.size() > 0) {
                    for (int i = 0; i < b.size(); ++i) {
                        try {
                            FileConnection f = (FileConnection)Connector.open((String)b.elementAt(i).toString());
                            e = f.list();
                            f.close();
                            System.out.println("scan " + b.elementAt(i).toString());
                            if (e.hasMoreElements()) {
                                while (e.hasMoreElements()) {
                                    String fn = (String)e.nextElement();
                                    if (fn.endsWith("/")) {
                                        String temp = b.elementAt(i).toString();
                                        b.addElement(temp + fn);
                                        continue;
                                    }
                                    this.removeItem(b.elementAt(i).toString() + fn);
                                }
                            } else {
                                System.out.println("remove " + b.elementAt(i).toString() + ": b SIZE=" + b.size());
                                this.removeItem(b.elementAt(i).toString());
                                b.removeElementAt(i);
                            }
                        }
                        catch (IOException io) {
                            b.removeElementAt(i);
                        }
                        e = null;
                    }
                    continue;
                }
                System.out.println("remove main");
                this.removeItem(p);
            }
            fc.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void PasteProc() {
        boolean success = false;
        for (int i = 0; i < this.currfile.size(); ++i) {
            try {
                if (this.currfile.elementAt(i).toString().endsWith("/")) {
                    FileConnection fc = (FileConnection)Connector.open((String)("file://localhost/" + this.currDirName + this.currfile.elementAt(i).toString()), (int)3);
                    if (!fc.exists()) {
                        fc.mkdir();
                        this.copyDIR(this.currfile.elementAt(i).toString(), this.currfile.elementAt(i).toString());
                    } else {
                        fc = (FileConnection)Connector.open((String)("file://localhost/" + this.currDirName + "Copy of " + this.currfile.elementAt(i).toString()), (int)3);
                        fc.mkdir();
                        this.copyDIR(this.currfile.elementAt(i).toString(), "Copy of " + this.currfile.elementAt(i).toString());
                    }
                    fc.close();
                    success = true;
                    continue;
                }
                FileConnection des = (FileConnection)Connector.open((String)("file://localhost/" + this.currDirName + this.currfile.elementAt(i).toString()), (int)3);
                if (!des.exists()) {
                    this.copyFILE("file://localhost/" + this._Path + this.currfile.elementAt(i).toString(), "file://localhost/" + this.currDirName + this.currfile.elementAt(i).toString());
                } else {
                    this.copyFILE("file://localhost/" + this._Path + this.currfile.elementAt(i).toString(), "file://localhost/" + this.currDirName + "Copy of " + this.currfile.elementAt(i).toString());
                }
                success = true;
                continue;
            }
            catch (IOException ex) {
                this.msg("Error", ex.toString(), -2, AlertType.ERROR);
            }
        }
        if ("CUT".equals(this._Mode) && success) {
            this.msg("Information", "Done", 3000, AlertType.INFO);
            new Thread(new Runnable(){

                public void run() {
                    MiniXplorer.this.DelProc(MiniXplorer.this._Path);
                }
            }).start();
        } else if ("COPY".equals(this._Mode) && success) {
            this._Mode = null;
            this.currfile.removeAllElements();
            this.msg("Information", "Done", 3000, AlertType.INFO);
            this.OpenDir();
        }
        success = false;
    }

    public void DelProc(String _DIR) {
        for (int i = 0; i < this.currfile.size(); ++i) {
            if (this.currfile.elementAt(i).toString().endsWith("/")) {
                this.delDIR("file://localhost/" + _DIR + this.currfile.elementAt(i).toString());
                continue;
            }
            this.removeItem("file://localhost/" + _DIR + this.currfile.elementAt(i).toString());
        }
        if (this._Mode != null) {
            this._Mode = null;
            this._Path = null;
        }
        this.currfile.removeAllElements();
        this.OpenDir();
    }

    public void MarkProc(String f, List c) {
        if (UP_DIRECTORY.equals(f)) {
            new Thread(new Runnable(){

                public void run() {
                    MiniXplorer.this.traverseDirectory(MiniXplorer.UP_DIRECTORY);
                }
            }).start();
        } else if (f.charAt(f.length() - 1) == '/') {
            this.currfile.addElement(f);
        } else {
            this.currfile.addElement(f);
            this.fileList.setSelectCommand(this.cmdAddMark);
            this.fileList.addCommand(this.cmdRemMark);
            this.fileList.removeCommand(this.cmdMark);
            this.fileList.removeCommand(this.cmdRF);
            this.fileList.removeCommand(this.cmdOpen);
            this.fileList.removeCommand(this.cmdMkdir);
            this.fileList.setCommandListener((CommandListener)this);
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.fileList);
            try {
                c.set(c.getSelectedIndex(), c.getString(c.getSelectedIndex()), Image.createImage((String)"/resource/mark.png"));
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void OpenDir() {
        Vector<String> folder = new Vector<String>();
        Vector<String> file = new Vector<String>();
        this.fileList = new List(this.currDirName, 3);
        try {
            Enumeration e;
            if ("/".equals(this.currDirName)) {
                e = FileSystemRegistry.listRoots();
            } else {
                FileConnection fc = (FileConnection)Connector.open((String)("file://localhost/" + this.currDirName));
                e = fc.list("*", true);
                this.fileList.append(UP_DIRECTORY, Image.createImage((String)"/resource/folderup.png"));
                if (fc != null) {
                    fc.close();
                }
                if ("CUT".equals(this._Mode) || "COPY".equals(this._Mode)) {
                    this.fileList.addCommand(this.cmdPaste);
                } else {
                    this.fileList.addCommand(this.cmdMark);
                    this.fileList.addCommand(this.cmdCopy);
                    this.fileList.addCommand(this.cmdCut);
                    this.fileList.addCommand(this.cmdRF);
                    this.fileList.addCommand(this.cmdDel);
                    this.fileList.addCommand(this.cmdNewFile);
                    this.fileList.addCommand(this.cmdDetail);
                }
                this.fileList.addCommand(this.cmdMkdir);
                this.fileList.addCommand(this.cmdBack);
            }
            while (e.hasMoreElements()) {
                String fileName = (String)e.nextElement();
                if (fileName.charAt(fileName.length() - 1) == '/') {
                    folder.addElement(fileName);
                    continue;
                }
                file.addElement(fileName);
            }
            for (int i = 0; i < folder.size(); ++i) {
                this.fileList.append(folder.elementAt(i).toString(), Image.createImage((String)"/resource/folder.png"));
            }
            for (int j = 0; j < file.size(); ++j) {
                String fileName = file.elementAt(j).toString();
                if (fileName.endsWith("mp3") || fileName.endsWith("MP3") || fileName.endsWith("wma") || fileName.endsWith("WMA") || fileName.endsWith("amr") || fileName.endsWith("AMR")) {
                    this.fileList.append(fileName, Image.createImage((String)"/resource/music.png"));
                    continue;
                }
                if (fileName.endsWith("MP4") || fileName.endsWith("mp4") || fileName.endsWith("3gp") || fileName.endsWith("3GP")) {
                    this.fileList.append(fileName, Image.createImage((String)"/resource/movie.png"));
                    continue;
                }
                if (fileName.endsWith("jpg") || fileName.endsWith("JPG") || fileName.endsWith("png") || fileName.endsWith("PNG")) {
                    this.fileList.append(fileName, Image.createImage((String)"/resource/image.png"));
                    continue;
                }
                if (fileName.endsWith("zip") || fileName.endsWith("ZIP")) {
                    this.fileList.append(fileName, Image.createImage((String)"/resource/zip.png"));
                    continue;
                }
                if (fileName.endsWith("rar") || fileName.endsWith("RAR")) {
                    this.fileList.append(fileName, Image.createImage((String)"/resource/rar.png"));
                    continue;
                }
                this.fileList.append(fileName, Image.createImage((String)"/resource/file.png"));
            }
            this.fileList.setSelectCommand(this.cmdOpen);
            this.fileList.addCommand(this.cmdAbout);
            this.fileList.addCommand(this.exit);
            this.fileList.setCommandListener((CommandListener)this);
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.fileList);
        }
        catch (IOException ioe) {
            // empty catch block
        }
    }

    public void traverseDirectory(String fileName) {
        if (this.currDirName.equals("/")) {
            if (fileName.equals(UP_DIRECTORY)) {
                return;
            }
            this.currDirName = fileName;
        } else {
            int i;
            this.currDirName = fileName.equals(UP_DIRECTORY) ? ((i = this.currDirName.lastIndexOf(47, this.currDirName.length() - 2)) != -1 ? this.currDirName.substring(0, i + 1) : "/") : this.currDirName + fileName;
        }
        this.OpenDir();
    }

    public void ProgForm(String a) {
        Form myForm = new Form("Progress");
        Gauge bar = new Gauge(a, false, -1, 2);
        myForm.append((Item)bar);
        myForm.addCommand(this.cmdStop);
        myForm.setCommandListener((CommandListener)this);
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)myForm);
    }

    public String getFileSize(long a) {
        String memoryType = "bytes";
        long fSize = a;
        memoryType = fSize >= 1024000L ? "MB" : (fSize >= 1024L ? "KB" : "bytes");
        while (fSize > 1024L) {
            fSize /= 1024L;
        }
        return fSize + memoryType;
    }

    public String Dateformat(String a) {
        String b = a;
        Vector<String> c = new Vector<String>();
        String temp = "";
        for (int i = 0; i < b.length(); ++i) {
            if (b.charAt(i) != ' ') {
                temp = temp + b.charAt(i);
                if (i + 1 != b.length()) continue;
                c.addElement(temp);
                temp = "";
                continue;
            }
            c.addElement(temp);
            temp = "";
        }
        return c.elementAt(2) + " " + c.elementAt(1) + " " + c.elementAt(5) + " " + c.elementAt(3);
    }

    public void viewDIRDetail(String a) {
        Enumeration e;
        Vector<String> b = new Vector<String>();
        long size = 0L;
        int totalfolder = 0;
        int totalfile = 0;
        try {
            FileConnection fc = (FileConnection)Connector.open((String)("file://localhost/" + this.currDirName + a), (int)1);
            e = fc.list();
            fc.close();
            if (e.hasMoreElements()) {
                while (e.hasMoreElements()) {
                    String f = (String)e.nextElement();
                    if (f.endsWith("/")) {
                        b.addElement("file://localhost/" + this.currDirName + a + f);
                        ++totalfolder;
                        continue;
                    }
                    fc = (FileConnection)Connector.open((String)("file://localhost/" + this.currDirName + a + f), (int)1);
                    size += fc.fileSize();
                    ++totalfile;
                    fc.close();
                }
            }
        }
        catch (IOException io) {
            // empty catch block
        }
        e = null;
        while (b.size() > 0) {
            String f = null;
            for (int i = 0; i < b.size(); ++i) {
                try {
                    FileConnection fc = (FileConnection)Connector.open((String)((String)b.elementAt(i)), (int)1);
                    e = fc.list();
                    fc.close();
                    if (e.hasMoreElements()) {
                        while (e.hasMoreElements()) {
                            f = (String)e.nextElement();
                            if (f.endsWith("/")) {
                                b.addElement((String)b.elementAt(i) + f);
                                ++totalfolder;
                                continue;
                            }
                            fc = (FileConnection)Connector.open((String)((String)b.elementAt(i) + f), (int)1);
                            size += fc.fileSize();
                            ++totalfile;
                            fc.close();
                        }
                    }
                    b.removeElementAt(i);
                    continue;
                }
                catch (IOException io) {
                    // empty catch block
                }
            }
        }
        Form myform = new Form("Properties");
        myform.append("Contains:\n" + totalfile + " Files, " + totalfolder + " Folders\n\n" + "File Size:\n" + this.getFileSize(size) + "\n\n");
        myform.addCommand(this.cmdClose);
        myform.setCommandListener((CommandListener)this);
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)myform);
    }

    public void viewDetail(String f) {
        try {
            if (f.endsWith("/")) {
                this.viewDIRDetail(f);
            } else {
                this.viewfile = f;
                FileConnection fc = (FileConnection)Connector.open((String)("file://localhost/" + this.currDirName + f));
                this.cRead = new ChoiceGroup("Readable", 1);
                this.cWrite = new ChoiceGroup("Writable", 1);
                this.cHidden = new ChoiceGroup("Hidden", 1);
                String size = this.getFileSize(fc.fileSize());
                Date d = new Date(fc.lastModified());
                String type = f.substring(f.length() - 3, f.length());
                this.cRead.append("Yes", null);
                this.cRead.append("No ", null);
                this.cRead.setSelectedIndex(1, true);
                this.cWrite.append("Yes", null);
                this.cWrite.append("No", null);
                this.cWrite.setSelectedIndex(1, true);
                this.cHidden.append("Yes", null);
                this.cHidden.append("No", null);
                this.cHidden.setSelectedIndex(1, true);
                if (fc.canRead()) {
                    this.cRead.setSelectedIndex(0, true);
                }
                if (fc.canWrite()) {
                    this.cWrite.setSelectedIndex(0, true);
                }
                if (fc.isHidden()) {
                    this.cHidden.setSelectedIndex(0, true);
                }
                fc.close();
                Form myform = new Form("Properties");
                myform.append("Filename:\n" + f + "\n\n" + "File Size:\n" + size + "\n\n" + "File Type:\n" + type.toUpperCase() + "\n\n" + "Date Modified:\n" + this.Dateformat(d.toString()) + "\n\n");
                myform.append((Item)this.cRead);
                myform.append((Item)this.cWrite);
                myform.append((Item)this.cHidden);
                myform.addCommand(this.cmdClose);
                myform.addCommand(this.cmdChange);
                myform.setCommandListener((CommandListener)this);
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)myform);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void changeProperties(String f) {
        try {
            FileConnection fc = (FileConnection)Connector.open((String)("file://localhost/" + this.currDirName + f));
            if (this.cRead.getSelectedIndex() == 0) {
                fc.setReadable(true);
            } else {
                fc.setReadable(false);
            }
            if (this.cWrite.getSelectedIndex() == 0) {
                fc.setWritable(true);
            } else {
                fc.setWritable(false);
            }
            if (this.cHidden.getSelectedIndex() == 0) {
                fc.setHidden(true);
            } else {
                fc.setHidden(false);
            }
            fc.close();
            fc = null;
            this.viewfile = "";
            this.OpenDir();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void ToPage() {
        this.page = Integer.parseInt(this.tb.getString()) - 1;
        if (this.page < 0 || this.page > this.totalpage) {
            this.msg("Warning", "Page doesn't exists! Enter from 1 - " + this.totalpage, -2, AlertType.WARNING);
        } else {
            Form myTxt = new Form("Page " + (this.page + 1) + " of " + this.totalpage);
            myTxt.append((String)this.arr.elementAt(this.page));
            myTxt.addCommand(this.cmdClose);
            myTxt.addCommand(this.cmdEdit);
            if (this.page + 1 < this.totalpage) {
                myTxt.addCommand(this.cmdNext);
            } else {
                myTxt.removeCommand(this.cmdNext);
            }
            if (this.page > 0) {
                myTxt.addCommand(this.cmdPrev);
            } else {
                myTxt.removeCommand(this.cmdPrev);
            }
            myTxt.addCommand(this.cmdGoto);
            myTxt.setCommandListener((CommandListener)this);
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)myTxt);
        }
    }

    public void readTXT(String f) {
        InputStream is = null;
        this.sb = new StringBuffer();
        this._textpath = "file://localhost/" + this.currDirName + f;
        try {
            FileConnection fc = (FileConnection)Connector.open((String)this._textpath);
            if (!fc.exists()) {
                throw new IOException("File does not exists");
            }
            is = fc.openInputStream();
            InputStreamReader r = new InputStreamReader(is, "UTF-8");
            int c = 0;
            while ((c = ((Reader)r).read()) != -1) {
                this.sb.append((char)c);
            }
            int offset = 0;
            int limit = 1000;
            String t = this.sb.toString();
            int s = 1;
            if (t.length() > limit) {
                s = t.length() / limit;
            }
            if (s * limit < t.length()) {
                ++s;
            }
            this.totalpage = s;
            this.page = 0;
            this.arr = new Vector();
            while (s > 0) {
                int start = offset;
                if (t.length() > limit) {
                    if ((offset += limit) > t.length()) {
                        offset = t.length();
                    }
                } else {
                    offset = t.length();
                }
                this.arr.addElement(t.substring(start, offset));
                --s;
            }
            Form myTxt = new Form(f);
            myTxt.append((String)this.arr.elementAt(0));
            myTxt.addCommand(this.cmdClose);
            myTxt.addCommand(this.cmdEdit);
            if (this.totalpage > 1) {
                myTxt.addCommand(this.cmdNext);
                myTxt.addCommand(this.cmdGoto);
            }
            myTxt.setCommandListener((CommandListener)this);
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)myTxt);
            ((Reader)r).close();
            is.close();
            fc.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void editTXT(String e) {
        this.tb = new TextBox("Text Editor", e, e.length() + 2048, 0);
        this.tb.removeCommand(this.cmdEdit);
        this.tb.addCommand(this.cmdSave);
        this.tb.addCommand(this.ConfNO);
        this.tb.setCommandListener((CommandListener)this);
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.tb);
    }

    public void saveTXT(String s) {
        FileConnection fc = null;
        OutputStream os = null;
        OutputStreamWriter w = null;
        if (!"NEW".equals(this._Mode)) {
            this.removeItem(this._textpath);
        }
        try {
            fc = (FileConnection)Connector.open((String)this._textpath, (int)3);
            if (!fc.exists()) {
                fc.create();
            } else {
                String addStr = "(1)";
                int i = 1;
                String temp = this._textpath.toString();
                temp = temp.substring(0, temp.length() - 4);
                while (fc.exists()) {
                    fc = (FileConnection)Connector.open((String)(temp + addStr + ".txt"), (int)3);
                    addStr = "(" + ++i + ")";
                }
                fc.create();
            }
            os = fc.openOutputStream();
            w = new OutputStreamWriter(os, "UTF-8");
            w.write(s, 0, s.length());
            w.flush();
            w.close();
            fc.close();
            this.txt = null;
            this._textpath = null;
            this._Mode = null;
            this.msg("Information", "Done", 3000, AlertType.INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.OpenDir();
    }

    public void newTXT() {
        this.tb = new TextBox("Text Editor", "", 1024, 0);
        this.tb.addCommand(this.cmdSaveAs);
        this.tb.addCommand(this.ConfNO);
        this.tb.setCommandListener((CommandListener)this);
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.tb);
    }

    public void saveAsTXT() {
        this.txt = this.tb.getString();
        this.tb = new TextBox("Save as name", "Untitled", 512, 0);
        this.tb.addCommand(this.cmdSaveAsOK);
        this.tb.setCommandListener((CommandListener)this);
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.tb);
    }

    public void getNewTextInfo() {
        this._textpath = "file://localhost/" + this.currDirName + this.tb.getString() + ".txt";
        this.ProgForm("Saving");
        this._Mode = "NEW";
        new Thread(new Runnable(){

            public void run() {
                MiniXplorer.this.saveTXT(MiniXplorer.this.txt);
            }
        }).start();
    }

    public void playMediaFile(String f, String t) throws IOException {
        try {
            FileConnection fc = (FileConnection)Connector.open((String)("file://localhost/" + this.currDirName + f), (int)1);
            long size = fc.fileSize();
            this.canvas = new FileCanvas();
            Date d = new Date(fc.lastModified());
            fc.close();
            this.canvas.playMedia("file://localhost/" + this.currDirName, f, size, t);
            this.canvas.setFullScreenMode(true);
            this.canvas.addCommand(this.plyBack);
            this.canvas.setCommandListener(this);
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.canvas);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void viewImage(String f) {
        InputStream dis = null;
        ByteArrayOutputStream output = new ByteArrayOutputStream(1024);
        long fs = 0L;
        byte[] buffer = new byte[1024];
        byte[] imageData = null;
        try {
            FileConnection fc = (FileConnection)Connector.open((String)("file://localhost/" + this.currDirName + f), (int)1);
            fs = fc.fileSize();
            if (fs <= 256000L && fs > 0L) {
                int ch;
                this.ProgForm("Creating thumnail, please wait...");
                dis = fc.openInputStream();
                while ((ch = dis.read(buffer)) > 0) {
                    output.write(buffer, 0, ch);
                    imageData = output.toByteArray();
                }
                output.close();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        if (fs <= 256000L && fs > 0L) {
            this.canvas = new FileCanvas();
            this.canvas.setImage(imageData);
            this.canvas.setFullScreenMode(true);
            this.canvas.addCommand(this.cmdClose);
            this.canvas.setCommandListener(this);
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.canvas);
        } else {
            this.msg("Error", "Image is too large to be display.", -2, AlertType.WARNING);
        }
    }

    public void commandAction(Command c, Displayable d) {
        if (c == this.cmdOpen) {
            List curr = (List)d;
            final String[] currFile = new String[]{curr.getString(curr.getSelectedIndex())};
            new Thread(new Runnable(){

                public void run() {
                    if (currFile[0].endsWith("/") || currFile[0].equals(MiniXplorer.UP_DIRECTORY)) {
                        MiniXplorer.this.traverseDirectory(currFile[0]);
                    } else if (currFile[0].endsWith("TXT") || currFile[0].endsWith("txt") || currFile[0].endsWith("INI") || currFile[0].endsWith("ini") || currFile[0].endsWith("lrc") || currFile[0].endsWith("LRC")) {
                        MiniXplorer.this.ProgForm("Reading");
                        MiniXplorer.this.readTXT(currFile[0]);
                    } else if (currFile[0].endsWith("mp3") || currFile[0].endsWith("MP3") || currFile[0].endsWith("wma") || currFile[0].endsWith("WMA") || currFile[0].endsWith("amr") || currFile[0].endsWith("AMR")) {
                        try {
                            MiniXplorer.this.playMediaFile(currFile[0].toString(), "audio");
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                        }
                    } else if (currFile[0].endsWith("mp4") || currFile[0].endsWith("MP4") || currFile[0].endsWith("3gp") || currFile[0].endsWith("3GP")) {
                        try {
                            MiniXplorer.this.playMediaFile(currFile[0].toString(), "video");
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                        }
                    } else if (currFile[0].endsWith("jpg") || currFile[0].endsWith("JPG") || currFile[0].endsWith("gif") || currFile[0].endsWith("GIF") || currFile[0].endsWith("png") || currFile[0].endsWith("PNG")) {
                        MiniXplorer.this.viewImage(currFile[0].toString());
                    }
                }
            }).start();
        } else if (c == this.cmdGoto) {
            this.tb = new TextBox("Goto", "", 10, 2);
            this.tb.addCommand(this.cmdToPage);
            this.tb.addCommand(this.ConfNO);
            this.tb.setCommandListener((CommandListener)this);
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.tb);
        } else if (c == this.cmdToPage) {
            new Thread(new Runnable(){

                public void run() {
                    MiniXplorer.this.ToPage();
                }
            }).start();
        } else if (c == this.cmdNext) {
            ++this.page;
            Form myTxt = new Form("Page " + (this.page + 1) + " of " + this.totalpage);
            myTxt.append((String)this.arr.elementAt(this.page));
            myTxt.addCommand(this.cmdClose);
            myTxt.addCommand(this.cmdEdit);
            if (this.page + 1 < this.totalpage) {
                myTxt.addCommand(this.cmdNext);
            } else {
                myTxt.removeCommand(this.cmdNext);
            }
            if (this.page > 0) {
                myTxt.addCommand(this.cmdPrev);
            } else {
                myTxt.removeCommand(this.cmdPrev);
            }
            if (this.totalpage > 1) {
                myTxt.addCommand(this.cmdGoto);
            } else {
                myTxt.removeCommand(this.cmdGoto);
            }
            myTxt.setCommandListener((CommandListener)this);
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)myTxt);
        } else if (c == this.cmdPrev) {
            --this.page;
            Form myTxt = new Form("Page " + (this.page + 1) + " of " + this.totalpage);
            myTxt.append((String)this.arr.elementAt(this.page));
            myTxt.addCommand(this.cmdClose);
            myTxt.addCommand(this.cmdEdit);
            if (this.page + 1 < this.totalpage) {
                myTxt.addCommand(this.cmdNext);
            } else {
                myTxt.removeCommand(this.cmdNext);
            }
            if (this.page > 0) {
                myTxt.addCommand(this.cmdPrev);
            } else {
                myTxt.removeCommand(this.cmdPrev);
            }
            if (this.totalpage > 1) {
                myTxt.addCommand(this.cmdGoto);
            } else {
                myTxt.removeCommand(this.cmdGoto);
            }
            myTxt.setCommandListener((CommandListener)this);
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)myTxt);
        } else if (c == this.plyBack) {
            try {
                this.canvas.getPlayer().stop();
                this.canvas.getPlayer().deallocate();
                this.canvas.getPlayer().close();
                this.canvas = null;
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.fileList);
            }
            catch (MediaException me) {}
        } else if (c == this.cmdDetail) {
            List curr = (List)d;
            final String f = curr.getString(curr.getSelectedIndex());
            new Thread(new Runnable(){

                public void run() {
                    MiniXplorer.this.viewDetail(f);
                }
            }).start();
        } else if (c == this.cmdChange) {
            new Thread(new Runnable(){

                public void run() {
                    MiniXplorer.this.changeProperties(MiniXplorer.this.viewfile);
                }
            }).start();
        } else if (c == this.cmdEdit) {
            this.ProgForm("Open Editor");
            new Thread(new Runnable(){

                public void run() {
                    MiniXplorer.this.editTXT(MiniXplorer.this.sb.toString());
                }
            }).start();
        } else if (c == this.cmdSave) {
            this.ProgForm("Saving");
            new Thread(new Runnable(){

                public void run() {
                    MiniXplorer.this.saveTXT(MiniXplorer.this.tb.getString());
                }
            }).start();
        } else if (c == this.cmdNewFile) {
            this.newTXT();
        } else if (c == this.cmdSaveAs) {
            this.saveAsTXT();
        } else if (c == this.cmdSaveAsOK) {
            this.getNewTextInfo();
        } else if (c == this.cmdClose) {
            this._textpath = "";
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.fileList);
        } else if (c == this.cmdDel) {
            List curr = (List)d;
            if (this.currfile.size() < 1) {
                this.currfile.addElement(curr.getString(curr.getSelectedIndex()));
            }
            if (UP_DIRECTORY.equals(this.currfile.elementAt(0))) {
                this.msg("Error", "Delete is not possible!", -2, AlertType.WARNING);
                this.currfile.removeAllElements();
            } else {
                Alert alert = new Alert("Confirmation", "Are you sure want to delete the selected file(s)?", null, null);
                alert.setTimeout(-2);
                alert.setType(AlertType.WARNING);
                alert.addCommand(this.ConfYES);
                alert.addCommand(this.ConfNO);
                alert.setCommandListener((CommandListener)this);
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)alert);
            }
        } else if (c == this.ConfYES) {
            new Thread(new Runnable(){

                public void run() {
                    MiniXplorer.this.DelProc(MiniXplorer.this.currDirName);
                }
            }).start();
        } else if (c == this.ConfNO) {
            new Thread(new Runnable(){

                public void run() {
                    MiniXplorer.this.OpenDir();
                }
            }).start();
        } else if (c == this.cmdStop) {
            new Thread(new Runnable(){

                public void run() {
                    MiniXplorer.this.OpenDir();
                }
            }).start();
        } else if (c == this.cmdCopy) {
            List curr = (List)d;
            if (this.currfile.size() < 1) {
                this.currfile.addElement(curr.getString(curr.getSelectedIndex()));
            }
            if (UP_DIRECTORY.equals(this.currfile.elementAt(0))) {
                this.msg("Error", "Copy is not possible!", -2, AlertType.WARNING);
                this.currfile.removeAllElements();
            } else {
                new Thread(new Runnable(){

                    public void run() {
                        MiniXplorer.this.GetFileProc(MiniXplorer.this.currDirName, "COPY");
                    }
                }).start();
            }
        } else if (c == this.cmdCut) {
            List curr = (List)d;
            if (this.currfile.size() < 1) {
                this.currfile.addElement(curr.getString(curr.getSelectedIndex()));
            }
            if (UP_DIRECTORY.equals(this.currfile.elementAt(0))) {
                this.msg("Error", "Cut is not possible!", -2, AlertType.WARNING);
                this.currfile.removeAllElements();
            } else {
                new Thread(new Runnable(){

                    public void run() {
                        MiniXplorer.this.GetFileProc(MiniXplorer.this.currDirName, "CUT");
                    }
                }).start();
            }
        } else if (c == this.cmdPaste) {
            if (this.currfile.size() > 0) {
                String op = null;
                op = "CUT".equals(this._Mode) ? "Moving" : "Copying";
                this.ProgForm(op);
                new Thread(new Runnable(){

                    public void run() {
                        MiniXplorer.this.PasteProc();
                    }
                }).start();
            }
        } else if (c == this.cmdRFOK) {
            new Thread(new Runnable(){

                public void run() {
                    MiniXplorer.this.RenProc();
                }
            }).start();
        } else if (c == this.cmdRF) {
            List curr = (List)d;
            this.currfile.addElement(curr.getString(curr.getSelectedIndex()));
            if (UP_DIRECTORY.equals(curr.getString(curr.getSelectedIndex()))) {
                this.msg("Error", "Rename is not possible!", -2, AlertType.WARNING);
                this.currfile.removeAllElements();
            } else {
                this.tb = new TextBox("New File Name", curr.getString(curr.getSelectedIndex()), 1024, 0);
                this.tb.addCommand(this.cmdRFOK);
                this.tb.addCommand(this.ConfNO);
                this.tb.setCommandListener((CommandListener)this);
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.tb);
            }
        } else if (c == this.cmdMkdir) {
            this.tb = new TextBox("New Folder Name", "New Folder", 1024, 0);
            this.tb.addCommand(this.cmdOK);
            this.tb.addCommand(this.ConfNO);
            this.tb.setCommandListener((CommandListener)this);
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.tb);
        } else if (c == this.cmdOK) {
            new Thread(new Runnable(){

                public void run() {
                    MiniXplorer.this.MakeDirProc();
                }
            }).start();
        } else if (c == this.cmdMark) {
            List curr = (List)d;
            String _FILE = curr.getString(curr.getSelectedIndex());
            this.MarkProc(_FILE, curr);
        } else if (c == this.cmdAddMark) {
            List curr = (List)d;
            String _FILE = curr.getString(curr.getSelectedIndex());
            this.MarkProc(_FILE, curr);
        } else if (c == this.cmdRemMark) {
            List curr = (List)d;
            if (UP_DIRECTORY.equals(curr.getString(curr.getSelectedIndex()))) {
                new Thread(new Runnable(){

                    public void run() {
                        MiniXplorer.this.traverseDirectory(MiniXplorer.UP_DIRECTORY);
                    }
                }).start();
            } else {
                this.currfile.removeElement(curr.getString(curr.getSelectedIndex()));
                try {
                    curr.set(curr.getSelectedIndex(), curr.getString(curr.getSelectedIndex()), Image.createImage((String)"/resource/file.png"));
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                if (this.currfile.size() < 1) {
                    this.fileList.removeCommand(this.cmdRemMark);
                    this.fileList.removeCommand(this.cmdMark);
                    this.fileList.addCommand(this.cmdMark);
                    if ("CUT".equals(this._Mode) || "COPY".equals(this._Mode)) {
                        this.fileList.addCommand(this.cmdPaste);
                    }
                    this.fileList.setCommandListener((CommandListener)this);
                    Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.fileList);
                }
            }
        } else if (c == this.cmdAbout) {
            Form myform = new Form("About");
            myform.append("MiniXplorer Version " + this.version + "\n\rDeveloped by Jason Lee (KK)\n\rCopyright (c) Jason Lee. All right reserved.");
            myform.addCommand(this.ConfNO);
            myform.setCommandListener((CommandListener)this);
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)myform);
        } else if (c == this.cmdBack) {
            new Thread(new Runnable(){

                public void run() {
                    MiniXplorer.this.traverseDirectory(MiniXplorer.UP_DIRECTORY);
                }
            }).start();
        } else if (c == this.exit) {
            this.destroyApp(false);
        }
    }
}

