/*
 * Decompiled with CFR 0.152.
 */
package movilib;

import app.MainMenu;
import javax.microedition.lcdui.Graphics;
import movilib.ANIManager;
import movilib.SPRManager;
import movilib.Sprite;
import movilib.SpriteImage;

public class SpriteLayer {
    public static final int COD_EMPTY = -1;
    public static final int COD_RESERVED = -2;
    public int maxSprites;
    public Sprite[] sprites;
    public int y0;

    public SpriteLayer(int maxSprites) {
        this.maxSprites = maxSprites;
        this.sprites = new Sprite[maxSprites];
        for (int i = 0; i < maxSprites; ++i) {
            this.sprites[i] = new Sprite();
            this.sprites[i].status = 0;
        }
    }

    public void clear() {
        if (this.sprites != null) {
            for (int i = 0; i < this.maxSprites; ++i) {
                if (this.sprites[i] != null) {
                    this.sprites[i].unload();
                }
                this.sprites[i] = null;
            }
            this.sprites = null;
        }
    }

    public int addSprite(SPRManager sprman, int ind, int id, int x, int y, int flags, int code) {
        if (ind == -1) {
            for (ind = 0; ind < this.maxSprites && this.sprites[ind].status != 0; ++ind) {
            }
            if (ind >= this.maxSprites) {
                return -1;
            }
        }
        if (ind != -1) {
            Sprite spr = this.sprites[ind];
            if (id == -1) {
                spr.status = 1;
                spr.ind = (short)-1;
            } else {
                spr.status = (byte)2;
                spr.ind = (short)sprman.findSprite(id);
            }
            spr.sprman = sprman;
            spr.ani = null;
            spr.x = x;
            spr.y = y;
            spr.dy = 0;
            spr.dx = 0;
            spr.flags = (byte)flags;
            spr.code = (short)code;
        }
        return ind;
    }

    public short addAnimation(ANIManager animan, int ind, int id, int x, int y, int flags, int code, int speed) {
        if ((ind = this.addSprite(animan.sprman, ind, 0, x, y, 0, code)) != -1) {
            this.changeAnimation(ind, animan, id, flags, code, speed);
        }
        return (short)ind;
    }

    public void removeSprite(int ind) {
        this.sprites[ind].status = 0;
    }

    public void removeAllSprites() {
        if (this.sprites != null) {
            for (int i = 0; i < this.maxSprites; ++i) {
                if (this.sprites[i] == null) continue;
                this.sprites[i].status = 0;
            }
        }
    }

    public void setMove(int ind, int dx, int dy) {
        this.sprites[ind].dx = dx;
        this.sprites[ind].dy = dy;
    }

    public void setMoveTo(int ind, int destX, int destY, int speed) {
        int distX = destX - (this.sprites[ind].x >> 8);
        int distY = destY - (this.sprites[ind].y >> 8);
        if (distX == 0) {
            distX = 1;
        }
        if (distY == 0) {
            distY = 1;
        }
        if (Math.abs(distX) > Math.abs(distY)) {
            this.sprites[ind].dx = (speed << 8) * MainMenu.sgn(distX);
            this.sprites[ind].dy = (distY << 8) / Math.abs(distX) * speed;
        } else {
            this.sprites[ind].dx = (distX << 8) / Math.abs(distY) * speed;
            this.sprites[ind].dy = (speed << 8) * MainMenu.sgn(distY);
        }
    }

    public void moveSpriteTo(int ind, int x, int y) {
        this.sprites[ind].x = x << 8;
        this.sprites[ind].y = y << 8;
    }

    public void changeSprite(int ind, int id, int flags, int code) {
        this.sprites[ind].status = (byte)2;
        this.sprites[ind].ind = (short)this.sprites[ind].sprman.findSprite(id);
        this.sprites[ind].flags = (byte)flags;
        this.sprites[ind].code = (short)code;
        this.sprites[ind].ani = null;
        this.sprites[ind].fy = 0;
        this.sprites[ind].fx = 0;
    }

    public SpriteImage getSpriteImage(int ind) {
        return this.sprites[ind].sprman.sprites[this.sprites[ind].ind];
    }

    public void changeAnimation(int ind, ANIManager animan, int id, int flags, int code, int speed) {
        this.sprites[ind].status = (byte)2;
        this.sprites[ind].sprman = animan.sprman;
        this.sprites[ind].ani = animan.animations[animan.findAnimation(id)];
        this.sprites[ind].animFlags = (byte)flags;
        this.sprites[ind].code = (short)code;
        this.sprites[ind].speed = (byte)speed;
        this.sprites[ind].currentFrame = 0;
        this.updateFrameInfo(this.sprites[ind]);
    }

    private void updateFrameInfo(Sprite spr) {
        int f = spr.currentFrame << 2;
        spr.ind = spr.ani.frames[f];
        spr.flags = (byte)(spr.ani.frames[f + 3] >> 8 & 0xFF ^ spr.animFlags & 3);
        spr.fx = (byte)spr.ani.frames[f + 1];
        spr.fy = (byte)spr.ani.frames[f + 2];
        if ((spr.animFlags & 1) != 0) {
            spr.fx = -spr.fx;
        }
        if ((spr.animFlags & 2) != 0) {
            spr.fy = -spr.fy;
        }
        spr._ft = (byte)((spr.ani.frames[f + 3] & 0xFF) * spr.speed);
    }

    public void nextFrame() {
        for (int i = this.maxSprites - 1; i >= 0; --i) {
            if (this.sprites[i].status != 2) continue;
            Sprite spr = this.sprites[i];
            spr.x += spr.dx;
            spr.y += spr.dy;
            if (spr.ani == null) continue;
            if (spr._ft > 0) {
                spr._ft = (byte)(spr._ft - 1);
            }
            if (spr._ft != 0) continue;
            spr.currentFrame = (byte)(spr.currentFrame + 1);
            if (spr.currentFrame >= spr.ani.frames.length >> 2) {
                if (spr.ani.loop != -1) {
                    spr.currentFrame = spr.ani.loop;
                    this.updateFrameInfo(spr);
                    continue;
                }
                switch (spr.animFlags & 0xF0) {
                    case 16: {
                        spr.status = 1;
                        break;
                    }
                    case 64: {
                        spr.changeAnimation();
                        break;
                    }
                    case 32: {
                        spr.currentFrame = (byte)(spr.currentFrame - 1);
                        spr._ft = (byte)-1;
                        break;
                    }
                    default: {
                        spr.status = 0;
                        break;
                    }
                }
                continue;
            }
            this.updateFrameInfo(spr);
        }
    }

    public void draw(Graphics g) {
        for (int i = 0; i < this.maxSprites; ++i) {
            Sprite spr = this.sprites[i];
            if (spr.status != 2) continue;
            spr.sprman.drawSprite(g, spr.ind, spr.fx + spr.x, spr.fy + this.y0 + spr.y, spr.flags);
        }
    }

    public void unload() {
        if (this.sprites != null) {
            for (int i = this.sprites.length - 1; i >= 0; --i) {
                if (this.sprites[i] != null) {
                    this.sprites[i].unload();
                }
                this.sprites[i] = null;
            }
        }
        this.sprites = null;
    }
}

