/*
 * Decompiled with CFR 0.152.
 */
package movilib;

import com.movilenio.game.Kernel;
import java.io.DataInputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class BitmapFont {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    public static final int TOP = 0;
    public static final int MIDDLE = 16;
    public static final int BOTTOM = 32;
    public Image image;
    public static final int CHR_SIZE = 6;
    public static final int X = 0;
    public static final int Y = 1;
    public static final int WIDTH = 2;
    public static final int HEIGHT = 3;
    public static final int OFFSET_Y = 4;
    public static final int ADVANCE = 5;
    public byte[] chr;
    public short[] chrIndex;
    public int ind_tilde;
    public int ind_dieresis;
    public int ind_tilde_inv;
    public int ind_circunflejo;
    public int ind_rabito;
    public int fontHeight;

    public BitmapFont(String fontFile) {
        try {
            DataInputStream dis = new DataInputStream(this.getClass().getResourceAsStream(fontFile));
            dis.readByte();
            int pngSize = dis.readInt();
            byte[] buf = new byte[pngSize];
            Kernel.readStreamData(dis, buf, 0, pngSize);
            this.image = Image.createImage((byte[])buf, (int)0, (int)pngSize);
            buf = null;
            int numChars = (dis.readByte() & 0xFF) + 1;
            this.chr = new byte[numChars * 6];
            this.chrIndex = new short[256];
            this.fontHeight = 0;
            for (int i = 0; i < numChars; ++i) {
                int pos = i * 6;
                int asciiCode = dis.readByte() & 0xFF;
                this.chr[pos + 0] = dis.readByte();
                this.chr[pos + 1] = dis.readByte();
                this.chr[pos + 2] = dis.readByte();
                this.chr[pos + 3] = dis.readByte();
                if (this.chr[pos + 3] > this.fontHeight) {
                    this.fontHeight = this.chr[pos + 3];
                }
                this.chr[pos + 4] = dis.readByte();
                this.chr[pos + 5] = dis.readByte();
                this.chrIndex[asciiCode] = (short)pos;
            }
            dis.close();
            this.ind_tilde = this.chrIndex[180];
            this.ind_dieresis = this.chrIndex[168];
            this.ind_tilde_inv = this.chrIndex[96];
            this.ind_circunflejo = this.chrIndex[94];
            this.ind_rabito = this.chrIndex[126];
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getAdvance(char ch) {
        return this.chr[this.chrIndex[ch & 0xFF] + 5];
    }

    public int getWidth(char ch) {
        return this.chr[this.chrIndex[ch & 0xFF] + 2];
    }

    public int getHeight() {
        return this.fontHeight;
    }

    public int stringWidth(String str) {
        int width = 0;
        int i = 0;
        for (int n = str.length(); n != 0; --n) {
            short ind = this.chrIndex[str.charAt(i) & 0xFF];
            if (ind != this.ind_tilde) {
                width += n > 1 ? this.chr[ind + 5] : this.chr[ind + 2];
            }
            ++i;
        }
        return width;
    }

    public void drawChar(Graphics g, char ch, int x, int y, int flags) {
        if ((flags & 0xF) != 0) {
            x -= (this.getAdvance(ch) >> 1) * (flags & 0xF);
        }
        if ((flags & 0xF0) != 0) {
            y -= (this.fontHeight >> 1) * (flags >> 4 & 0xF);
        }
        short ind = this.chrIndex[ch];
        int cX = g.getClipX();
        int cY = g.getClipY();
        int cW = g.getClipWidth();
        int cH = g.getClipHeight();
        g.clipRect(x, y + this.chr[ind + 4], (int)this.chr[ind + 2], (int)this.chr[ind + 3]);
        g.drawImage(this.image, x - this.chr[ind + 0], y + this.chr[ind + 4] - this.chr[ind + 1], 0);
        g.setClip(cX, cY, cW, cH);
    }

    public void drawString(Graphics g, String str, int x, int y, int flags) {
        int tilde = 0;
        if ((flags & 0xF) != 0) {
            x -= (this.stringWidth(str) >> 1) * (flags & 0xF);
        }
        if ((flags & 0xF0) != 0) {
            y -= (this.fontHeight >> 1) * (flags >> 4 & 0xF);
        }
        int cX = g.getClipX();
        int cY = g.getClipY();
        int cW = g.getClipWidth();
        int cH = g.getClipHeight();
        int i = 0;
        for (int n = str.length(); n != 0; --n) {
            char ch = str.charAt(i);
            switch (ch) {
                case '\u00b4': {
                    tilde = this.ind_tilde;
                    break;
                }
                default: {
                    short ind = this.chrIndex[ch];
                    g.setClip(cX, cY, cW, cH);
                    g.clipRect(x, y + this.chr[ind + 4], (int)this.chr[ind + 2], (int)this.chr[ind + 3]);
                    g.drawImage(this.image, x - this.chr[ind + 0], y + this.chr[ind + 4] - this.chr[ind + 1], 0);
                    if (tilde != 0) {
                        int tx = x + this.chr[ind + 5] - this.chr[tilde + 5];
                        int ty = y + this.chr[tilde + 4];
                        g.setClip(cX, cY, cW, cH);
                        g.clipRect(tx, ty, (int)this.chr[tilde + 2], (int)this.chr[tilde + 3]);
                        g.drawImage(this.image, tx - this.chr[tilde + 0], ty - this.chr[tilde + 1], 0);
                        tilde = 0;
                    }
                    x += this.chr[ind + 5];
                }
            }
            ++i;
        }
        g.setClip(cX, cY, cW, cH);
    }

    public void unload() {
        this.image = null;
        this.chr = null;
        this.chrIndex = null;
    }
}

